/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.el.order;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.pec.atom.el.authority.PebOperationPermissionsCheckingAtomService;
import com.tydic.order.pec.atom.el.authority.bo.PebOperationPermissionsCheckingAtomReqBO;
import com.tydic.order.pec.atom.el.authority.bo.PebOperationPermissionsCheckingAtomRspBO;
import com.tydic.order.pec.atom.el.order.UocPebClearingARefundAtomService;
import com.tydic.order.pec.atom.el.order.bo.UocPebClearingARefundAtomReqBO;
import com.tydic.order.pec.atom.el.order.bo.UocPebClearingARefundAtomRspBO;
import com.tydic.order.pec.bo.el.common.UocPebOrderCancellationReqBO;
import com.tydic.order.pec.bo.el.common.UocPebOrderCancellationRspBO;
import com.tydic.order.pec.bo.el.order.UocPebAccessoryBO;
import com.tydic.order.pec.busi.el.order.UocPebOrderCancellationBusiService;
import com.tydic.order.pec.busi.es.order.bo.UocReverseReqBO;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.pec.dic.SelectDicValByPcodeAndCode;
import com.tydic.order.pec.dic.bo.SelectSingleDictReqBO;
import com.tydic.order.pec.dic.bo.SelectSingleDictRspBO;
import com.tydic.order.uoc.atom.core.UocCoreBusiOperRecordAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreBusiOperRecordReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreBusiOperRecordRspBO;
import com.tydic.order.uoc.atom.other.UocCoreCreateAccessoryAtomService;
import com.tydic.order.uoc.atom.process.UocRunProcessAtomService;
import com.tydic.order.uoc.bo.other.UocCoreCreateAccessoryReqBO;
import com.tydic.order.uoc.bo.other.UocCoreCreateAccessoryRspBO;
import com.tydic.order.uoc.bo.process.UocProcessRunReqBO;
import com.tydic.order.uoc.bo.process.UocProcessRunRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdCancelMapper;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdCancelPO;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.order.uoc.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocPebOrderCancellationBusiServiceImpl
implements UocPebOrderCancellationBusiService {
    @Autowired
    private PebOperationPermissionsCheckingAtomService pebOperationPermissionsCheckingAtomService;
    @Autowired
    private UocCoreBusiOperRecordAtomService uocCoreBusiOperRecordAtomService;
    @Autowired
    private UocPebClearingARefundAtomService uocPebClearingARefundAtomService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private UocCoreCreateAccessoryAtomService uocCoreCreateAccessoryAtomService;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private OrdCancelMapper ordCancelMapper;
    @Resource(name="uocPebOrderCancelMsgProvider")
    private ProxyMessageProducer uocPebOrderCancelMsgProvider;
    @Value(value="${uoc.reverse:false}")
    private Boolean reverse;
    @Value(value="${UOC_ORDER_CANCEL_TOPIC}")
    private String topic;
    @Value(value="${UOC_ORDER_CANCEL_TAG}")
    private String tag;

    public UocPebOrderCancellationRspBO dealPebOrderCancellation(UocPebOrderCancellationReqBO reqBO) {
        if (reqBO.getIsVal() == null || reqBO.getIsVal().booleanValue()) {
            this.doCheckAuthority(reqBO);
        }
        this.doRunProcess(reqBO);
        if (reqBO.getIsRefund() == null || reqBO.getIsRefund().booleanValue()) {
            this.doRefund(reqBO);
        }
        this.saveFile(reqBO);
        OrderPO orderPO = new OrderPO();
        orderPO.setCancelReason(reqBO.getCancelReson());
        orderPO.setCancelDesc(reqBO.getCancelReson());
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO.setCancelOperId(reqBO.getUsername());
        orderPO.setCancelTime(new Date());
        orderPO.setOrderDesc(reqBO.getDealCode());
        orderPO.setProcState(reqBO.getFailCode());
        this.orderMapper.updateById(orderPO);
        OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
        ordExtMapPO.setId(Long.valueOf(this.idUtil.nextId()));
        ordExtMapPO.setFieldValue(reqBO.getDealCode());
        ordExtMapPO.setFieldCode("del_type");
        ordExtMapPO.setFieldName("\u53d6\u6d88\u7c7b\u578b");
        ordExtMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        ordExtMapPO.setObjId(reqBO.getOrderId());
        ordExtMapPO.setOrderId(reqBO.getOrderId());
        this.ordExtMapMapper.insert(ordExtMapPO);
        if (null == reqBO.getIsCancel() || !reqBO.getIsCancel().booleanValue()) {
            this.save(reqBO);
        }
        UocPebOrderCancellationRspBO rspBO = new UocPebOrderCancellationRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u53d6\u6d88\u6210\u529f");
        if (this.reverse != null && this.reverse.booleanValue()) {
            UocReverseReqBO reverseReqBO = new UocReverseReqBO();
            reverseReqBO.setOrderId(orderPO.getOrderId());
            reverseReqBO.setObjType(UocConstant.ORDER_TYPE.SALE_ORDER);
            this.uocPebOrderCancelMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)reverseReqBO)));
        }
        return rspBO;
    }

    private void save(UocPebOrderCancellationReqBO reqBO) {
        OrdCancelPO cancelPO = new OrdCancelPO();
        cancelPO.setId(Long.valueOf(this.idUtil.nextId()));
        cancelPO.setCancelNo(this.biuldNo("", "QXSQ"));
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCancelDesc())) {
            cancelPO.setCancelReason(reqBO.getCancelDesc());
        } else {
            cancelPO.setCancelReason(reqBO.getCancelReson());
        }
        cancelPO.setOrderId(reqBO.getOrderId());
        cancelPO.setSaleVoucherId(reqBO.getSaleVoucherId());
        cancelPO.setCreateOperId(reqBO.getUserId().toString());
        cancelPO.setCreateOperName(reqBO.getUsername());
        cancelPO.setCreateTime(new Date());
        cancelPO.setOrderStatus(Integer.valueOf(1));
        cancelPO.setStatus(UocConstant.CANCEL_ORDER_STATUS.CANCEL_SUCCESS);
        this.ordCancelMapper.insert(cancelPO);
    }

    private String biuldNo(String planNo, String pro) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        String no = "";
        if (StringUtils.isNotBlank((CharSequence)pro)) {
            no = no + pro;
        }
        if ((no = no + date + time.substring(time.length() - 6)).equals(planNo)) {
            this.biuldNo(no, pro);
        }
        OrdCancelPO cancelPO = new OrdCancelPO();
        cancelPO.setCancelNo(no);
        int count = this.ordCancelMapper.getCheckBy(cancelPO);
        if (count > 0) {
            this.biuldNo(no, pro);
        }
        return no;
    }

    private void saveFile(UocPebOrderCancellationReqBO reqBO) {
        List pebAccessoryReqBOList = reqBO.getAccessoryList();
        if (!CollectionUtils.isEmpty((Collection)pebAccessoryReqBOList)) {
            for (UocPebAccessoryBO pebAccessoryReqBO : pebAccessoryReqBOList) {
                UocCoreCreateAccessoryReqBO uocCoreCreateAccessoryReqBO = new UocCoreCreateAccessoryReqBO();
                uocCoreCreateAccessoryReqBO.setAccessoryId(pebAccessoryReqBO.getAccessoryId());
                uocCoreCreateAccessoryReqBO.setAccessoryName(pebAccessoryReqBO.getAccessoryName());
                uocCoreCreateAccessoryReqBO.setOrderId(reqBO.getOrderId());
                uocCoreCreateAccessoryReqBO.setAccessoryUrl(pebAccessoryReqBO.getAccessoryUrl());
                uocCoreCreateAccessoryReqBO.setAttachmentType(pebAccessoryReqBO.getAttachmentType());
                uocCoreCreateAccessoryReqBO.setObjectType(UocConstant.OBJ_TYPE.SALE);
                uocCoreCreateAccessoryReqBO.setObjectId(reqBO.getSaleVoucherId());
                uocCoreCreateAccessoryReqBO.setRemark(reqBO.getDealCode());
                UocCoreCreateAccessoryRspBO accessory = this.uocCoreCreateAccessoryAtomService.createAccessory(uocCoreCreateAccessoryReqBO);
                if ("0000".equals(accessory.getRespCode())) continue;
                throw new UocProBusinessException("0100", "\u751f\u6210\u9644\u4ef6\u4fe1\u606f,\u5931\u8d25\u63cf\u8ff0:" + accessory.getRespDesc());
            }
        }
    }

    private void doCheckAuthority(UocPebOrderCancellationReqBO reqBO) {
        if (!PecConstant.AuthCtrl.NO_CTRL.equals(reqBO.getAuthCtrl())) {
            PebOperationPermissionsCheckingAtomReqBO permissionsCheckingAtomReqBO = new PebOperationPermissionsCheckingAtomReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)permissionsCheckingAtomReqBO);
            PebOperationPermissionsCheckingAtomRspBO permissionsCheckingAtomRspBO = this.pebOperationPermissionsCheckingAtomService.dealPebOperationPermissionsChecking(permissionsCheckingAtomReqBO);
            if (!"0000".equals(permissionsCheckingAtomRspBO.getRespCode())) {
                throw new UocProBusinessException("0100", "\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u6743\u9650\u6821\u9a8c\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0\uff1a" + permissionsCheckingAtomRspBO.getRespDesc());
            }
        }
    }

    private void doBusiOperRecord(UocPebOrderCancellationReqBO reqBO) {
        UocCoreBusiOperRecordRspBO busiOperRecordRspBO;
        UocCoreBusiOperRecordReqBO operRecordReqBO = new UocCoreBusiOperRecordReqBO();
        operRecordReqBO.setOrderId(reqBO.getOrderId());
        operRecordReqBO.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.ORDER_OPER_RECORD);
        operRecordReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        operRecordReqBO.setObjId(reqBO.getSaleVoucherId());
        operRecordReqBO.setDealCode(StringUtils.isBlank((CharSequence)reqBO.getDealCode()) ? "ACTPEB014" : reqBO.getDealCode());
        operRecordReqBO.setDealReason(StringUtils.isBlank((CharSequence)reqBO.getCancelReson()) ? "\u53d6\u6d88\u8ba2\u5355" : reqBO.getCancelReson());
        operRecordReqBO.setDealDesc(StringUtils.isBlank((CharSequence)reqBO.getCancelDesc()) ? "\u53d6\u6d88\u8ba2\u5355" : reqBO.getCancelDesc());
        operRecordReqBO.setCreateTime(new Date());
        operRecordReqBO.setDealOperName(reqBO.getUsername());
        operRecordReqBO.setDealOperId(String.valueOf(reqBO.getUserId()));
        operRecordReqBO.setDealDeptId(String.valueOf(reqBO.getOrgId()));
        operRecordReqBO.setDealDeptName(reqBO.getOrgName());
        operRecordReqBO.setDealPostId(String.valueOf(reqBO.getOrgId()));
        operRecordReqBO.setDealPostName(reqBO.getOrgName());
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(operRecordReqBO.getDealCode());
        dictReqBO.setPcode("ACTION_CODE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if (dictRspBO != null && dictRspBO.getDicDictionarys() != null) {
            String describe = dictRspBO.getDicDictionarys().getDescrip();
            operRecordReqBO.setDealName(describe);
            operRecordReqBO.setDealTypeName(describe);
        }
        if (!"0000".equals((busiOperRecordRspBO = this.uocCoreBusiOperRecordAtomService.createBusiOperRecord(operRecordReqBO)).getRespCode())) {
            throw new UocProBusinessException("0100", "\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0\uff1a" + busiOperRecordRspBO.getRespDesc());
        }
    }

    private void doRefund(UocPebOrderCancellationReqBO reqBO) {
        UocPebClearingARefundAtomReqBO uocPebClearingARefundAtomReqBO = new UocPebClearingARefundAtomReqBO();
        uocPebClearingARefundAtomReqBO.setOrderId(reqBO.getOrderId());
        uocPebClearingARefundAtomReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocPebClearingARefundAtomReqBO.setObjId(reqBO.getSaleVoucherId());
        uocPebClearingARefundAtomReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        UocPebClearingARefundAtomRspBO uocPebClearingARefundAtomRspBO = this.uocPebClearingARefundAtomService.dealPebClearingARefund(uocPebClearingARefundAtomReqBO);
        if (!"0000".equals(uocPebClearingARefundAtomRspBO.getRespCode())) {
            throw new UocProBusinessException("0100", "\u8ba2\u5355\u53d6\u6d88\u9000\u6b3e\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0\uff1a" + uocPebClearingARefundAtomRspBO.getRespDesc());
        }
    }

    private void doRunProcess(UocPebOrderCancellationReqBO reqBO) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setProcDefKey("sales_order_master_order_status");
        processRunReqBO.setObjId(reqBO.getSaleVoucherId());
        processRunReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        if (reqBO.getProcParam() != null) {
            processRunReqBO.setVariables(reqBO.getProcParam());
        } else {
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put("auditFlag", "1");
            processRunReqBO.setVariables(map);
        }
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setOperId(reqBO.getUserId() + "");
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("100032", "\u8ba2\u5355\u53d6\u6d88\u8c03\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }
}

