/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.el.order;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.order.pec.atom.el.other.UocPebBusiOperRecordAtomService;
import com.tydic.order.pec.atom.el.other.bo.UocPebBusiOperRecordReqBO;
import com.tydic.order.pec.atom.el.other.bo.UocPebBusiOperRecordRspBO;
import com.tydic.order.pec.busi.el.order.UocPebOrderTakeBusiService;
import com.tydic.order.pec.busi.el.order.bo.UocPebOrderTakeReqBO;
import com.tydic.order.pec.busi.el.order.bo.UocPebOrderTakeRspBO;
import com.tydic.order.uoc.atom.core.UocCoreDealOrderAtomService;
import com.tydic.order.uoc.atom.core.UocCoreQryTaskInstAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreDealOrderReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreDealOrderRspBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreQryTaskInstReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreQryTaskInstRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdProtocolDetailMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.po.OrdProtocolDetailPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocPebOrderTakeBusiService")
public class UocPebOrderTakeBusiServiceImpl
implements UocPebOrderTakeBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPebOrderTakeBusiServiceImpl.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrdProtocolDetailMapper pecOrdProtocolDetailMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocCoreQryTaskInstAtomService uocCoreQryTaskInstAtomService;
    @Autowired
    private UocCoreDealOrderAtomService uocCoreDealOrderAtomService;
    @Autowired
    private UocPebBusiOperRecordAtomService uocPebBusiOperRecordAtomService;
    private Integer DEFAULT_SUPPLYCYCLE = 5;

    public UocPebOrderTakeRspBO execOrderTake(UocPebOrderTakeReqBO busiReqBO) {
        UocPebOrderTakeRspBO rsp = new UocPebOrderTakeRspBO();
        this.initParam(busiReqBO);
        try {
            OrdProtocolDetailPO pecOrdProtocolDetailPO = new OrdProtocolDetailPO();
            pecOrdProtocolDetailPO.setSaleVoucherId(busiReqBO.getSaleVoucherId());
            pecOrdProtocolDetailPO.setOrderId(busiReqBO.getOrderId());
            OrdProtocolDetailPO pecOrdProtocolDetail = this.pecOrdProtocolDetailMapper.getModelBy(pecOrdProtocolDetailPO);
            if (null == pecOrdProtocolDetail) {
                throw new UocProBusinessException("8888", "\u534f\u8bae\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
            String arriveTime = this.getArriveDate(pecOrdProtocolDetail);
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setSaleVoucherId(busiReqBO.getSaleVoucherId());
            ordSalePO.setOrderId(busiReqBO.getOrderId());
            ordSalePO.setArriveTime(arriveTime);
            int isUpdate = this.ordSaleMapper.updateById(ordSalePO);
            if (isUpdate < 1) {
                throw new UocProBusinessException("8888", "\u9500\u552e\u5355\u8868\u66f4\u65b0\u9884\u8ba1\u5230\u8d27\u65f6\u95f4\u5931\u8d25\uff01");
            }
            UocCoreQryTaskInstReqBO uocCoreQryTaskInstReqBO = new UocCoreQryTaskInstReqBO();
            uocCoreQryTaskInstReqBO.setOrderId(busiReqBO.getOrderId());
            UocCoreQryTaskInstRspBO uocCoreQryTaskInstRspBO = this.uocCoreQryTaskInstAtomService.qryTaskInst(uocCoreQryTaskInstReqBO);
            if (!"0000".equals(uocCoreQryTaskInstRspBO.getRespCode())) {
                throw new UocProBusinessException("8888", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u67e5\u8be2\u4efb\u52a1\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u5931\u8d25!" + uocCoreQryTaskInstRspBO.getRespDesc());
            }
            if (!"PEB21".equals(uocCoreQryTaskInstRspBO.getTaskInstBO().getTacheCode())) {
                throw new UocProBusinessException("8888", "\u8be5\u8ba2\u5355[" + busiReqBO.getOrderId() + "]\u5bf9\u5e94\u5f53\u524d\u73af\u8282\u4e0d\u662f\u4f9b\u5e94\u5546\u63a5\u62d2\u5355\uff01");
            }
            UocPebBusiOperRecordReqBO operRecordReqBO = new UocPebBusiOperRecordReqBO();
            operRecordReqBO.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.TASK_OPER_RECORD);
            operRecordReqBO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            operRecordReqBO.setDealCode("B_6");
            operRecordReqBO.setDealTypeId("PEB21");
            operRecordReqBO.setOrderId(busiReqBO.getOrderId());
            operRecordReqBO.setDealOperId(busiReqBO.getUserId().toString());
            operRecordReqBO.setDealOperName(busiReqBO.getUsername());
            operRecordReqBO.setDealCompId(busiReqBO.getOrgId());
            operRecordReqBO.setDealCompName(busiReqBO.getOrgName());
            operRecordReqBO.setDealDeptId(busiReqBO.getOrgId());
            operRecordReqBO.setDealDeptName(busiReqBO.getOrgName());
            operRecordReqBO.setDealDesc("\u4f9b\u5e94\u5546\u63a5\u5355");
            UocPebBusiOperRecordRspBO uocPebBusiOperRecordRspBO = this.uocPebBusiOperRecordAtomService.dealBusiOperRecord(operRecordReqBO);
            if (!"0000".equals(uocPebBusiOperRecordRspBO.getRespCode())) {
                throw new UocProBusinessException("8888", "\u8c03\u7528\u7535\u5546\u901a\u7528\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff01" + uocPebBusiOperRecordRspBO.getRespDesc());
            }
            UocCoreDealOrderReqBO uocCoreDealOrderReqBO = new UocCoreDealOrderReqBO();
            uocCoreDealOrderReqBO.setOrderId(busiReqBO.getOrderId());
            uocCoreDealOrderReqBO.setTaskId(uocCoreQryTaskInstRspBO.getTaskInstBO().getTaskId());
            uocCoreDealOrderReqBO.setDealOperId(busiReqBO.getUserId().toString());
            uocCoreDealOrderReqBO.setDealDesc("\u4f9b\u5e94\u5546\u63a5\u5355");
            HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
            paramMap.put("confirmOrder", 1);
            uocCoreDealOrderReqBO.setParamMap(paramMap);
            UocCoreDealOrderRspBO uocCoreDealOrderRspBO = this.uocCoreDealOrderAtomService.dealCoreDealOrder(uocCoreDealOrderReqBO);
            if (!"0000".equals(uocCoreDealOrderRspBO.getRespCode())) {
                throw new UocProBusinessException("8888", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff01" + uocCoreDealOrderRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u4e13\u533a\u4f9b\u5e94\u5546\u63a5\u5355\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38:", (Object)e.getMessage());
            throw new UocProBusinessException("8888", "\u4e13\u533a\u4f9b\u5e94\u5546\u63a5\u5355\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4e13\u533a\u4f9b\u5e94\u5546\u63a5\u5355\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private String getArriveDate(OrdProtocolDetailPO pecOrdProtocolDetail) {
        Integer supplyCycle = pecOrdProtocolDetail.getSupplyCycle();
        if (supplyCycle == null) {
            supplyCycle = this.DEFAULT_SUPPLYCYCLE;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, supplyCycle);
        Date date = calendar.getTime();
        String arriveDate = DateUtils.dateToStr((Date)date);
        return arriveDate;
    }

    private void initParam(UocPebOrderTakeReqBO busiReqBO) {
        if (null == busiReqBO) {
            throw new UocProBusinessException("7777", "\u4e13\u533a\u4f9b\u5e94\u5546\u63a5\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == busiReqBO.getOrderId()) {
            throw new UocProBusinessException("7777", "\u4e13\u533a\u4f9b\u5e94\u5546\u63a5\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010OrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == busiReqBO.getSaleVoucherId()) {
            throw new UocProBusinessException("7777", "\u4e13\u533a\u4f9b\u5e94\u5546\u63a5\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010SaleVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

