/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.el.other;

import com.tydic.order.pec.atom.el.other.UocPebSendMsgAtomService;
import com.tydic.order.pec.busi.el.other.UocPebMsgNotifyBusiService;
import com.tydic.order.pec.busi.el.other.bo.UocPebMsgNotifyReqBO;
import com.tydic.order.pec.busi.el.other.bo.UocPebMsgNotifyRspBO;
import com.tydic.order.pec.dao.PecRemindConfigureMapper;
import com.tydic.order.pec.dao.PecRemindLogMapper;
import com.tydic.order.pec.dao.po.PecRemindConfigurePO;
import com.tydic.order.uoc.atom.core.UocCoreQryTaskInstAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreQryTaskInstReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreQryTaskInstRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdProtocolDetailMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.po.OrdProtocolDetailPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocPebMsgNotifyBusiService")
public class UocPebMsgNotifyBusiServiceImpl
implements UocPebMsgNotifyBusiService {
    private static final Logger logger = LoggerFactory.getLogger(UocPebMsgNotifyBusiServiceImpl.class);
    private static final Integer URGE_NOTICE = 0;
    private static final Integer REMIND_NOTICE = 1;
    private static final Integer PURCHASER_TYPE = 0;
    private static final Integer PRO_ORG_TYPE = 1;
    public static final String PROFESSIONAL = "Rx1";
    public static final String SUPPLIER = "Rx2";
    @Autowired
    private UocCoreQryTaskInstAtomService uocCoreQryTaskInstAtomService;
    @Autowired
    private UocPebSendMsgAtomService uocPebSendMsgAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private PecRemindConfigureMapper remindConfigureMapper;
    @Autowired
    private PecRemindLogMapper remindLogMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdProtocolDetailMapper protocolDetailMapper;

    public UocPebMsgNotifyRspBO notifyPebMsg(UocPebMsgNotifyReqBO reqBO) {
        if (!PURCHASER_TYPE.equals(reqBO.getDealType()) && !PRO_ORG_TYPE.equals(reqBO.getDealType())) {
            throw new UocProBusinessException("7777", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b");
        }
        Long orderId = reqBO.getOrderId();
        Long saleVoucherId = reqBO.getSaleVoucherId();
        OrdSalePO ordSalePO = new OrdSalePO();
        OrdProtocolDetailPO protocolDetailPO = new OrdProtocolDetailPO();
        OrdStakeholderPO stakeholderPO = new OrdStakeholderPO();
        try {
            ordSalePO.setOrderId(orderId);
            ordSalePO.setSaleVoucherId(saleVoucherId);
            ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
            stakeholderPO = this.ordStakeholderMapper.getModelById(orderId.longValue());
            protocolDetailPO.setOrderId(orderId);
            protocolDetailPO.setSaleVoucherId(saleVoucherId);
            protocolDetailPO = this.protocolDetailMapper.getModelBy(protocolDetailPO);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38");
        }
        if (ordSalePO == null) {
            throw new UocProBusinessException("8888", "\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728,saleVoucherId=" + saleVoucherId);
        }
        if (stakeholderPO == null) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u4e0b\u5355\u4fe1\u606f");
        }
        if (protocolDetailPO == null) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u534f\u8bae\u4fe1\u606f");
        }
        UocCoreQryTaskInstReqBO qryTaskInstReqBO = new UocCoreQryTaskInstReqBO();
        qryTaskInstReqBO.setOrderId(orderId);
        UocCoreQryTaskInstRspBO qryTaskInstRspBO = this.uocCoreQryTaskInstAtomService.qryTaskInst(qryTaskInstReqBO);
        if (!"0000".equals(qryTaskInstRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u5f53\u524d\u4efb\u52a1\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + qryTaskInstRspBO.getRespDesc());
        }
        if (URGE_NOTICE.equals(reqBO.getNoticeFlag())) {
            if (UocConstant.SALE_ORDER_STATUS.DELIVERED.equals(ordSalePO.getSaleState())) {
                throw new UocProBusinessException("8888", "\u8be5\u8ba2\u5355\u53d1\u8d27\u5355\u5df2\u5168\u90e8\u53d1\u8d27\u5b8c\u6210\uff0c\u4e0d\u80fd\u8fdb\u884c\u50ac\u4ea4");
            }
            return this.smsSendProcess(orderId, PURCHASER_TYPE.equals(reqBO.getDealType()) ? "B_23" : "B_22", reqBO.getUserId().toString(), qryTaskInstRspBO.getTaskInstBO().getTacheCode(), ordSalePO, stakeholderPO, protocolDetailPO);
        }
        if (REMIND_NOTICE.equals(reqBO.getNoticeFlag())) {
            if (!"PEB21".equals(qryTaskInstRspBO.getTaskInstBO().getTacheCode())) {
                throw new UocProBusinessException("8888", "\u8be5\u8ba2\u5355\u4e0d\u662f\u4f9b\u5e94\u5546\u63a5\u5355\u73af\u8282\uff0c\u4e0d\u80fd\u8fdb\u884c\u63d0\u9192");
            }
            return this.smsSendProcess(orderId, PURCHASER_TYPE.equals(reqBO.getDealType()) ? "B_20" : "B_21", reqBO.getUserId().toString(), qryTaskInstRspBO.getTaskInstBO().getTacheCode(), ordSalePO, stakeholderPO, protocolDetailPO);
        }
        throw new UocProBusinessException("8888", "\u4e0d\u652f\u6301\u7684\u63d0\u9192\u7c7b\u578b");
    }

    private UocPebMsgNotifyRspBO smsSendProcess(Long orderId, String busiType, String userId, String tacheCode, OrdSalePO ordSalePO, OrdStakeholderPO stakeholderPO, OrdProtocolDetailPO protocolDetailPO) {
        PecRemindConfigurePO paramPO = new PecRemindConfigurePO();
        paramPO.setTacheCode(tacheCode);
        paramPO.setIsDispatch(ordSalePO.getIsDispatch());
        paramPO.setOrderState(ordSalePO.getSaleState());
        paramPO.setBusiType(busiType);
        List configureList = null;
        try {
            configureList = this.remindConfigureMapper.getList(paramPO);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u77ed\u4fe1\u6a21\u677f\u5f02\u5e38", (Throwable)e);
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u77ed\u4fe1\u6a21\u677f\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty((Collection)configureList)) {
            throw new UocProBusinessException("8888", "\u6ca1\u6709\u5bf9\u5e94\u6a21\u677f\u914d\u7f6e");
        }
        int successCount = 0;
        int failCount = 0;
        UocPebMsgNotifyRspBO rspBO = new UocPebMsgNotifyRspBO();
        StringBuilder failDesc = new StringBuilder();
        StringBuilder respDesc = new StringBuilder();
        for (PecRemindConfigurePO configurePO : configureList) {
            int hasSendCount = this.remindLogMapper.querySendCountByDay(orderId, new Date(), configurePO.getId());
            if (hasSendCount < configurePO.getSendCount()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("configureId" + configurePO.getId() + "\u8d85\u51fa\u53d1\u9001\u6b21\u6570\uff0c\u4e0d\u80fd\u518d\u53d1\u9001\u4fe1\u606f");
            }
            ++failCount;
            failDesc.append("configureId").append(configurePO.getId()).append("\u8d85\u51fa\u53d1\u9001\u6b21\u6570\uff0c\u4e0d\u80fd\u518d\u53d1\u9001\u4fe1\u606f").append("\uff0c");
        }
        if (successCount == 1 && failCount == 0) {
            respDesc.append("\u53d1\u9001\u6210\u529f1\u6761\u4fe1\u606f\uff01");
        } else if (successCount == 0 && failCount == 1) {
            respDesc.append("\u53d1\u9001\u5931\u8d251\u6761\u4fe1\u606f\uff01");
        } else {
            respDesc.append("\u53d1\u9001\u6210\u529f\u3010").append(successCount).append("\u3011\u6761\u4fe1\u606f\uff0c\u53d1\u9001\u5931\u8d25\u3010").append(failCount).append("\u3011\u6761\u4fe1\u606f");
            if (failDesc.length() > 0) {
                respDesc.append("\uff0c\u5931\u8d25\u539f\u56e0\uff0c").append(failDesc.substring(0, failDesc.length() - 1));
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(respDesc.toString());
        return rspBO;
    }
}

