/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.es.order;

import com.tydic.order.pec.bo.es.order.UocPebOrderShipReqBO;
import com.tydic.order.pec.bo.es.order.UocPebOrderShipRspBO;
import com.tydic.order.pec.bo.es.order.UocPebShipCruxFieldBO;
import com.tydic.order.pec.bo.es.order.UocPebShipExtFieldBO;
import com.tydic.order.pec.bo.es.order.UocPebShipItemBO;
import com.tydic.order.pec.busi.es.order.UocPebOrderShipBusiService;
import com.tydic.order.uoc.atom.core.UocCoreDealOrderAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreDealOrderReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreDealOrderRspBO;
import com.tydic.order.uoc.atom.ship.UocCoreOrderShipAtomService;
import com.tydic.order.uoc.bo.ship.ShipCruxFieldBO;
import com.tydic.order.uoc.bo.ship.ShipExtFieldBO;
import com.tydic.order.uoc.bo.ship.UocCoreOrderShipReqBO;
import com.tydic.order.uoc.bo.ship.UocCoreOrderShipRspBO;
import com.tydic.order.uoc.bo.ship.UocCoreShipItemReqBO;
import com.tydic.order.uoc.dao.OrdItemMapper;
import com.tydic.order.uoc.dao.OrdTaskMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdTaskPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocPebOrderShipBusiService")
public class UocPebOrderShipBusiServiceImpl
implements UocPebOrderShipBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPebOrderShipBusiServiceImpl.class);
    @Autowired
    private UocCoreOrderShipAtomService uocCoreOrderShipAtomService;
    @Autowired
    private UocCoreDealOrderAtomService uocCoreDealOrderAtomService;
    @Autowired
    private OrdTaskMapper ordTaskMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;

    public UocPebOrderShipRspBO executeOrderShip(UocPebOrderShipReqBO uocPebOrderShipReqBO) {
        this.validationParams(uocPebOrderShipReqBO);
        UocPebOrderShipRspBO rspBO = new UocPebOrderShipRspBO();
        UocCoreOrderShipReqBO uocCoreOrderShipBusiReqBO = this.assemblyCoreOrderShipAtomParameterObject(uocPebOrderShipReqBO);
        UocCoreOrderShipRspBO uocCoreOrderShipBusiRspBO = this.uocCoreOrderShipAtomService.dealCoreOrderShip(uocCoreOrderShipBusiReqBO);
        if (!"0000".equals(uocCoreOrderShipBusiRspBO.getRespCode())) {
            BeanUtils.copyProperties((Object)uocCoreOrderShipBusiRspBO, (Object)rspBO);
            return rspBO;
        }
        UocCoreDealOrderReqBO uocCoreDealOrderReqBO = new UocCoreDealOrderReqBO();
        OrdTaskPO ordTaskParamPO = new OrdTaskPO();
        ordTaskParamPO.setOrderId(uocPebOrderShipReqBO.getOrderId());
        try {
            OrdTaskPO ordTaskPO = this.ordTaskMapper.getModelBy(ordTaskParamPO);
            uocCoreDealOrderReqBO.setTaskId(ordTaskPO.getTaskId());
            uocCoreDealOrderReqBO.setOrderId(ordTaskPO.getOrderId());
            uocCoreDealOrderReqBO.setTacheCode(ordTaskPO.getTacheCode());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4efb\u52a1\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u53d1\u8d27\u4e1a\u52a1\u670d\u52a1\u4e2d\u67e5\u8be2\u4efb\u52a1\u5217\u8868\u5f02\u5e38");
            return rspBO;
        }
        try {
            OrderPO orderParamPo = new OrderPO();
            orderParamPo.setOrderId(uocPebOrderShipReqBO.getOrderId());
            OrderPO orderPO = this.orderMapper.getModelBy(orderParamPo);
            uocCoreDealOrderReqBO.setDealOperId(orderPO.getCreateOperId());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u53d1\u8d27\u4e1a\u52a1\u670d\u52a1\u4e2d\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38");
            return rspBO;
        }
        UocCoreDealOrderRspBO uocCoreDealOrderRspBO = this.uocCoreDealOrderAtomService.dealCoreDealOrder(uocCoreDealOrderReqBO);
        rspBO.setRespCode(uocCoreDealOrderRspBO.getRespCode());
        rspBO.setRespDesc(uocCoreDealOrderRspBO.getRespDesc());
        return rspBO;
    }

    private void validationParams(UocPebOrderShipReqBO reqBO) {
        if (reqBO.getSaleVoucherId() == null || reqBO.getSaleVoucherId() == 0L) {
            throw new UocProBusinessException("7777", "\u6267\u884c\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d1\u8d27\u4e1a\u52a1\u5931\u8d25\uff1a\u9500\u552e\u8ba2\u5355ID[saleVoucherId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null || reqBO.getOrderId() == 0L) {
            throw new UocProBusinessException("7777", "\u6267\u884c\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d1\u8d27\u4e1a\u52a1\u5931\u8d25\uff1a\u8ba2\u5355ID[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getUocPebShipItemBOList() == null || reqBO.getUocPebShipItemBOList().isEmpty()) {
            throw new UocProBusinessException("7777", "\u6267\u884c\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d1\u8d27\u4e1a\u52a1\u5931\u8d25\uff1a\u53d1\u8d27\u5355\u660e\u7ec6\u5217\u8868[uocPebshipItemList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocPebShipItemBO uocPebShipItemBO : reqBO.getUocPebShipItemBOList()) {
            if (uocPebShipItemBO.getOrdItemId() == null || uocPebShipItemBO.getOrdItemId() == 0L) {
                throw new UocProBusinessException("7777", "\u6267\u884c\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d1\u8d27\u4e1a\u52a1\u5931\u8d25\uff1a\u53d1\u8d27\u5355\u660e\u7ec6\u4e2d\u9500\u552e\u8ba2\u5355\u660e\u7ec6ID[ordItemId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (uocPebShipItemBO.getPurchaseCount() != null && uocPebShipItemBO.getPurchaseCount().longValue() != 0L) continue;
            throw new UocProBusinessException("7777", "\u6267\u884c\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d1\u8d27\u4e1a\u52a1\u5931\u8d25\uff1a\u53d1\u8d27\u5355\u660e\u7ec6\u4e2d\u53d1\u8d27\u6570\u91cf[purchaseCount]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UocCoreOrderShipReqBO assemblyCoreOrderShipAtomParameterObject(UocPebOrderShipReqBO reqBO) {
        UocCoreOrderShipReqBO uocCoreOrderShipBusiReqBO = new UocCoreOrderShipReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uocCoreOrderShipBusiReqBO);
        uocCoreOrderShipBusiReqBO.setShipStatus("1202");
        uocCoreOrderShipBusiReqBO.setCreateTime(new Date());
        List uocPebShipItemBOList = reqBO.getUocPebShipItemBOList();
        ArrayList<UocCoreShipItemReqBO> uocCoreShipItemReqBOList = new ArrayList<UocCoreShipItemReqBO>();
        for (UocPebShipItemBO uocPebShipItemBO : uocPebShipItemBOList) {
            UocCoreShipItemReqBO shipItemBO = new UocCoreShipItemReqBO();
            BeanUtils.copyProperties((Object)uocPebShipItemBO, (Object)shipItemBO);
            shipItemBO.setOrderId(reqBO.getOrderId());
            shipItemBO.setArriveCount(BigDecimal.ZERO);
            shipItemBO.setRefuseCount(BigDecimal.ZERO);
            shipItemBO.setReturnCount(BigDecimal.ZERO);
            shipItemBO.setAcceptanceCount(BigDecimal.ZERO);
            uocCoreShipItemReqBOList.add(shipItemBO);
        }
        uocCoreOrderShipBusiReqBO.setShipItemList(uocCoreShipItemReqBOList);
        if (reqBO.getUocPebShipCruxFieldBOList() != null && !reqBO.getUocPebShipCruxFieldBOList().isEmpty()) {
            ArrayList<ShipCruxFieldBO> shipCruxFieldBOList = new ArrayList<ShipCruxFieldBO>();
            for (UocPebShipCruxFieldBO uocPebShipCruxFieldBO : reqBO.getUocPebShipCruxFieldBOList()) {
                ShipCruxFieldBO shipCruxFieldBO = new ShipCruxFieldBO();
                BeanUtils.copyProperties((Object)uocPebShipCruxFieldBO, (Object)shipCruxFieldBO);
                shipCruxFieldBOList.add(shipCruxFieldBO);
            }
            uocCoreOrderShipBusiReqBO.setCruxFieldList(shipCruxFieldBOList);
        }
        if (reqBO.getUocPebShipExtFieldBOList() != null && !reqBO.getUocPebShipExtFieldBOList().isEmpty()) {
            ArrayList<ShipExtFieldBO> shipExtFieldBOList = new ArrayList<ShipExtFieldBO>();
            for (UocPebShipExtFieldBO uocPebShipExtFieldBO : reqBO.getUocPebShipExtFieldBOList()) {
                ShipExtFieldBO shipExtFieldBO = new ShipExtFieldBO();
                BeanUtils.copyProperties((Object)uocPebShipExtFieldBO, (Object)shipExtFieldBO);
                shipExtFieldBOList.add(shipExtFieldBO);
            }
            uocCoreOrderShipBusiReqBO.setExtFieldList(shipExtFieldBOList);
        }
        return uocCoreOrderShipBusiReqBO;
    }
}

