/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.es.timetask;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.order.pec.busi.es.timetask.UocPebQryOutPushMsgBusiService;
import com.tydic.order.pec.busi.es.timetask.bo.UocPebQryOutPushMsgReqBO;
import com.tydic.order.pec.busi.es.timetask.bo.UocPebQryOutPushMsgRspBO;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.third.intf.ability.esb.other.PebIntfDelMsgPushAbilityService;
import com.tydic.order.third.intf.ability.esb.other.PebIntfGetMsgPushAbilityService;
import com.tydic.order.third.intf.bo.esb.other.BusiDelMsgReqBO;
import com.tydic.order.third.intf.bo.esb.other.BusiDelMsgRspBO;
import com.tydic.order.third.intf.bo.esb.other.BusiGetMsgReqBO;
import com.tydic.order.third.intf.bo.esb.other.BusiGetMsgRspBO;
import com.tydic.order.third.intf.bo.esb.other.ResultBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.ConfSupplierMapper;
import com.tydic.order.uoc.dao.MsgPoolMapper;
import com.tydic.order.uoc.dao.OrdQueryIndexMapper;
import com.tydic.order.uoc.dao.po.ConfSupplierPO;
import com.tydic.order.uoc.dao.po.MsgPoolPO;
import com.tydic.order.uoc.dao.po.OrdQueryIndexPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebQryOutPushMsgBusiService")
public class UocPebQryOutPushMsgBusiServiceImpl
implements UocPebQryOutPushMsgBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(UocPebQryOutPushMsgBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOG.isDebugEnabled();
    @Autowired
    private MsgPoolMapper msgPoolMapper;
    @Autowired
    private ConfSupplierMapper confSupplierMapper;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private PebIntfGetMsgPushAbilityService pebIntfGetMsgPushAbilityService;
    @Autowired
    private PebIntfDelMsgPushAbilityService pebIntfDelMsgPushAbilityService;
    @Value(value="${isOpenDelPushMsg}")
    private boolean isOpenDelPushMsg;

    public UocPebQryOutPushMsgRspBO createAndQryOutPushMsg(UocPebQryOutPushMsgReqBO uocPebQryOutPushMsgReqBO) {
        String[] dealTypes;
        this.validataParams(uocPebQryOutPushMsgReqBO);
        UocPebQryOutPushMsgRspBO rspBO = new UocPebQryOutPushMsgRspBO();
        ConfSupplierPO confSupplierPo = this.qryConfSupplier(uocPebQryOutPushMsgReqBO);
        Long supNo = uocPebQryOutPushMsgReqBO.getGoodsSupplierId();
        for (String dealType : dealTypes = confSupplierPo.getDealType().split(",")) {
            BusiGetMsgRspBO qryMsgRsp;
            Boolean isAnalysis = this.defineAnalysisType(dealType);
            if (!isAnalysis.booleanValue()) {
                dealType = dealType.substring(0, dealType.length() - 1);
            }
            if (null != (qryMsgRsp = this.qryPushMsg(supNo, dealType, isAnalysis)) && null != qryMsgRsp.getResult() && !qryMsgRsp.getResult().isEmpty()) {
                List resultVoList = qryMsgRsp.getResult();
                this.insertOutPushMsg(resultVoList, supNo, isAnalysis);
                continue;
            }
            LOG.debug("\u672a\u67e5\u8be2\u5230\u6d88\u606f\u7c7b\u578b\u4e3a[dealType=" + dealType + "]\u7684\u5916\u90e8\u7535\u5546\u63a8\u9001\u6d88\u606f");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u63a8\u9001\u6d88\u606f\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private void validataParams(UocPebQryOutPushMsgReqBO uocPebQryOutPushMsgReqBO) {
        if (uocPebQryOutPushMsgReqBO.getGoodsSupplierId() == null || uocPebQryOutPushMsgReqBO.getGoodsSupplierId() == 0L) {
            throw new UocProBusinessException("7777", "\u4f9b\u5e94\u5546\u7f16\u53f7[goodsSupplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private ConfSupplierPO qryConfSupplier(UocPebQryOutPushMsgReqBO reqBO) {
        try {
            ConfSupplierPO confSupplierPo = this.confSupplierMapper.getModelById(reqBO.getGoodsSupplierId().longValue());
            if (confSupplierPo == null) {
                throw new UocProBusinessException("8888", "\u6267\u884c\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u672a\u67e5\u8be2\u5230\u5f53\u524d\u4f9b\u5e94\u5546[" + reqBO.getGoodsSupplierId() + "]\u914d\u7f6e\u4fe1\u606f!");
            }
            if (StringUtils.isEmpty((CharSequence)confSupplierPo.getDealType())) {
                throw new UocProBusinessException("8888", "\u6267\u884c\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u5f53\u524d\u4f9b\u5e94\u5546[" + reqBO.getGoodsSupplierId() + "]\u672a\u914d\u7f6e\u5904\u7406\u7c7b\u578b!");
            }
            return confSupplierPo;
        }
        catch (Exception e) {
            if (this.IS_DEBUG_ENABLED) {
                LOG.debug("\u6267\u884c\u5904\u7406\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u67e5\u8be2\u4f9b\u5e94\u5546\u914d\u7f6e\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38!", (Throwable)e);
            }
            throw new UocProBusinessException("8888", "\u6267\u884c\u5904\u7406\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u67e5\u8be2\u4f9b\u5e94\u5546\u914d\u7f6e\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38!");
        }
    }

    private Boolean defineAnalysisType(String dealType) {
        boolean isAnalysis = true;
        String endWithUpper = "F";
        String endWithLower = "f";
        if (dealType.endsWith(endWithUpper) || dealType.endsWith(endWithLower)) {
            isAnalysis = false;
        }
        if (this.IS_DEBUG_ENABLED) {
            LOG.debug("\u5224\u65ad\u67e5\u8be2\u51fa\u7684\u5916\u90e8\u63a8\u9001\u6d88\u606f\u662f\u5426\u8be6\u7ec6\u89e3\u6790\u5b57\u6bb5 isAnalysis= " + isAnalysis);
        }
        return isAnalysis;
    }

    private BusiGetMsgRspBO qryPushMsg(Long supNo, String dealType, Boolean isAnalysis) {
        BusiGetMsgReqBO busiGetMsgReq = new BusiGetMsgReqBO();
        busiGetMsgReq.setSupplierId(supNo);
        busiGetMsgReq.setType(Integer.valueOf(dealType));
        busiGetMsgReq.setIsAnalysis(isAnalysis);
        BusiGetMsgRspBO qryMsgRsp = this.pebIntfGetMsgPushAbilityService.getMsg(busiGetMsgReq);
        if (qryMsgRsp == null || !qryMsgRsp.isSuccess()) {
            LOG.error("\u6267\u884c\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u5931\u8d25");
            return null;
        }
        List resultVolist = qryMsgRsp.getResult();
        if (null == resultVolist) {
            LOG.error("\u6267\u884c\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u5916\u90e8\u670d\u52a1\u672a\u8fd4\u56de\u5904\u7406\u6d88\u606f");
            return null;
        }
        if (this.IS_DEBUG_ENABLED) {
            LOG.debug("\u8c03\u7528\u63a8\u9001\u6d88\u606f\u51fa\u53c2 \u5f00\u59cb\u6253\u5370");
            for (ResultBO resultVO : resultVolist) {
                LOG.debug("\u8c03\u7528\u63a8\u9001\u6d88\u606f\u51fa\u53c2resultVO\uff1a" + resultVO.toString());
                if (null == resultVO.getResult()) continue;
                LOG.debug("\u8c03\u7528\u63a8\u9001\u6d88\u606f\u51fa\u53c2Result: " + resultVO.getResult().toString());
            }
            LOG.debug("\u8c03\u7528\u63a8\u9001\u6d88\u606f\u51fa\u53c2 \u6253\u5370\u7ed3\u675f");
        }
        return qryMsgRsp;
    }

    private void insertOutPushMsg(List<ResultBO> resultVoList, Long supNo, Boolean isAnalysis) {
        for (ResultBO resultVO : resultVoList) {
            OrdQueryIndexPO queryIndexPo;
            if (resultVO.getResult() == null) {
                LOG.error("=======\u5916\u90e8\u7535\u5546\u672a\u8fd4\u56de\u5177\u4f53\u63a8\u9001\u7ed3\u679c=======");
                continue;
            }
            String outOrderNo = null;
            if (StringUtils.isNotBlank((CharSequence)resultVO.getResult().getOrderId())) {
                outOrderNo = resultVO.getResult().getOrderId();
            } else if (StringUtils.isNotBlank((CharSequence)resultVO.getResult().getPOrder())) {
                outOrderNo = resultVO.getResult().getPOrder();
            }
            if (StringUtils.isBlank((CharSequence)outOrderNo) && !Long.valueOf(102L).equals(resultVO.getType()) && !Long.valueOf(107L).equals(resultVO.getType())) {
                LOG.error("=======\u63a8\u9001\u6d88\u606f[" + resultVO.getId() + "]\u672a\u8fd4\u56de\u8ba2\u5355ID\u6216\u7236\u8ba2\u5355ID=======");
                continue;
            }
            try {
                OrdQueryIndexPO queryIndexModel = new OrdQueryIndexPO();
                if (Long.valueOf(102L).equals(resultVO.getType()) || Long.valueOf(107L).equals(resultVO.getType()) || Long.valueOf(13L).equals(resultVO.getType())) {
                    if (Long.valueOf(13L).equals(resultVO.getType())) {
                        queryIndexModel.setOutOrderNo(resultVO.getResult().getAfsServiceId());
                    } else {
                        queryIndexModel.setOutOrderNo(resultVO.getResult().getServiceId());
                    }
                } else {
                    queryIndexModel.setOutOrderNo(outOrderNo);
                }
                List list = this.ordQueryIndexMapper.getList(queryIndexModel);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    LOG.error("=======\u672a\u5728\u5185\u5916\u8ba2\u5355\u5173\u8054\u5173\u7cfb\u8868\u4e2d\u67e5\u8be2\u5230\u6d88\u606f\u7c7b\u578b[" + resultVO.getType() + "]\u6570\u636e\u4e3a[" + JSONObject.toJSONString((Object)resultVO) + "]\u6240\u5bf9\u5e94\u7684\u7684\u4fe1\u606f===========,\u8be5\u6761\u4fe1\u606f\u4e0d\u4e88\u8fdb\u884c\u5165\u5e93\u64cd\u4f5c");
                    continue;
                }
                queryIndexPo = (OrdQueryIndexPO)list.get(0);
            }
            catch (Exception e) {
                LOG.error("\u67e5\u8be2\u5916\u90e8\u8ba2\u5355\u4e0e\u5185\u90e8\u8ba2\u5355\u5173\u7cfb\u5f02\u5e38\uff0c\u5904\u7406\u5916\u90e8\u63a8\u9001\u6d88\u606f\u5931\u8d25\uff1a", (Throwable)e);
                throw new UocProBusinessException("8888", "\u6267\u884c\u5904\u7406\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u67e5\u8be2\u5916\u90e8\u8ba2\u5355\u4e0e\u5185\u90e8\u8ba2\u5355\u5173\u7cfb\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
            }
            MsgPoolPO msgPool = this.assemblyMsgPoolPO(resultVO, isAnalysis, supNo, queryIndexPo);
            this.addMsgPoolAndDelOutPushMsg(msgPool, resultVO, supNo, msgPool.getOrderId());
        }
    }

    private MsgPoolPO assemblyMsgPoolPO(ResultBO resultVO, Boolean isAnalysis, Long supNo, OrdQueryIndexPO queryIndexPO) {
        MsgPoolPO msgPoolPO = new MsgPoolPO();
        Integer type = Integer.parseInt(resultVO.getType().toString());
        Integer offLineType = 28;
        Integer newJdOrderType = 13;
        String jsonStr = JSONObject.toJSONString((Object)resultVO);
        msgPoolPO.setSupNo(supNo);
        msgPoolPO.setMsgId(resultVO.getId());
        msgPoolPO.setMsgType(type);
        msgPoolPO.setMsgContent(jsonStr);
        msgPoolPO.setCreateTime(new Date());
        msgPoolPO.setPushTime(resultVO.getTime());
        msgPoolPO.setFailureCount(Integer.valueOf(0));
        msgPoolPO.setRunResult(PecConstant.OUT_MSG_RUN_RESULT.WAIT_RUN);
        if (queryIndexPO != null) {
            msgPoolPO.setObjId(queryIndexPO.getObjId());
            msgPoolPO.setObjType(queryIndexPO.getObjType());
            if (msgPoolPO.getMsgType().equals(5)) {
                msgPoolPO.setObjType(UocConstant.OBJ_TYPE.SHIP);
            }
            msgPoolPO.setOrderId(queryIndexPO.getOrderId());
        }
        if (!isAnalysis.booleanValue()) {
            msgPoolPO.setResultString(resultVO.getResultString());
        } else {
            msgPoolPO.setOutOrderId(resultVO.getResult().getOrderId());
            msgPoolPO.setPOrderId(resultVO.getResult().getPOrder());
            msgPoolPO.setPackageid(resultVO.getResult().getPackageId());
            if (offLineType.equals(type)) {
                msgPoolPO.setPackageid(resultVO.getResult().getSkuId());
            }
            msgPoolPO.setMsgState(resultVO.getResult().getState());
            msgPoolPO.setServiceid(resultVO.getResult().getAfsServiceId());
            if (StringUtils.isBlank((CharSequence)msgPoolPO.getServiceid())) {
                msgPoolPO.setServiceid(resultVO.getResult().getServiceId());
            }
            msgPoolPO.setOrderType(resultVO.getResult().getOrderType());
        }
        return msgPoolPO;
    }

    private void addMsgPoolAndDelOutPushMsg(MsgPoolPO msgPool, ResultBO resultVO, Long supNo, Long orderId) {
        block7: {
            MsgPoolPO checkMsgPoolPo = new MsgPoolPO();
            checkMsgPoolPo.setOrderId(orderId);
            checkMsgPoolPo.setSupNo(supNo);
            checkMsgPoolPo.setMsgId(resultVO.getId());
            try {
                int count = this.msgPoolMapper.getCheckBy(checkMsgPoolPo);
                if (count == 0) {
                    if (this.IS_DEBUG_ENABLED) {
                        LOG.debug("\u83b7\u53d6\u63a8\u9001\u4fe1\u606f\u5b9a\u65f6\u4efb\u52a1 \u5199\u5165\u6d88\u606f\u6c60 \u5165\u53c2" + msgPool.toString());
                    }
                    try {
                        Sequence sequence = Sequence.getInstance();
                        msgPool.setId(Long.valueOf(sequence.nextId()));
                        int line = this.msgPoolMapper.insert(msgPool);
                        if (line < 1) {
                            LOG.error("\u6d88\u606f[" + msgPool.getMsgId() + "]\u5165\u5e93\u6d88\u606f\u6c60\u5931\u8d25!");
                            return;
                        }
                        this.deletePushMsg(msgPool.getMsgId(), supNo);
                        break block7;
                    }
                    catch (Exception e) {
                        LOG.error("\u5916\u90e8\u63a8\u9001\u6d88\u606f\u5165\u5e93\u6d88\u606f\u6c60\u8868\u5f02\u5e38,", (Throwable)e);
                        throw new UocProBusinessException("8888", "\u6267\u884c\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u4f9b\u5e94\u5546" + supNo + ":" + resultVO.getId() + "\u5165\u5e93\u6d88\u606f\u6c60\u8868\u5f02\u5e38");
                    }
                }
                this.deletePushMsg(msgPool.getMsgId(), supNo);
            }
            catch (Exception e) {
                LOG.error("\u6267\u884c\u5904\u7406\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u662f\u5426\u5df2\u5165\u5e93\u5f02\u5e38,", (Throwable)e);
                throw new UocProBusinessException("8888", "\u6267\u884c\u5904\u7406\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u4f9b\u5e94\u5546" + supNo + ":" + resultVO.getId() + "\u67e5\u8be2\u6d88\u606f\u6c60\u8868\u5f02\u5e38");
            }
        }
    }

    private void deletePushMsg(String msgId, Long supplierId) {
        if (this.isOpenDelPushMsg) {
            BusiDelMsgReqBO busiDelMsgReq = new BusiDelMsgReqBO();
            busiDelMsgReq.setId(msgId);
            busiDelMsgReq.setSupplierId(supplierId);
            BusiDelMsgRspBO usiDelMsgRsp = this.pebIntfDelMsgPushAbilityService.delMsgPush(busiDelMsgReq);
            if (!"0000".equals(usiDelMsgRsp.getRespCode()) && this.IS_DEBUG_ENABLED) {
                LOG.debug("\u63a8\u9001\u6d88\u606f\u5165\u5e93\u65f6\u672a\u6210\u529f\u5220\u9664\u6570\u636e\u5e93\u4e2d\u672a\u5b58\u5728\u7684\u5916\u90e8\u8ba2\u5355\u7684\u63a8\u9001\u6d88\u606f!" + usiDelMsgRsp.getRespDesc());
            }
        }
    }
}

