/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.pay;

import com.alibaba.fastjson.JSON;
import com.tydic.order.pec.atom.PebCalculationReturnFeeAtomService;
import com.tydic.order.pec.atom.bo.PebCalculationReturnFeeReqBO;
import com.tydic.order.pec.atom.bo.PebCalculationReturnFeeRspBO;
import com.tydic.order.pec.bo.pay.UocPayOrderReFundReqBO;
import com.tydic.order.pec.bo.pay.UocPayOrderReFundRspBO;
import com.tydic.order.pec.busi.pay.UocPayOrderReFundBusiService;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.third.intf.ability.fsc.PebIntfFscDealRefundOrderAbilityService;
import com.tydic.order.third.intf.ability.pay.PebIntfPayProRefundAbilityService;
import com.tydic.order.third.intf.bo.fsc.PebIntfFscDealRefundOrderReqBO;
import com.tydic.order.third.intf.bo.fsc.PebIntfFscDealRefundOrderRspBO;
import com.tydic.order.uoc.atom.process.UocRunProcessAtomService;
import com.tydic.order.uoc.bo.process.UocProcessRunReqBO;
import com.tydic.order.uoc.bo.process.UocProcessRunRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdAfterServiceMapper;
import com.tydic.order.uoc.dao.OrdPayApplyMapper;
import com.tydic.order.uoc.dao.OrdPayMapper;
import com.tydic.order.uoc.dao.OrdRefundFailureLogMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdShipMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.UocOrdPayConfMapper;
import com.tydic.order.uoc.dao.po.OrdAfterServicePO;
import com.tydic.order.uoc.dao.po.OrdPayApply;
import com.tydic.order.uoc.dao.po.OrdPayPO;
import com.tydic.order.uoc.dao.po.OrdRefundFailureLog;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdShipPO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.order.uoc.dao.po.UocOrdPayConfPO;
import com.tydic.uac.util.GenerateIdUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocPayOrderReFundBusiServiceImpl
implements UocPayOrderReFundBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPayOrderReFundBusiServiceImpl.class);
    @Autowired
    private PebIntfPayProRefundAbilityService pebIntfPayProRefundAbilityService;
    @Autowired
    private PebIntfFscDealRefundOrderAbilityService pebIntfFscDealRefundOrderAbilityService;
    @Autowired
    private PebCalculationReturnFeeAtomService pebCalculationReturnFeeAtomService;
    @Autowired
    private OrdPayApplyMapper ordPayApplyMapper;
    @Autowired
    private GenerateIdUtil idUtil;
    @Autowired
    private OrdRefundFailureLogMapper ordRefundFailureLogMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocOrdPayConfMapper uocOrdPayConfMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Value(value="${uoc.pay.refund.notifyUrl:123}")
    private String refundNotifyUrl;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;

    public UocPayOrderReFundRspBO dealOrderReFund(UocPayOrderReFundReqBO reqBO) {
        UocPayOrderReFundRspBO rspBO = new UocPayOrderReFundRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        OrdSalePO ordSale = new OrdSalePO();
        ordSale.setOrderId(reqBO.getOrderId());
        ordSale = this.ordSaleMapper.getModelBy(ordSale);
        if (ordSale == null) {
            log.debug("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u7684\u4fe1\u606f,\u8ba2\u5355id\uff1a{}", (Object)reqBO.getOrderId());
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u7684\u4fe1\u606f");
        }
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(ordSale.getOrderId());
        orderPO = this.orderMapper.getModelBy(orderPO);
        if (UocConstant.ORDER_SOURCE.PROTOCOL_GENERATION.equals(Integer.valueOf(ordSale.getOrderSource())) && PecConstant.OrderType.RY.equals(orderPO.getOrderType())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5197\u4f59\u7269\u8d44\u4e0d\u9000\u6b3e");
            return rspBO;
        }
        reqBO.setSaleVoucherId(ordSale.getSaleVoucherId());
        UocOrdPayConfPO uocOrdPayConf = new UocOrdPayConfPO();
        uocOrdPayConf.setOrderId(ordSale.getOrderId());
        List payConfList = this.uocOrdPayConfMapper.selectByCondition(uocOrdPayConf);
        if (CollectionUtils.isEmpty((Collection)payConfList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u7b14\u8ba2\u5355\u652f\u4ed8\u914d\u7f6e");
            return rspBO;
        }
        UocOrdPayConfPO payConf = (UocOrdPayConfPO)payConfList.get(0);
        OrdPayApply ordPayApply = new OrdPayApply();
        ordPayApply.setOrderId(ordSale.getOrderId());
        OrdPayApply ordPay = this.ordPayApplyMapper.queryOne(ordPayApply);
        if (ordPay == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5f53\u524d\u8ba2\u5355\u4e0d\u9000\u6b3e");
            return rspBO;
        }
        if (UocConstant.PayMod.OFFLINE.equals(ordPay.getPayChannel()) || UocConstant.PayMod.CN_BACK.equals(ordPay.getPayChannel())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5f53\u524d\u7c7b\u578b\u4e0d\u9700\u8981\u9000\u6b3e");
            return rspBO;
        }
        PebIntfFscDealRefundOrderReqBO pebIntfFscDealRefundOrderReqBO = new PebIntfFscDealRefundOrderReqBO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getServiceId())) {
            OrdAfterServicePO ordAfterServicePO = new OrdAfterServicePO();
            ordAfterServicePO.setOrderId(reqBO.getOrderId());
            ordAfterServicePO.setAfterServId(Long.valueOf(reqBO.getServiceId()));
            ordAfterServicePO = this.ordAfterServiceMapper.getModelBy(ordAfterServicePO);
            if (ordAfterServicePO == null) {
                log.debug("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u552e\u540e\u4fe1\u606f,\u8ba2\u5355id\uff1a{}", (Object)reqBO.getOrderId());
                throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u552e\u540e\u4fe1\u606f");
            }
            BigDecimal totalReFundFee = BigDecimal.ZERO;
            if (payConf.getPrePaySup() != null && payConf.getPrePaySup().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal payFee = new BigDecimal(ordAfterServicePO.getRetTotalSaleFee()).divide(new BigDecimal("10000"), 4, 1);
                BigDecimal prePaySup = payConf.getPrePaySup().divide(new BigDecimal("100"), 2, 1);
                totalReFundFee = payFee.multiply(prePaySup).setScale(2, 4);
            } else {
                totalReFundFee = new BigDecimal(ordAfterServicePO.getRetTotalSaleFee()).divide(new BigDecimal("10000"), 2, 1);
            }
            log.info("\u8ba1\u7b97\u540e\u7684\u91d1\u989d\uff1a{}", (Object)totalReFundFee);
            pebIntfFscDealRefundOrderReqBO.setRefundAmtSum(totalReFundFee);
        } else {
            pebIntfFscDealRefundOrderReqBO.setRefundAmtSum(BigDecimal.ZERO);
        }
        OrdPayPO ordPayPO = new OrdPayPO();
        if (ordSale.getPayOrderId() != null) {
            ordPayPO.setOrderId(ordSale.getPayOrderId());
        } else {
            ordPayPO.setOrderId(reqBO.getOrderId());
            ordPayPO.setObjId(ordSale.getSaleVoucherId());
        }
        ordPayPO.setInterType(Integer.valueOf(0));
        ordPayPO = (OrdPayPO)this.ordPayMapper.getList(ordPayPO).get(0);
        if (ordPayPO == null) {
            log.debug("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u6e90\u4ed8\u6b3e\u4fe1\u606f,\u8ba2\u5355id\uff1a{}", (Object)reqBO.getOrderId());
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u6e90\u4ed8\u6b3e\u4fe1\u606f");
        }
        if (BigDecimal.ZERO.compareTo(pebIntfFscDealRefundOrderReqBO.getRefundAmtSum()) == 0 && null != payConf.getPrePaySup()) {
            BigDecimal payFee = new BigDecimal(ordPayPO.getPayFee()).divide(new BigDecimal("10000"), 4, 1);
            BigDecimal prePaySup = payConf.getPrePaySup().divide(new BigDecimal("100"), 2, 1);
            BigDecimal totalReFundFee = payFee.multiply(prePaySup).setScale(2, 4);
            log.info("\u8ba1\u7b97\u540e\u7684\u91d1\u989d\uff1a{}", (Object)totalReFundFee);
            PebCalculationReturnFeeReqBO pebCalculationReturnFeeReqBO = new PebCalculationReturnFeeReqBO();
            pebCalculationReturnFeeReqBO.setOrderId(reqBO.getOrderId());
            pebCalculationReturnFeeReqBO.setTotalFee(ordSale.getSaleFee());
            Long refundFee = totalReFundFee.multiply(new BigDecimal("10000")).setScale(0, 1).longValue();
            log.info("\u4f20\u7ed9\u7ed3\u7b97\u7684\u9000\u6b3e\u91d1\u989d\u662f\uff1a{}", (Object)totalReFundFee);
            pebCalculationReturnFeeReqBO.setReturnFee(refundFee);
            PebCalculationReturnFeeRspBO pebCalculationReturnFeeRspBO = this.pebCalculationReturnFeeAtomService.calculationReturnFee(pebCalculationReturnFeeReqBO);
            if (pebCalculationReturnFeeRspBO.getPrePayFee() <= 0L) {
                throw new UocProBusinessException("8888", "\u8be5\u7b14\u8ba2\u5355\u4e0d\u80fd\u9000\u6b3e");
            }
            pebIntfFscDealRefundOrderReqBO.setRefundAmtSum(totalReFundFee);
        }
        pebIntfFscDealRefundOrderReqBO.setOrderId(String.valueOf(ordSale.getOrderId()));
        if (StringUtils.isNotBlank((CharSequence)orderPO.getUpdateOperId())) {
            pebIntfFscDealRefundOrderReqBO.setParentOrderId(orderPO.getUpdateOperId());
        }
        pebIntfFscDealRefundOrderReqBO.setOperType(reqBO.getOperType());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getExtOrderId())) {
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setOrderId(ordSale.getOrderId());
            ordShipPO.setExtOrderId(reqBO.getExtOrderId());
            ordShipPO = this.ordShipMapper.getModelBy(ordShipPO);
            if (null != ordShipPO) {
                pebIntfFscDealRefundOrderReqBO.setSendGoodsNo(String.valueOf(ordShipPO.getShipVoucherId()));
            }
        }
        OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
        ordStakeholderPO.setOrderId(ordSale.getOrderId());
        ordStakeholderPO = this.ordStakeholderMapper.getModelBy(ordStakeholderPO);
        if (null != ordStakeholderPO) {
            pebIntfFscDealRefundOrderReqBO.setPayableNo(ordStakeholderPO.getExtField4());
            pebIntfFscDealRefundOrderReqBO.setOperatorName(ordStakeholderPO.getPurRelaName());
            pebIntfFscDealRefundOrderReqBO.setCompanyId(ordStakeholderPO.getCompanyId());
            pebIntfFscDealRefundOrderReqBO.setCompanyName(ordStakeholderPO.getCompanyName());
        }
        pebIntfFscDealRefundOrderReqBO.setOperatorId(Long.valueOf(orderPO.getCreateOperId()));
        pebIntfFscDealRefundOrderReqBO.setOutRefundOrderSn(ordPayPO.getOutPayOrderNo());
        pebIntfFscDealRefundOrderReqBO.setFlowType(orderPO.getUserType());
        log.info("\u8c03\u7528\u7ed3\u7b97\u9000\u6b3e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)pebIntfFscDealRefundOrderReqBO));
        PebIntfFscDealRefundOrderRspBO pebIntfFscDealRefundOrderRspBO = this.pebIntfFscDealRefundOrderAbilityService.dealMakeRefundOrder(pebIntfFscDealRefundOrderReqBO);
        log.info("\u8c03\u7528\u7ed3\u7b97\u9000\u6b3e\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)pebIntfFscDealRefundOrderRspBO));
        if (!"0000".equals(pebIntfFscDealRefundOrderRspBO.getRespCode())) {
            log.error("\u8c03\u7528\u7ed3\u7b97\u4e2d\u5fc3\u9000\u6b3e\u670d\u52a1\u5931\u8d25,\u5f02\u5e38\u63cf\u8ff0\uff1a{}" + pebIntfFscDealRefundOrderRspBO.getRespDesc());
            this.recordRefundLog(ordSale, pebIntfFscDealRefundOrderRspBO);
            throw new UocProBusinessException(rspBO.getRespCode(), "\u9000\u6b3e\u5931\u8d25\uff1a" + rspBO.getRespDesc());
        }
        if ("03".equals(pebIntfFscDealRefundOrderRspBO.getDealResult())) {
            this.recordRefundLog(ordSale, pebIntfFscDealRefundOrderRspBO);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(pebIntfFscDealRefundOrderRspBO.getRespDesc());
            return rspBO;
        }
        if ("02".equals(pebIntfFscDealRefundOrderRspBO.getDealResult())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        if ("01".equals(pebIntfFscDealRefundOrderRspBO.getDealResult())) {
            if (StringUtils.isNotBlank((CharSequence)reqBO.getServiceId())) {
                this.run(reqBO);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        return rspBO;
    }

    private void recordRefundLog(OrdSalePO sale, PebIntfFscDealRefundOrderRspBO pebIntfFscDealRefundOrderRspBO) {
        try {
            Long id = this.idUtil.nextId();
            OrdRefundFailureLog ordRefundFailureLog = new OrdRefundFailureLog();
            ordRefundFailureLog.setId(id);
            ordRefundFailureLog.setOrderId(sale.getOrderId());
            ordRefundFailureLog.setObjId(sale.getSaleVoucherId());
            ordRefundFailureLog.setObjType(UocConstant.OBJ_TYPE.SALE);
            ordRefundFailureLog.setStepType("\u9000\u6b3e");
            ordRefundFailureLog.setRefundMoney(sale.getSaleFee());
            ordRefundFailureLog.setBeRefundPerson("111");
            ordRefundFailureLog.setRefundFailuerReason(pebIntfFscDealRefundOrderRspBO.getRespDesc());
            ordRefundFailureLog.setAgainRefundNum(Integer.valueOf(0));
            this.ordRefundFailureLogMapper.insert(ordRefundFailureLog);
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u5931\u8d25\u8bb0\u5f55\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }

    private void run(UocPayOrderReFundReqBO reqBO) {
        OrdAfterServicePO ordAfterServicePO = new OrdAfterServicePO();
        ordAfterServicePO.setOrderId(reqBO.getOrderId());
        ordAfterServicePO.setAfsServiceId(reqBO.getServiceId());
        ordAfterServicePO = this.ordAfterServiceMapper.getModelBy(ordAfterServicePO);
        HashMap<String, String> var = new HashMap<String, String>(1);
        var.put("payFlag", "1");
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setProcDefKey("after_sale_order_status");
        processRunReqBO.setObjId(ordAfterServicePO.getAfterServId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.AFTER_SERVICE);
        processRunReqBO.setOrderId(ordAfterServicePO.getOrderId());
        processRunReqBO.setVariables(var);
        processRunReqBO.setOperId("0");
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }
}

