/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.ship;

import com.tydic.order.pec.bo.order.UocOrdStakeholderRspBO;
import com.tydic.order.pec.bo.other.UocOrdAccessoryRspBO;
import com.tydic.order.pec.bo.ship.UocOrdShipItemRspBO;
import com.tydic.order.pec.bo.ship.UocOrdShipRspBO;
import com.tydic.order.pec.bo.ship.UocShipDetailsListQueryReqBO;
import com.tydic.order.pec.bo.ship.UocShipDetailsListQueryRspBO;
import com.tydic.order.pec.bo.ship.UocShipDetailsQueryRspBO;
import com.tydic.order.pec.busi.ship.UocShipDetailsListQueryBusiService;
import com.tydic.order.pec.dic.SelectDicValByPcodeAndCode;
import com.tydic.order.pec.dic.bo.SelectSingleDictReqBO;
import com.tydic.order.pec.dic.bo.SelectSingleDictRspBO;
import com.tydic.order.uoc.atom.ship.UocCoreShipDetailsQueryAtomService;
import com.tydic.order.uoc.bo.afterservice.AfterServBO;
import com.tydic.order.uoc.bo.order.OrdStakeholderRspBO;
import com.tydic.order.uoc.bo.other.OrdAccessoryRspBO;
import com.tydic.order.uoc.bo.ship.OrdShipItemRspBO;
import com.tydic.order.uoc.bo.ship.UocCoreShipDetailsQueryReqBO;
import com.tydic.order.uoc.bo.ship.UocCoreShipDetailsQueryRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdAfterServiceMapper;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdShipMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdLogisticsRelaPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdShipPO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocShipDetailsQueryBusiService")
public class UocShipDetailsListQueryBusiServiceImpl
implements UocShipDetailsListQueryBusiService {
    @Autowired
    private UocCoreShipDetailsQueryAtomService uocCoreShipDetailsQueryAtomService;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;

    /*
     * Enabled aggressive block sorting
     */
    public UocShipDetailsListQueryRspBO getShipDetailsQuery(UocShipDetailsListQueryReqBO reqBO) {
        UocShipDetailsListQueryRspBO rspBO = new UocShipDetailsListQueryRspBO();
        this.validateParams(reqBO);
        if (null != reqBO.getShipVoucherId()) {
            ArrayList<UocShipDetailsQueryRspBO> shipDetailsQueryRspBOList = new ArrayList<UocShipDetailsQueryRspBO>();
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setOrderId(reqBO.getOrderId());
            ordShipPO.setShipVoucherId(reqBO.getShipVoucherId());
            UocCoreShipDetailsQueryRspBO atomRspBO = this.transferAtomService(reqBO, false);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                rspBO.setRespCode(atomRspBO.getRespCode());
                rspBO.setRespDesc(atomRspBO.getRespDesc());
                return rspBO;
            }
            UocShipDetailsQueryRspBO uocShipDetailsQueryRspBO = this.buildAtomRspBO(atomRspBO, ordShipPO, false, reqBO);
            this.transOrdShip(uocShipDetailsQueryRspBO.getOrdShipRspBO());
            this.buildOrdStakeholderRspBO(uocShipDetailsQueryRspBO.getOrdShipRspBO());
            shipDetailsQueryRspBOList.add(uocShipDetailsQueryRspBO);
            rspBO.setShipDetailsQueryRspBOList(shipDetailsQueryRspBOList);
        } else {
            List ordShipPOList;
            OrdShipPO shipPO = new OrdShipPO();
            shipPO.setOrderId(reqBO.getOrderId());
            if (null != reqBO.getShipStatus()) {
                shipPO.setShipStatus(String.valueOf(reqBO.getShipStatus()));
            }
            if (!CollectionUtils.isNotEmpty((Collection)(ordShipPOList = this.ordShipMapper.getList(shipPO)))) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u53d1\u8d27\u5355\u4fe1\u606f:" + reqBO.getOrderId());
                return rspBO;
            }
            ArrayList<UocShipDetailsQueryRspBO> shipDetailsQueryRspBOList = new ArrayList<UocShipDetailsQueryRspBO>();
            for (OrdShipPO ordShipPO : ordShipPOList) {
                reqBO.setShipVoucherId(ordShipPO.getShipVoucherId());
                UocCoreShipDetailsQueryRspBO atomRspBO = new UocCoreShipDetailsQueryRspBO();
                if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) && !"0000".equals((atomRspBO = this.transferAtomService(reqBO, true)).getRespCode())) {
                    rspBO.setRespCode(atomRspBO.getRespCode());
                    rspBO.setRespDesc(atomRspBO.getRespDesc());
                    return rspBO;
                }
                UocShipDetailsQueryRspBO uocShipDetailsQueryRspBO = this.buildAtomRspBO(atomRspBO, ordShipPO, true, reqBO);
                this.transOrdShip(uocShipDetailsQueryRspBO.getOrdShipRspBO());
                this.buildOrdStakeholderRspBO(uocShipDetailsQueryRspBO.getOrdShipRspBO());
                shipDetailsQueryRspBOList.add(uocShipDetailsQueryRspBO);
            }
            rspBO.setShipDetailsQueryRspBOList(shipDetailsQueryRspBOList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParams(UocShipDetailsListQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("0001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("0001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("0002", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
    }

    private UocOrdShipRspBO buildOrdShipRspBO(OrdShipPO ordShipPO) {
        UocOrdShipRspBO ordShipRspBO = new UocOrdShipRspBO();
        BeanUtils.copyProperties((Object)ordShipPO, (Object)ordShipRspBO);
        ordShipRspBO.setShipExtraMap(this.buildShipExtraInfoMap(ordShipPO));
        AfterServBO afterServBO = new AfterServBO();
        afterServBO.setShipVoucherId(ordShipPO.getShipVoucherId());
        afterServBO.setOrderId(ordShipPO.getOrderId());
        ArrayList<Integer> notStatus = new ArrayList<Integer>(2);
        notStatus.add(UocConstant.AFS_ORDER_STATUS.SUCCESS);
        notStatus.add(UocConstant.ZONE_AFS_STATUS.COMPLETE);
        afterServBO.setNotStatus(notStatus);
        int notEndCount = this.ordAfterServiceMapper.getNotEndCount(afterServBO);
        if (0 < notEndCount) {
            ordShipRspBO.setIsUndoneAfter(Integer.valueOf(0));
        } else {
            ordShipRspBO.setIsUndoneAfter(Integer.valueOf(1));
        }
        return ordShipRspBO;
    }

    private Map<String, Object> buildShipExtraInfoMap(OrdShipPO ordShipPO) {
        HashMap<String, Object> orderExtraMap = new HashMap<String, Object>(16);
        OrdExtMapPO ordExtMapCondition = new OrdExtMapPO();
        ordExtMapCondition.setOrderId(ordShipPO.getOrderId());
        ordExtMapCondition.setObjId(ordShipPO.getShipVoucherId());
        ordExtMapCondition.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
        List ordExtMapList = this.ordExtMapMapper.getList(ordExtMapCondition);
        if (!CollectionUtils.isEmpty((Collection)ordExtMapList)) {
            for (OrdExtMapPO ordExtMap : ordExtMapList) {
                orderExtraMap.put(ordExtMap.getFieldCode(), ordExtMap.getFieldValue());
            }
        }
        return orderExtraMap;
    }

    private UocCoreShipDetailsQueryRspBO transferAtomService(UocShipDetailsListQueryReqBO reqBO, Boolean isQueryLevel) {
        UocCoreShipDetailsQueryReqBO atomReqBO = new UocCoreShipDetailsQueryReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)atomReqBO);
        atomReqBO.setOrderId(reqBO.getOrderId());
        atomReqBO.setShipVoucherId(reqBO.getShipVoucherId());
        if (isQueryLevel.booleanValue()) {
            atomReqBO.setQueryLevel(UocCoreConstant.QUERY_LEVEL.QUERY_ITEM);
        }
        return this.uocCoreShipDetailsQueryAtomService.getShipDetailsQuery(atomReqBO);
    }

    private UocShipDetailsQueryRspBO buildAtomRspBO(UocCoreShipDetailsQueryRspBO atomRspBO, OrdShipPO ordShipPO, Boolean isBuildPrimary, UocShipDetailsListQueryReqBO reqBO) {
        UocShipDetailsQueryRspBO uocShipDetailsQueryRspBO = new UocShipDetailsQueryRspBO();
        if (isBuildPrimary.booleanValue()) {
            uocShipDetailsQueryRspBO.setOrdShipRspBO(this.buildOrdShipRspBO(ordShipPO));
        } else {
            UocOrdShipRspBO uocOrdShipRspBO = new UocOrdShipRspBO();
            BeanUtils.copyProperties((Object)atomRspBO.getOrdShipRspBO(), (Object)uocOrdShipRspBO);
            uocShipDetailsQueryRspBO.setOrdShipRspBO(uocOrdShipRspBO);
        }
        if (CollectionUtils.isNotEmpty((Collection)atomRspBO.getShipAccessoryRspList())) {
            ArrayList<UocOrdAccessoryRspBO> ordAccessoryRspBOList = new ArrayList<UocOrdAccessoryRspBO>();
            for (OrdAccessoryRspBO ordAccessoryRspBO : atomRspBO.getShipAccessoryRspList()) {
                UocOrdAccessoryRspBO uocOrdAccessoryRspBO = new UocOrdAccessoryRspBO();
                BeanUtils.copyProperties((Object)ordAccessoryRspBO, (Object)uocOrdAccessoryRspBO);
                ordAccessoryRspBOList.add(uocOrdAccessoryRspBO);
            }
            uocShipDetailsQueryRspBO.setShipAccessoryRspList(ordAccessoryRspBOList);
        }
        if (CollectionUtils.isNotEmpty((Collection)atomRspBO.getOrdShipItemRspBOList())) {
            ArrayList<UocOrdShipItemRspBO> ordShipItemRspBOList = new ArrayList<UocOrdShipItemRspBO>();
            for (OrdShipItemRspBO ordShipItemRspBO : atomRspBO.getOrdShipItemRspBOList()) {
                UocOrdShipItemRspBO uocOrdShipItemRspBO = new UocOrdShipItemRspBO();
                BeanUtils.copyProperties((Object)ordShipItemRspBO, (Object)uocOrdShipItemRspBO);
                if (null != reqBO.getAfterDimension()) {
                    if (UocCoreConstant.shipAfterDimension.SHIPPING.equals(reqBO.getAfterDimension())) {
                        if (null != ordShipItemRspBO.getReturnCount() && BigDecimal.ZERO.compareTo(ordShipItemRspBO.getReturnCount()) < 0) {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getSendCount().subtract(ordShipItemRspBO.getReturnCount()));
                        } else {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getSendCount());
                        }
                    } else if (UocCoreConstant.shipAfterDimension.ARRIVED.equals(reqBO.getAfterDimension())) {
                        if (null != ordShipItemRspBO.getReturnCount() && BigDecimal.ZERO.compareTo(ordShipItemRspBO.getReturnCount()) < 0) {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getArriveCount().subtract(ordShipItemRspBO.getReturnCount()));
                        } else {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getArriveCount());
                        }
                    } else if (UocCoreConstant.shipAfterDimension.ACCEPTED.equals(reqBO.getAfterDimension())) {
                        if (null != ordShipItemRspBO.getReturnCount() && BigDecimal.ZERO.compareTo(ordShipItemRspBO.getReturnCount()) < 0) {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getAcceptanceCount().subtract(ordShipItemRspBO.getReturnCount()));
                        } else {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getAcceptanceCount());
                        }
                    }
                }
                ordShipItemRspBOList.add(uocOrdShipItemRspBO);
            }
            uocShipDetailsQueryRspBO.setOrdShipItemRspBOList(ordShipItemRspBOList);
        }
        uocShipDetailsQueryRspBO.setRespCode("0000");
        uocShipDetailsQueryRspBO.setRespDesc("\u6210\u529f");
        return uocShipDetailsQueryRspBO;
    }

    public void transOrdShip(UocOrdShipRspBO ordShipRspBO) {
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(ordShipRspBO.getShipStatus() + "");
        dictReqBO.setPcode("SHIP_ORDER_STATUS");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordShipRspBO.setShipStatusStr(dictRspBO.getDicDictionarys().getDescrip());
        }
    }

    private void buildOrdStakeholderRspBO(UocOrdShipRspBO ordShipRspBO) {
        OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(ordShipRspBO.getOrderId().longValue());
        OrdLogisticsRelaPO ordLogisticsRelaPO = new OrdLogisticsRelaPO();
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(ordShipRspBO.getOrderId());
        OrdSalePO salePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (null != salePO) {
            ordLogisticsRelaPO.setOrderId(ordShipRspBO.getOrderId());
            ordLogisticsRelaPO.setContactId(salePO.getContactId());
            OrdLogisticsRelaPO relaPO = this.ordLogisticsRelaMapper.getModelBy(ordLogisticsRelaPO);
            OrdStakeholderRspBO ordStakeholderRspBO = new OrdStakeholderRspBO();
            if (null != ordStakeholderPO) {
                BeanUtils.copyProperties((Object)ordStakeholderPO, (Object)ordStakeholderRspBO);
            }
            if (null != relaPO) {
                ordStakeholderRspBO.setPurAddress(relaPO.getContactAddress());
            }
            UocOrdStakeholderRspBO uocOrdStakeholderRspBO = new UocOrdStakeholderRspBO();
            BeanUtils.copyProperties((Object)ordStakeholderRspBO, (Object)ordStakeholderRspBO);
            ordShipRspBO.setOrdStakeholderRspBO(uocOrdStakeholderRspBO);
        }
    }
}

