/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.config.mq;

import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.tydic.order.pec.consumer.UocNotifyOrderConsumer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MqOrderNotifyMessageConfiguration {
    @Value(value="${UOC_NOTIFY_ORDER_PID}")
    private String orderCreatePid;
    @Value(value="${UOC_NOTIFY_ORDER_CID}")
    private String orderCreateCid;
    @Value(value="${UOC_NOTIFY_ORDER_TOPIC}")
    private String orderCreateTopic;
    @Value(value="${UOC_NOTIFY_ORDER_TAG}")
    private String orderCreateTag;

    @Bean(value={"notifyOrderMsgProxyMessageConfig"})
    public DefaultProxyMessageConfig defaultProxyMessageConfig() {
        DefaultProxyMessageConfig defaultProxyMessageConfig = new DefaultProxyMessageConfig();
        defaultProxyMessageConfig.setId(this.orderCreatePid);
        return defaultProxyMessageConfig;
    }

    @Bean(value={"notifyOrderMsgProvider"}, initMethod="startup", destroyMethod="shutdown")
    public ProxyProducerFactoryBean proxyProducerFactoryBean() {
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig((ProxyMessageConfig)this.defaultProxyMessageConfig());
        return proxyProducerFactoryBean;
    }

    @Bean(value={"uocNotifyOrderConsumer"})
    public UocNotifyOrderConsumer uocCreateOrderConsumer() {
        UocNotifyOrderConsumer pebNotifyOrderConsumer = new UocNotifyOrderConsumer();
        pebNotifyOrderConsumer.setId(this.orderCreateCid);
        pebNotifyOrderConsumer.setSubject(this.orderCreateTopic);
        String[] tags = new String[]{this.orderCreateTag};
        pebNotifyOrderConsumer.setTags(tags);
        return pebNotifyOrderConsumer;
    }
}

