/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.order.pec.atom.es.order.bo.UocPebUpdateMsgPoolReqBO;
import com.tydic.order.pec.atom.es.order.bo.UocPebUpdateMsgPoolRspBO;
import com.tydic.order.pec.bo.es.consumer.UocPebGeneralConsumerReqBO;
import com.tydic.order.pec.bo.es.order.UocPebExtRetailerNoticeShipReqBO;
import com.tydic.order.pec.bo.es.order.UocPebExtRetailerNoticeShipRspBO;
import com.tydic.order.pec.busi.es.others.UocPebUpdateMsgPoolBusiService;
import com.tydic.order.pec.comb.es.order.UocPebExtRetailerNoticeShipCombService;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.uoc.atom.core.UocCoreBusiOperRecordAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreBusiOperRecordReqBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class UocPebUpdateShipSendedConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(UocPebUpdateShipSendedConsumer.class);
    private static final Logger LOG = LoggerFactory.getLogger(UocPebUpdateShipSendedConsumer.class);
    private final boolean IS_DEBUG_ENABLED = LOG.isDebugEnabled();
    public static final String UPDATE = "\u4fee\u6539";
    @Autowired
    private UocPebExtRetailerNoticeShipCombService uocPebExtRetailerNoticeShipCombService;
    @Autowired
    private UocPebUpdateMsgPoolBusiService uocPebUpdateMsgPoolBusiService;
    @Autowired
    private UocCoreBusiOperRecordAtomService uocCoreBusiOperRecordAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Value(value="${isActivationTemp}")
    private boolean isActivationTemp;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        if (this.IS_DEBUG_ENABLED) {
            LOG.debug("\u7535\u5b50\u8d85\u5e02\u66f4\u65b0\u6216\u521b\u5efa\u53d1\u8d27\u5355\u4fe1\u606f\u6d88\u8d39\u8005Start------");
        }
        try {
            UocPebExtRetailerNoticeShipRspBO rspBO;
            UocPebGeneralConsumerReqBO uocPebGeneralConsumerReqBO = (UocPebGeneralConsumerReqBO)JSON.parseObject((String)proxyMessage.getContent(), (TypeReference)new TypeReference<UocPebGeneralConsumerReqBO>(){}, (Feature[])new Feature[0]);
            if (this.IS_DEBUG_ENABLED) {
                LOG.debug("\u8f6c\u6362\u540e\u5f97\u5230\u7684\u6d88\u8d39\u8005\u53c2\u6570\u4e3a:" + uocPebGeneralConsumerReqBO.toString());
            }
            UocPebExtRetailerNoticeShipReqBO reqBO = new UocPebExtRetailerNoticeShipReqBO();
            BeanUtils.copyProperties((Object)uocPebGeneralConsumerReqBO, (Object)reqBO);
            try {
                rspBO = this.uocPebExtRetailerNoticeShipCombService.executeUpdateOrCreateShip(reqBO);
            }
            catch (Exception e) {
                rspBO = new UocPebExtRetailerNoticeShipRspBO();
                rspBO.setRespCode("8888");
            }
            if (!"0000".equals(rspBO.getRespCode())) {
                LOG.debug("\u66f4\u65b0\u6216\u521b\u5efa\u53d1\u8d27\u5355\u4fe1\u606f\u5931\u8d25" + rspBO.getRespDesc());
            }
            if (!this.isActivationTemp) {
                this.updateMsgPoolInfo(uocPebGeneralConsumerReqBO, rspBO);
            }
            if (this.IS_DEBUG_ENABLED) {
                LOG.debug("\u7535\u5b50\u8d85\u5e02\u66f4\u65b0\u6216\u521b\u5efa\u53d1\u8d27\u5355\u4fe1\u606f\u6d88\u8d39\u8005End------");
            }
            this.buildOrderLog(uocPebGeneralConsumerReqBO.getOrderId());
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            LOG.error("\u66f4\u65b0\u6216\u521b\u5efa\u53d1\u8d27\u5355\u4fe1\u606f\u5931\u8d25" + e);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }

    private void buildOrderLog(Long orderId) {
        try {
            UocCoreBusiOperRecordReqBO recordReqBO = new UocCoreBusiOperRecordReqBO();
            recordReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            recordReqBO.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.ORDER_LOG_RECORD);
            recordReqBO.setDealOperId("01");
            recordReqBO.setOrderId(orderId);
            recordReqBO.setDealOperName("01");
            recordReqBO.setDealDesc(UPDATE);
            recordReqBO.setCreateTime(new Date());
            recordReqBO.setIpAddress("\u672a\u77e5");
            OrdSalePO ordSale = this.getOrdSale(orderId);
            recordReqBO.setOrderNo(ordSale.getSaleVoucherNo());
            this.uocCoreBusiOperRecordAtomService.createBusiOperRecord(recordReqBO);
            log.info("\u8bb0\u5f55\u8ba2\u5355\u65e5\u5fd7\u6210\u529f...");
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            throw new ZTBusinessException(String.format("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\uff0c\u5f02\u5e38\u8be6\u60c5\uff1a%s", e.getMessage()));
        }
    }

    private OrdSalePO getOrdSale(Long saleVoucherId) {
        OrdSalePO orderSale = this.ordSaleMapper.getModelById(saleVoucherId.longValue());
        if (null == orderSale) {
            throw new UocProBusinessException("0200", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u8bb0\u5f55");
        }
        return orderSale;
    }

    private void updateMsgPoolInfo(UocPebGeneralConsumerReqBO consumerReqBO, UocPebExtRetailerNoticeShipRspBO rspBO) {
        UocPebUpdateMsgPoolReqBO uocPebUpdateMsgPoolReqBO = new UocPebUpdateMsgPoolReqBO();
        uocPebUpdateMsgPoolReqBO.setMsgId(consumerReqBO.getMsgId());
        uocPebUpdateMsgPoolReqBO.setGoodSupplierId(consumerReqBO.getSupplierId());
        if (!"0000".equals(rspBO.getRespCode())) {
            uocPebUpdateMsgPoolReqBO.setRunResult(PecConstant.OUT_MSG_RUN_RESULT.RUN_FAILURE);
            uocPebUpdateMsgPoolReqBO.setFailureReason(rspBO.getRespDesc());
        } else {
            uocPebUpdateMsgPoolReqBO.setRunResult(PecConstant.OUT_MSG_RUN_RESULT.RUN_SUCCESS);
        }
        UocPebUpdateMsgPoolRspBO updateMsgPoolRspBO = this.uocPebUpdateMsgPoolBusiService.updateMsgPool(uocPebUpdateMsgPoolReqBO);
        if (!"0000".equals(updateMsgPoolRspBO.getRespCode())) {
            LOG.error("\u7535\u5b50\u8d85\u5e02\u53d1\u8d27\u5b8c\u6210\u540e\u66f4\u65b0\u6d88\u606f\u6c60\u6570\u636e\u5931\u8d25\uff1a" + updateMsgPoolRspBO.getRespDesc());
        }
    }
}

