/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.order.pec.dic.SelectDicValBypCodesBusiService;
import com.tydic.order.pec.dic.bo.DicDictionaryBO;
import com.tydic.order.pec.dic.bo.DicValAndpCodeBO;
import com.tydic.order.pec.dic.bo.SelectDicValBypCodesReqBO;
import com.tydic.order.pec.dic.bo.SelectDicValBypCodesRspBO;
import com.tydic.order.uoc.ability.UocProOrderEffectiveListPageQueryAbilityService;
import com.tydic.order.uoc.ability.bo.UocProOrderEffectiveInfoBo;
import com.tydic.order.uoc.ability.bo.UocProOrderEffectiveListPageQueryReqBo;
import com.tydic.order.uoc.ability.bo.UocProOrderEffectiveListPageQueryRspBo;
import com.tydic.order.uoc.dao.ConfEffectiveMapper;
import com.tydic.order.uoc.dao.po.ConfEffectivePO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=UocProOrderEffectiveListPageQueryAbilityService.class)
public class UocProOrderEffectiveListPageQueryAbilityServiceImpl
implements UocProOrderEffectiveListPageQueryAbilityService {
    @Autowired
    private ConfEffectiveMapper confEffectiveMapper;
    @Autowired
    private SelectDicValBypCodesBusiService selectDicValBypCodesBusiService;

    public UocProOrderEffectiveListPageQueryRspBo queryOrderEffectiveListPage(UocProOrderEffectiveListPageQueryReqBo reqBo) {
        UocProOrderEffectiveListPageQueryRspBo rspBo = new UocProOrderEffectiveListPageQueryRspBo();
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        ConfEffectivePO effectivePOWhere = new ConfEffectivePO();
        Map<String, String> effectiveNameMap = null;
        if (null != reqBo.getEffectiveId() && 0L != reqBo.getEffectiveId()) {
            effectivePOWhere.setEffectiveId(reqBo.getEffectiveId());
        } else {
            if (StringUtils.hasText((String)reqBo.getEffectiveName())) {
                DicValAndpCodeBO effectiveName = this.getEffectiveCodeListByEffectiveName();
                if (null == effectiveName || CollectionUtils.isEmpty((Collection)effectiveName.getDicDictionaries())) {
                    rspBo.setTotal(0);
                    rspBo.setRecordsTotal(0);
                    rspBo.setRows(new ArrayList(0));
                    return rspBo;
                }
                effectiveNameMap = new HashMap<String, String>(effectiveName.getDicDictionaries().size());
                ArrayList<String> effectiveCodeList = new ArrayList<String>();
                for (DicDictionaryBO dicDictionaryBO : effectiveName.getDicDictionaries()) {
                    if (null == dicDictionaryBO.getDescrip() || !dicDictionaryBO.getDescrip().contains(reqBo.getEffectiveName())) continue;
                    effectiveCodeList.add(dicDictionaryBO.getCode());
                    effectiveNameMap.put(dicDictionaryBO.getCode(), dicDictionaryBO.getDescrip());
                }
                if (CollectionUtils.isEmpty(effectiveCodeList)) {
                    rspBo.setTotal(0);
                    rspBo.setRecordsTotal(0);
                    rspBo.setRows(new ArrayList(0));
                    return rspBo;
                }
                effectivePOWhere.setEffectiveCodeList(effectiveCodeList);
            }
            effectivePOWhere.setBusinessTypeCode(reqBo.getBusinessTypeCode());
            effectivePOWhere.setSupplierNo(reqBo.getSupplierNo());
            effectivePOWhere.setSourceCode(reqBo.getSourceCode());
            effectivePOWhere.setOperatingTimeStart(DateUtils.strToDateLong((String)reqBo.getOperatingTimeStart()));
            effectivePOWhere.setOperatingTimeEnd(DateUtils.strToDateLong((String)reqBo.getOperatingTimeEnd()));
            effectivePOWhere.setOperatorName(reqBo.getOperatorName());
        }
        effectivePOWhere.setOrderBy("effective_code, source_code,case business_type_code when '2' then 1 when '1' then 2 else 3 end");
        Page confEffectivePOPage = new Page();
        confEffectivePOPage.setPageNo(reqBo.getPageNo());
        confEffectivePOPage.setPageSize(reqBo.getPageSize());
        List effectivePOList = this.confEffectiveMapper.getListPage(effectivePOWhere, confEffectivePOPage);
        if (CollectionUtils.isEmpty((Collection)effectivePOList)) {
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList(0));
        } else {
            rspBo.setTotal(confEffectivePOPage.getTotalPages());
            rspBo.setRecordsTotal(confEffectivePOPage.getTotalCount());
            ArrayList<UocProOrderEffectiveInfoBo> rows = new ArrayList<UocProOrderEffectiveInfoBo>(effectivePOList.size());
            List<Map<String, String>> dicValName = this.getDicValName(effectiveNameMap);
            effectiveNameMap = dicValName.get(0);
            Map<String, String> businessTypeMap = dicValName.get(1);
            Map<String, String> sourceNameMap = dicValName.get(2);
            for (ConfEffectivePO effectivePO : effectivePOList) {
                UocProOrderEffectiveInfoBo orderEffectiveInfoBo = new UocProOrderEffectiveInfoBo();
                orderEffectiveInfoBo.setEffectiveId(effectivePO.getEffectiveId());
                orderEffectiveInfoBo.setEffectiveCode(effectivePO.getEffectiveCode());
                orderEffectiveInfoBo.setBusinessTypeCode(effectivePO.getBusinessTypeCode());
                orderEffectiveInfoBo.setSupplierNo(effectivePO.getSupplierNo());
                orderEffectiveInfoBo.setSupplierName(effectivePO.getSupplierName());
                orderEffectiveInfoBo.setAging(effectivePO.getAging());
                orderEffectiveInfoBo.setSourceCode(effectivePO.getSourceCode());
                orderEffectiveInfoBo.setOperatingTime(effectivePO.getOperatingTime());
                orderEffectiveInfoBo.setOperatorId(effectivePO.getOperatorId());
                orderEffectiveInfoBo.setOperatorName(effectivePO.getOperatorName());
                if (null != effectiveNameMap) {
                    orderEffectiveInfoBo.setEffectiveName(effectiveNameMap.get(effectivePO.getEffectiveCode()));
                }
                if (null != businessTypeMap) {
                    orderEffectiveInfoBo.setBusinessTypeName(businessTypeMap.get(effectivePO.getBusinessTypeCode()));
                }
                if (null != sourceNameMap) {
                    orderEffectiveInfoBo.setSourceName(sourceNameMap.get(effectivePO.getSourceCode()));
                }
                rows.add(orderEffectiveInfoBo);
            }
            rspBo.setRows(rows);
        }
        return rspBo;
    }

    private DicValAndpCodeBO getEffectiveCodeListByEffectiveName() {
        SelectDicValBypCodesReqBO selectDicValBypCodesReqBO = new SelectDicValBypCodesReqBO();
        selectDicValBypCodesReqBO.setpCodes(Collections.singletonList("EFFECTIVE_CODE"));
        SelectDicValBypCodesRspBO selectDicValBypCodesRspBO = this.selectDicValBypCodesBusiService.selectDicValBypCodes(selectDicValBypCodesReqBO);
        if (!"0000".equals(selectDicValBypCodesRspBO.getRespCode())) {
            throw new UocProBusinessException(selectDicValBypCodesRspBO.getRespCode(), selectDicValBypCodesRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)selectDicValBypCodesRspBO.getDicValAndpCodeBOs())) {
            return null;
        }
        return (DicValAndpCodeBO)((Map)selectDicValBypCodesRspBO.getDicValAndpCodeBOs().get(0)).get("EFFECTIVE_CODE");
    }

    private List<Map<String, String>> getDicValName(Map<String, String> effectiveNameMap) {
        HashMap<String, String> businessTypeMap = null;
        HashMap<String, String> sourceNameMap = null;
        SelectDicValBypCodesReqBO selectDicValBypCodesReqBO = new SelectDicValBypCodesReqBO();
        ArrayList<String> pCodes = new ArrayList<String>();
        if (null == effectiveNameMap) {
            pCodes.add("EFFECTIVE_CODE");
        }
        pCodes.add("ORDER_SOURCE");
        pCodes.add("SOURCE_CODE");
        selectDicValBypCodesReqBO.setpCodes(pCodes);
        SelectDicValBypCodesRspBO selectDicValBypCodesRspBO = this.selectDicValBypCodesBusiService.selectDicValBypCodes(selectDicValBypCodesReqBO);
        if (!"0000".equals(selectDicValBypCodesRspBO.getRespCode())) {
            throw new UocProBusinessException(selectDicValBypCodesRspBO.getRespCode(), selectDicValBypCodesRspBO.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)selectDicValBypCodesRspBO.getDicValAndpCodeBOs())) {
            for (Map dicValAndpCodeBOMap : selectDicValBypCodesRspBO.getDicValAndpCodeBOs()) {
                if (null == dicValAndpCodeBOMap || dicValAndpCodeBOMap.size() <= 0) continue;
                for (Map.Entry dicValAndpCodeBO : dicValAndpCodeBOMap.entrySet()) {
                    DicValAndpCodeBO value = (DicValAndpCodeBO)dicValAndpCodeBO.getValue();
                    if (CollectionUtils.isEmpty((Collection)value.getDicDictionaries())) continue;
                    if ("EFFECTIVE_CODE".equals(dicValAndpCodeBO.getKey())) {
                        if (null == effectiveNameMap) {
                            effectiveNameMap = new HashMap<String, String>(value.getDicDictionaries().size());
                        }
                        for (DicDictionaryBO dicDictionaryBO : value.getDicDictionaries()) {
                            effectiveNameMap.put(dicDictionaryBO.getCode(), dicDictionaryBO.getDescrip());
                        }
                        continue;
                    }
                    if ("ORDER_SOURCE".equals(dicValAndpCodeBO.getKey())) {
                        if (null == businessTypeMap) {
                            businessTypeMap = new HashMap<String, String>(value.getDicDictionaries().size());
                        }
                        for (DicDictionaryBO dicDictionaryBO : value.getDicDictionaries()) {
                            businessTypeMap.put(dicDictionaryBO.getCode(), dicDictionaryBO.getDescrip());
                        }
                        continue;
                    }
                    if (!"SOURCE_CODE".equals(dicValAndpCodeBO.getKey())) continue;
                    if (null == sourceNameMap) {
                        sourceNameMap = new HashMap<String, String>(value.getDicDictionaries().size());
                    }
                    for (DicDictionaryBO dicDictionaryBO : value.getDicDictionaries()) {
                        sourceNameMap.put(dicDictionaryBO.getCode(), dicDictionaryBO.getDescrip());
                    }
                }
            }
        }
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>(3);
        mapList.add(effectiveNameMap);
        mapList.add(businessTypeMap);
        mapList.add(sourceNameMap);
        return mapList;
    }
}

