/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.pec.bo.other.UocOrdIdxSyncReqBO;
import com.tydic.order.pec.busi.es.order.UocPebPreOrderSubmitBsuiService;
import com.tydic.order.pec.busi.es.order.bo.UocPebPreOrderSubmitReqBO;
import com.tydic.order.pec.busi.es.order.bo.UocPebPreOrderSubmitRspBO;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.uoc.ability.UocProOrderPaymentAbilityService;
import com.tydic.order.uoc.ability.bo.UocProOrderPaymentAbilityReqBo;
import com.tydic.order.uoc.ability.bo.UocProOrderPaymentAbilityRspBo;
import com.tydic.order.uoc.atom.process.UocRunProcessAtomService;
import com.tydic.order.uoc.bo.process.UocProcessRunReqBO;
import com.tydic.order.uoc.bo.process.UocProcessRunRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdPayMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdPayPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=UocProOrderPaymentAbilityService.class)
public class UocProOrderPaymentAbilityServiceImpl
implements UocProOrderPaymentAbilityService {
    @Autowired
    private UocPebPreOrderSubmitBsuiService uocPebPreOrderSubmitBsuiService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;

    public UocProOrderPaymentAbilityRspBo dealPay(UocProOrderPaymentAbilityReqBo reqBo) {
        this.validateArg(reqBo);
        UocProOrderPaymentAbilityRspBo rspBo = (UocProOrderPaymentAbilityRspBo)UocProRspBoUtil.success(UocProOrderPaymentAbilityRspBo.class);
        OrdSalePO qryOrderPo = new OrdSalePO();
        qryOrderPo.setOrderId(reqBo.getOrderId());
        OrdSalePO saleRspBO = this.ordSaleMapper.getModelBy(qryOrderPo);
        if (saleRspBO == null) {
            throw new UocProBusinessException("214003", "\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728(" + reqBo.getOrderId() + ")");
        }
        Integer saleState = saleRspBO.getSaleState();
        if (!UocConstant.SALE_ORDER_STATUS.PAYING.equals(saleState)) {
            return (UocProOrderPaymentAbilityRspBo)UocProRspBoUtil.failed((String)("\u8be5\u8ba2\u5355(" + reqBo.getOrderId() + ")\u4e0d\u6ee1\u8db3\u652f\u4ed8\u6761\u4ef6"), UocProOrderPaymentAbilityRspBo.class);
        }
        if (UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(saleState)) {
            return (UocProOrderPaymentAbilityRspBo)UocProRspBoUtil.failed((String)("\u8be5\u8ba2\u5355(" + reqBo.getOrderId() + ")\u5df2\u652f\u4ed8\u6210\u529f\u4e86"), UocProOrderPaymentAbilityRspBo.class);
        }
        if ("2".equals(saleRspBO.getOrderSource())) {
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setSysCode("UOC");
            processRunReqBO.setObjId(saleRspBO.getSaleVoucherId());
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            processRunReqBO.setOrderId(saleRspBO.getOrderId());
            processRunReqBO.setOperId(String.valueOf(reqBo.getUserId()));
            UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
                return (UocProOrderPaymentAbilityRspBo)UocProRspBoUtil.failed((String)("\u4ece\u4ed8\u6b3e\u4e2d\u6d41\u8f6c\u5230\u9884\u8ba2\u5355\u5931\u8d25\uff1a" + uocProcessRunRspBO.getRespDesc()), UocProOrderPaymentAbilityRspBo.class);
            }
            UocPebPreOrderSubmitReqBO submitReqBO = new UocPebPreOrderSubmitReqBO();
            submitReqBO.setOrderId(saleRspBO.getOrderId());
            submitReqBO.setSaleVoucherId(saleRspBO.getSaleVoucherId());
            UocPebPreOrderSubmitRspBO submit = this.uocPebPreOrderSubmitBsuiService.submit(submitReqBO);
            if (!"0000".equals(submit.getRespCode())) {
                return (UocProOrderPaymentAbilityRspBo)UocProRspBoUtil.failed((String)("\u9884\u8ba2\u5355\u786e\u8ba4\u5931\u8d25" + submit.getRespDesc()), UocProOrderPaymentAbilityRspBo.class);
            }
            this.syncSale(saleRspBO);
        } else if ("1".equals(saleRspBO.getOrderSource()) || "3".equals(saleRspBO.getOrderSource())) {
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setSysCode("UOC");
            processRunReqBO.setObjId(saleRspBO.getSaleVoucherId());
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            processRunReqBO.setOrderId(saleRspBO.getOrderId());
            processRunReqBO.setOperId(String.valueOf(reqBo.getUserId()));
            UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
                return (UocProOrderPaymentAbilityRspBo)UocProRspBoUtil.failed((String)("\u4ece\u4ed8\u6b3e\u4e2d\u6d41\u8f6c\u5230\u9884\u8ba2\u5355\u5931\u8d25\uff1a" + uocProcessRunRspBO.getRespDesc()), UocProOrderPaymentAbilityRspBo.class);
            }
            this.syncSale(saleRspBO);
            return rspBo;
        }
        return rspBo;
    }

    private void validateArg(UocProOrderPaymentAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("214003", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("214003", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void syncSale(OrdSalePO saleRspBO) {
        OrdPayPO ordPayPO = new OrdPayPO();
        ordPayPO.setOrderId(saleRspBO.getOrderId());
        ordPayPO.setPayTime(new Date());
        ordPayPO.setObjId(saleRspBO.getSaleVoucherId());
        ordPayPO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
        ordPayPO.setInterType(PecConstant.PAY_FLAG);
        ordPayPO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        this.ordPayMapper.updateById(ordPayPO);
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(saleRspBO.getOrderId());
        orderPO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
        this.orderMapper.updateById(orderPO);
        UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdSaleIdxSyncReqBO.setObjId(saleRspBO.getSaleVoucherId());
        uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdSaleIdxSyncReqBO.setOrderId(saleRspBO.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
    }
}

