/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.aop;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taobao.eagleeye.EagleEye;
import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.bo.PayProBaseRspBo;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=20)
public class UocProLoggerAspect {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String SEPARATOR = "|";
    private static final String excludeMethods = "subscribe";
    private static final String CLASS_METHOD_SEPARATOR = ".";
    private static final String START_IDENTIFICATION = "START";
    private static final String ERROR_IDENTIFICATION = "ERROR";
    private static final String END_IDENTIFICATION = "END";
    private static final Logger atomLogger = LoggerFactory.getLogger(UocProLoggerAspect.class);

    @Pointcut(value="(execution(* com.tydic.order..impl..*(..))) || (execution(* com.tydic.order.*.ability.impl..*(..)))")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        HashMap<String, String> hiddenParm = new HashMap<String, String>();
        String traceId = "";
        if (hiddenParm.containsKey("traceId")) {
            traceId = (String)hiddenParm.get("traceId");
        } else {
            traceId = EagleEye.getTraceId();
            hiddenParm.put("traceId", traceId);
        }
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> rspClass = method.getReturnType();
        Object rspObj = null;
        String[] infos = this.printBusiAopStartLog(pjp, traceId);
        try {
            rspObj = pjp.proceed();
            this.putCodeToRsp(rspObj, "0000", "\u6210\u529f");
        }
        catch (UocProBusinessException e) {
            if (atomLogger.isDebugEnabled()) {
                e.printStackTrace();
            }
            rspObj = rspClass.newInstance();
            String msgCode = e.getMsgCode();
            String desc = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)msgCode)) {
                msgCode = "8888";
            }
            if (StringUtils.isEmpty((CharSequence)desc)) {
                desc = "\u5931\u8d25";
            }
            this.printBusiAopErrorLog(infos, e);
            this.putCodeToRsp(rspObj, msgCode, desc);
        }
        catch (Throwable e) {
            if (!rspClass.isInterface()) {
                if (atomLogger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                this.printBusiAopErrorLog(infos, e);
                rspObj = rspClass.newInstance();
                this.putCodeToRsp(rspObj, "8888", "\u670d\u52a1\u8c03\u7528\u5f02\u5e38:" + e.getMessage());
            }
            throw e;
        }
        this.printBusiAopEndLog(infos, rspObj);
        return rspObj;
    }

    private void printBusiAopErrorLog(String[] infos, Throwable e) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[1] = ERROR_IDENTIFICATION;
        infos[3] = nowTime.toString();
        if (null != this.getThrowableStrRep(e)) {
            infos[5] = this.getThrowableStrRep(e);
        }
        atomLogger.error(this.getLogInfoByStrings(infos));
    }

    private void putCodeToRsp(Object object, String code, String desc) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.putCodeToRsp(object, code, desc, false);
    }

    private void putCodeToRsp(Object object, String code, String desc, boolean fource) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field;
        if (object instanceof PayProBaseRspBo) {
            Field field2 = PayProBaseRspBo.class.getDeclaredField("respCode");
            if (field2 != null) {
                field2.setAccessible(true);
                if (!fource && field2.get(object) == null) {
                    field2.set(object, code);
                    field2 = PayProBaseRspBo.class.getDeclaredField("respDesc");
                    field2.setAccessible(true);
                    field2.set(object, desc);
                } else if (fource && field2.get(object) == null) {
                    field2.set(object, code);
                    field2 = PayProBaseRspBo.class.getDeclaredField("respDesc");
                    field2.setAccessible(true);
                    field2.set(object, desc);
                }
            }
        } else if (object instanceof BaseRspInfoBO && (field = BaseRspInfoBO.class.getDeclaredField("rspCode")) != null) {
            field.setAccessible(true);
            if (!fource && field.get(object) == null) {
                field.set(object, code);
                field = BaseRspInfoBO.class.getDeclaredField("rspName");
                field.setAccessible(true);
                field.set(object, desc);
            } else if (fource && field.get(object) == null) {
                field.set(object, code);
                field = BaseRspInfoBO.class.getDeclaredField("rspName");
                field.setAccessible(true);
                field.set(object, desc);
            }
        }
    }

    private String[] printBusiAopStartLog(ProceedingJoinPoint pjp, String traceId) throws Throwable {
        Long nowTime = System.currentTimeMillis();
        StringBuilder commonHead = new StringBuilder(traceId + SEPARATOR);
        String className = pjp.getTarget().getClass().getName();
        String methodString = pjp.getSignature().getName();
        if (excludeMethods.equals(methodString)) {
            return null;
        }
        commonHead.append(className);
        commonHead.append(CLASS_METHOD_SEPARATOR);
        commonHead.append(methodString);
        String[] infos = new String[8];
        infos[0] = commonHead.toString();
        infos[1] = START_IDENTIFICATION;
        infos[2] = nowTime.toString();
        infos[3] = "";
        Object[] params = pjp.getArgs();
        if (params != null && params.length > 0) {
            if (params.length == 1) {
                try {
                    infos[4] = mapper.writeValueAsString(params[0]);
                }
                catch (JsonProcessingException e) {
                    infos[4] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + params[0]).replace("\r\n", "");
                }
            } else {
                StringBuilder paramsStr = new StringBuilder();
                paramsStr.append("[");
                for (Object obj : params) {
                    String objStr = null;
                    if (obj != null) {
                        try {
                            objStr = mapper.writeValueAsString(obj);
                        }
                        catch (JsonProcessingException e) {
                            objStr = null;
                        }
                    }
                    paramsStr.append(objStr);
                    paramsStr.append(",");
                }
                paramsStr.setLength(paramsStr.length() - 1);
                paramsStr.append("]");
            }
        }
        atomLogger.info(this.getLogInfoByStrings(infos));
        return infos;
    }

    private void printBusiAopEndLog(String[] infos, Object object) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[1] = END_IDENTIFICATION;
        infos[3] = nowTime.toString();
        if (object != null && object instanceof PayProBaseRspBo) {
            PayProBaseRspBo resp = (PayProBaseRspBo)object;
            infos[4] = resp.getRespCode();
            infos[5] = resp.getRespDesc();
            infos[6] = "\u7528\u65f6\uff1a" + (Long.parseLong(infos[3]) - Long.parseLong(infos[2])) + "ms";
            infos[7] = object.toString();
        }
        atomLogger.info(this.getLogInfoByStrings(infos));
    }

    private String getLogInfoByStrings(String[] infos) {
        StringBuilder stb = new StringBuilder();
        for (String info : infos) {
            if (StringUtils.isBlank((CharSequence)info)) {
                info = "";
            }
            stb.append(info + SEPARATOR);
        }
        if (stb.length() > 1) {
            stb.setLength(stb.length() - 1);
        }
        return stb.toString();
    }

    private String getThrowableStrRep(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.flush();
        LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));
        StringBuffer sb = new StringBuffer();
        try {
            String line = reader.readLine();
            while (line != null) {
                sb.append(line + "\r\n");
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            sb.append(ex.toString());
        }
        return sb.toString();
    }
}

