/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.atom.impl.core;

import com.google.common.collect.Maps;
import com.tydic.order.uoc.atom.core.UocCoreExtFieldInAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreExtFieldInReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreExtFieldInRspBO;
import com.tydic.order.uoc.bo.CommonCenterFieldValueBO;
import com.tydic.order.uoc.dao.ConfModFieldMapper;
import com.tydic.order.uoc.dao.OrdCruxMapMapper;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.po.ConfModFieldPO;
import com.tydic.order.uoc.dao.po.OrdCruxMapPO;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreExtFieldInAtomService")
public class UocCoreExtFieldInAtomServiceImpl
implements UocCoreExtFieldInAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UocCoreExtFieldInAtomServiceImpl.class);
    public static final String ORD_CRUX_TABLE = "UOC_ORD_CRUX_MAP";
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;
    @Autowired
    private ConfModFieldMapper confModFieldMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;

    @Override
    public UocCoreExtFieldInRspBO dealCoreExtFieldIn(UocCoreExtFieldInReqBO reqBO) {
        Long orderId = reqBO.getOrderId();
        Integer objType = reqBO.getObjType();
        if (orderId == null || objType == null) {
            throw new UocProBusinessException("7777", "\u8ba2\u5355Id\u3001\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getCruFieldList()) && CollectionUtils.isEmpty(reqBO.getExtFieldList())) {
            throw new UocProBusinessException("7777", "\u5173\u952e\u5b57\u6bb5\u5217\u8868\u8ddf\u975e\u5173\u952e\u5b57\u6bb5\u5217\u8868\u5fc5\u4f20\u5176\u4e00");
        }
        UocCoreExtFieldInRspBO rspBO = new UocCoreExtFieldInRspBO();
        if (reqBO.getCruFieldList() != null && reqBO.getCruFieldList().size() > 0) {
            HashMap fieldValueMap = Maps.newHashMapWithExpectedSize((int)reqBO.getCruFieldList().size());
            StringBuilder fieldCodes = new StringBuilder();
            for (CommonCenterFieldValueBO fieldValueBO : reqBO.getCruFieldList()) {
                if (StringUtils.isBlank((CharSequence)fieldValueBO.getFieldCode()) || StringUtils.isBlank((CharSequence)fieldValueBO.getFieldValue())) {
                    throw new UocProBusinessException("7777", "\u5173\u952e\u5b57\u6bb5\u5217\u8868\u4e2d\u7684fieldCode\u548cfieldValue\u4e0d\u80fd\u4e3a\u7a7a");
                }
                fieldCodes.append("'" + fieldValueBO.getFieldCode() + "',");
                fieldValueMap.put(fieldValueBO.getFieldCode(), fieldValueBO);
            }
            List modFields = this.confModFieldMapper.queryTabFieldByCodes(fieldCodes.substring(0, fieldCodes.length() - 1));
            try {
                if (modFields != null && modFields.size() > 0) {
                    OrdCruxMapPO ordCruxMapPO = new OrdCruxMapPO();
                    ordCruxMapPO.setObjType(objType);
                    ordCruxMapPO.setOrderId(orderId);
                    ordCruxMapPO.setObjId(reqBO.getObjId());
                    OrdCruxMapPO existCrux = this.ordCruxMapMapper.getModelBy(ordCruxMapPO);
                    for (ConfModFieldPO modFieldPO : modFields) {
                        String tableName = modFieldPO.getTabName();
                        String fieldCodeName = modFieldPO.getTabFieldName();
                        fieldCodeName = OrdCruxMapPO.underline2Camel((String)fieldCodeName);
                        if (!ORD_CRUX_TABLE.equalsIgnoreCase(tableName) || !StringUtils.isNotBlank((CharSequence)fieldCodeName)) continue;
                        if (existCrux != null) {
                            this.dynamicSet(existCrux, fieldValueMap, fieldCodeName, modFieldPO.getFieldCode());
                            continue;
                        }
                        this.dynamicSet(ordCruxMapPO, fieldValueMap, fieldCodeName, modFieldPO.getFieldCode());
                    }
                    if (existCrux != null) {
                        this.ordCruxMapMapper.updateById(existCrux);
                    } else {
                        ordCruxMapPO.setId(Long.valueOf(this.sequence.nextId()));
                        this.ordCruxMapMapper.insert(ordCruxMapPO);
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u62d3\u5c55\u5c5e\u6027\u5165\u5e93\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u62d3\u5c55\u5c5e\u6027\u5165\u5e93\u670d\u52a1\u5f02\u5e38");
                return rspBO;
            }
        }
        if (reqBO.getExtFieldList() != null && reqBO.getExtFieldList().size() > 0) {
            ArrayList<OrdExtMapPO> extMapList = new ArrayList<OrdExtMapPO>();
            for (CommonCenterFieldValueBO fieldValueBO : reqBO.getExtFieldList()) {
                if (StringUtils.isBlank((CharSequence)fieldValueBO.getFieldCode()) || StringUtils.isBlank((CharSequence)fieldValueBO.getFieldValue())) {
                    throw new UocProBusinessException("7777", "\u975e\u5173\u952e\u5b57\u6bb5\u5217\u8868\u4e2d\u7684fieldCode\u548cfieldValue\u4e0d\u80fd\u4e3a\u7a7a");
                }
                OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
                ordExtMapPO.setObjType(objType);
                ordExtMapPO.setOrderId(orderId);
                ordExtMapPO.setObjId(reqBO.getObjId());
                ordExtMapPO.setFieldCode(fieldValueBO.getFieldCode());
                ordExtMapPO.setFieldName(fieldValueBO.getFieldName());
                ordExtMapPO.setFieldValue(fieldValueBO.getFieldValue());
                ordExtMapPO.setId(Long.valueOf(this.sequence.nextId()));
                extMapList.add(ordExtMapPO);
            }
            try {
                this.ordExtMapMapper.insertBatch(extMapList);
            }
            catch (Exception e) {
                logger.error("\u62d3\u5c55\u5c5e\u6027\u5165\u5e93\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u62d3\u5c55\u5c5e\u6027\u5165\u5e93\u670d\u52a1\u5f02\u5e38");
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u62d3\u5c55\u5c5e\u6027\u5165\u5e93\u6210\u529f");
        return rspBO;
    }

    private void dynamicSet(OrdCruxMapPO ordCruxMapPO, Map<String, CommonCenterFieldValueBO> fieldValueMap, String fieldCodeName, String fieldKey) throws IllegalAccessException, NoSuchFieldException {
        Field fieldCode2 = ordCruxMapPO.getClass().getDeclaredField(fieldCodeName);
        fieldCode2.setAccessible(true);
        fieldCode2.set(ordCruxMapPO, fieldKey);
        Field fieldValue = ordCruxMapPO.getClass().getDeclaredField(fieldCodeName.replace("Code", "Value"));
        fieldValue.setAccessible(true);
        fieldValue.set(ordCruxMapPO, fieldValueMap.get(fieldKey).getFieldValue());
        Field fieldName = ordCruxMapPO.getClass().getDeclaredField(fieldCodeName.replace("Code", "Name"));
        fieldName.setAccessible(true);
        fieldName.set(ordCruxMapPO, fieldValueMap.get(fieldKey).getFieldName());
    }

    public static final void validList(List<CommonCenterFieldValueBO> list) {
        for (CommonCenterFieldValueBO fieldValueBO : list) {
            if (!StringUtils.isBlank((CharSequence)fieldValueBO.getFieldCode()) && !StringUtils.isBlank((CharSequence)fieldValueBO.getFieldValue())) continue;
            throw new UocProBusinessException("7777", "\u5b57\u6bb5\u5217\u8868\u4e2d\u7684fieldCode\u548cfieldValue\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

