/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.atom.impl.core;

import com.tydic.order.uoc.atom.core.UocCoreGetObjIdAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreGetObjIdReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreGetObjIdRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdAfterServiceMapper;
import com.tydic.order.uoc.dao.OrdInspectionMapper;
import com.tydic.order.uoc.dao.OrdPayMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdShipMapper;
import com.tydic.order.uoc.dao.po.OrdAfterServicePO;
import com.tydic.order.uoc.dao.po.OrdInspectionPO;
import com.tydic.order.uoc.dao.po.OrdPayPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdShipPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreGetObjIdAtomService")
public class UocCoreGetObjIdAtomServiceImpl
implements UocCoreGetObjIdAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UocCoreGetObjIdAtomServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;

    @Override
    public UocCoreGetObjIdRspBO getObjId(UocCoreGetObjIdReqBO reqBO) {
        if (reqBO.getOrderId() == null || reqBO.getObjType() == null) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355ID\u548c\u7968\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UocCoreGetObjIdRspBO rspBO = new UocCoreGetObjIdRspBO();
        Integer objType = reqBO.getObjType();
        Long orderId = reqBO.getOrderId();
        try {
            if (UocConstant.OBJ_TYPE.ORDER.equals(objType)) {
                rspBO.setObjIdList(Arrays.asList(orderId));
            } else if (UocConstant.OBJ_TYPE.SALE.equals(objType) || UocConstant.OBJ_TYPE.PURCHASE.equals(objType)) {
                OrdSalePO ordSaleQuery = new OrdSalePO();
                ordSaleQuery.setOrderId(orderId);
                ordSaleQuery = this.ordSaleMapper.getModelBy(ordSaleQuery);
                if (ordSaleQuery != null) {
                    rspBO.setObjIdList(Arrays.asList(ordSaleQuery.getSaleVoucherId()));
                }
            } else if (UocConstant.OBJ_TYPE.SHIP.equals(objType)) {
                OrdShipPO ordShipQuery = new OrdShipPO();
                ordShipQuery.setOrderId(orderId);
                List orderList = this.ordShipMapper.getList(ordShipQuery);
                if (orderList != null && orderList.size() > 0) {
                    rspBO.setObjIdList(orderList.stream().map(OrdShipPO::getShipVoucherId).collect(Collectors.toList()));
                }
            } else if (UocConstant.OBJ_TYPE.INSPECTION.equals(objType)) {
                OrdInspectionPO ordInspectionQuery = new OrdInspectionPO();
                ordInspectionQuery.setOrderId(orderId);
                List orderList = this.ordInspectionMapper.getList(ordInspectionQuery);
                if (orderList != null && orderList.size() > 0) {
                    rspBO.setObjIdList(orderList.stream().map(OrdInspectionPO::getInspectionVoucherId).collect(Collectors.toList()));
                }
            } else if (UocConstant.OBJ_TYPE.AFTER_SERVICE.equals(objType)) {
                OrdAfterServicePO ordAfterServiceQuery = new OrdAfterServicePO();
                ordAfterServiceQuery.setOrderId(orderId);
                List orderList = this.ordAfterServiceMapper.getList(ordAfterServiceQuery);
                if (orderList != null && orderList.size() > 0) {
                    rspBO.setObjIdList(orderList.stream().map(OrdAfterServicePO::getAfterServId).collect(Collectors.toList()));
                }
            } else if (UocConstant.OBJ_TYPE.PAY.equals(objType)) {
                OrdPayPO ordPayQuery = new OrdPayPO();
                ordPayQuery.setOrderId(orderId);
                ordPayQuery = this.ordPayMapper.getModelBy(ordPayQuery);
                if (ordPayQuery != null) {
                    rspBO.setObjIdList(Arrays.asList(ordPayQuery.getPayVoucherId()));
                }
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u4e0d\u652f\u6301\u7684objType\u7c7b\u578b");
                return rspBO;
            }
            if (rspBO.getObjIdList() != null && rspBO.getObjIdList().size() > 0) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u83b7\u53d6\u5355\u636e\u53f7\u5217\u8868\u6210\u529f");
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5355\u636eID");
            }
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5355\u636e\u53f7\u5217\u8868\u539f\u5b50\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u83b7\u53d6\u5355\u636e\u53f7\u5217\u8868\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            return rspBO;
        }
    }
}

