/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.atom.impl.core;

import com.alibaba.fastjson.JSONObject;
import com.tydic.order.uoc.atom.core.UocCoreOrderOutAtomService;
import com.tydic.order.uoc.atom.core.bo.ReflectFuncReqBO;
import com.tydic.order.uoc.atom.core.bo.ReflectFuncRspBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreOrderOutReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreOrderOutRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.ConfModFieldMapper;
import com.tydic.order.uoc.dao.po.ConfModFieldPO;
import com.tydic.order.uoc.dao.po.QueryTabFieldPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreOrderOutAtomService")
public class UocCoreOrderOutAtomServiceImpl
implements UocCoreOrderOutAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UocCoreOrderOutAtomServiceImpl.class);
    private static final String REFLECT_FUNC_CLASS = "com.tydic.order.uoc.atom.impl.core.OutByReflectFuncServiceImpl";
    @Autowired
    private ConfModFieldMapper confModFieldMapper;

    @Override
    public UocCoreOrderOutRspBO orderOut(UocCoreOrderOutReqBO reqBO) {
        Long orderId = reqBO.getOrderId();
        String jsonModule = reqBO.getJsonModule();
        Map<String, Object> extParamMap = reqBO.getExtParamMap();
        if (orderId == null || StringUtils.isBlank((String)jsonModule)) {
            throw new UocProBusinessException("7777", "\u5165\u53c2orderId\u3001jsonModule\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UocCoreOrderOutRspBO rspBO = new UocCoreOrderOutRspBO();
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)jsonModule);
            Iterator item = jsonObject.keySet().iterator();
            while (item.hasNext()) {
                String key = item.next().toString();
                String value = jsonObject.get((Object)key).toString();
                if (StringUtils.isNotBlank((String)value)) {
                    if (value.startsWith("@")) {
                        String function = value.substring(value.indexOf("@") + 1, value.indexOf("("));
                        String paramStr = value.substring(value.indexOf("(") + 1, value.indexOf(")"));
                        String[] params = paramStr.split(",");
                        for (int i = 0; i < params.length; ++i) {
                            String fieldValue;
                            if (!params[i].startsWith("$")) continue;
                            String fieldCode2 = params[i].substring(1, params[i].length());
                            params[i] = fieldValue = this.getFieldTabValue(fieldCode2, orderId);
                        }
                        ReflectFuncReqBO reflectReqBO = new ReflectFuncReqBO();
                        reflectReqBO.setOrderId(orderId);
                        reflectReqBO.setParams(params);
                        reflectReqBO.setExtParamMap(extParamMap);
                        Class<?> clazz = Class.forName(REFLECT_FUNC_CLASS);
                        Method method = clazz.getMethod(function, ReflectFuncReqBO.class);
                        ReflectFuncRspBO reflectRspBO = (ReflectFuncRspBO)((Object)method.invoke(clazz.newInstance(), reflectReqBO));
                        if (StringUtils.isNotBlank((String)reflectRspBO.getRspJson())) {
                            jsonObject.put(key, (Object)reflectRspBO.getRspJson());
                            continue;
                        }
                        jsonObject.put(key, (Object)"");
                        continue;
                    }
                    if (value.startsWith("$")) {
                        String fieldCode3 = value.substring(1, value.length());
                        if (extParamMap != null && extParamMap.get(fieldCode3) != null) {
                            jsonObject.put(key, (Object)extParamMap.get(fieldCode3).toString());
                            continue;
                        }
                        String fieldValue = this.getFieldTabValue(fieldCode3, orderId);
                        jsonObject.put(key, (Object)fieldValue);
                        continue;
                    }
                    jsonObject.put(key, (Object)value);
                    continue;
                }
                jsonObject.put(key, (Object)"");
            }
            rspBO.setJsonOut(jsonObject.toJSONString());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8ba2\u5355\u51fa\u5e93\u6210\u529f");
            return rspBO;
        }
        catch (UocProBusinessException b) {
            logger.error(b.getMsgInfo(), (Throwable)b);
            rspBO.setRespCode(b.getMsgCode());
            rspBO.setRespDesc(b.getMsgInfo());
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u8ba2\u5355\u51fa\u5e93\u539f\u5b50\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8ba2\u5355\u51fa\u5e93\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            return rspBO;
        }
    }

    private String getFieldTabValue(String fieldCode2, Long orderId) {
        String fieldTabValue = "";
        ConfModFieldPO confModFieldPO = new ConfModFieldPO();
        confModFieldPO.setFieldCode(fieldCode2);
        try {
            confModFieldPO = this.confModFieldMapper.getModelBy(confModFieldPO);
        }
        catch (Exception e) {
            throw new UocProBusinessException("1111", "\u67e5\u8be2\u6a21\u677f\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
        if (confModFieldPO != null) {
            String tabName = confModFieldPO.getTabName();
            String fieldName = confModFieldPO.getTabFieldName();
            if (StringUtils.isNotBlank((String)tabName) && StringUtils.isNotBlank((String)fieldName)) {
                QueryTabFieldPO queryTabFieldPO = new QueryTabFieldPO();
                queryTabFieldPO.setOrderId(orderId);
                queryTabFieldPO.setTabName(tabName);
                queryTabFieldPO.setTabFieldName(fieldName);
                fieldTabValue = this.confModFieldMapper.queryTabFieldValue(queryTabFieldPO);
                if (StringUtils.isBlank((String)fieldTabValue)) {
                    if (UocConstant.IS_ALLOW_EMPTY.equals(confModFieldPO.getIsNull())) {
                        fieldTabValue = "";
                    } else {
                        throw new UocProBusinessException("1112", tabName + "\u8868" + fieldName + "\u5b57\u6bb5\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
            }
        }
        return fieldTabValue;
    }
}

