/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.atom.impl.core;

import com.tydic.order.uoc.atom.core.UocCoreTacheEntryAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreTacheEntryReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreTacheEntryRspBO;
import com.tydic.order.uoc.dao.ConfModComposeMapper;
import com.tydic.order.uoc.dao.ConfModFieldMapper;
import com.tydic.order.uoc.dao.ConfTacheModMapper;
import com.tydic.order.uoc.dao.po.ConfModComposePO;
import com.tydic.order.uoc.dao.po.ConfModFieldPO;
import com.tydic.order.uoc.dao.po.ConfTacheModPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreTacheEntryAtomService")
public class UocCoreTacheEntryAtomServiceImpl
implements UocCoreTacheEntryAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UocCoreTacheEntryAtomServiceImpl.class);
    @Autowired
    private ConfTacheModMapper confTacheModMapper;
    @Autowired
    private ConfModComposeMapper confModComposeMapper;
    @Autowired
    private ConfModFieldMapper confModFieldMapper;

    @Override
    public UocCoreTacheEntryRspBO tacheEntry(UocCoreTacheEntryReqBO reqBO) {
        Long orderId = reqBO.getOrderId();
        String tacheCode = reqBO.getTacheCode();
        Map<String, Object> paramMap = reqBO.getParamMap();
        if (orderId == null || StringUtils.isBlank((CharSequence)tacheCode) || paramMap == null) {
            throw new UocProBusinessException("7777", "orderId\u3001tacheCode\u3001paramMap\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UocCoreTacheEntryRspBO rspBO = new UocCoreTacheEntryRspBO();
        try {
            ConfTacheModPO tacheModPO = new ConfTacheModPO();
            tacheModPO.setTacheCode(tacheCode);
            tacheModPO = this.confTacheModMapper.getModelBy(tacheModPO);
            if (tacheModPO == null || tacheModPO.getModId() == null) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("UOC_CONF_TACHE_MOD\u8868\u672a\u67e5\u8be2\u5230" + tacheCode + "\u73af\u8282\u5165\u5e93\u6a21\u677f\uff0c\u8df3\u8fc7\u5165\u5e93\u65b9\u6cd5");
                return rspBO;
            }
            ConfModComposePO modComposePO = new ConfModComposePO();
            modComposePO.setModId(tacheModPO.getModId());
            List modComposeList = this.confModComposeMapper.getList(modComposePO);
            if (modComposeList == null || modComposeList.size() == 0) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("UOC_CONF_MOD_COMPOSE\u8868\u672a\u67e5\u8be2\u5230" + tacheModPO.getModId() + "\u6a21\u677f\u914d\u7f6e\u5b57\u6bb5\uff0c\u8df3\u8fc7\u5165\u5e93\u65b9\u6cd5");
                return rspBO;
            }
            StringBuilder fieldIds = new StringBuilder();
            for (ConfModComposePO confModComposePO : modComposeList) {
                fieldIds.append("'" + confModComposePO.getFieldId().toString() + "',");
            }
            List modFields = this.confModFieldMapper.queryTabFieldByIds(fieldIds.substring(0, fieldIds.length() - 1));
            if (modFields == null || modFields.size() == 0) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("UOC_CONF_MOD_FIELD\u8868\u672a\u67e5\u8be2\u5230" + tacheModPO.getModId() + "\u6a21\u677f\u914d\u7f6e\u5b57\u6bb5\uff0c\u8df3\u8fc7\u5165\u5e93\u65b9\u6cd5");
                return rspBO;
            }
            HashMap<String, Map> tabFieldMap = new HashMap<String, Map>(8);
            for (ConfModFieldPO confModFieldPO : modFields) {
                String fieldCode2 = confModFieldPO.getFieldCode();
                String tabName = confModFieldPO.getTabName();
                String fieldName = confModFieldPO.getTabFieldName();
                if (paramMap.get(fieldCode2) == null || StringUtils.isBlank((CharSequence)paramMap.get(fieldCode2).toString())) continue;
                String fieldValue = paramMap.get(fieldCode2).toString();
                if (!StringUtils.isNotBlank((CharSequence)tabName) || !StringUtils.isNotBlank((CharSequence)fieldName)) continue;
                if (tabFieldMap.get(tabName) != null) {
                    Map existFieldMap = (Map)tabFieldMap.get(tabName);
                    existFieldMap.put(fieldName, fieldValue);
                    tabFieldMap.put(tabName, existFieldMap);
                    continue;
                }
                HashMap<String, String> newFieldMap = new HashMap<String, String>(2);
                newFieldMap.put(fieldName, fieldValue);
                tabFieldMap.put(tabName, newFieldMap);
            }
            Iterator tabItem = tabFieldMap.keySet().iterator();
            while (tabItem.hasNext()) {
                String table = tabItem.next().toString();
                Map map = (Map)tabFieldMap.get(table);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u73af\u8282\u5165\u5e93\u6210\u529f");
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u73af\u8282\u5165\u5e93\u539f\u5b50\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u73af\u8282\u5165\u5e93\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            return rspBO;
        }
    }
}

