/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.atom.impl.order;

import com.tydic.order.uoc.atom.order.UocCoreCancelOrderAtomService;
import com.tydic.order.uoc.bo.order.UocCoreCancelOrderReqBO;
import com.tydic.order.uoc.bo.order.UocCoreCancelOrderRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdInspectionMapper;
import com.tydic.order.uoc.dao.OrdPayMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdShipMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdInspectionPO;
import com.tydic.order.uoc.dao.po.OrdPayPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdShipPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreCancelOrderAtomService")
public class UocCoreCancelOrderAtomServiceImpl
implements UocCoreCancelOrderAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocCoreCancelOrderAtomServiceImpl.class);
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;

    @Override
    public UocCoreCancelOrderRspBO dealCoreCancelOrder(UocCoreCancelOrderReqBO reqBO) {
        UocCoreCancelOrderRspBO rspBO;
        block15: {
            rspBO = new UocCoreCancelOrderRspBO();
            this.validateArg(reqBO);
            try {
                OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
                if (orderPO != null) {
                    orderPO.setCancelOperId(reqBO.getCancelOperId());
                    orderPO.setCancelTime(new Date());
                    orderPO.setOrderState(UocConstant.CORE_ORDER_STATUS.CANCEL);
                    orderPO.setCancelReason(reqBO.getCancelReason());
                    orderPO.setCancelDesc(reqBO.getCancelRemark());
                    this.orderMapper.updateById(orderPO);
                    OrdSalePO ordSalePO = new OrdSalePO();
                    ordSalePO.setOrderId(reqBO.getOrderId());
                    List salePOS = this.ordSaleMapper.getList(ordSalePO);
                    if (salePOS != null && !salePOS.isEmpty()) {
                        for (OrdSalePO salePO : salePOS) {
                            salePO.setSaleState(UocConstant.SALE_ORDER_STATUS.CANCEL);
                            salePO.setPurchaseState(UocConstant.ORDER_PURCHASE_STATUS.CANCEL);
                            this.ordSaleMapper.updateById(salePO);
                        }
                    }
                    OrdShipPO ordShipPO = new OrdShipPO();
                    ordShipPO.setOrderId(reqBO.getOrderId());
                    List shipPOS = this.ordShipMapper.getList(ordShipPO);
                    if (shipPOS != null && !shipPOS.isEmpty()) {
                        for (OrdShipPO shipPO : shipPOS) {
                            shipPO.setShipStatus("1206");
                            this.ordShipMapper.updateById(shipPO);
                        }
                    }
                    OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
                    ordInspectionPO.setOrderId(reqBO.getOrderId());
                    List inspectionPOS = this.ordInspectionMapper.getList(ordInspectionPO);
                    if (inspectionPOS != null && !inspectionPOS.isEmpty()) {
                        for (OrdInspectionPO inspectionPO : inspectionPOS) {
                            inspectionPO.setInspectionState(UocConstant.ACCEPT_ORDER_STATUS.CANCEL);
                            this.ordInspectionMapper.updateById(inspectionPO);
                        }
                    }
                    OrdPayPO ordPayPO = new OrdPayPO();
                    ordPayPO.setOrderId(reqBO.getOrderId());
                    List payPOS = this.ordPayMapper.getList(ordPayPO);
                    if (payPOS != null && !payPOS.isEmpty()) {
                        for (OrdPayPO payPO : payPOS) {
                            if (reqBO.getPayState() != null) {
                                payPO.setPayState(reqBO.getPayState());
                            } else {
                                payPO.setPayState(UocConstant.PAY_ORDER_STATUS.CANCEL);
                            }
                            this.ordPayMapper.updateById(payPO);
                        }
                    }
                    break block15;
                }
                if (log.isDebugEnabled()) {
                    log.debug("\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1,\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
                }
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1,\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
                return rspBO;
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u6355\u6349\u5230\u5f02\u5e38!" + e);
                }
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u64a4\u9500\u6210\u529f");
        return rspBO;
    }

    private void validateArg(UocCoreCancelOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("7777", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("7777", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCancelOperId())) {
            throw new UocProBusinessException("7777", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010cancelOperId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

