/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.atom.impl.order;

import com.tydic.order.uoc.atom.core.UocCoreTacheStateUpdateAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreTacheStateUpdateReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreTacheStateUpdateRspBO;
import com.tydic.order.uoc.atom.order.UocCoreFinishOrderAtomService;
import com.tydic.order.uoc.bo.order.UocCoreFinishOrderReqBO;
import com.tydic.order.uoc.bo.order.UocCoreFinishOrderRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreFinishOrderAtomService")
public class UocCoreFinishOrderAtomServiceImpl
implements UocCoreFinishOrderAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocCoreFinishOrderAtomServiceImpl.class);
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocCoreTacheStateUpdateAtomService uocCoreTacheStateUpdateAtomService;
    private static final String CUR_TACHE_CODE = "FINISH";

    @Override
    public UocCoreFinishOrderRspBO dealCoreFinishOrder(UocCoreFinishOrderReqBO reqBO) {
        UocCoreFinishOrderRspBO rspBO = new UocCoreFinishOrderRspBO();
        this.validateArg(reqBO);
        OrderPO orderPO = new OrderPO();
        try {
            orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
            if (orderPO == null) {
                if (log.isDebugEnabled()) {
                    log.debug("\u8ba2\u5355\u7ae3\u5de5\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
                }
                throw new UocProBusinessException("8888", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("\u8ba2\u5355\u7ae3\u5de5\u539f\u5b50\u670d\u52a1\u5f02\u5e38!" + e);
            }
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8ba2\u5355\u7ae3\u5de5\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38");
            return rspBO;
        }
        UocCoreTacheStateUpdateReqBO tacheStateUpdateReqBO = new UocCoreTacheStateUpdateReqBO();
        tacheStateUpdateReqBO.setCurTacheCode(CUR_TACHE_CODE);
        tacheStateUpdateReqBO.setOrderId(reqBO.getOrderId());
        tacheStateUpdateReqBO.setOperId(orderPO.getCreateOperId());
        UocCoreTacheStateUpdateRspBO tacheStateUpdateRspBO = this.uocCoreTacheStateUpdateAtomService.dealCoreTacheStateUpdate(tacheStateUpdateReqBO);
        if (!"0000".equals(tacheStateUpdateRspBO.getRespCode())) {
            if (log.isDebugEnabled()) {
                log.debug("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u7ae3\u5de5\u539f\u5b50\u670d\u52a1,\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u73af\u8282\u72b6\u6001\u66f4\u65b0\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + tacheStateUpdateRspBO.getRespDesc());
            }
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u7ae3\u5de5\u539f\u5b50\u670d\u52a1,\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u73af\u8282\u72b6\u6001\u66f4\u65b0\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + tacheStateUpdateRspBO.getRespDesc());
        }
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO.setFinishFlag(UocConstant.CORE_ORDER_FINISH_FLAG.FINISH);
        orderPO.setOrderState(UocConstant.CORE_ORDER_STATUS.FINISH);
        orderPO.setFinishTime(new Date());
        try {
            this.orderMapper.updateById(orderPO);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("\u8ba2\u5355\u7ae3\u5de5\u539f\u5b50\u670d\u52a1\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38!" + e);
            }
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8ba2\u5355\u7ae3\u5de5\u539f\u5b50\u670d\u52a1\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u7ae3\u5de5\u6210\u529f");
        return rspBO;
    }

    private void validateArg(UocCoreFinishOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("7777", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u7ae3\u5de5\u539f\u5b50\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("7777", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u7ae3\u5de5\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

