/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.atom.impl.order;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.order.uoc.atom.order.UocCoreOrderMaintainAtomService;
import com.tydic.order.uoc.bo.order.OrderItemAdjustBO;
import com.tydic.order.uoc.bo.order.UocCoreOrderMaintainReqBO;
import com.tydic.order.uoc.bo.order.UocCoreOrderMaintainRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdItemMapMapper;
import com.tydic.order.uoc.dao.OrdItemMapper;
import com.tydic.order.uoc.dao.OrdItemWtLogMapper;
import com.tydic.order.uoc.dao.OrdSaleMapWtLogMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdSaleMtLogMapper;
import com.tydic.order.uoc.dao.OrdSaleWtMainLogMapper;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdItemMapPO;
import com.tydic.order.uoc.dao.po.OrdItemPO;
import com.tydic.order.uoc.dao.po.OrdItemWtLogPO;
import com.tydic.order.uoc.dao.po.OrdSaleMapWtLogPO;
import com.tydic.order.uoc.dao.po.OrdSaleMtLogPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdSaleWtMainLogPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreOrderMaintainAtomService")
public class UocCoreOrderMaintainAtomServiceImpl
implements UocCoreOrderMaintainAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UocCoreOrderMaintainAtomServiceImpl.class);
    private static final String MARK_UP_RATE_CODE = "markUpRate";
    @Autowired
    private OrdSaleWtMainLogMapper wtMainLogMapper;
    @Autowired
    private OrdSaleMtLogMapper saleMtLogMapper;
    @Autowired
    private OrdSaleMapWtLogMapper saleMapWtLogMapper;
    @Autowired
    private OrdItemWtLogMapper itemWtLogMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;

    @Override
    public UocCoreOrderMaintainRspBO dealOrderMaintain(UocCoreOrderMaintainReqBO reqBO) {
        this.validParam(reqBO);
        Integer dealFlag = reqBO.getDealFlag();
        Long orderId = reqBO.getOrderId();
        Long saleVoucherId = reqBO.getSaleVoucherId();
        String operId = reqBO.getOperId();
        UocCoreOrderMaintainRspBO rspBO = new UocCoreOrderMaintainRspBO();
        try {
            if (UocConstant.ORDER_MAINTAIN_FLAG.MAINTAIN.equals(dealFlag)) {
                if (this.checkMaintainDataExist(reqBO)) {
                    return this.maintainProcess(reqBO);
                }
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u7ef4\u62a4\u6570\u636e\u4e3a\u7a7a");
                return rspBO;
            }
            if (UocConstant.ORDER_MAINTAIN_FLAG.APPROVE.equals(dealFlag)) {
                if (this.checkMaintainDataExist(reqBO) && !"0000".equals((rspBO = this.maintainProcess(reqBO)).getRespCode())) {
                    return rspBO;
                }
                OrdSaleWtMainLogPO wtMainValid = new OrdSaleWtMainLogPO();
                wtMainValid.setOrderId(orderId);
                wtMainValid.setSaleVoucherId(saleVoucherId);
                wtMainValid.setWtState(UocConstant.ORDER_MAINTAIN_FLAG.MATAIN_STATE);
                wtMainValid = this.wtMainLogMapper.getModelBy(wtMainValid);
                if (wtMainValid == null) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u5f85\u786e\u5b9a\u7ef4\u62a4\u6570\u636e\uff0c\u4e0d\u80fd\u5ba1\u6279");
                    return rspBO;
                }
                wtMainValid.setWtState(UocConstant.ORDER_MAINTAIN_FLAG.VALID_STATE);
                wtMainValid.setEffTime(new Date());
                wtMainValid.setEffLoginId(operId);
                wtMainValid.setRemark(reqBO.getDealRemark());
                this.wtMainLogMapper.updateById(wtMainValid);
                Long wtId = wtMainValid.getWtId();
                OrdSaleMtLogPO saleMtLogPO = new OrdSaleMtLogPO();
                saleMtLogPO.setIsNew(UocConstant.ORDER_MAINTAIN_FLAG.NEW);
                saleMtLogPO.setOrderId(orderId);
                saleMtLogPO.setSaleVoucherId(saleVoucherId);
                saleMtLogPO.setWtId(wtId);
                saleMtLogPO = this.saleMtLogMapper.getModelBy(saleMtLogPO);
                OrdSalePO ordSalePO = new OrdSalePO();
                ordSalePO.setSaleVoucherId(saleVoucherId);
                ordSalePO.setOrderId(orderId);
                boolean updateOrdSale = false;
                if (saleMtLogPO != null) {
                    updateOrdSale = true;
                    ordSalePO.setTaxRate(saleMtLogPO.getTaxRate());
                    ordSalePO.setArriveTime(saleMtLogPO.getArriveTime());
                    ordSalePO.setOrderMethod(saleMtLogPO.getOrderMethod());
                    ordSalePO.setWarantty(saleMtLogPO.getWarantty());
                }
                OrdSaleMapWtLogPO saleMapWtLogPO = new OrdSaleMapWtLogPO();
                saleMapWtLogPO.setOrderId(orderId);
                saleMapWtLogPO.setSaleVoucherId(saleVoucherId);
                saleMapWtLogPO.setWtId(wtId);
                List saleMapLogList = this.saleMapWtLogMapper.getList(saleMapWtLogPO);
                if (CollectionUtils.isNotEmpty((Collection)saleMapLogList)) {
                    ArrayList<OrdExtMapPO> insertSaleMapList = new ArrayList<OrdExtMapPO>();
                    for (OrdSaleMapWtLogPO saleMapWtLog : saleMapLogList) {
                        OrdExtMapPO extSaleMap = new OrdExtMapPO();
                        extSaleMap.setOrderId(reqBO.getOrderId());
                        extSaleMap.setFieldCode(saleMapWtLog.getFieldCode());
                        extSaleMap.setFieldValue(saleMapWtLog.getNewFieldValue());
                        if (saleMapWtLog.getOldFieldValue() != null) {
                            this.ordExtMapMapper.updateById(extSaleMap);
                            continue;
                        }
                        extSaleMap.setObjId(saleVoucherId);
                        extSaleMap.setObjType(UocConstant.OBJ_TYPE.SALE);
                        insertSaleMapList.add(extSaleMap);
                    }
                    if (insertSaleMapList.size() > 0) {
                        this.ordExtMapMapper.insertBatch(insertSaleMapList);
                    }
                }
                OrdItemWtLogPO newItemLog = new OrdItemWtLogPO();
                newItemLog.setIsNew(UocConstant.ORDER_MAINTAIN_FLAG.NEW);
                newItemLog.setOrderId(orderId);
                newItemLog.setWtId(wtId);
                List saleItemLogList = this.itemWtLogMapper.getList(newItemLog);
                Long totalPurchasePrice = 0L;
                Long totalSalePrice = 0L;
                if (CollectionUtils.isNotEmpty((Collection)saleItemLogList)) {
                    ArrayList<OrdItemMapPO> insertItemMapList = new ArrayList<OrdItemMapPO>();
                    for (OrdItemWtLogPO saleItemLog : saleItemLogList) {
                        OrdItemMapPO itemMapPO = new OrdItemMapPO();
                        itemMapPO.setOrderItemId(saleItemLog.getOrdItemId());
                        itemMapPO.setOrderId(orderId);
                        itemMapPO.setFieldCode(MARK_UP_RATE_CODE);
                        itemMapPO = this.ordItemMapMapper.getModelBy(itemMapPO);
                        if (itemMapPO != null) {
                            itemMapPO.setFieldValue(saleItemLog.getMarkUpRate().toString());
                            itemMapPO.setFieldName("\u8c03\u4ef7\u6bd4\u7387");
                            this.ordItemMapMapper.updateById(itemMapPO);
                        } else {
                            itemMapPO = new OrdItemMapPO();
                            itemMapPO.setOrderItemId(saleItemLog.getOrdItemId());
                            itemMapPO.setOrderId(orderId);
                            itemMapPO.setFieldCode(MARK_UP_RATE_CODE);
                            itemMapPO.setFieldValue(saleItemLog.getMarkUpRate().toString());
                            itemMapPO.setFieldName("\u8c03\u4ef7\u6bd4\u7387");
                            insertItemMapList.add(itemMapPO);
                        }
                        OrdItemPO ordItemPO = new OrdItemPO();
                        ordItemPO.setOrderId(orderId);
                        ordItemPO.setOrdItemId(saleItemLog.getOrdItemId());
                        ordItemPO.setPurchasePrice(saleItemLog.getPurchasePrice());
                        ordItemPO.setSalePrice(saleItemLog.getSalePrice());
                        ordItemPO.setTotalPurchaseFee(saleItemLog.getTotalPurchaseFee());
                        ordItemPO.setTotalSaleFee(saleItemLog.getTotalSaleFee());
                        this.ordItemMapper.updateById(ordItemPO);
                        totalPurchasePrice = totalPurchasePrice + saleItemLog.getTotalPurchaseFee();
                        totalSalePrice = totalSalePrice + saleItemLog.getTotalSaleFee();
                    }
                    updateOrdSale = true;
                    ordSalePO.setPurchaseFee(totalPurchasePrice);
                    ordSalePO.setSaleFee(totalSalePrice);
                    if (insertItemMapList.size() > 0) {
                        this.ordItemMapMapper.insertBatch(insertItemMapList);
                    }
                }
                if (updateOrdSale) {
                    this.ordSaleMapper.updateById(ordSalePO);
                }
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5ba1\u6279\u901a\u8fc7\u6210\u529f");
                return rspBO;
            }
            if (UocConstant.ORDER_MAINTAIN_FLAG.REJECT.equals(dealFlag)) {
                OrdSaleWtMainLogPO wtMainValid = new OrdSaleWtMainLogPO();
                wtMainValid.setOrderId(orderId);
                wtMainValid.setSaleVoucherId(saleVoucherId);
                wtMainValid.setWtState(UocConstant.ORDER_MAINTAIN_FLAG.VALID_STATE);
                wtMainValid = this.wtMainLogMapper.getModelBy(wtMainValid);
                if (wtMainValid != null) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u8be5\u8ba2\u5355\u7ef4\u62a4\u6570\u636e\u5df2\u751f\u6548\uff0c\u4e0d\u80fd\u9a73\u56de");
                    return rspBO;
                }
                wtMainValid = new OrdSaleWtMainLogPO();
                wtMainValid.setOrderId(orderId);
                wtMainValid.setSaleVoucherId(saleVoucherId);
                wtMainValid.setWtState(UocConstant.ORDER_MAINTAIN_FLAG.MATAIN_STATE);
                wtMainValid = this.wtMainLogMapper.getModelBy(wtMainValid);
                if (wtMainValid == null) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u5f85\u786e\u5b9a\u7ef4\u62a4\u6570\u636e\uff0c\u4e0d\u80fd\u9a73\u56de");
                    return rspBO;
                }
                wtMainValid.setWtState(UocConstant.ORDER_MAINTAIN_FLAG.INVALID_STATE);
                wtMainValid.setEffLoginId(operId);
                wtMainValid.setEffTime(new Date());
                wtMainValid.setRemark(reqBO.getDealRemark());
                this.wtMainLogMapper.updateById(wtMainValid);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5ba1\u6279\u9a73\u56de\u6210\u529f");
                return rspBO;
            }
            rspBO.setRespCode("7777");
            rspBO.setRespDesc("\u4e0d\u652f\u6301\u7684\u5904\u7406\u7c7b\u578b");
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u8ba2\u5355\u7ef4\u62a4\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8ba2\u5355\u7ef4\u62a4\u670d\u52a1\u5f02\u5e38");
            return rspBO;
        }
    }

    private void validParam(UocCoreOrderMaintainReqBO reqBO) {
        if (reqBO.getOrderId() == null || reqBO.getSaleVoucherId() == null || StringUtils.isBlank((CharSequence)reqBO.getOperId())) {
            throw new UocProBusinessException("7777", "\u8ba2\u5355ID\u3001\u64cd\u4f5c\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrderItemAdjustList())) {
            for (OrderItemAdjustBO adjustBO : reqBO.getOrderItemAdjustList()) {
                if (adjustBO.getSaleOrderItemId() != null && adjustBO.getPurchasingPriceNew() != null && adjustBO.getMarkUpRateNew() != null) continue;
                throw new UocProBusinessException("7777", "\u8c03\u4ef7\u660e\u7ec6\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a");
            }
        }
    }

    private boolean checkMaintainDataExist(UocCoreOrderMaintainReqBO reqBO) throws Exception {
        Field[] fields;
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrderItemAdjustList())) {
            return true;
        }
        for (Field field : fields = reqBO.getClass().getDeclaredFields()) {
            String mod;
            field.setAccessible(true);
            if (field.get(reqBO) == null || (mod = Modifier.toString(field.getModifiers())).indexOf("static") != -1) continue;
            if ("BigDecimal".equalsIgnoreCase(field.getType().getSimpleName())) {
                return true;
            }
            if ("orderItemAdjustList".equalsIgnoreCase(field.getName()) || "orderId".equalsIgnoreCase(field.getName()) || "saleVoucherId".equalsIgnoreCase(field.getName()) || "dealFlag".equalsIgnoreCase(field.getName()) || "operId".equalsIgnoreCase(field.getName()) || "dealRemark".equalsIgnoreCase(field.getName())) continue;
            return true;
        }
        return false;
    }

    private UocCoreOrderMaintainRspBO maintainProcess(UocCoreOrderMaintainReqBO reqBO) throws Exception {
        Long orderId = reqBO.getOrderId();
        Long saleVoucherId = reqBO.getSaleVoucherId();
        String operId = reqBO.getOperId();
        UocCoreOrderMaintainRspBO rspBO = new UocCoreOrderMaintainRspBO();
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(orderId);
        ordSalePO.setSaleVoucherId(saleVoucherId);
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (ordSalePO == null) {
            rspBO.setRespCode("7777");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355saleVoucherId=" + saleVoucherId);
            return rspBO;
        }
        OrdSaleWtMainLogPO wtMainValid = new OrdSaleWtMainLogPO();
        wtMainValid.setOrderId(orderId);
        wtMainValid.setSaleVoucherId(saleVoucherId);
        wtMainValid.setWtState(UocConstant.ORDER_MAINTAIN_FLAG.VALID_STATE);
        wtMainValid = this.wtMainLogMapper.getModelBy(wtMainValid);
        if (wtMainValid != null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8be5\u8ba2\u5355\u7ef4\u62a4\u6570\u636e\u5df2\u751f\u6548\uff0c\u4e0d\u80fd\u518d\u6b21\u7ef4\u62a4");
            return rspBO;
        }
        wtMainValid = new OrdSaleWtMainLogPO();
        wtMainValid.setOrderId(orderId);
        wtMainValid.setSaleVoucherId(saleVoucherId);
        wtMainValid.setWtState(UocConstant.ORDER_MAINTAIN_FLAG.MATAIN_STATE);
        wtMainValid = this.wtMainLogMapper.getModelBy(wtMainValid);
        if (wtMainValid != null) {
            wtMainValid.setWtState(UocConstant.ORDER_MAINTAIN_FLAG.INVALID_STATE);
            this.wtMainLogMapper.updateById(wtMainValid);
        }
        OrdSaleWtMainLogPO wtMainLogPO = new OrdSaleWtMainLogPO();
        wtMainLogPO.setOrderId(orderId);
        wtMainLogPO.setSaleVoucherId(saleVoucherId);
        wtMainLogPO.setWtLoginId(operId);
        wtMainLogPO.setRemark(reqBO.getDealRemark());
        this.wtMainLogMapper.insert(wtMainLogPO);
        Long wtId = wtMainLogPO.getWtId();
        ArrayList<OrdSaleMapWtLogPO> saleMapLogList = new ArrayList<OrdSaleMapWtLogPO>();
        OrdSaleMtLogPO newSaleLog = new OrdSaleMtLogPO();
        BeanUtils.copyProperties((Object)ordSalePO, (Object)newSaleLog);
        newSaleLog.setWtId(wtId);
        newSaleLog.setIsNew(UocConstant.ORDER_MAINTAIN_FLAG.NEW);
        if (this.dynamicInsertSale(reqBO, newSaleLog, wtId, saleMapLogList)) {
            this.saleMtLogMapper.insert(newSaleLog);
            OrdSaleMtLogPO oldSaleLog = new OrdSaleMtLogPO();
            BeanUtils.copyProperties((Object)ordSalePO, (Object)oldSaleLog);
            oldSaleLog.setWtId(wtId);
            oldSaleLog.setIsNew(UocConstant.ORDER_MAINTAIN_FLAG.OLD);
            this.saleMtLogMapper.insert(oldSaleLog);
        }
        if (saleMapLogList.size() > 0) {
            this.saleMapWtLogMapper.insertBatch(saleMapLogList);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrderItemAdjustList())) {
            ArrayList<OrdItemWtLogPO> itemLogList = new ArrayList<OrdItemWtLogPO>();
            for (OrderItemAdjustBO adjustBO : reqBO.getOrderItemAdjustList()) {
                Long ordItemId = adjustBO.getSaleOrderItemId();
                OrdItemPO ordItemPO = new OrdItemPO();
                ordItemPO.setOrdItemId(ordItemId);
                ordItemPO.setOrderId(orderId);
                ordItemPO = this.ordItemMapper.getModelBy(ordItemPO);
                if (ordItemPO == null) {
                    rspBO.setRespCode("7777");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u660e\u7ec6ordItemId=" + ordItemId);
                    return rspBO;
                }
                OrdItemWtLogPO oldItemLog = new OrdItemWtLogPO();
                BeanUtils.copyProperties((Object)ordItemPO, (Object)oldItemLog);
                oldItemLog.setWtId(wtId);
                oldItemLog.setIsNew(UocConstant.ORDER_MAINTAIN_FLAG.OLD);
                OrdItemMapPO itemMapPO = new OrdItemMapPO();
                itemMapPO.setOrderItemId(ordItemId);
                itemMapPO.setOrderId(orderId);
                itemMapPO.setFieldCode(MARK_UP_RATE_CODE);
                itemMapPO = this.ordItemMapMapper.getModelBy(itemMapPO);
                if (itemMapPO != null) {
                    oldItemLog.setMarkUpRate(Double.valueOf(itemMapPO.getFieldValue()));
                }
                OrdItemWtLogPO newItemLog = new OrdItemWtLogPO();
                BeanUtils.copyProperties((Object)ordItemPO, (Object)newItemLog);
                newItemLog.setWtId(wtId);
                newItemLog.setIsNew(UocConstant.ORDER_MAINTAIN_FLAG.NEW);
                newItemLog.setPurchasePrice(MoneyUtils.BigDecimal2Long((BigDecimal)adjustBO.getPurchasingPriceNew()));
                newItemLog.setTotalPurchaseFee(MoneyUtils.BigDecimal2Long((BigDecimal)ordItemPO.getPurchaseCount().multiply(adjustBO.getPurchasingPriceNew())));
                newItemLog.setMarkUpRate(adjustBO.getMarkUpRateNew());
                if (adjustBO.getSalePriceNew() != null) {
                    newItemLog.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)adjustBO.getSalePriceNew()));
                    newItemLog.setTotalSaleFee(MoneyUtils.BigDecimal2Long((BigDecimal)ordItemPO.getPurchaseCount().multiply(adjustBO.getSalePriceNew())));
                }
                itemLogList.add(oldItemLog);
                itemLogList.add(newItemLog);
            }
            this.itemWtLogMapper.insertBatch(itemLogList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u7ef4\u62a4\u6210\u529f");
        return rspBO;
    }

    private OrdSaleMapWtLogPO dynamicInsertMap(UocCoreOrderMaintainReqBO reqBO, String filedCode, Long wtId) throws Exception {
        Field field = reqBO.getClass().getDeclaredField(filedCode);
        field.setAccessible(true);
        OrdSaleMapWtLogPO saleMapWtLogPO = new OrdSaleMapWtLogPO();
        saleMapWtLogPO.setOrderId(reqBO.getOrderId());
        saleMapWtLogPO.setSaleVoucherId(reqBO.getSaleVoucherId());
        saleMapWtLogPO.setWtId(wtId);
        saleMapWtLogPO.setFieldCode(filedCode);
        saleMapWtLogPO.setNewFieldValue(field.get(reqBO).toString());
        OrdExtMapPO existSaleMap = new OrdExtMapPO();
        existSaleMap.setOrderId(reqBO.getOrderId());
        existSaleMap.setFieldCode(filedCode);
        existSaleMap = this.ordExtMapMapper.getModelBy(existSaleMap);
        if (existSaleMap != null) {
            saleMapWtLogPO.setOldFieldValue(existSaleMap.getFieldValue());
        }
        return saleMapWtLogPO;
    }

    private boolean dynamicInsertSale(UocCoreOrderMaintainReqBO reqBO, OrdSaleMtLogPO ordSaleLog, Long wtId, List<OrdSaleMapWtLogPO> saleMapLogList) throws Exception {
        Field[] fields = reqBO.getClass().getDeclaredFields();
        boolean isInsertLog = false;
        for (Field field : fields) {
            String mod;
            field.setAccessible(true);
            if (field.get(reqBO) == null || (mod = Modifier.toString(field.getModifiers())).indexOf("static") != -1) continue;
            if ("BigDecimal".equalsIgnoreCase(field.getType().getSimpleName())) {
                saleMapLogList.add(this.dynamicInsertMap(reqBO, field.getName(), wtId));
                continue;
            }
            if ("orderItemAdjustList".equalsIgnoreCase(field.getName()) || "orderId".equalsIgnoreCase(field.getName()) || "saleVoucherId".equalsIgnoreCase(field.getName())) continue;
            try {
                Field saleField = ordSaleLog.getClass().getDeclaredField(field.getName());
                saleField.setAccessible(true);
                saleField.set(ordSaleLog, field.get(reqBO));
                isInsertLog = true;
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
        }
        return isInsertLog;
    }
}

