/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.atom.impl.other;

import com.ohaotian.plugin.file.FileClient;
import com.tydic.order.uoc.atom.other.UocCoreFileUploadAtomService;
import com.tydic.order.uoc.bo.other.UocCoreFileBO;
import com.tydic.order.uoc.bo.other.UocCoreFileUploadReqBO;
import com.tydic.order.uoc.bo.other.UocCoreFileUploadRspBO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocCoreFileUploadAbilityService")
public class UocCoreFileUploadAtomServiceImpl
implements UocCoreFileUploadAtomService {
    @Autowired
    private FileClient fileClient;
    private static final String path = "uoc";
    @Value(value="${oss.fileUrl}")
    private String baseUrl;

    @Override
    public UocCoreFileUploadRspBO upload(UocCoreFileUploadReqBO reqBO) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList fileList = new ArrayList();
        for (UocCoreFileBO file : reqBO.getFiles()) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFile());
            String fileName = UUID.randomUUID().toString().replaceAll("-", "") + file.getFileType();
            String fileUrl = this.baseUrl + this.fileClient.uploadFileByInputStream(path, fileName, (InputStream)inputStream);
            if (!fileUrl.contains("https")) {
                fileUrl = fileUrl.replace("http", "https");
            }
            list.add(fileUrl);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", file.getFileName());
            map.put("url", fileUrl);
            fileList.add(map);
        }
        UocCoreFileUploadRspBO rspBO = new UocCoreFileUploadRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setUrlList(list);
        rspBO.setFileList(fileList);
        return rspBO;
    }
}

