/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.atom.impl.process;

import com.alibaba.fastjson.JSON;
import com.tydic.order.uoc.atom.core.UocCoreChgVoucherStateAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreChgVoucherStateReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreChgVoucherStateRspBO;
import com.tydic.order.uoc.atom.process.UocCreateTaskAtomService;
import com.tydic.order.uoc.atom.process.UocRunProcessAtomService;
import com.tydic.order.uoc.bo.other.VoucherStateBO;
import com.tydic.order.uoc.bo.process.UocProcessRunReqBO;
import com.tydic.order.uoc.bo.process.UocProcessRunRspBO;
import com.tydic.order.uoc.bo.task.UocCreateTaskReqBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdAfterServiceMapper;
import com.tydic.order.uoc.dao.OrdInspectionMapper;
import com.tydic.order.uoc.dao.OrdPayMapper;
import com.tydic.order.uoc.dao.OrdPurchaseMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdShipMapper;
import com.tydic.order.uoc.dao.OrdStateProcMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdAfterServicePO;
import com.tydic.order.uoc.dao.po.OrdInspectionPO;
import com.tydic.order.uoc.dao.po.OrdPayPO;
import com.tydic.order.uoc.dao.po.OrdPurchasePO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdShipPO;
import com.tydic.order.uoc.dao.po.OrdStateProcPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.osworkflow.engine.runtime.StepWithOutInstance;
import com.tydic.osworkflow.engine.runtime.TaskService;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocRunProcessAtomServiceImpl
implements UocRunProcessAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UocRunProcessAtomServiceImpl.class);
    private final Boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private TaskService taskService;
    @Autowired
    private OrdStateProcMapper ordVoucherProcMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;
    @Autowired
    private UocCoreChgVoucherStateAtomService uocCoreChgVoucherStateAtomService;
    @Autowired
    private UocCreateTaskAtomService uocCreateTaskAtomService;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String sysCode;
    @Value(value="${status.auth:false}")
    private Boolean isAuth;
    private static final String AUTO = "AUTO";

    @Override
    public UocProcessRunRspBO start(UocProcessRunReqBO reqBO) {
        this.val(reqBO);
        OrdStateProcPO procPo = new OrdStateProcPO();
        procPo.setObjType(reqBO.getObjType());
        procPo.setObjId(reqBO.getObjId() + "");
        procPo.setOrderId(reqBO.getOrderId());
        OrdStateProcPO result = null;
        try {
            result = (OrdStateProcPO)this.ordVoucherProcMapper.getList(procPo).get(0);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u6ca1\u6709\u627e\u6d41\u7a0b\u51fa\u9519");
        }
        if (result == null) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u6d41\u7a0b");
        }
        String stepId = this.valStatus(reqBO);
        logger.debug("\u72b6\u6001\u673a\u72b6\u6001\u5165\u53c2" + JSON.toJSONString((Object)reqBO) + "id" + stepId);
        try {
            StepWithOutInstance stepInstance = this.taskService.newTaskCompleteBuilder().procDefId(null).procDefKey(result.getProcInstId()).sysCode(this.sysCode).stepId(stepId).variables(reqBO.getVariables()).completeWithOutInstance();
            logger.debug("\u72b6\u6001\u673a\u56de\u53c2\uff1a" + JSON.toJSONString((Object)stepInstance) + "\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO) + "id" + stepId);
            if (!stepInstance.getIsFinish().booleanValue()) {
                this.updateStatus(reqBO, stepInstance);
            }
            if (this.isAuth.booleanValue()) {
                this.createTask(reqBO, stepInstance);
            }
            UocProcessRunRspBO rspBO = new UocProcessRunRspBO();
            BeanUtils.copyProperties((Object)stepInstance, (Object)rspBO);
            rspBO.setAuto(Boolean.valueOf(AUTO.equals(stepInstance.getStepType())));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        catch (Exception e) {
            if (this.isDebugEnabled.booleanValue()) {
                logger.debug("\u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
            }
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25" + e.getMessage());
        }
    }

    private void createTask(UocProcessRunReqBO reqBO, StepWithOutInstance stepInstance) {
        UocCreateTaskReqBO uocCreateTaskReqBO = new UocCreateTaskReqBO();
        uocCreateTaskReqBO.setInstance(stepInstance);
        uocCreateTaskReqBO.setObjId(reqBO.getObjId());
        uocCreateTaskReqBO.setObjType(reqBO.getObjType());
        uocCreateTaskReqBO.setOrderId(reqBO.getOrderId());
        this.uocCreateTaskAtomService.createTask(uocCreateTaskReqBO);
    }

    private void updateStatus(UocProcessRunReqBO reqBO, StepWithOutInstance stepInstance) {
        UocCoreChgVoucherStateReqBO voucherStateReqBO = new UocCoreChgVoucherStateReqBO();
        voucherStateReqBO.setDealDesc(reqBO.getDealDesc());
        voucherStateReqBO.setOperId(reqBO.getOperId());
        voucherStateReqBO.setOrderId(reqBO.getOrderId());
        ArrayList<VoucherStateBO> voucherStateBoS = new ArrayList<VoucherStateBO>();
        VoucherStateBO voucherStateBO = new VoucherStateBO();
        voucherStateBO.setAfterState(Integer.valueOf(Integer.parseInt(stepInstance.getStepId())));
        voucherStateBO.setObjId(reqBO.getObjId());
        voucherStateBO.setObjType(reqBO.getObjType());
        voucherStateBoS.add(voucherStateBO);
        voucherStateReqBO.setVoucherStateList(voucherStateBoS);
        UocCoreChgVoucherStateRspBO rspBO = this.uocCoreChgVoucherStateAtomService.dealCoreChgVoucherState(voucherStateReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u66f4\u65b0\u72b6\u6001\u5931\u8d25," + rspBO.getRespDesc());
        }
    }

    private String valStatus(UocProcessRunReqBO reqBO) {
        if (UocConstant.OBJ_TYPE.ORDER.equals(reqBO.getObjType())) {
            return this.order(reqBO);
        }
        if (UocConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType())) {
            return this.sale(reqBO);
        }
        if (UocConstant.OBJ_TYPE.SHIP.equals(reqBO.getObjType())) {
            return this.ship(reqBO);
        }
        if (UocConstant.OBJ_TYPE.INSPECTION.equals(reqBO.getObjType())) {
            return this.inspection(reqBO);
        }
        if (UocConstant.OBJ_TYPE.AFTER_SERVICE.equals(reqBO.getObjType())) {
            return this.after(reqBO);
        }
        if (UocConstant.OBJ_TYPE.PAY.equals(reqBO.getObjType())) {
            return this.pay(reqBO);
        }
        if (UocConstant.OBJ_TYPE.PURCHASE.equals(reqBO.getObjType())) {
            return this.purchase(reqBO);
        }
        throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u4f20\u5165objType\u4e0d\u5bf9");
    }

    private String order(UocProcessRunReqBO reqBO) {
        OrderPO orderPO = this.orderMapper.getModelById(reqBO.getObjId().longValue());
        if (orderPO == null) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8ba2\u5355");
        }
        if (reqBO.getStepId() != null && !reqBO.getStepId().equals(orderPO.getOrderState().toString())) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u8ba2\u5355\u72b6\u6001\u4e8e\u4f20\u5165stepId\u4e0d\u4e00\u81f4");
        }
        return orderPO.getOrderState().toString();
    }

    private String sale(UocProcessRunReqBO reqBO) {
        OrdSalePO po = new OrdSalePO();
        po.setOrderId(reqBO.getOrderId());
        po.setSaleVoucherId(reqBO.getObjId());
        try {
            if (null != reqBO.getPreState()) {
                return String.valueOf(reqBO.getPreState());
            }
            if ((po = this.ordSaleMapper.getModelBy(po)) == null) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u67e5\u8be2\u9500\u552e\u5355\u9519\u8bef");
            }
            if (reqBO.getStepId() != null && !reqBO.getStepId().equals(po.getSaleState().toString())) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u9500\u552e\u5355\u72b6\u6001\u4e8e\u4f20\u5165stepId\u4e0d\u4e00\u81f4");
            }
            return po.getSaleState().toString();
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u9500\u552e\u5355");
        }
    }

    private String ship(UocProcessRunReqBO reqBO) {
        OrdShipPO po = new OrdShipPO();
        po.setShipVoucherId(reqBO.getObjId());
        po.setOrderId(reqBO.getOrderId());
        try {
            po = this.ordShipMapper.getModelBy(po);
            logger.debug(JSON.toJSONString((Object)po));
            if (po == null) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u67e5\u8be2\u53d1\u8d27\u5355\u9519\u8bef");
            }
            if (reqBO.getStepId() != null && !reqBO.getStepId().equals(po.getShipStatus())) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u53d1\u8d27\u5355\u72b6\u6001\u4e8e\u4f20\u5165stepId\u4e0d\u4e00\u81f4");
            }
            return po.getShipStatus();
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u53d1\u8d27\u5355");
        }
    }

    private String inspection(UocProcessRunReqBO reqBO) {
        OrdInspectionPO po = null;
        try {
            po = this.ordInspectionMapper.getModelById(reqBO.getObjId().longValue());
            if (po == null) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u67e5\u8be2\u6536\u8d27\u5355\u9519\u8bef");
            }
            if (reqBO.getStepId() != null && !reqBO.getStepId().equals(po.getInspectionState().toString())) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u6536\u8d27\u5355\u72b6\u6001\u4e8e\u4f20\u5165stepId\u4e0d\u4e00\u81f4");
            }
            return po.getInspectionState().toString();
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6536\u8d27\u5355");
        }
    }

    private String after(UocProcessRunReqBO reqBO) {
        OrdAfterServicePO po = null;
        try {
            po = this.ordAfterServiceMapper.getModelById(reqBO.getObjId().longValue());
            if (po == null) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u67e5\u8be2\u552e\u540e\u670d\u52a1\u5355\u9519\u8bef");
            }
            if (reqBO.getStepId() != null && !reqBO.getStepId().equals(po.getServState().toString())) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u552e\u540e\u670d\u52a1\u5355\u72b6\u6001\u4e8e\u4f20\u5165stepId\u4e0d\u4e00\u81f4");
            }
            return po.getServState().toString();
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u552e\u540e\u670d\u52a1\u5355");
        }
    }

    private String pay(UocProcessRunReqBO reqBO) {
        OrdPayPO po = null;
        try {
            po = this.ordPayMapper.getModelById(reqBO.getObjId().longValue());
            if (po == null) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u67e5\u8be2\u652f\u4ed8\u5355\u9519\u8bef");
            }
            if (reqBO.getStepId() != null && !reqBO.getStepId().equals(po.getPayState().toString())) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u652f\u4ed8\u5355\u72b6\u6001\u4e8e\u4f20\u5165stepId\u4e0d\u4e00\u81f4");
            }
            return po.getPayState().toString();
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u652f\u4ed8\u5355");
        }
    }

    private String purchase(UocProcessRunReqBO reqBO) {
        OrdPurchasePO po = null;
        try {
            po = this.ordPurchaseMapper.getModelById(reqBO.getObjId().longValue());
            if (po == null) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u67e5\u8be2\u91c7\u8d2d\u5355\u9519\u8bef");
            }
            if (reqBO.getStepId() != null && !reqBO.getStepId().equals(po.getPurchaseState().toString())) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u91c7\u8d2d\u5355\u72b6\u6001\u4e8e\u4f20\u5165stepId\u4e0d\u4e00\u81f4");
            }
            return po.getPurchaseState().toString();
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u91c7\u8d2d\u5355");
        }
    }

    private void val(UocProcessRunReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5165\u53c2\u4e3a\u7a7a");
        }
        if (reqBO.getObjId() == null) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,objId\u5165\u53c2\u4e3a\u7a7a");
        }
        if (reqBO.getObjType() == null) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,objType\u5165\u53c2\u4e3a\u7a7a");
        }
    }
}

