/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.ability.impl.saleorder;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.extend.ability.saleorder.PebExtAgreementCancelAbilityService;
import com.tydic.order.extend.bo.saleorder.PebExtAgreementCancelAbilityReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtAgreementCancelAbilityRspBO;
import com.tydic.order.extend.bo.saleorder.PebExtCancelReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtCancelRspBO;
import com.tydic.order.extend.busi.saleorder.PebExtCancelBusiService;
import com.tydic.order.pec.ability.el.order.UocPebOrderCancellationAbilityService;
import com.tydic.order.pec.ability.el.order.bo.UocPebOrderCancellationAbilityReqBO;
import com.tydic.order.pec.ability.el.order.bo.UocPebOrderCancellationAbilityRspBO;
import com.tydic.order.pec.bo.other.UocOrdIdxSyncReqBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=PebExtAgreementCancelAbilityService.class)
public class PebExtAgreementCancelAbilityServiceImpl
implements PebExtAgreementCancelAbilityService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV")
    private UocPebOrderCancellationAbilityService uocPebOrderCancellationAbilityService;
    @Autowired
    private PebExtCancelBusiService pebExtCancelBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    public PebExtAgreementCancelAbilityRspBO agreementCancel(PebExtAgreementCancelAbilityReqBO reqBO) {
        PebExtAgreementCancelAbilityRspBO rspBO = new PebExtAgreementCancelAbilityRspBO();
        this.validateParam(reqBO);
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (null == ordSalePO) {
            throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u9500\u552e\u5355\u4fe1\u606f");
        }
        if (UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(ordSalePO.getSaleState())) {
            PebExtCancelReqBO pebExtCancelReqBO = (PebExtCancelReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), PebExtCancelReqBO.class);
            pebExtCancelReqBO.setCancelReason(reqBO.getCancelReson());
            PebExtCancelRspBO pebExtCancelRspBO = this.pebExtCancelBusiService.dealOrderCancelled(pebExtCancelReqBO);
            if (!"0000".equals(pebExtCancelRspBO.getRespCode())) {
                throw new UocProBusinessException(pebExtCancelRspBO.getRespCode(), pebExtCancelRspBO.getRespDesc());
            }
            UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
            uocOrdIdxSyncReqBO.setObjId(reqBO.getSaleVoucherId());
            uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
            uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
        } else {
            UocPebOrderCancellationAbilityRspBO cancellationAbilityRspBO = this.uocPebOrderCancellationAbilityService.dealPebOrderCancellation((UocPebOrderCancellationAbilityReqBO)reqBO);
            if (!"0000".equals(cancellationAbilityRspBO.getRespCode())) {
                throw new UocProBusinessException(cancellationAbilityRspBO.getRespCode(), cancellationAbilityRspBO.getRespDesc());
            }
            rspBO.setRespCode(cancellationAbilityRspBO.getRespCode());
            rspBO.setRespDesc(cancellationAbilityRspBO.getRespDesc());
        }
        return rspBO;
    }

    private void validateParam(PebExtAgreementCancelAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOrderId() == null || 0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("0001", "\u5165\u53c2\u3010\u8ba2\u5355ID\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getSaleVoucherId() == null || 0L == reqBO.getSaleVoucherId()) {
            throw new UocProBusinessException("0001", "\u5165\u53c2\u3010\u9500\u552e\u5355ID\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getCancelReson())) {
            throw new UocProBusinessException("0001", "\u3010\u53d6\u6d88\u539f\u56e0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

