/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.busi.impl.msg;

import com.alibaba.fastjson.JSON;
import com.tydic.order.extend.bo.msg.PebExtOrderRemindReqBO;
import com.tydic.order.extend.bo.msg.PebExtOrderRemindRspBO;
import com.tydic.order.extend.busi.msg.PebExtOrderRemindBusiService;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.order.pec.dic.SelectDicValBypCodesBusiService;
import com.tydic.order.pec.dic.bo.DicDictionaryBO;
import com.tydic.order.pec.dic.bo.DicValAndpCodeBO;
import com.tydic.order.pec.dic.bo.SelectDicValBypCodesReqBO;
import com.tydic.order.pec.dic.bo.SelectDicValBypCodesRspBO;
import com.tydic.order.third.intf.ability.umc.PebIntfMemDetailQueryAbilityService;
import com.tydic.order.third.intf.bo.notify.PebTheOrderRemindReqBO;
import com.tydic.order.third.intf.bo.notify.PebTheOrderRemindRspBO;
import com.tydic.order.third.intf.bo.umc.MemDetailInfoBO;
import com.tydic.order.third.intf.bo.umc.MemDetailQueryReqBO;
import com.tydic.order.third.intf.bo.umc.MemDetailQueryRspBO;
import com.tydic.order.third.intf.busi.notify.PebTheOrderRemindBusiService;
import com.tydic.order.third.intf.constant.ThirdApiCommonConstant;
import com.tydic.order.uoc.dao.OrdRemindLogMapper;
import com.tydic.order.uoc.dao.po.OrdRemindLogPO;
import com.tydic.order.uoc.utils.OrderGenerateIdUtil;
import com.tydic.order.uoc.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtOrderRemindBusiServiceImpl
implements PebExtOrderRemindBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebExtOrderRemindBusiServiceImpl.class);
    @Autowired
    private PebTheOrderRemindBusiService pebTheOrderRemindBusiService;
    @Autowired
    private SelectDicValBypCodesBusiService selectDicValBypCodesBusiService;
    @Autowired
    OrdRemindLogMapper ordRemindLogMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private PebIntfMemDetailQueryAbilityService pebIntfMemDetailQueryAbilityService;

    public PebExtOrderRemindRspBO dealOrderRemind(PebExtOrderRemindReqBO reqBO) {
        LOGGER.debug("\u63d0\u9192\u670d\u52a1\u63a5\u6536\u5230\u7684\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        PebExtOrderRemindRspBO rspBO = new PebExtOrderRemindRspBO();
        try {
            this.doGetconfigs(reqBO);
            List<MemDetailInfoBO> menList = this.doGetMemInfo(reqBO);
            this.doSendMobilMsg(reqBO, menList);
            this.doSendSiteMsg(reqBO, menList);
            this.doSendEmailMsg(reqBO, menList);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void doGetconfigs(PebExtOrderRemindReqBO reqBO) {
        Long templateId;
        ArrayList<String> pCodes = new ArrayList<String>();
        if (PebExtConstant.REMIND_TYPE.ORDER_APPROVAL_PASS.equals(reqBO.getRemindType())) {
            pCodes.add("TEMPLATE_CODE_AUDIT_PASS");
        } else if (PebExtConstant.REMIND_TYPE.ORDER_APPROVAL_REFUSE.equals(reqBO.getRemindType())) {
            pCodes.add("TEMPLATE_CODE_AUDIT_REFUSE");
        } else {
            pCodes.add("TEMPLATE_CODE");
        }
        SelectDicValBypCodesReqBO dictReqBO = new SelectDicValBypCodesReqBO();
        dictReqBO.setpCodes(pCodes);
        SelectDicValBypCodesRspBO dictRspBO = this.selectDicValBypCodesBusiService.selectDicValBypCodes(dictReqBO);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u83b7\u53d6\u5c97\u4f4d\u7f16\u7801\u548c\u6a21\u677fid\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)dictRspBO));
        }
        if (!"0000".equals(dictRspBO.getRespCode())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u83b7\u53d6\u5c97\u4f4d\u7f16\u7801\u548c\u6a21\u677fid\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0:{}", (Object)dictRspBO.getRespDesc());
            }
            throw new UocProBusinessException("8888", dictRspBO.getRespDesc());
        }
        Map dicValAndpCodeBOMap = (Map)dictRspBO.getDicValAndpCodeBOs().get(0);
        if (dicValAndpCodeBOMap == null || dicValAndpCodeBOMap.isEmpty()) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u6a21\u677f\u548c\u5c97\u4f4d\u914d\u7f6e\u5931\u8d25\uff0c\u6ca1\u6709\u914d\u7f6e\u6570\u636e");
        }
        try {
            templateId = PebExtConstant.REMIND_TYPE.ORDER_APPROVAL_PASS.equals(reqBO.getRemindType()) ? Long.valueOf(((DicDictionaryBO)((DicValAndpCodeBO)dicValAndpCodeBOMap.get("TEMPLATE_CODE_AUDIT_PASS")).getDicDictionaries().get(0)).getDescrip()) : (PebExtConstant.REMIND_TYPE.ORDER_APPROVAL_REFUSE.equals(reqBO.getRemindType()) ? Long.valueOf(((DicDictionaryBO)((DicValAndpCodeBO)dicValAndpCodeBOMap.get("TEMPLATE_CODE_AUDIT_REFUSE")).getDicDictionaries().get(0)).getDescrip()) : Long.valueOf(((DicDictionaryBO)((DicValAndpCodeBO)dicValAndpCodeBOMap.get("TEMPLATE_CODE")).getDicDictionaries().get(0)).getDescrip()));
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", e.getMessage());
        }
        reqBO.setTemplateId(String.valueOf(templateId));
    }

    private List<MemDetailInfoBO> doGetMemInfo(PebExtOrderRemindReqBO reqBO) {
        ArrayList<MemDetailInfoBO> memInfoList = new ArrayList<MemDetailInfoBO>();
        MemDetailQueryReqBO memDetailReq = new MemDetailQueryReqBO();
        memDetailReq.setUserIdWeb(reqBO.getUserId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u5165\u53c2\uff1a{}" + JSON.toJSONString((Object)memDetailReq));
        }
        MemDetailQueryRspBO memDetailRsp = this.pebIntfMemDetailQueryAbilityService.memDetailQuery(memDetailReq);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u51fa\u53c2\uff1a{}" + JSON.toJSONString((Object)memDetailRsp));
        }
        if (!"0000".equals(memDetailRsp.getRespCode())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0:{}", (Object)memDetailRsp.getRespDesc());
            }
            throw new UocProBusinessException("8888", memDetailRsp.getRespDesc());
        }
        if (memDetailRsp.getUmcMemDetailInfoAbilityRspBO() == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u65e0\u6570\u636e\u8fd4\u56de");
            }
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u65e0\u6570\u636e\u8fd4\u56de");
        }
        memInfoList.add(memDetailRsp.getUmcMemDetailInfoAbilityRspBO());
        return memInfoList;
    }

    private void doSendSiteMsg(PebExtOrderRemindReqBO reqBO, List<MemDetailInfoBO> menList) {
        String titel = "\u8ba2\u5355\u6210\u4ea4\u901a\u77e5";
        String text = "\u5c0a\u656c\u7684\u7528\u6237\u60a8\u597d\uff01\u60a8\u5728\u9996\u94a2\u5728\u7ebf\u4ea4\u6613\u5e73\u53f0\u8d2d\u4e70\u7684\u5546\u54c1\u5df2\u7ecf\u4e0b\u5355\u6210\u529f\uff0c\u8ba2\u5355\u7f16\u53f7{<a href='" + OrderPropertiesUtil.getProperty("order.detail.url") + "/" + reqBO.getOrderId() + "/" + reqBO.getObjId() + "'>" + reqBO.getSaleVoucherNo() + "</a>" + "}\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u3002";
        if (PebExtConstant.REMIND_TYPE.ORDER_APPROVAL_REFUSE.equals(reqBO.getRemindType()) || PebExtConstant.REMIND_TYPE.ORDER_APPROVAL_PASS.equals(reqBO.getRemindType())) {
            titel = "\u8ba2\u5355\u5ba1\u6279\u7ed3\u679c\u901a\u77e5";
            text = reqBO.getMsgParam();
        }
        for (MemDetailInfoBO memBO : menList) {
            String status;
            PebTheOrderRemindReqBO pebTheOrderRemindReqBO = new PebTheOrderRemindReqBO();
            pebTheOrderRemindReqBO.setUserId(reqBO.getUserId());
            pebTheOrderRemindReqBO.setReceiveId(memBO.getUserId());
            pebTheOrderRemindReqBO.setTitel(titel);
            pebTheOrderRemindReqBO.setText(text);
            pebTheOrderRemindReqBO.setTemplateId(Long.valueOf(reqBO.getTemplateId()));
            pebTheOrderRemindReqBO.setToken(reqBO.getToken());
            pebTheOrderRemindReqBO.setSendType(ThirdApiCommonConstant.ORDER_SEND_MESSAGE);
            PebTheOrderRemindRspBO pebTheOrderRemindRspBO = this.pebTheOrderRemindBusiService.dealPebTheOrderRemind(pebTheOrderRemindReqBO);
            if ("0000".equals(pebTheOrderRemindRspBO.getRespCode())) {
                status = "1";
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0:{}", (Object)pebTheOrderRemindRspBO.getRespDesc());
                }
                status = "0";
            }
            this.dealAddLog(reqBO, status, PebExtConstant.SEND_TYPE.ORDER_SEND_MESSAGE, String.valueOf(memBO.getUserId()));
        }
    }

    private void doSendEmailMsg(PebExtOrderRemindReqBO reqBO, List<MemDetailInfoBO> menList) {
        String titel = "\u8ba2\u5355\u6210\u4ea4\u901a\u77e5";
        String text = "\u5c0a\u656c\u7684\u7528\u6237\u60a8\u597d\uff01\u60a8\u5728\u9996\u94a2\u5728\u7ebf\u4ea4\u6613\u5e73\u53f0\u8d2d\u4e70\u7684\u5546\u54c1\u5df2\u7ecf\u4e0b\u5355\u6210\u529f\uff0c\u8ba2\u5355\u7f16\u53f7{<a href='" + OrderPropertiesUtil.getProperty("order.detail.url") + "/" + reqBO.getOrderId() + "/" + reqBO.getObjId() + "'>" + reqBO.getSaleVoucherNo() + "</a>" + "}\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u3002";
        if (PebExtConstant.REMIND_TYPE.ORDER_APPROVAL_REFUSE.equals(reqBO.getRemindType()) || PebExtConstant.REMIND_TYPE.ORDER_APPROVAL_PASS.equals(reqBO.getRemindType())) {
            titel = "\u8ba2\u5355\u5ba1\u6279\u7ed3\u679c\u901a\u77e5";
            text = reqBO.getMsgParam();
        }
        for (MemDetailInfoBO memBO : menList) {
            String status;
            PebTheOrderRemindReqBO pebTheOrderRemindReqBO = new PebTheOrderRemindReqBO();
            pebTheOrderRemindReqBO.setSubject(titel);
            pebTheOrderRemindReqBO.setText(text);
            pebTheOrderRemindReqBO.setEmail(memBO.getRegEmail());
            pebTheOrderRemindReqBO.setSendType(ThirdApiCommonConstant.ORDER_SEND_EMIL);
            PebTheOrderRemindRspBO pebTheOrderRemindRspBO = this.pebTheOrderRemindBusiService.dealPebTheOrderRemind(pebTheOrderRemindReqBO);
            if ("0000".equals(pebTheOrderRemindRspBO.getRespCode())) {
                status = "1";
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0:{}", (Object)pebTheOrderRemindRspBO.getRespDesc());
                }
                status = "0";
            }
            this.dealAddLog(reqBO, status, PebExtConstant.SEND_TYPE.ORDER_SEND_EMIL, String.valueOf(memBO.getUserId()));
        }
    }

    private void doSendMobilMsg(PebExtOrderRemindReqBO reqBO, List<MemDetailInfoBO> menList) {
        String status;
        StringBuilder builder = new StringBuilder();
        for (MemDetailInfoBO memBO : menList) {
            builder.append(memBO.getRegMobile()).append(",");
        }
        String[] params = PebExtConstant.REMIND_TYPE.ORDER_APPROVAL_PASS.equals(reqBO.getRemindType()) ? new String[]{reqBO.getSaleVoucherNo() + ""} : (PebExtConstant.REMIND_TYPE.ORDER_APPROVAL_REFUSE.equals(reqBO.getRemindType()) ? new String[]{reqBO.getSaleVoucherNo() + "", reqBO.getRemark()} : new String[]{reqBO.getSaleVoucherNo() + ""});
        String mobile = builder.substring(0, builder.length() - 1);
        PebTheOrderRemindReqBO pebTheOrderRemindReqBO = new PebTheOrderRemindReqBO();
        pebTheOrderRemindReqBO.setText("\u5c0a\u656c\u7684\u7528\u6237\u60a8\u597d\uff01\u60a8\u5728\u9996\u94a2\u5728\u7ebf\u4ea4\u6613\u5e73\u53f0\u8d2d\u4e70\u7684\u5546\u54c1\u5df2\u7ecf\u4e0b\u5355\u6210\u529f\uff0c\u8ba2\u5355\u7f16\u53f7{" + reqBO.getSaleVoucherNo() + "}\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u3002");
        pebTheOrderRemindReqBO.setMobile(mobile);
        pebTheOrderRemindReqBO.setParams(params);
        pebTheOrderRemindReqBO.setTemplateId(Long.valueOf(reqBO.getTemplateId()));
        pebTheOrderRemindReqBO.setSendType(ThirdApiCommonConstant.ORDER_SEND_MOBILE);
        PebTheOrderRemindRspBO pebTheOrderRemindRspBO = this.pebTheOrderRemindBusiService.dealPebTheOrderRemind(pebTheOrderRemindReqBO);
        if ("0000".equals(pebTheOrderRemindRspBO.getRespCode())) {
            status = "1";
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0:{}", (Object)pebTheOrderRemindRspBO.getRespDesc());
            }
            status = "0";
        }
        for (MemDetailInfoBO memBO : menList) {
            this.dealAddLog(reqBO, status, PebExtConstant.SEND_TYPE.ORDER_SEND_MOBILE, memBO.getRegMobile());
        }
    }

    private void dealAddLog(PebExtOrderRemindReqBO reqBO, String status, Integer sendType, String receiveRole) {
        block3: {
            OrdRemindLogPO ordRemindLogPO = new OrdRemindLogPO();
            ordRemindLogPO.setId(Long.valueOf(this.sequence.nextId()));
            ordRemindLogPO.setReceiveRole(receiveRole);
            ordRemindLogPO.setStatus(status);
            ordRemindLogPO.setTemplateId(reqBO.getTemplateId());
            ordRemindLogPO.setSendType(sendType);
            ordRemindLogPO.setOrderId(reqBO.getOrderId());
            ordRemindLogPO.setCreateTime(new Date());
            try {
                int result = this.ordRemindLogMapper.insert(ordRemindLogPO);
                if (result != 1 && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug("\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + e);
            }
        }
    }
}

