/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.busi.impl.notify;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.order.extend.bo.notify.PebExtAddNotifyConfReqBO;
import com.tydic.order.extend.bo.notify.PebExtAddNotifyConfRspBO;
import com.tydic.order.extend.busi.notify.PebExtAddNotifyConfBusiService;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.order.uoc.dao.OrdConfNotifyMapper;
import com.tydic.order.uoc.dao.po.OrdConfNotifyPO;
import com.tydic.uac.util.GenerateIdUtil;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebExtAddNotifyConfBusiServiceImpl
implements PebExtAddNotifyConfBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtAddNotifyConfBusiServiceImpl.class);
    @Autowired
    private OrdConfNotifyMapper ordConfNotifyMapper;
    @Autowired
    private GenerateIdUtil idUtil;

    public PebExtAddNotifyConfRspBO addNotifyConf(PebExtAddNotifyConfReqBO reqBO) {
        this.checkParam(reqBO);
        PebExtAddNotifyConfRspBO pebExtAddNotifyConfRspBO = new PebExtAddNotifyConfRspBO();
        OrdConfNotifyPO ordConfNotifyPO = new OrdConfNotifyPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)ordConfNotifyPO);
        if (reqBO.getId() != null && reqBO.getId() != 0L && reqBO.getState() != null) {
            ordConfNotifyPO.setUpdateTime(new Date());
            int update = this.ordConfNotifyMapper.update(ordConfNotifyPO);
            if (update > 0) {
                pebExtAddNotifyConfRspBO.setRespCode("0000");
                pebExtAddNotifyConfRspBO.setRespDesc("\u66f4\u65b0\u72b6\u6001\u6210\u529f");
            } else {
                pebExtAddNotifyConfRspBO.setRespCode("8888");
                pebExtAddNotifyConfRspBO.setRespDesc("\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
            }
            return pebExtAddNotifyConfRspBO;
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getNotifyWayList())) {
            String notifyWay = String.join((CharSequence)",", reqBO.getNotifyWayList());
            ordConfNotifyPO.setNotifyWay(notifyWay);
        }
        String receiveRole = "";
        if (!CollectionUtils.isEmpty((Collection)reqBO.getReceiveRoleList())) {
            receiveRole = String.join((CharSequence)",", reqBO.getReceiveRoleList());
            ordConfNotifyPO.setReceiveRole(receiveRole);
        }
        if (this.checkModel(reqBO, pebExtAddNotifyConfRspBO, receiveRole)) {
            return pebExtAddNotifyConfRspBO;
        }
        try {
            if (ordConfNotifyPO.getId() != null && ordConfNotifyPO.getId() != 0L) {
                ordConfNotifyPO.setUpdateTime(new Date());
                int update = this.ordConfNotifyMapper.update(ordConfNotifyPO);
                if (update > 0) {
                    pebExtAddNotifyConfRspBO.setRespCode("0000");
                    pebExtAddNotifyConfRspBO.setRespDesc("\u66f4\u65b0\u8ba2\u5355\u901a\u77e5\u914d\u7f6e\u6210\u529f");
                } else {
                    pebExtAddNotifyConfRspBO.setRespCode("8888");
                    pebExtAddNotifyConfRspBO.setRespDesc("\u66f4\u65b0\u8ba2\u5355\u901a\u77e5\u914d\u7f6e\u5931\u8d25");
                }
            } else {
                Long id = this.idUtil.nextId();
                ordConfNotifyPO.setId(id);
                ordConfNotifyPO.setCreateTime(new Date());
                ordConfNotifyPO.setUpdateTime(new Date());
                int insert = this.ordConfNotifyMapper.insert(ordConfNotifyPO);
                if (insert > 0) {
                    pebExtAddNotifyConfRspBO.setRespCode("0000");
                    pebExtAddNotifyConfRspBO.setRespDesc("\u6dfb\u52a0\u8ba2\u5355\u901a\u77e5\u914d\u7f6e\u6210\u529f");
                } else {
                    pebExtAddNotifyConfRspBO.setRespCode("8888");
                    pebExtAddNotifyConfRspBO.setRespDesc("\u6dfb\u52a0\u8ba2\u5355\u901a\u77e5\u914d\u7f6e\u5931\u8d25");
                }
            }
        }
        catch (Exception e) {
            log.error("\u7ef4\u62a4\u8ba2\u5355\u901a\u77e5\u914d\u7f6e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            pebExtAddNotifyConfRspBO.setRespCode("8888");
            pebExtAddNotifyConfRspBO.setRespDesc("\u7ef4\u62a4\u8ba2\u5355\u901a\u77e5\u914d\u7f6e\u5931\u8d25");
        }
        return pebExtAddNotifyConfRspBO;
    }

    private boolean checkModel(PebExtAddNotifyConfReqBO reqBO, PebExtAddNotifyConfRspBO pebExtAddNotifyConfRspBO, String receiveRole) {
        OrdConfNotifyPO notifyPO = new OrdConfNotifyPO();
        notifyPO.setNotifyType(reqBO.getNotifyType());
        if (PebExtConstant.NOTIFY_TYPE.ORDER_NOTIFY.equals(reqBO.getNotifyType())) {
            notifyPO.setReceiveRole(receiveRole);
            notifyPO.setOrderType(reqBO.getOrderType());
            notifyPO.setNotifyBusiness(reqBO.getNotifyBusiness());
        } else if (PebExtConstant.NOTIFY_TYPE.ORDER_WARNING.equals(reqBO.getNotifyType()) || PebExtConstant.NOTIFY_TYPE.ZQ_YQ.equals(reqBO.getNotifyType())) {
            notifyPO.setReceiveRole(receiveRole);
            notifyPO.setSaleState(reqBO.getSaleState());
            notifyPO.setPayWay(reqBO.getPayWay());
            notifyPO.setDealTime(reqBO.getDealTime());
        } else {
            notifyPO.setReceiveRole(receiveRole);
            notifyPO.setNotifyBusiness(reqBO.getNotifyBusiness());
        }
        OrdConfNotifyPO model = this.ordConfNotifyMapper.queryByModel(notifyPO);
        if (model != null) {
            pebExtAddNotifyConfRspBO.setRespCode("8888");
            pebExtAddNotifyConfRspBO.setRespDesc("\u5df2\u5b58\u5728\u76f8\u540c\u901a\u77e5\u6216\u9884\u8b66\u53c2\u6570\u8bbe\u5b9a\uff0c\u8bf7\u786e\u8ba4\uff01");
            return true;
        }
        return false;
    }

    private void checkParam(PebExtAddNotifyConfReqBO reqBO) {
        if (reqBO.getId() == null) {
            if (StringUtils.isBlank((CharSequence)reqBO.getNotifyName())) {
                throw new ZTBusinessException("\u901a\u77e5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!PebExtConstant.NOTIFY_TYPE.DA_YY.equals(reqBO.getNotifyType()) && !PebExtConstant.NOTIFY_TYPE.RY_WZ.equals(reqBO.getNotifyType()) && null == reqBO.getOrderType()) {
                throw new ZTBusinessException("\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getNotifyType()) {
                throw new ZTBusinessException("\u901a\u77e5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)reqBO.getReceiveRoleList())) {
                throw new ZTBusinessException("\u63a5\u6536\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)reqBO.getNotifyWayList())) {
                throw new ZTBusinessException("\u901a\u77e5\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (PebExtConstant.NOTIFY_TYPE.ORDER_NOTIFY.equals(reqBO.getNotifyType()) && null == reqBO.getNotifyBusiness()) {
                throw new ZTBusinessException("\u901a\u77e5\u573a\u666f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (PebExtConstant.NOTIFY_TYPE.ORDER_WARNING.equals(reqBO.getNotifyType()) && null == reqBO.getSaleState()) {
                throw new ZTBusinessException("\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (PebExtConstant.NOTIFY_TYPE.ORDER_WARNING.equals(reqBO.getNotifyType()) && null == reqBO.getDealTime()) {
                throw new ZTBusinessException("\u5f85\u5904\u7406\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getContent())) {
                throw new ZTBusinessException("\u901a\u77e5\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

