/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.busi.impl.notify;

import com.ohaotian.plugin.db.Page;
import com.tydic.order.extend.bo.notify.PebExtQueryNotifyConfListInfoBO;
import com.tydic.order.extend.bo.notify.PebExtQueryNotifyConfListReqBO;
import com.tydic.order.extend.bo.notify.PebExtQueryNotifyConfListRspBO;
import com.tydic.order.extend.busi.notify.PebExtQueryNotifyConfListBusiService;
import com.tydic.order.pec.dic.SelectDicValByPcodeAndCode;
import com.tydic.order.pec.dic.bo.SelectSingleDictReqBO;
import com.tydic.order.pec.dic.bo.SelectSingleDictRspBO;
import com.tydic.order.uoc.dao.OrdConfNotifyMapper;
import com.tydic.order.uoc.dao.po.OrdConfNotifyPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtQueryNotifyConfListBusiServiceImpl
implements PebExtQueryNotifyConfListBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtQueryNotifyConfListBusiServiceImpl.class);
    @Autowired
    private OrdConfNotifyMapper ordConfNotifyMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;

    public PebExtQueryNotifyConfListRspBO queryNotifyConfList(PebExtQueryNotifyConfListReqBO reqBO) {
        PebExtQueryNotifyConfListRspBO rspBO = new PebExtQueryNotifyConfListRspBO();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        OrdConfNotifyPO ordConfNotifyPO = new OrdConfNotifyPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)ordConfNotifyPO);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getNotifyName())) {
            ordConfNotifyPO.setNotifyName(reqBO.getNotifyName());
        }
        if (reqBO.getNotifyType() != null) {
            ordConfNotifyPO.setNotifyType(reqBO.getNotifyType());
        }
        try {
            List ordConfNotifyPOS = this.ordConfNotifyMapper.queryAll(ordConfNotifyPO, page);
            if (ordConfNotifyPOS != null && ordConfNotifyPOS.size() > 0) {
                List confListInfoBOS = ordConfNotifyPOS.stream().map(confNotifyPO -> {
                    PebExtQueryNotifyConfListInfoBO rspBo = new PebExtQueryNotifyConfListInfoBO();
                    BeanUtils.copyProperties((Object)confNotifyPO, (Object)rspBo);
                    if (StringUtils.isNotBlank((CharSequence)confNotifyPO.getNotifyWay())) {
                        String[] notifyWay = confNotifyPO.getNotifyWay().split(",");
                        List<String> notifyWayList = Arrays.asList(notifyWay);
                        rspBo.setNotifyWayList(notifyWayList);
                    }
                    if (StringUtils.isNotBlank((CharSequence)confNotifyPO.getReceiveRole())) {
                        String[] receiveRole = confNotifyPO.getReceiveRole().split(",");
                        List<String> receiveRoleList = Arrays.asList(receiveRole);
                        rspBo.setReceiveRoleList(receiveRoleList);
                    }
                    this.transOrdConf(rspBo);
                    return rspBo;
                }).collect(Collectors.toList());
                rspBO.setPageNo(reqBO.getPageNo());
                rspBO.setRows(confListInfoBOS);
                rspBO.setTotal(page.getTotalPages());
                rspBO.setRecordsTotal(page.getTotalCount());
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8ba2\u5355\u901a\u77e5\u914d\u7f6e\u5217\u8868\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u5931\u8d25");
        }
        return rspBO;
    }

    private void transOrdConf(PebExtQueryNotifyConfListInfoBO notifyConfListInfoBO) {
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(notifyConfListInfoBO.getNotifyType() + "");
        dictReqBO.setPcode("NOTIFY_TYPE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            notifyConfListInfoBO.setNotifyTypeStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        ArrayList<String> notifyWayListStr = new ArrayList<String>();
        for (String notifyWay : notifyConfListInfoBO.getNotifyWayList()) {
            dictReqBO.setCode(notifyWay);
            dictReqBO.setPcode("NOTIFY_WAY");
            dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if (!"0000".equals(dictRspBO.getRespCode())) continue;
            notifyWayListStr.add(dictRspBO.getDicDictionarys().getDescrip());
        }
        notifyConfListInfoBO.setNotifyWayListStr(notifyWayListStr);
        dictReqBO.setCode(notifyConfListInfoBO.getNotifyBusiness() + "");
        dictReqBO.setPcode("NOTIFY_BUSINESS");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            notifyConfListInfoBO.setNotifyBusinessStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(notifyConfListInfoBO.getSaleState() + "");
        dictReqBO.setPcode("NOTIFY_ORDER_STATUS_EL");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            notifyConfListInfoBO.setSaleStateStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        ArrayList<String> receiveRoleListStr = new ArrayList<String>();
        for (String role : notifyConfListInfoBO.getReceiveRoleList()) {
            dictReqBO.setCode(role);
            dictReqBO.setPcode("RECEIVE_ROLE");
            dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if (!"0000".equals(dictRspBO.getRespCode())) continue;
            receiveRoleListStr.add(dictRspBO.getDicDictionarys().getDescrip());
        }
        notifyConfListInfoBO.setReceiveRoleListStr(receiveRoleListStr);
        dictReqBO.setCode(notifyConfListInfoBO.getOrderType() + "");
        dictReqBO.setPcode("ORDER_SOURCE");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            notifyConfListInfoBO.setOrderTypeStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(notifyConfListInfoBO.getPayWay() + "");
        dictReqBO.setPcode("PAY_WAY");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            notifyConfListInfoBO.setPayWayStr(dictRspBO.getDicDictionarys().getDescrip());
        }
    }
}

