/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.busi.impl.order;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.order.extend.bo.order.UocPebOrderPayApplyReqBO;
import com.tydic.order.extend.bo.order.UocPebOrderPayApplyRspBO;
import com.tydic.order.extend.busi.order.UocPebOrderPayApplyBusiService;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.order.extend.dao.OrdPayConfMapper;
import com.tydic.order.extend.dao.OrderPayApplyMapper;
import com.tydic.order.extend.dao.po.OrdPayConfPO;
import com.tydic.order.extend.dao.po.OrderPayApply;
import com.tydic.order.pec.bo.el.order.UocPebAccessoryBO;
import com.tydic.order.third.intf.ability.fsc.PebIntfFscDealPayableAbilityService;
import com.tydic.order.third.intf.ability.fsc.PebIntfPayConfigDetailQryDetailService;
import com.tydic.order.third.intf.ability.fsc.PebIntfQryPayMerchantInfoService;
import com.tydic.order.third.intf.ability.pay.PenIntfPayProOrderAbilityService;
import com.tydic.order.third.intf.ability.umc.PebIntfThirdBindQryListPageAbilityService;
import com.tydic.order.third.intf.bo.fsc.BusiAddPayConfigExceptReqBO;
import com.tydic.order.third.intf.bo.fsc.BusiReqData;
import com.tydic.order.third.intf.bo.fsc.PayGoodsInfos;
import com.tydic.order.third.intf.bo.fsc.PayMerchantInfoReqBO;
import com.tydic.order.third.intf.bo.fsc.PayMerchantInfoRspBO;
import com.tydic.order.third.intf.bo.fsc.PayProOrderAbilityServiceReqBO;
import com.tydic.order.third.intf.bo.fsc.PayTypeConfigQryListRspBO;
import com.tydic.order.third.intf.bo.fsc.PayeeInfos;
import com.tydic.order.third.intf.bo.fsc.PebIntfFscDealPayableReqBO;
import com.tydic.order.third.intf.bo.fsc.PebIntfFscDealPayableRspBO;
import com.tydic.order.third.intf.bo.fsc.PushFscPayableOrderBusiParamReqBO;
import com.tydic.order.third.intf.bo.pay.BusiAddPayConfigExceptRspBO;
import com.tydic.order.third.intf.bo.pay.PayFscBusiRspData;
import com.tydic.order.third.intf.bo.umc.ThirdBindBO;
import com.tydic.order.third.intf.bo.umc.ThirdBindQryListPageAbilityReqBO;
import com.tydic.order.third.intf.bo.umc.ThirdBindQryListPageAbilityRspBO;
import com.tydic.order.third.intf.busi.pay.PebOrderRealPayBusiService;
import com.tydic.order.uoc.atom.process.UocRunProcessAtomService;
import com.tydic.order.uoc.bo.common.OrdAccessoryPO;
import com.tydic.order.uoc.bo.process.UocProcessRunReqBO;
import com.tydic.order.uoc.bo.process.UocProcessRunRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdAccessoryMapper;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdPayMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdPayPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.order.uoc.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="UocPebOrderPayApplyBusiService")
public class UocPebOrderPayApplyBusiServiceImpl
implements UocPebOrderPayApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPebOrderPayApplyBusiServiceImpl.class);
    @Autowired
    OrdSaleMapper ordSaleMapper;
    @Autowired
    OrderMapper orderMapper;
    @Autowired
    OrdPayMapper ordPayMapper;
    @Autowired
    OrderPayApplyMapper orderPayApplyMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private PenIntfPayProOrderAbilityService penIntfPayProOrderAbilityService;
    @Value(value="${uoc.pay.redirectUrl}")
    private String redirectUrl;
    @Value(value="${uoc.pay.wb.redirectUrl}")
    private String wbRedirectUrl;
    @Value(value="${uoc.pay.notifyUrl}")
    private String notifyUrl;
    @Value(value="${uoc.pay.wb.dept.redirectUrl}")
    private String wbDeptRedirectUrl;
    @Autowired
    private PebIntfQryPayMerchantInfoService pebIntfQryPayMerchantInfoService;
    @Autowired
    private PebOrderRealPayBusiService pebOrderRealPayBusiService;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private PebIntfPayConfigDetailQryDetailService pebIntfPayConfigDetailQryDetailService;
    private static final int ICBC = 2;
    private static final int CN_BACK = 1;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private PebIntfThirdBindQryListPageAbilityService pebIntfThirdBindQryListPageAbilityService;
    @Autowired
    private PebIntfFscDealPayableAbilityService pebIntfFscDealPayableAbilityService;

    public UocPebOrderPayApplyRspBO orderPayApplay(UocPebOrderPayApplyReqBO reqBO) {
        UocPebOrderPayApplyRspBO rspBO = new UocPebOrderPayApplyRspBO();
        this.validateParams(reqBO);
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        OrdSalePO salePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (salePO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9519\u8bef\uff0c\u8981\u652f\u4ed8\u7684\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
            return rspBO;
        }
        if (!UocConstant.SALE_ORDER_STATUS.PAYING.equals(salePO.getSaleState())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8ba2\u5355\u72b6\u6001\u4e3a\u652f\u4ed8\u4e2d\u7684\u624d\u80fd\u8fdb\u884c\u4ed8\u6b3e\u64cd\u4f5c\uff01");
            return rspBO;
        }
        OrderPayApply qry = new OrderPayApply();
        qry.setOrderId(reqBO.getOrderId());
        if (PebExtConstant.PayMod.OFFLINE.equals(reqBO.getPayChannel())) {
            qry = this.orderPayApplyMapper.queryOne(qry);
            OrderPayApply orderPayApply = new OrderPayApply();
            BeanUtils.copyProperties((Object)reqBO, (Object)orderPayApply);
            orderPayApply.setOrderFee(salePO.getSaleFee());
            orderPayApply.setPayTime(new Date());
            if (qry == null) {
                orderPayApply.setId(Long.valueOf(this.idUtil.nextId()));
                this.orderPayApplyMapper.insert(orderPayApply);
            } else {
                this.orderPayApplyMapper.update(orderPayApply);
            }
        }
        this.saveAccessory(reqBO);
        OrdPayPO ordPayPO = new OrdPayPO();
        ordPayPO.setOrderId(reqBO.getOrderId());
        ordPayPO.setObjId(reqBO.getSaleVoucherId());
        OrdPayPO payPO = this.ordPayMapper.getModelBy(ordPayPO);
        OrderPO order = new OrderPO();
        order.setOrderId(reqBO.getOrderId());
        if (reqBO.getPayChannel() != null) {
            OrderPO orderPO = this.orderMapper.getModelBy(order);
            orderPO.setPayMod(reqBO.getPayChannel().toString());
            this.orderMapper.updateById(orderPO);
        }
        if (PebExtConstant.PayMod.OFFLINE.equals(reqBO.getPayChannel())) {
            payPO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
            this.ordPayMapper.updateById(payPO);
            this.run(reqBO);
        } else {
            this.online(rspBO, reqBO, payPO, salePO);
            this.ordPayMapper.updateById(payPO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u652f\u4ed8\u7533\u8bf7\u64cd\u4f5c\u6210\u529f");
        return rspBO;
    }

    public UocPebOrderPayApplyRspBO orderRealPay(UocPebOrderPayApplyReqBO reqBO) {
        Page<OrdSalePO> page = this.setSelectPageSize(100);
        List list = this.orderPayApplyMapper.queryNeedRealPayOrd(page);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            for (OrderPayApply payApply : list) {
                this.orderPayApplyMapper.update(payApply);
            }
        }
        UocPebOrderPayApplyRspBO rspBO = new UocPebOrderPayApplyRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setIsSuccess(Boolean.valueOf(true));
        return rspBO;
    }

    private Page<OrdSalePO> setSelectPageSize(int i) {
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(i);
        return page;
    }

    public void online(UocPebOrderPayApplyRspBO rspBO, UocPebOrderPayApplyReqBO reqBO, OrdPayPO ordPayPO, OrdSalePO ordSalePO) {
        Integer payChannel = reqBO.getPayChannel();
        OrderPO orderPO = this.orderMapper.getModelById(ordSalePO.getOrderId().longValue());
        BusiAddPayConfigExceptRspBO exceptRspBO = this.getPay(reqBO, orderPO);
        StringBuilder payMods = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)exceptRspBO.getPayTypeConfigFscQryListRspBoList())) {
            payMods = new StringBuilder();
            for (PayTypeConfigQryListRspBO listRspBO : exceptRspBO.getPayTypeConfigFscQryListRspBoList()) {
                String[] ps;
                if (!StringUtils.isNotBlank((CharSequence)listRspBO.getPayMent())) continue;
                for (String str : ps = listRspBO.getPayMent().split(",")) {
                    if (StringUtils.isBlank((CharSequence)str)) continue;
                    payMods.append(str).append(",");
                }
            }
            if (payMods.length() > 1) {
                payMods.replace(payMods.length() - 1, payMods.length(), "");
            }
        }
        if (payMods == null) {
            this.iCBCPay(rspBO, reqBO, ordPayPO, ordSalePO, null, orderPO);
        } else {
            this.iCBCPay(rspBO, reqBO, ordPayPO, ordSalePO, payMods.toString(), orderPO);
        }
    }

    private BusiAddPayConfigExceptRspBO getPay(UocPebOrderPayApplyReqBO reqBO, OrderPO orderPO) {
        BusiAddPayConfigExceptReqBO exceptReqBO = new BusiAddPayConfigExceptReqBO();
        if (PebExtConstant.OrderType.DA.equals(orderPO.getOrderType())) {
            exceptReqBO.setPayBusiType("7");
        } else if (PebExtConstant.OrderType.TH.equals(orderPO.getOrderType())) {
            exceptReqBO.setPayBusiType("0");
        } else if (PebExtConstant.OrderType.PT_AGR.equals(orderPO.getOrderType())) {
            exceptReqBO.setPayBusiType("1");
        } else if (PebExtConstant.OrderType.DW_AGR.equals(orderPO.getOrderType())) {
            exceptReqBO.setPayBusiType("2");
        } else if (PebExtConstant.OrderType.RY.equals(orderPO.getOrderType())) {
            exceptReqBO.setPayBusiType("6");
        } else if (PebExtConstant.OrderType.ZY.equals(orderPO.getOrderType())) {
            exceptReqBO.setPayBusiType("8");
        }
        exceptReqBO.setExceptId(reqBO.getCompanyId());
        String in = "0";
        String out = "1";
        String p = "0";
        String dept = "1";
        switch (reqBO.getMemUserType()) {
            case "1": {
                exceptReqBO.setPaySubClass(out);
                exceptReqBO.setPaySubType(p);
                break;
            }
            case "2": {
                exceptReqBO.setPaySubClass(out);
                exceptReqBO.setPaySubType(dept);
                break;
            }
            case "3": {
                exceptReqBO.setPaySubClass(in);
                exceptReqBO.setPaySubType(p);
                break;
            }
            default: {
                exceptReqBO.setPaySubClass(in);
                exceptReqBO.setPaySubType(dept);
            }
        }
        BusiAddPayConfigExceptRspBO rspBO = this.pebIntfPayConfigDetailQryDetailService.qryPayConfigDetailOrPayConfig(exceptReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException(rspBO.getRespCode(), "\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u5931\u8d25\uff1a" + rspBO.getRespDesc());
        }
        return rspBO;
    }

    public void iCBCPay(UocPebOrderPayApplyRspBO rspBO, UocPebOrderPayApplyReqBO reqBO, OrdPayPO ordPayPO, OrdSalePO ordSalePO, String payMods, OrderPO orderPO) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getWxAppId())) {
            ThirdBindQryListPageAbilityReqBO abilityReqBO = new ThirdBindQryListPageAbilityReqBO();
            abilityReqBO.setMemId(reqBO.getMemIdIn());
            abilityReqBO.setAuthType(PebExtConstant.AuthType.WX_APP);
            ThirdBindQryListPageAbilityRspBO abilityRspBO = this.pebIntfThirdBindQryListPageAbilityService.qryThirdBindListPage(abilityReqBO);
            if (!"0000".equals(abilityRspBO.getRespCode())) {
                throw new UocProBusinessException(abilityRspBO.getRespCode(), "\u67e5\u8be2\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25\uff1a" + abilityRspBO.getRespDesc());
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
                throw new UocProBusinessException(abilityRspBO.getRespCode(), "\u5f53\u524d\u7528\u6237\u672a\u8ba4\u8bc1\uff0c\u8bf7\u5148\u8fdb\u884c\u8ba4\u8bc1");
            }
            reqBO.setOpenId(((ThirdBindBO)abilityRspBO.getRows().get(0)).getAuthId());
        }
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(ordSalePO.getOrderId().longValue());
        PayProOrderAbilityServiceReqBO serviceReqBO = new PayProOrderAbilityServiceReqBO();
        serviceReqBO.setBusiCode("D500");
        serviceReqBO.setOutOrderId(ordPayPO.getPayVoucherId().toString());
        OrdExtMapPO mapPO = new OrdExtMapPO();
        mapPO.setFieldCode("busiMode");
        mapPO.setOrderId(ordSalePO.getOrderId());
        mapPO.setObjId(ordSalePO.getOrderId());
        mapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        mapPO = this.ordExtMapMapper.getModelBy(mapPO);
        PayMerchantInfoReqBO infoReqBO = new PayMerchantInfoReqBO();
        if (mapPO == null) {
            infoReqBO.setOrgId(Long.valueOf(stakeholderPO.getProNo()));
        } else if ("0".equals(mapPO.getFieldValue())) {
            infoReqBO.setOrgId(Long.valueOf(stakeholderPO.getProNo()));
        } else {
            infoReqBO.setOrgId(Long.valueOf(stakeholderPO.getSupNo()));
        }
        PayMerchantInfoRspBO infoRspBO = this.pebIntfQryPayMerchantInfoService.qryPayMerchantInfo(infoReqBO);
        if (!"0000".equals(infoRspBO.getRespCode())) {
            throw new UocProBusinessException(infoRspBO.getRespCode(), infoRspBO.getRespDesc());
        }
        if (infoRspBO.getMerchantId() == null) {
            throw new UocProBusinessException("8888", "\u5f53\u524d\u6536\u6b3e\u65b9\u672a\u914d\u7f6e\u652f\u4ed8\u5546\u6237\uff0c\u8bf7\u5148\u8fdb\u884c\u914d\u7f6e");
        }
        serviceReqBO.setMerchantId(infoRspBO.getMerchantId().toString());
        OrdPayConfPO confPO = new OrdPayConfPO();
        confPO.setOrderId(reqBO.getOrderId());
        List list = this.ordPayConfMapper.selectByCondition(confPO);
        long fee = ordSalePO.getSaleFee() / 100L;
        HashMap map = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            confPO = (OrdPayConfPO)list.get(0);
            try {
                fee = MoneyUtils.Long2BigDecimal((Long)ordSalePO.getSaleFee()).multiply(confPO.getPrePaySup()).longValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        serviceReqBO.setTotalFee(String.valueOf(fee));
        serviceReqBO.setDetailName("\u8ba2\u5355\uff1a" + ordSalePO.getSaleVoucherNo());
        if (reqBO.getReqWay() != null) {
            serviceReqBO.setReqWay(reqBO.getReqWay().toString());
        } else {
            serviceReqBO.setReqWay("1");
        }
        if ("1".equals(orderPO.getUserType())) {
            serviceReqBO.setRedirectUrl(this.wbRedirectUrl);
        } else {
            serviceReqBO.setRedirectUrl(this.redirectUrl);
        }
        if ("2".equals(reqBO.getMemUserType())) {
            serviceReqBO.setRedirectUrl(this.wbDeptRedirectUrl);
        }
        serviceReqBO.setNotifyUrl(this.notifyUrl);
        BusiReqData data = new BusiReqData();
        serviceReqBO.setBusiReqData(data);
        data.setAccountId(stakeholderPO.getPurNo());
        data.setPayerAccno(reqBO.getPayBankAccount());
        data.setPayMemno("1");
        data.setPayerAccname(reqBO.getPayAcctName());
        data.setPayMethods(payMods);
        ArrayList<PayeeInfos> ps = new ArrayList<PayeeInfos>();
        PayeeInfos payeeInfos = new PayeeInfos();
        ps.add(payeeInfos);
        data.setPayeeInfos(ps);
        payeeInfos.setMallCode(stakeholderPO.getSupNo());
        payeeInfos.setMallName(stakeholderPO.getSupName());
        payeeInfos.setPayeeCompanyName(reqBO.getRecAcctName());
        payeeInfos.setPayAmount(serviceReqBO.getTotalFee());
        payeeInfos.setPayeeAccno(reqBO.getBankAccount());
        payeeInfos.setPayeeSysflag("1");
        ArrayList<PayGoodsInfos> gs = new ArrayList<PayGoodsInfos>();
        PayGoodsInfos goodsInfos = new PayGoodsInfos();
        gs.add(goodsInfos);
        goodsInfos.setGoodsAmt(serviceReqBO.getTotalFee());
        goodsInfos.setGoodsName("\u8ba2\u5355\uff1a" + ordSalePO.getSaleVoucherNo());
        goodsInfos.setGoodsNumber("1");
        goodsInfos.setGoodsSubId("1");
        goodsInfos.setGoodsUnit("\u4ef6");
        goodsInfos.setPayeeCompanyName(reqBO.getRecAcctName());
        data.setGoodsInfos(gs);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getWxAppId())) {
            data.setAppletAppId(reqBO.getWxAppId());
            data.setOpenId(reqBO.getOpenId());
            serviceReqBO.setPayMethod("15");
            serviceReqBO.setReqWay("3");
            serviceReqBO.setCreateIpAddress("127.0.0.1");
            data.setGoodsInfos(null);
            data.setPayeeInfos(null);
        }
        PebIntfFscDealPayableReqBO pebIntfFscDealPayableReqBO = new PebIntfFscDealPayableReqBO();
        pebIntfFscDealPayableReqBO.setFlowType(reqBO.getMemUserType());
        pebIntfFscDealPayableReqBO.setOperatorId(reqBO.getUserId());
        pebIntfFscDealPayableReqBO.setOperatorName(reqBO.getUsername());
        pebIntfFscDealPayableReqBO.setCompanyId(String.valueOf(reqBO.getCompanyId()));
        pebIntfFscDealPayableReqBO.setCompanyName(reqBO.getCompanyName());
        pebIntfFscDealPayableReqBO.setOrderDetail("\u8ba2\u5355\uff1a" + ordSalePO.getSaleVoucherNo());
        pebIntfFscDealPayableReqBO.setIpAddress("127.0.0.1");
        if ("1".equals(orderPO.getUserType())) {
            pebIntfFscDealPayableReqBO.setWebUrl(this.wbRedirectUrl);
        } else {
            pebIntfFscDealPayableReqBO.setWebUrl(this.redirectUrl);
        }
        if ("2".equals(reqBO.getMemUserType())) {
            pebIntfFscDealPayableReqBO.setWebUrl(this.wbDeptRedirectUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getWxAppId())) {
            PushFscPayableOrderBusiParamReqBO pushFscPayableOrderBusiParamReqBO = new PushFscPayableOrderBusiParamReqBO();
            pushFscPayableOrderBusiParamReqBO.setAppletAppId(reqBO.getWxAppId());
            pushFscPayableOrderBusiParamReqBO.setAppPayAppId(reqBO.getWxAppId());
            pushFscPayableOrderBusiParamReqBO.setOpenId(reqBO.getOpenId());
            pushFscPayableOrderBusiParamReqBO.setPayMethods("15");
            pebIntfFscDealPayableReqBO.setFscPayableOrderBusiParamBO(pushFscPayableOrderBusiParamReqBO);
        }
        pebIntfFscDealPayableReqBO.setOrderCode(ordSalePO.getSaleVoucherNo());
        pebIntfFscDealPayableReqBO.setPayableNos(Collections.singletonList(stakeholderPO.getExtField4()));
        pebIntfFscDealPayableReqBO.setOperType("SUBMIT");
        PebIntfFscDealPayableRspBO serviceRspBO = this.pebIntfFscDealPayableAbilityService.dealPayable(pebIntfFscDealPayableReqBO);
        if (!"0000".equals(serviceRspBO.getRespCode())) {
            throw new UocProBusinessException(serviceRspBO.getRespCode(), "\u652f\u4ed8\u5931\u8d25\uff1a" + serviceRspBO.getRespDesc());
        }
        BeanUtils.copyProperties((Object)serviceRspBO, (Object)rspBO);
        if (serviceRspBO.getBusiRspData() != null) {
            PayFscBusiRspData payBusiRspData = (PayFscBusiRspData)JSON.parseObject((String)JSON.toJSONString((Object)serviceRspBO.getBusiRspData()), PayFscBusiRspData.class);
            rspBO.setPayBusiRspData(payBusiRspData);
        }
        ordPayPO.setPayVoucherNo(serviceRspBO.getPayNotifyTransId());
        ordPayPO.setOutPayOrderNo(serviceRspBO.getPayOrderId());
    }

    public void BOCPay(UocPebOrderPayApplyRspBO rspBO, UocPebOrderPayApplyReqBO reqBO, OrdPayPO ordPayPO, OrdSalePO ordSalePO) {
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(ordSalePO.getOrderId().longValue());
        PayProOrderAbilityServiceReqBO serviceReqBO = new PayProOrderAbilityServiceReqBO();
        serviceReqBO.setBusiCode("D500");
        serviceReqBO.setOutOrderId(ordPayPO.getPayVoucherId().toString());
        PayMerchantInfoReqBO infoReqBO = new PayMerchantInfoReqBO();
        infoReqBO.setOrgId(Long.valueOf(stakeholderPO.getSupNo()));
        PayMerchantInfoRspBO infoRspBO = this.pebIntfQryPayMerchantInfoService.qryPayMerchantInfo(infoReqBO);
        if (!"0000".equals(infoRspBO.getRespCode())) {
            throw new UocProBusinessException(infoRspBO.getRespCode(), infoRspBO.getRespDesc());
        }
        if (infoRspBO.getMerchantId() == null) {
            infoRspBO.setMerchantId(Long.valueOf(1000000001L));
        }
        serviceReqBO.setMerchantId(infoRspBO.getMerchantId().toString());
        Long fee = ordSalePO.getSaleFee() / 100L;
        serviceReqBO.setTotalFee(String.valueOf(fee));
        serviceReqBO.setDetailName("\u8ba2\u5355\uff1a" + ordSalePO.getSaleVoucherNo());
        serviceReqBO.setPayMethod("180");
        serviceReqBO.setReqWay("1");
        serviceReqBO.setNotifyUrl(this.notifyUrl);
        BusiReqData data = new BusiReqData();
        serviceReqBO.setBusiReqData(data);
        data.setAccountId(stakeholderPO.getPurNo());
        ArrayList<PayeeInfos> ps = new ArrayList<PayeeInfos>();
        PayeeInfos payeeInfos = new PayeeInfos();
        ps.add(payeeInfos);
        data.setPayeeInfos(ps);
        payeeInfos.setMallCode(stakeholderPO.getSupNo());
        payeeInfos.setMallName(stakeholderPO.getSupName());
        payeeInfos.setPayeeCompanyName(reqBO.getRecAcctName());
        payeeInfos.setPayAmount(serviceReqBO.getTotalFee());
        payeeInfos.setPayeeAccno(reqBO.getBankAccount());
        payeeInfos.setPayeeSysflag("1");
        PebIntfFscDealPayableReqBO pebIntfFscDealPayableReqBO = new PebIntfFscDealPayableReqBO();
        pebIntfFscDealPayableReqBO.setPayableNos(Collections.singletonList(stakeholderPO.getExtField4()));
        pebIntfFscDealPayableReqBO.setOperType("SUBMIT");
        PebIntfFscDealPayableRspBO serviceRspBO = this.pebIntfFscDealPayableAbilityService.dealPayable(pebIntfFscDealPayableReqBO);
        if (!"0000".equals(serviceRspBO.getRespCode())) {
            throw new UocProBusinessException(serviceRspBO.getRespCode(), "\u652f\u4ed8\u5931\u8d25\uff1a" + serviceRspBO.getRespDesc());
        }
        if (serviceRspBO.getBusiRspData() != null) {
            PayFscBusiRspData payBusiRspData = (PayFscBusiRspData)JSON.parseObject((String)JSON.toJSONString((Object)serviceRspBO.getBusiRspData()), PayFscBusiRspData.class);
            rspBO.setPayBusiRspData(payBusiRspData);
        }
        ordPayPO.setPayVoucherNo(serviceRspBO.getPayNotifyTransId());
        ordPayPO.setOutPayOrderNo(serviceRspBO.getPayOrderId());
    }

    private void run(UocPebOrderPayApplyReqBO reqBO) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(reqBO.getSaleVoucherId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setOperId(String.valueOf(reqBO.getMemId()));
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private void saveAccessory(UocPebOrderPayApplyReqBO reqBO) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            return;
        }
        Long orderId = reqBO.getOrderId();
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getAccessoryList().size());
        for (UocPebAccessoryBO accessoryBO : reqBO.getAccessoryList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.ATTACHMENT_TYPE.PAY_APPLY);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.PAY);
            ordAccessoryPO.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPO.setAccessoryId(accessoryBO.getAccessoryId());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(orderId);
            ordAccessoryPO.setRemark("\u4ed8\u6b3e\u7533\u8bf7");
            list.add(ordAccessoryPO);
        }
        this.ordAccessoryMapper.insertBatch(list);
    }

    private void validateParams(UocPebOrderPayApplyReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("7777", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null || reqBO.getSaleVoucherId() == null) {
            throw new UocProBusinessException("7777", "\u5165\u53c2\u8ba2\u5355 id\u548c\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

