/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.busi.impl.plan;

import com.tydic.order.extend.bo.es.PebExtExecuteSyncPlanReqBO;
import com.tydic.order.extend.bo.plan.PebExtUpdatePlanReqBO;
import com.tydic.order.extend.bo.plan.PebExtUpdatePlanRspBO;
import com.tydic.order.extend.bo.saleorder.PebExtThirdSupplierSkuInfo;
import com.tydic.order.extend.busi.es.PebExtExecuteSyncPlanBusiService;
import com.tydic.order.extend.busi.plan.PebExtUpdatePlanBusiService;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.order.extend.dao.OrdEcpPlanItemMapper;
import com.tydic.order.extend.dao.OrdEcpPlanMapper;
import com.tydic.order.extend.dao.po.OrdEcpPlanItemPO;
import com.tydic.order.extend.dao.po.OrdEcpPlanPO;
import com.tydic.order.pec.dic.SelectDicValByPcodeAndCode;
import com.tydic.order.pec.dic.bo.SelectSingleDictReqBO;
import com.tydic.order.pec.dic.bo.SelectSingleDictRspBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtUpdatePlanBusiServiceImpl
implements PebExtUpdatePlanBusiService {
    @Autowired
    private OrdEcpPlanMapper ordEcpPlanMapper;
    @Autowired
    private OrdEcpPlanItemMapper ordEcpPlanItemMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private PebExtExecuteSyncPlanBusiService pebExtExecuteSyncPlanBusiService;

    public PebExtUpdatePlanRspBO dealUpdate(PebExtUpdatePlanReqBO reqBO) {
        if (null != reqBO.getPlanId()) {
            OrdEcpPlanItemPO itemPO;
            OrdEcpPlanPO planPO = this.ordEcpPlanMapper.getModelById(reqBO.getPlanId().longValue());
            BigDecimal price = BigDecimal.ZERO;
            if (reqBO.getSaleOrderItemList() != null) {
                for (PebExtThirdSupplierSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
                    price = price.add(skuInfo.getPurchaseCount().multiply(skuInfo.getSkuSalePrice()));
                    itemPO = new OrdEcpPlanItemPO();
                    itemPO.setUsed(skuInfo.getPurchaseCount());
                    itemPO.setPlanId(skuInfo.getPlanId());
                    itemPO.setPlanItemId(skuInfo.getPlanItemId());
                    itemPO.setOrderId(planPO.getOrderId());
                    this.ordEcpPlanItemMapper.updateCount(itemPO);
                }
            }
            if (reqBO.getAgreementSkuInfo() != null) {
                for (PebExtThirdSupplierSkuInfo skuInfo : reqBO.getAgreementSkuInfo()) {
                    price = price.add(skuInfo.getPurchaseCount().multiply(skuInfo.getSkuSalePrice()));
                    itemPO = new OrdEcpPlanItemPO();
                    itemPO.setUsed(skuInfo.getPurchaseCount());
                    itemPO.setPlanId(skuInfo.getPlanId());
                    itemPO.setPlanItemId(skuInfo.getPlanItemId());
                    itemPO.setOrderId(planPO.getOrderId());
                    this.ordEcpPlanItemMapper.updateCount(itemPO);
                }
            }
            OrdEcpPlanPO update = new OrdEcpPlanPO();
            update.setOrderId(planPO.getOrderId());
            update.setPlanId(planPO.getPlanId());
            int sc = 100000000;
            update.setUsed(price.divide(new BigDecimal(sc)));
            if (planPO.getUsed() == null) {
                planPO.setUsed(BigDecimal.ZERO);
            }
            if (planPO.getUsed().add(update.getUsed()).compareTo(planPO.getYsje()) == 0) {
                update.setStatus(PebExtConstant.PlanStatus.FINISH);
            } else {
                update.setStatus(PebExtConstant.PlanStatus.DOING);
            }
            update.setStatusStr(this.getPlanStatusStr(update.getStatus()));
            this.ordEcpPlanMapper.updateCount(update);
        }
        PebExtUpdatePlanRspBO rspBO = new PebExtUpdatePlanRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public PebExtUpdatePlanRspBO dealReverse(PebExtUpdatePlanReqBO reqBO) {
        if (null != reqBO.getPlanId()) {
            OrdEcpPlanPO planPO = this.ordEcpPlanMapper.getModelById(reqBO.getPlanId().longValue());
            BigDecimal price = BigDecimal.ZERO;
            for (PebExtThirdSupplierSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
                skuInfo.setPurchaseCount(skuInfo.getPurchaseCount().negate());
                price = price.add(skuInfo.getPurchaseCount().multiply(skuInfo.getSkuSalePrice()));
                OrdEcpPlanItemPO itemPO = new OrdEcpPlanItemPO();
                itemPO.setUsed(skuInfo.getPurchaseCount());
                itemPO.setPlanId(skuInfo.getPlanId());
                itemPO.setPlanItemId(skuInfo.getPlanItemId());
                itemPO.setOrderId(planPO.getOrderId());
                this.ordEcpPlanItemMapper.updateCount(itemPO);
            }
            OrdEcpPlanPO update = new OrdEcpPlanPO();
            update.setOrderId(planPO.getOrderId());
            update.setPlanId(planPO.getPlanId());
            int sc = 100000000;
            update.setUsed(price.divide(new BigDecimal(sc)));
            if (planPO.getUsed() == null) {
                planPO.setUsed(BigDecimal.ZERO);
            }
            if (PebExtConstant.PlanStatus.FINISH.equals(planPO.getStatus()) && planPO.getUsed().compareTo(planPO.getYsje()) == 0) {
                update.setStatus(PebExtConstant.PlanStatus.DOING);
                update.setStatusStr(this.getPlanStatusStr(update.getStatus()));
            }
            if (update.getUsed().add(planPO.getUsed()).compareTo(BigDecimal.ZERO) == 0) {
                update.setStatus(PebExtConstant.PlanStatus.TODO);
                update.setStatusStr(this.getPlanStatusStr(update.getStatus()));
            }
            this.ordEcpPlanMapper.updateCount(update);
            this.syncPlanInfo(planPO.getPlanId(), planPO.getOrderId());
        }
        PebExtUpdatePlanRspBO rspBO = new PebExtUpdatePlanRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getPlanStatusStr(Integer status) {
        SelectSingleDictReqBO dicReqBo = new SelectSingleDictReqBO();
        dicReqBo.setCode(status.toString());
        dicReqBo.setPcode("CNNC_PLAN_STATUS");
        SelectSingleDictRspBO dicRetBo = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dicReqBo);
        if (!"0000".equals(dicRetBo.getRespCode())) {
            throw new UocProBusinessException("0002", "\u6267\u884c\u72b6\u6001\u66f4\u65b0\u65f6\uff0c\u72b6\u6001\u503c(status= " + status + ")\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8ba1\u5212\u72b6\u6001\u5e94\u4e3a:1700\uff08\u672a\u6267\u884c\uff09\uff0c1701\uff08\u6267\u884c\u4e2d\uff09\uff0c1702\uff08\u5df2\u9000\u56de\uff09\uff0c1703\uff08\u5df2\u5b8c\u7ed3\uff09");
        }
        return dicRetBo.getDicDictionarys().getDescrip();
    }

    private void syncPlanInfo(Long planId, Long orderId) {
        PebExtExecuteSyncPlanReqBO syncPlanReqBo = new PebExtExecuteSyncPlanReqBO();
        syncPlanReqBo.setOrderId(orderId);
        syncPlanReqBo.setPlanId(planId);
        try {
            this.pebExtExecuteSyncPlanBusiService.executeSync(syncPlanReqBo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

