/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.busi.impl.saleorder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.extend.bo.saleorder.PebExtCancelReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtCancelRspBO;
import com.tydic.order.extend.busi.saleorder.PebExtCancelBusiService;
import com.tydic.order.extend.comb.saleorder.TimerUnpaidOrderCancelComboService;
import com.tydic.order.mall.bo.timetask.TaskReqBo;
import com.tydic.order.pec.bo.other.UocOrdIdxSyncReqBO;
import com.tydic.order.pec.busi.es.order.bo.UocPebOrderCancelReqBO;
import com.tydic.order.pec.comb.es.order.UocPebOrderCancelCombService;
import com.tydic.order.pec.comb.es.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.pec.comb.es.timetask.bo.UocPebSaleOrdSevenDayCancelRspBO;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.po.OrdSaleForCancelPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="TimerUnpaidOrderCancelComboService")
public class TimerUnpaidOrderCancelComboServiceImpl
implements TimerUnpaidOrderCancelComboService {
    private static final Logger log = LoggerFactory.getLogger(TimerUnpaidOrderCancelComboServiceImpl.class);
    private final OrdSaleMapper ordSaleMapper;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    private final PebExtCancelBusiService pebExtCancelBusiService;
    private final UocPebOrderCancelCombService uocPebOrderCancelCombService;

    public TimerUnpaidOrderCancelComboServiceImpl(OrdSaleMapper ordSaleMapper, PebExtCancelBusiService pebExtCancelBusiService, UocPebOrderCancelCombService uocPebOrderCancelCombService) {
        this.ordSaleMapper = ordSaleMapper;
        this.pebExtCancelBusiService = pebExtCancelBusiService;
        this.uocPebOrderCancelCombService = uocPebOrderCancelCombService;
    }

    public UocPebSaleOrdSevenDayCancelRspBO cancelUnpaidOrder(TaskReqBo reqBO) {
        UocPebSaleOrdSevenDayCancelRspBO rspBO = new UocPebSaleOrdSevenDayCancelRspBO();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int executeDay = 7;
        calendar.add(5, -executeDay);
        Date before7days = calendar.getTime();
        OrdSaleForCancelPO qryOrderReqBO = new OrdSaleForCancelPO();
        qryOrderReqBO.setSaleState(UocConstant.SALE_ORDER_STATUS.PAYING);
        qryOrderReqBO.setCancelTime(before7days);
        qryOrderReqBO.setOrderSourceList(Arrays.asList(PecConstant.ORDER_SOURCE.ELEC_SUPERMARKET, PecConstant.ORDER_SOURCE.ELEC_AREA));
        qryOrderReqBO.setUserTypeList(Arrays.asList("1", "2"));
        Page<OrdSalePO> page = this.setSelectPageSize(100);
        List needCancelOrderList = this.ordSaleMapper.getNeedCancelOrder(qryOrderReqBO, page);
        log.info("\u5206\u9875\u67e5\u8be2\u5230\u76847\u5929\u672a\u4ed8\u6b3e\u8ba2\u5355\u4e3a" + (needCancelOrderList == null ? "0" : Integer.valueOf(needCancelOrderList.size())) + "\u6761");
        if (!CollectionUtils.isEmpty((Collection)needCancelOrderList)) {
            for (OrdSaleForCancelPO orderBO : needCancelOrderList) {
                PebExtCancelRspBO pebExtCancelRspBO;
                PebExtCancelReqBO pebExtCancelReqBO;
                log.debug("\u67e5\u8be2\u5230\u7684\u53ef\u53d6\u6d88\u5355\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)orderBO));
                if (("" + PecConstant.ORDER_SOURCE.ELEC_SUPERMARKET).equals(orderBO.getOrderSource())) {
                    pebExtCancelReqBO = (PebExtCancelReqBO)JSON.parseObject((String)JSON.toJSONString((Object)orderBO), PebExtCancelReqBO.class);
                    pebExtCancelRspBO = this.pebExtCancelBusiService.dealOrderCancelled(pebExtCancelReqBO);
                    if (!"0000".equals(pebExtCancelRspBO.getRespCode())) continue;
                    if (!pebExtCancelRspBO.getPush().booleanValue()) {
                        UocPebOrderCancelReqBO cancelReqBO = new UocPebOrderCancelReqBO();
                        BeanUtils.copyProperties((Object)reqBO, (Object)cancelReqBO);
                        cancelReqBO.setCancelDesc("\u672a\u4ed8\u6b3e\u8ba2\u5355\u8d85\u8fc77\u5929\u81ea\u52a8\u53d6\u6d88");
                        cancelReqBO.setSaleVoucherId(orderBO.getSaleVoucherId());
                        cancelReqBO.setCancelOperId("99999999999");
                        this.uocPebOrderCancelCombService.dealOrderCancel(cancelReqBO);
                    }
                    UocPebOrdIdxSyncReqBO syncReqBO = new UocPebOrdIdxSyncReqBO();
                    syncReqBO.setObjId(orderBO.getSaleVoucherId());
                    syncReqBO.setOrderId(orderBO.getOrderId());
                    syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)syncReqBO)));
                    continue;
                }
                if (!("" + PecConstant.ORDER_SOURCE.ELEC_AREA).equals(orderBO.getOrderSource())) continue;
                pebExtCancelReqBO = (PebExtCancelReqBO)JSON.parseObject((String)JSON.toJSONString((Object)orderBO), PebExtCancelReqBO.class);
                pebExtCancelReqBO.setCancelReason("\u672a\u4ed8\u6b3e\u8ba2\u5355\u8d85\u8fc77\u5929\u81ea\u52a8\u53d6\u6d88");
                pebExtCancelRspBO = this.pebExtCancelBusiService.dealOrderCancelled(pebExtCancelReqBO);
                if (!"0000".equals(pebExtCancelRspBO.getRespCode())) {
                    log.info("\u672a\u4ed8\u6b3e\u8ba2\u5355\u8d85\u8fc77\u5929\u81ea\u52a8\u53d6\u6d88\u5931\u8d25\uff1a" + pebExtCancelRspBO.getRespDesc());
                    continue;
                }
                UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
                uocOrdIdxSyncReqBO.setObjId(orderBO.getSaleVoucherId());
                uocOrdIdxSyncReqBO.setOrderId(orderBO.getOrderId());
                uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Page<OrdSalePO> setSelectPageSize(int i) {
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(i);
        return page;
    }
}

