/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.comb.impl.plan;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.extend.bo.es.PebExtOrdIdxSyncReqBO;
import com.tydic.order.extend.bo.plan.PebExtUpdatePlanReqBO;
import com.tydic.order.extend.bo.plan.PebExtUpdatePlanRspBO;
import com.tydic.order.extend.bo.saleorder.PebExtThirdSupplierSkuInfo;
import com.tydic.order.extend.busi.plan.PebExtUpdatePlanBusiService;
import com.tydic.order.extend.comb.plan.PebReverseCombService;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.order.extend.dao.OrdEcpPlanItemMapper;
import com.tydic.order.extend.dao.OrdPayConfMapper;
import com.tydic.order.extend.dao.po.OrdEcpPlanItemPO;
import com.tydic.order.extend.dao.po.OrdPayConfPO;
import com.tydic.order.pec.busi.es.order.bo.UocReverseItemBO;
import com.tydic.order.pec.busi.es.order.bo.UocReverseReqBO;
import com.tydic.order.third.intf.ability.fsc.PebIntfBusiAddCreditLineService;
import com.tydic.order.third.intf.ability.umc.PebIntfMemDetailQueryAbilityService;
import com.tydic.order.third.intf.ability.umc.PebIntfSgOrgAmountDeductAbilityService;
import com.tydic.order.third.intf.ability.umc.PebIntfWalletConsumeAbilityService;
import com.tydic.order.third.intf.bo.fsc.AddCreditLineReqBO;
import com.tydic.order.third.intf.bo.umc.MemDetailQueryReqBO;
import com.tydic.order.third.intf.bo.umc.MemDetailQueryRspBO;
import com.tydic.order.third.intf.bo.umc.SgOrgAmountDeductReqBO;
import com.tydic.order.third.intf.bo.umc.SgOrgAmountDeductRspBO;
import com.tydic.order.third.intf.bo.umc.WalletConsumeReqBO;
import com.tydic.order.third.intf.bo.umc.WalletConsumeRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdAfterServiceMapper;
import com.tydic.order.uoc.dao.OrdAsItemMapper;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdItemMapper;
import com.tydic.order.uoc.dao.OrdPayMapper;
import com.tydic.order.uoc.dao.OrdSaleCouponMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdShipItemMapper;
import com.tydic.order.uoc.dao.OrdShipMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdAfterServicePO;
import com.tydic.order.uoc.dao.po.OrdAsItemPO;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdItemPO;
import com.tydic.order.uoc.dao.po.OrdPayPO;
import com.tydic.order.uoc.dao.po.OrdSaleCouponPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdShipItemPO;
import com.tydic.order.uoc.dao.po.OrdShipPO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.uoc.base.bo.UocProBaseRspBo;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebReverseCombServiceImpl
implements PebReverseCombService {
    private static final Logger log = LoggerFactory.getLogger(PebReverseCombServiceImpl.class);
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdEcpPlanItemMapper ordEcpPlanItemMapper;
    @Autowired
    private PebExtUpdatePlanBusiService pebExtUpdatePlanBusiService;
    @Autowired
    private OrdAsItemMapper ordAsItemMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private PebIntfSgOrgAmountDeductAbilityService pebIntfSgOrgAmountDeductAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private PebIntfBusiAddCreditLineService pebIntfBusiAddCreditLineService;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private PebIntfWalletConsumeAbilityService pebIntfWalletConsumeAbilityService;
    @Autowired
    private PebIntfMemDetailQueryAbilityService pebIntfMemDetailQueryAbilityService;
    @Autowired
    private OrdSaleCouponMapper ordSaleCouponMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    public UocProBaseRspBo reverse(UocReverseReqBO reqBO) {
        OrdEcpPlanItemPO planItemPO;
        OrdExtMapPO extMapPO = new OrdExtMapPO();
        extMapPO.setFieldCode("purType");
        extMapPO.setOrderId(reqBO.getOrderId());
        extMapPO.setObjId(reqBO.getOrderId());
        extMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
        extMapPO = this.ordExtMapMapper.getModelBy(extMapPO);
        boolean flag = false;
        if (extMapPO == null || !PebExtConstant.PurchType.PLAN.toString().equals(extMapPO.getFieldCode())) {
            flag = true;
        }
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
        UocProBaseRspBo infoBO = new UocProBaseRspBo();
        infoBO.setRespCode("0000");
        infoBO.setRespDesc("\u6210\u529f");
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(reqBO.getOrderId());
        List list = this.ordItemMapper.getList(itemPO);
        if (((OrdItemPO)list.get(0)).getPlanItemId() == null) {
            flag = true;
            planItemPO = new OrdEcpPlanItemPO();
        } else {
            Long planItemId = ((OrdItemPO)list.get(0)).getPlanItemId();
            planItemPO = this.ordEcpPlanItemMapper.getModelById(planItemId.longValue());
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (reqBO.getReturnFee() != null && reqBO.getReturnFee() != 0L) {
            this.push(salePO.getOrderId(), stakeholderPO.getPurAccount(), salePO, reqBO);
            return infoBO;
        }
        if (reqBO.getObjType().equals(UocCoreConstant.OBJ_TYPE.SALE)) {
            this.dealOrder(reqBO, infoBO, list, planItemPO.getPlanId(), flag, stakeholderPO, salePO);
            return infoBO;
        }
        if (reqBO.getObjType().equals(UocCoreConstant.OBJ_TYPE.AFTER_SERVICE)) {
            this.dealAfs(reqBO, infoBO, list, planItemPO.getPlanId(), flag, stakeholderPO, salePO);
            return infoBO;
        }
        if (reqBO.getObjType().equals(UocCoreConstant.OBJ_TYPE.ABNORMAL)) {
            this.dealAb(reqBO, infoBO, list, planItemPO.getPlanId(), flag, stakeholderPO, salePO);
            return infoBO;
        }
        if (reqBO.getObjType().equals(UocCoreConstant.OBJ_TYPE.SHIP)) {
            this.dealShip(reqBO, infoBO, list, planItemPO.getPlanId(), flag, stakeholderPO, salePO);
            return infoBO;
        }
        return infoBO;
    }

    private void dealShip(UocReverseReqBO reqBO, UocProBaseRspBo infoBO, List<OrdItemPO> list, Long planId, boolean flag, OrdStakeholderPO stakeholderPO, OrdSalePO salePO) {
        OrdShipPO ordShipPO = new OrdShipPO();
        ordShipPO.setOrderId(reqBO.getOrderId());
        ordShipPO.setShipVoucherId(reqBO.getObjId());
        ordShipPO = this.ordShipMapper.getModelBy(ordShipPO);
        OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
        ordShipItemPO.setOrderId(reqBO.getOrderId());
        ordShipItemPO.setShipVoucherId(reqBO.getObjId());
        List ordShipItemPOS = this.ordShipItemMapper.getList(ordShipItemPO);
        long amount = 0L;
        for (OrdShipItemPO shipItemPO : ordShipItemPOS) {
            for (OrdItemPO itemPO : list) {
                if (!shipItemPO.getOrdItemId().equals(itemPO.getOrdItemId())) continue;
                amount += itemPO.getTotalSaleFee().longValue();
            }
        }
        if ("1203".equals(ordShipPO.getShipStatus())) {
            amount *= -1L;
        } else {
            this.returnWallet(salePO.getOrderId(), salePO.getSaleFee());
        }
        if (UocConstant.SALE_ORDER_STATUS.REJECTED_ORDER.equals(salePO.getSaleState())) {
            try {
                OrdPayPO ordPayPO = new OrdPayPO();
                ordPayPO.setInterType(Integer.valueOf(0));
                ordPayPO.setOrderId(salePO.getOrderId());
                ordPayPO.setPayState(UocConstant.PAY_ORDER_STATUS.CANCEL);
                this.ordPayMapper.updateById(ordPayPO);
                this.syncIdx(salePO);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        log.info("\u62d2\u6536\u9006\u5411" + amount);
        this.push(salePO.getOrderId(), stakeholderPO.getPurAccount(), salePO, amount, "2");
    }

    private void dealAb(UocReverseReqBO reqBO, UocProBaseRspBo infoBO, List<OrdItemPO> list, Long planId, boolean flag, OrdStakeholderPO stakeholderPO, OrdSalePO salePO) {
        PebExtUpdatePlanReqBO updatePlanReqBO = new PebExtUpdatePlanReqBO();
        ArrayList<PebExtThirdSupplierSkuInfo> saleOrderItemList = new ArrayList<PebExtThirdSupplierSkuInfo>();
        updatePlanReqBO.setPlanId(planId);
        updatePlanReqBO.setSaleOrderItemList(saleOrderItemList);
        long price = 0L;
        for (UocReverseItemBO reverseItemBO : reqBO.getItemBOS()) {
            for (OrdItemPO ordItemPO : list) {
                if (!ordItemPO.getOrdItemId().equals(reverseItemBO.getOrdItemId())) continue;
                PebExtThirdSupplierSkuInfo skuInfo = new PebExtThirdSupplierSkuInfo();
                skuInfo.setPurchaseCount(reverseItemBO.getCount());
                skuInfo.setPlanItemId(ordItemPO.getPlanItemId());
                skuInfo.setSkuSalePrice(new BigDecimal(ordItemPO.getSalePrice()));
                price += skuInfo.getSkuSalePrice().multiply(skuInfo.getPurchaseCount()).longValue();
                saleOrderItemList.add(skuInfo);
            }
        }
        this.editOrgAmount(Long.valueOf(stakeholderPO.getPurNo()), price, salePO.getOrderId());
        this.push(salePO.getOrderId(), stakeholderPO.getPurAccount(), salePO, price * -1L, "2");
        if (!flag) {
            return;
        }
        PebExtUpdatePlanRspBO rspBO = this.pebExtUpdatePlanBusiService.dealReverse(updatePlanReqBO);
        BeanUtils.copyProperties((Object)rspBO, (Object)infoBO);
    }

    private void syncIdx(OrdSalePO salePO) {
        PebExtOrdIdxSyncReqBO reqBO = new PebExtOrdIdxSyncReqBO();
        reqBO.setObjId(salePO.getSaleVoucherId());
        reqBO.setOrderId(salePO.getOrderId());
        reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        reqBO.setIsStatistics(Boolean.valueOf(false));
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
    }

    private void dealAfs(UocReverseReqBO reqBO, UocProBaseRspBo infoBO, List<OrdItemPO> list, Long planId, boolean flag, OrdStakeholderPO stakeholderPO, OrdSalePO salePO) {
        OrdAfterServicePO servicePO = new OrdAfterServicePO();
        servicePO.setAfterServId(reqBO.getObjId());
        servicePO.setOrderId(reqBO.getOrderId());
        servicePO = this.ordAfterServiceMapper.getModelBy(servicePO);
        if (!UocConstant.SERV_TYPE.SALES_RETURN.equals(servicePO.getServType())) {
            return;
        }
        OrdAsItemPO asItemPO = new OrdAsItemPO();
        asItemPO.setAfterServId(reqBO.getObjId());
        asItemPO.setOrderId(reqBO.getOrderId());
        asItemPO = this.ordAsItemMapper.getModelBy(asItemPO);
        PebExtUpdatePlanReqBO updatePlanReqBO = new PebExtUpdatePlanReqBO();
        ArrayList<PebExtThirdSupplierSkuInfo> saleOrderItemList = new ArrayList<PebExtThirdSupplierSkuInfo>();
        updatePlanReqBO.setPlanId(planId);
        updatePlanReqBO.setSaleOrderItemList(saleOrderItemList);
        long price = 0L;
        for (OrdItemPO ordItemPO : list) {
            if (!ordItemPO.getOrdItemId().equals(asItemPO.getOrdItemId())) continue;
            PebExtThirdSupplierSkuInfo skuInfo = new PebExtThirdSupplierSkuInfo();
            skuInfo.setPurchaseCount(asItemPO.getReturnCount().negate());
            skuInfo.setPlanItemId(ordItemPO.getPlanItemId());
            skuInfo.setSkuSalePrice(new BigDecimal(ordItemPO.getSalePrice()));
            price += skuInfo.getSkuSalePrice().multiply(skuInfo.getPurchaseCount()).longValue();
            saleOrderItemList.add(skuInfo);
            break;
        }
        this.editOrgAmount(Long.valueOf(stakeholderPO.getPurNo()), price, salePO.getOrderId());
        this.push(salePO.getOrderId(), stakeholderPO.getPurAccount(), salePO, price * -1L, "2");
        if (!flag) {
            return;
        }
        PebExtUpdatePlanRspBO rspBO = this.pebExtUpdatePlanBusiService.dealReverse(updatePlanReqBO);
        BeanUtils.copyProperties((Object)rspBO, (Object)infoBO);
    }

    private void dealOrder(UocReverseReqBO reqBO, UocProBaseRspBo infoBO, List<OrdItemPO> list, Long planId, boolean flag, OrdStakeholderPO stakeholderPO, OrdSalePO salePO) {
        this.editOrgAmount(Long.valueOf(stakeholderPO.getPurNo()), salePO.getSaleFee(), salePO.getOrderId());
        this.push(salePO.getOrderId(), stakeholderPO.getPurAccount(), salePO, salePO.getSaleFee(), "1");
        this.returnWallet(salePO.getOrderId(), salePO.getSaleFee());
        try {
            OrdPayPO ordPayPO = new OrdPayPO();
            ordPayPO.setInterType(Integer.valueOf(0));
            ordPayPO.setOrderId(salePO.getOrderId());
            ordPayPO.setPayState(UocConstant.PAY_ORDER_STATUS.CANCEL);
            this.ordPayMapper.updateById(ordPayPO);
            this.syncIdx(salePO);
        }
        catch (Exception ordPayPO) {
            // empty catch block
        }
        if (!flag) {
            return;
        }
        PebExtUpdatePlanReqBO updatePlanReqBO = new PebExtUpdatePlanReqBO();
        ArrayList<PebExtThirdSupplierSkuInfo> saleOrderItemList = new ArrayList<PebExtThirdSupplierSkuInfo>();
        for (OrdItemPO ordItemPO : list) {
            PebExtThirdSupplierSkuInfo skuInfo = new PebExtThirdSupplierSkuInfo();
            skuInfo.setPlanItemId(ordItemPO.getPlanItemId());
            skuInfo.setPurchaseCount(ordItemPO.getPurchaseCount());
            skuInfo.setSkuSalePrice(new BigDecimal(ordItemPO.getSalePrice()));
            saleOrderItemList.add(skuInfo);
        }
        updatePlanReqBO.setSaleOrderItemList(saleOrderItemList);
        updatePlanReqBO.setPlanId(planId);
        PebExtUpdatePlanRspBO rspBO = this.pebExtUpdatePlanBusiService.dealReverse(updatePlanReqBO);
        BeanUtils.copyProperties((Object)rspBO, (Object)infoBO);
    }

    private void editOrgAmount(Long orgId, Long price, Long orderId) {
        SgOrgAmountDeductReqBO sgOrgAmountDeductReqBO = new SgOrgAmountDeductReqBO();
        try {
            sgOrgAmountDeductReqBO.setAmount(MoneyUtils.Long2BigDecimal((Long)price).negate().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OrderPO orderPO = this.orderMapper.getModelById(orderId.longValue());
        sgOrgAmountDeductReqBO.setOrgId(orgId);
        sgOrgAmountDeductReqBO.setBalanceType(PebExtConstant.BalanceType.ND);
        sgOrgAmountDeductReqBO.setOperType("2");
        log.info("\u5e74\u5ea6\u4f59\u989d\u6263\u51cf" + JSON.toJSONString((Object)sgOrgAmountDeductReqBO));
        SgOrgAmountDeductRspBO sgOrgAmountDeductRspBO = this.pebIntfSgOrgAmountDeductAbilityService.editOrgAmount(sgOrgAmountDeductReqBO);
        if (!("2".equals(orderPO.getUserType()) || "1".equals(orderPO.getUserType()) || "0000".equals(sgOrgAmountDeductRspBO.getRespCode()))) {
            throw new UocProBusinessException("8888", sgOrgAmountDeductRspBO.getRespDesc());
        }
    }

    private void push(Long orderId, String countId, OrdSalePO salePO, UocReverseReqBO reverseReqBO) {
        log.info("\u8c03\u4ef7\u6388\u4fe1\u4fee\u6539\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reverseReqBO));
        try {
            OrdExtMapPO extMapPO = new OrdExtMapPO();
            extMapPO.setFieldCode("creditLine");
            extMapPO.setObjId(orderId);
            extMapPO.setOrderId(orderId);
            extMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            extMapPO = this.ordExtMapMapper.getModelBy(extMapPO);
            if (extMapPO == null) {
                return;
            }
            if (!"2".equals(extMapPO.getFieldValue())) {
                return;
            }
            OrdExtMapPO busiMode = new OrdExtMapPO();
            busiMode.setFieldCode("busiMode");
            busiMode.setObjId(orderId);
            busiMode.setOrderId(orderId);
            busiMode.setObjType(UocConstant.OBJ_TYPE.ORDER);
            busiMode = this.ordExtMapMapper.getModelBy(busiMode);
            if ("1".equals(busiMode.getFieldValue())) {
                return;
            }
            OrdPayConfPO ordPayConfPO = new OrdPayConfPO();
            ordPayConfPO.setOrderId(orderId);
            ordPayConfPO = (OrdPayConfPO)this.ordPayConfMapper.selectByCondition(ordPayConfPO).get(0);
            AddCreditLineReqBO reqBO = new AddCreditLineReqBO();
            reqBO.setAccountId(Long.valueOf(countId));
            reqBO.setPayConfigDetailId(Long.valueOf(ordPayConfPO.getPaySubTypeStr()));
            reqBO.setChangeType("1");
            try {
                reqBO.setChangeInfo(MoneyUtils.Long2BigDecimal((Long)reverseReqBO.getReturnFee()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            reqBO.setOrderCode(salePO.getSaleVoucherNo());
            reqBO.setOrderId(orderId);
            this.pebIntfBusiAddCreditLineService.addCreditLine(reqBO);
            reqBO.setPayConfigDetailId(Long.valueOf(ordPayConfPO.getPaySubTypeStr()));
            reqBO.setChangeType("0");
            try {
                reqBO.setChangeInfo(MoneyUtils.Long2BigDecimal((Long)reverseReqBO.getPayFee()).negate());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pebIntfBusiAddCreditLineService.addCreditLine(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void push(Long orderId, String countId, OrdSalePO salePO, Long fee, String type) {
        try {
            OrdExtMapPO extMapPO = new OrdExtMapPO();
            extMapPO.setFieldCode("creditLine");
            extMapPO.setOrderId(orderId);
            extMapPO.setObjId(orderId);
            extMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            extMapPO = this.ordExtMapMapper.getModelBy(extMapPO);
            if (extMapPO == null) {
                return;
            }
            if (!"2".equals(extMapPO.getFieldValue())) {
                return;
            }
            OrdExtMapPO busiMode = new OrdExtMapPO();
            busiMode.setFieldCode("busiMode");
            busiMode.setOrderId(orderId);
            busiMode.setObjId(orderId);
            busiMode.setObjType(UocConstant.OBJ_TYPE.ORDER);
            busiMode = this.ordExtMapMapper.getModelBy(busiMode);
            if ("1".equals(busiMode.getFieldValue())) {
                return;
            }
            OrdPayConfPO ordPayConfPO = new OrdPayConfPO();
            ordPayConfPO.setOrderId(orderId);
            ordPayConfPO = (OrdPayConfPO)this.ordPayConfMapper.selectByCondition(ordPayConfPO).get(0);
            AddCreditLineReqBO reqBO = new AddCreditLineReqBO();
            reqBO.setAccountId(Long.valueOf(countId));
            reqBO.setChangeType(type);
            reqBO.setPayConfigDetailId(Long.valueOf(ordPayConfPO.getPaySubTypeStr()));
            try {
                reqBO.setChangeInfo(MoneyUtils.Long2BigDecimal((Long)fee));
            }
            catch (Exception exception) {
                // empty catch block
            }
            reqBO.setOrderCode(salePO.getSaleVoucherNo());
            reqBO.setOrderId(orderId);
            this.pebIntfBusiAddCreditLineService.addCreditLine(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void returnWallet(Long orderId, Long fee) {
        OrdSaleCouponPO couponPO = new OrdSaleCouponPO();
        couponPO.setOrderId(orderId);
        List list = this.ordSaleCouponMapper.getList(couponPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        OrderPO orderPO = this.orderMapper.getModelById(orderId.longValue());
        if ("8888".equals(orderPO.getProcState())) {
            return;
        }
        MemDetailQueryReqBO reqBO = new MemDetailQueryReqBO();
        reqBO.setUserIdWeb(Long.valueOf(orderPO.getCreateOperId()));
        MemDetailQueryRspBO memDetailQueryRspBO = this.pebIntfMemDetailQueryAbilityService.memDetailQuery(reqBO);
        if (memDetailQueryRspBO.getUmcMemDetailInfoAbilityRspBO() == null) {
            return;
        }
        WalletConsumeReqBO walletConsumeReqBO = new WalletConsumeReqBO();
        try {
            walletConsumeReqBO.setConsumeAmount(MoneyUtils.Long2BigDecimal((Long)fee).negate());
        }
        catch (Exception exception) {
            // empty catch block
        }
        walletConsumeReqBO.setCheckFlag(Integer.valueOf(0));
        walletConsumeReqBO.setMemId(memDetailQueryRspBO.getUmcMemDetailInfoAbilityRspBO().getMemId());
        walletConsumeReqBO.setWalletType(Integer.valueOf(5));
        walletConsumeReqBO.setOrderId(orderId.toString());
        walletConsumeReqBO.setActivityCode(((OrdSaleCouponPO)list.get(0)).getCouponNo());
        WalletConsumeRspBO rspBO = this.pebIntfWalletConsumeAbilityService.walletConsume(walletConsumeReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            log.error("\u53d6\u6d88\u9000\u79ef\u5206\u5931\u8d25");
        }
    }
}

