/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.order.extend.bo.saleorder.OrdInterLogBO;
import com.tydic.order.extend.bo.saleorder.PebExtFieldInReqBO;
import com.tydic.order.extend.busi.saleorder.PebExtFieldInBusiService;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.order.extend.dao.OrdPayConfMapper;
import com.tydic.order.extend.dao.po.OrdPayConfPO;
import com.tydic.order.extend.dao.po.OrdShipPayAblePO;
import com.tydic.order.third.intf.ability.contract.PebIntfQueryContractSupplierService;
import com.tydic.order.third.intf.bo.contract.UocProQueryContractSupplierInfoReqBO;
import com.tydic.order.third.intf.bo.contract.UocProQueryContractSupplierInfoRspBO;
import com.tydic.order.third.intf.bo.fsc.PebBusiAddPayAbleReqBO;
import com.tydic.order.third.intf.bo.fsc.PebBusiAddPayAbleRspBO;
import com.tydic.order.third.intf.busi.fsc.PebBusiAddPayAbleServiceBusiService;
import com.tydic.order.uoc.atom.order.UocCoreQryOrderListAtomService;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdItemMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdShipItemMapper;
import com.tydic.order.uoc.dao.OrdShipMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.UocOrdPayConfMapper;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdItemPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdShipItemPO;
import com.tydic.order.uoc.dao.po.OrdShipPO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class PebBusiAddPayAbleServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(PebBusiAddPayAbleServiceConsumer.class);
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Autowired
    private PebExtFieldInBusiService pebExtFieldInBusiService;
    @Autowired
    OrdPayConfMapper ordPayConfMapper;
    @Autowired
    OrdSaleMapper ordSaleMapper;
    @Autowired
    OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    OrdExtMapMapper ordExtMapMapper;
    @Autowired
    OrderMapper orderMapper;
    @Autowired
    PebIntfQueryContractSupplierService pebIntfQueryContractSupplierService;
    @Autowired
    PebBusiAddPayAbleServiceBusiService pebBusiAddPayAbleServiceBusiService;
    @Autowired
    UocCoreQryOrderListAtomService uocCoreQryOrderListAtomService;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private UocOrdPayConfMapper uocOrdPayConfMapper;
    private static final String PAY_TYPE = "02";
    private static final String PAYABLE_STATUS = "01";

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        Long orderId = null;
        Long saleVoucherId = null;
        Long shipVoucherId = null;
        Map reqBO = null;
        try {
            reqBO = (Map)JSON.parseObject((String)proxyMessage.getContent(), Map.class);
            log.info("\u8ba2\u5355\u652f\u4ed8\u914d\u7f6e\u6d88\u8d39\u8005\u5165\u53c2:{}" + JSON.toJSONString((Object)reqBO));
            if (reqBO.get("ry") != null) {
                try {
                    this.pushRy(Long.valueOf(reqBO.get("orderId").toString()));
                }
                catch (Exception e) {
                    log.error("\u5197\u4f59\u7269\u8d44\u63a8\u9001\u5e94\u4ed8\u5931\u8d25" + e);
                }
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            orderId = "null".equals(String.valueOf(reqBO.get("orderId"))) ? null : Long.valueOf(Long.parseLong(String.valueOf(reqBO.get("orderId"))));
            saleVoucherId = "null".equals(String.valueOf(reqBO.get("saleVoucherId"))) ? null : Long.valueOf(Long.parseLong(String.valueOf(reqBO.get("saleVoucherId"))));
            Integer payableType2 = "null".equals(String.valueOf(reqBO.get("payableType"))) ? null : Integer.valueOf(Integer.parseInt(String.valueOf(reqBO.get("payableType"))));
            Long l = shipVoucherId = "null".equals(String.valueOf(reqBO.get("shipVoucherId"))) ? null : Long.valueOf(Long.parseLong(String.valueOf(reqBO.get("shipVoucherId"))));
            if (UocConstant.payableType.ZB.equals(payableType2) && orderId == null && saleVoucherId == null) {
                List<OrdShipPayAblePO> orderList = this.orderWaranttyPayInfo();
                if (!CollectionUtils.isEmpty(orderList)) {
                    for (OrdShipPayAblePO payAblePO : orderList) {
                        this.validateAndPushPayInfo(reqBO, payAblePO.getOrderId(), payAblePO.getSaleVoucherId(), payableType2, payAblePO.getShipVoucherId());
                    }
                }
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            this.validateAndPushPayInfo(reqBO, orderId, saleVoucherId, payableType2, shipVoucherId);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8ba2\u5355\u652f\u4ed8\u914d\u7f6e\u6d88\u8d39\u5931\u8d25:{}", (Object)e.getMessage());
            this.saveLog(orderId, saleVoucherId, JSON.toJSONString((Object)reqBO), JSON.toJSONString((Object)("error--" + e.getMessage())), "\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u5931\u8d25", "8888");
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void pushRy(Long orderId) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(orderId);
        salePO = this.ordSaleMapper.getModelBy(salePO);
        PebBusiAddPayAbleReqBO pebBusiAddPayAbleReqBO = new PebBusiAddPayAbleReqBO();
        OrdStakeholderPO stakeholder = this.getStakeholder(orderId);
        OrderPO orderPO = this.getModelById(orderId);
        pebBusiAddPayAbleReqBO.setSource(salePO.getOrderSource());
        pebBusiAddPayAbleReqBO.setSupplierId(Long.valueOf(Long.parseLong(stakeholder.getSupNo())));
        pebBusiAddPayAbleReqBO.setOperatorId(Long.valueOf(Long.parseLong(stakeholder.getProNo())));
        pebBusiAddPayAbleReqBO.setPurchaseNo(stakeholder.getPurNo());
        pebBusiAddPayAbleReqBO.setPurchaseOrderCode(salePO.getSaleVoucherNo());
        pebBusiAddPayAbleReqBO.setPurchaseOrderName(orderPO.getOrderName());
        pebBusiAddPayAbleReqBO.setSource(salePO.getOrderSource());
        pebBusiAddPayAbleReqBO.setPayType(PAY_TYPE);
        pebBusiAddPayAbleReqBO.setPayableStatus(PAYABLE_STATUS);
        pebBusiAddPayAbleReqBO.setPayableType(Integer.valueOf(7));
        pebBusiAddPayAbleReqBO.setOrderId(orderId);
        OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
        ordExtMapPO.setFieldCode("busiMode");
        ordExtMapPO.setOrderId(orderId);
        ordExtMapPO.setObjId(orderId);
        ordExtMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        OrdExtMapPO extMapPO = this.ordExtMapMapper.getModelBy(ordExtMapPO);
        if (null != extMapPO) {
            pebBusiAddPayAbleReqBO.setBusiModel(Integer.valueOf(extMapPO.getFieldValue()));
        } else {
            pebBusiAddPayAbleReqBO.setBusiModel(Integer.valueOf(0));
        }
        try {
            pebBusiAddPayAbleReqBO.setPayableAmt(MoneyUtils.Long2BigDecimal((Long)salePO.getSaleFee()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean validate = this.validateParams(pebBusiAddPayAbleReqBO);
        if (!validate) {
            this.saveLog(orderId, salePO.getSaleVoucherId(), JSON.toJSONString((Object)pebBusiAddPayAbleReqBO), JSON.toJSONString((Object)pebBusiAddPayAbleReqBO), "\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u5931\u8d25", "7777");
            return;
        }
        log.info("\u8ba2\u5355\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u6d88\u5165\u53c2:{}" + JSON.toJSONString((Object)pebBusiAddPayAbleReqBO));
        PebBusiAddPayAbleRspBO pebBusiAddPayAbleRspBO = this.pebBusiAddPayAbleServiceBusiService.pushPayInfo(pebBusiAddPayAbleReqBO);
        log.info("\u8ba2\u5355\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u6d88\u51fa\u53c2:{}" + JSON.toJSONString((Object)pebBusiAddPayAbleRspBO));
        if (!"0000".equals(pebBusiAddPayAbleRspBO.getRespCode())) {
            this.saveLog(orderId, salePO.getSaleVoucherId(), JSON.toJSONString((Object)pebBusiAddPayAbleReqBO), JSON.toJSONString((Object)pebBusiAddPayAbleRspBO), "\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u5931\u8d25", pebBusiAddPayAbleRspBO.getResultCode());
        }
    }

    private void validateAndPushPayInfo(Map reqBO, Long orderId, Long saleVoucherId, Integer payableType2, Long shipVoucherId) {
        OrdPayConfPO ordPayConfPO = this.getPayAbleConfig(orderId);
        if (ordPayConfPO == null) {
            log.warn("\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u9519\u8bef\uff0c\u5bf9\u5e94\u652f\u4ed8\u914d\u7f6e\u4e0d\u5b58\u5728");
            return;
        }
        if (ordPayConfPO.getPrePaySup() != null && ordPayConfPO.getPrePaySup().compareTo(new BigDecimal(100)) == 0) {
            log.info("\u8ba2\u5355\u652f\u4ed8\u914d\u7f6e\u4e3a\u9996\u4ed8\u6b3e100%\u652f\u4ed8,\u65e0\u9700\u63a8\u9001");
            return;
        }
        if (UocConstant.payableType.ZB.equals(payableType2) && Integer.valueOf(1).equals(ordPayConfPO.getIsPushQua())) {
            log.warn("\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u9519\u8bef\uff0c\u8d28\u4fdd\u652f\u4ed8\u914d\u7f6e\u5df2\u63a8\u9001");
            return;
        }
        if (ordPayConfPO.getPayType() == null) {
            ordPayConfPO.setPayType(Integer.valueOf(2));
        }
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(orderId);
        List list = this.ordItemMapper.getList(itemPO);
        BigDecimal fee = BigDecimal.ZERO;
        for (OrdItemPO po : list) {
            if (po.getRefuseCount() != null) {
                fee = fee.add(po.getRefuseCount().multiply(new BigDecimal(po.getSalePrice())));
            }
            if (po.getReturnCount() == null) continue;
            fee = fee.add(po.getRefuseCount().multiply(new BigDecimal(po.getSalePrice())));
        }
        OrdSalePO ordSalePO = this.getSaleOrder(saleVoucherId);
        long saleFee = ordSalePO.getSaleFee() - fee.longValue();
        if (saleFee <= 0L) {
            log.info("\u8ba2\u5355\u9000\u8d27\u6b3e\u548c\u62d2\u6536\u6b3e\u5df2\u62b5\u6263,\u65e0\u9700\u63a8\u9001");
            return;
        }
        Map<Long, OrdItemPO> collect = list.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, o -> o));
        try {
            PebBusiAddPayAbleReqBO pebBusiAddPayAbleReqBO = new PebBusiAddPayAbleReqBO();
            BeanUtils.copyProperties((Object)ordPayConfPO, (Object)pebBusiAddPayAbleReqBO);
            if (("" + PebExtConstant.NOTIFY_ORDER_TYPE.ORDER_AGREEMENT).equals(ordSalePO.getOrderSource()) && "1".equals(String.valueOf(ordPayConfPO.getPayType())) && shipVoucherId != null && (saleFee = (fee = this.getShipFee(orderId, payableType2, shipVoucherId, collect, pebBusiAddPayAbleReqBO)).longValue()) <= 0L) {
                log.info("\u53d1\u8d27\u5355\u9000\u8d27\u6b3e\u548c\u62d2\u6536\u6b3e\u5df2\u62b5\u6263,\u65e0\u9700\u63a8\u9001");
                return;
            }
            OrdStakeholderPO stakeholder = this.getStakeholder(orderId);
            OrderPO orderPO = this.getModelById(orderId);
            pebBusiAddPayAbleReqBO.setSupplierId(Long.valueOf(Long.parseLong(stakeholder.getSupNo())));
            pebBusiAddPayAbleReqBO.setOperatorId(Long.valueOf(Long.parseLong(stakeholder.getProNo())));
            pebBusiAddPayAbleReqBO.setPurchaseNo(stakeholder.getPurNo());
            pebBusiAddPayAbleReqBO.setPurchaserId(stakeholder.getPurPlaceOrderId());
            UocProQueryContractSupplierInfoRspBO supplierInfoRspBO = this.getContractId(orderId, stakeholder);
            pebBusiAddPayAbleReqBO.setContractId(supplierInfoRspBO.getContractId());
            pebBusiAddPayAbleReqBO.setPurchaseOrderCode(ordSalePO.getSaleVoucherNo());
            pebBusiAddPayAbleReqBO.setPurchaseOrderName(orderPO.getOrderName());
            pebBusiAddPayAbleReqBO.setPayBusiType(String.valueOf(orderPO.getOrderType()));
            pebBusiAddPayAbleReqBO.setSource(ordSalePO.getOrderSource());
            pebBusiAddPayAbleReqBO.setPayType(PAY_TYPE);
            pebBusiAddPayAbleReqBO.setPayableStatus(PAYABLE_STATUS);
            pebBusiAddPayAbleReqBO.setPayableType(payableType2);
            if ("2".equals(String.valueOf(ordPayConfPO.getPayType()))) {
                pebBusiAddPayAbleReqBO.setPayableType(UocConstant.payableType.ZQ);
            }
            if (UocConstant.payableType.ZQ.equals(pebBusiAddPayAbleReqBO.getPayableType()) && (ordPayConfPO.getPaymentDays() == 0 || ordPayConfPO.getPaymentDays() == null)) {
                log.info("\u8d26\u671f\u5929\u6570\u4e0d\u5b58\u5728\u6216\u4e3a0\uff0c\u4e0d\u4e88\u63a8\u9001");
                return;
            }
            if (UocConstant.payableType.ZQ.equals(pebBusiAddPayAbleReqBO.getPayableType()) && "1".equals(this.getBusiMode(orderId))) {
                log.info("\u64ae\u5408\u6a21\u5f0f\u4e0b\u8d26\u671f\u652f\u4ed8\u7684\u5e94\u4ed8\u751f\u6210\u8282\u70b9\u4e3a\u5f00\u7968");
                return;
            }
            if (UocConstant.payableType.ZQ.equals(pebBusiAddPayAbleReqBO.getPayableType()) && this.getOrderCategory(orderId).booleanValue()) {
                log.info("\u5458\u5de5\u798f\u5229\u8ba2\u5355\u8d26\u671f\u652f\u4ed8\u7684\u5e94\u4ed8\u751f\u6210\u8282\u70b9\u4e3a\u53d1\u7968\u7b7e\u6536\u540e");
                return;
            }
            switch (payableType2) {
                case 2: 
                case 5: {
                    if (ordPayConfPO.getVerPaySup() == null || ordPayConfPO.getVerPaySup().compareTo(BigDecimal.ZERO) < 0) {
                        log.info("\u5230\u8d27\u6b3e\u4e3a0\uff0c\u65e0\u9700\u63a8\u9001");
                        return;
                    }
                    pebBusiAddPayAbleReqBO.setPayableAmt(MoneyUtils.Long2BigDecimal((Long)saleFee).multiply(ordPayConfPO.getVerPaySup()).divide(new BigDecimal(100), 2, 0));
                    break;
                }
                case 3: {
                    if (ordPayConfPO.getPilPaySup() == null || ordPayConfPO.getPilPaySup().compareTo(BigDecimal.ZERO) < 0) {
                        log.info("\u9a8c\u6536\u6b3e\u4e3a0\uff0c\u65e0\u9700\u63a8\u9001");
                        return;
                    }
                    pebBusiAddPayAbleReqBO.setPayableAmt(MoneyUtils.Long2BigDecimal((Long)saleFee).multiply(ordPayConfPO.getPilPaySup()).divide(new BigDecimal(100), 2, 0));
                    break;
                }
                case 4: {
                    if (ordPayConfPO.getQuaPaySup() == null || ordPayConfPO.getQuaPaySup().compareTo(BigDecimal.ZERO) < 0) {
                        log.info("\u8d28\u4fdd\u6b3e\u4e3a0\uff0c\u65e0\u9700\u63a8\u9001");
                        return;
                    }
                    pebBusiAddPayAbleReqBO.setPayableAmt(MoneyUtils.Long2BigDecimal((Long)saleFee).multiply(ordPayConfPO.getQuaPaySup()).divide(new BigDecimal(100), 2, 0));
                    break;
                }
            }
            boolean validate = this.validateParams(pebBusiAddPayAbleReqBO);
            if (!validate) {
                this.saveLog(orderId, saleVoucherId, JSON.toJSONString((Object)pebBusiAddPayAbleReqBO), JSON.toJSONString((Object)pebBusiAddPayAbleReqBO), "\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u5931\u8d25", "7777");
                return;
            }
            OrdPayConfPO ableConfig = this.getPayAbleConfig(orderId);
            if (ableConfig == null) {
                return;
            }
            Long used = 0L;
            if (ableConfig.getPrePayFee() == null) {
                ableConfig.setPrePayFee(Long.valueOf(0L));
            }
            used = used + ableConfig.getPrePayFee();
            if (ableConfig.getVerPayFee() == null) {
                ableConfig.setVerPayFee(Long.valueOf(0L));
            }
            used = used + ableConfig.getVerPayFee();
            if (ableConfig.getPilPayFee() == null) {
                ableConfig.setPilPayFee(Long.valueOf(0L));
            }
            used = used + ableConfig.getPilPayFee();
            if (ableConfig.getQuaPayFee() == null) {
                ableConfig.setQuaPayFee(Long.valueOf(0L));
            }
            used = used + ableConfig.getQuaPayFee();
            Long payableAmt = MoneyUtils.BigDecimal2Long((BigDecimal)pebBusiAddPayAbleReqBO.getPayableAmt());
            if (used + payableAmt > saleFee) {
                payableAmt = saleFee - payableAmt;
            }
            pebBusiAddPayAbleReqBO.setPayableAmt(MoneyUtils.Long2BigDecimal((Long)payableAmt));
            payableAmt = MoneyUtils.BigDecimal2Long((BigDecimal)pebBusiAddPayAbleReqBO.getPayableAmt());
            switch (payableType2) {
                case 2: 
                case 5: {
                    ableConfig.setVerPayFee(payableAmt);
                    break;
                }
                case 3: {
                    ableConfig.setPilPayFee(payableAmt);
                    break;
                }
                case 4: {
                    ableConfig.setQuaPayFee(payableAmt);
                    break;
                }
            }
            OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
            ordExtMapPO.setFieldCode("busiMode");
            ordExtMapPO.setOrderId(orderId);
            ordExtMapPO.setObjId(orderId);
            ordExtMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            OrdExtMapPO extMapPO = this.ordExtMapMapper.getModelBy(ordExtMapPO);
            if (null != extMapPO) {
                pebBusiAddPayAbleReqBO.setBusiModel(Integer.valueOf(extMapPO.getFieldValue()));
            } else {
                pebBusiAddPayAbleReqBO.setBusiModel(Integer.valueOf(0));
            }
            log.debug("\u5230\u8d27\u63a8\u9001\u5e94\u4ed8\u91d1\u989dsaleFee\uff1a{}", (Object)saleFee);
            log.debug("\u5230\u8d27\u63a8\u9001\u5e94\u4ed8\u91d1\u989dpayableAmt\uff1a{}", (Object)payableAmt);
            log.debug("\u5230\u8d27\u63a8\u9001\u5e94\u4ed8\u91d1\u989dpebBusiAddPayAbleReqBO\uff1a{}", (Object)pebBusiAddPayAbleReqBO.getPayableAmt());
            log.info("\u8ba2\u5355\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u6d88\u5165\u53c2:{}" + JSON.toJSONString((Object)pebBusiAddPayAbleReqBO));
            PebBusiAddPayAbleRspBO pebBusiAddPayAbleRspBO = this.pebBusiAddPayAbleServiceBusiService.pushPayInfo(pebBusiAddPayAbleReqBO);
            log.info("\u8ba2\u5355\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u6d88\u51fa\u53c2:{}" + JSON.toJSONString((Object)pebBusiAddPayAbleRspBO));
            this.saveLog(orderId, saleVoucherId, JSON.toJSONString((Object)pebBusiAddPayAbleReqBO), JSON.toJSONString((Object)pebBusiAddPayAbleRspBO), "\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u6210\u529f", pebBusiAddPayAbleRspBO.getResultCode());
            if ("0000".equals(pebBusiAddPayAbleRspBO.getRespCode())) {
                BeanUtils.copyProperties((Object)ableConfig, (Object)payableAmt);
                this.ordPayConfMapper.update(ableConfig);
            }
            if (UocConstant.payableType.ZB.equals(payableType2)) {
                OrdPayConfPO ord = new OrdPayConfPO();
                ord.setOrderId(orderId);
                ord.setIsPushQua(Integer.valueOf(1));
                ord.setId(ordPayConfPO.getId());
                this.ordPayConfMapper.update(ord);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u5931\u8d25" + e);
            this.saveLog(orderId, saleVoucherId, JSON.toJSONString((Object)reqBO), JSON.toJSONString((Object)("error--" + e.getMessage())), "\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u5931\u8d25", "8888");
        }
    }

    private BigDecimal getShipFee(Long orderId, Integer payableType2, Long shipVoucherId, Map<Long, OrdItemPO> collect, PebBusiAddPayAbleReqBO pebBusiAddPayAbleReqBO) {
        OrdShipPO ordShipPO = new OrdShipPO();
        ordShipPO.setShipVoucherId(shipVoucherId);
        ordShipPO.setOrderId(orderId);
        OrdShipPO shipPO = this.ordShipMapper.getModelBy(ordShipPO);
        pebBusiAddPayAbleReqBO.setShipVoucherCode(shipPO.getShipVoucherCode());
        OrdShipItemPO shipItemPO = new OrdShipItemPO();
        shipItemPO.setOrderId(orderId);
        shipItemPO.setShipVoucherId(shipVoucherId);
        List shipItemList = this.ordShipItemMapper.getList(shipItemPO);
        BigDecimal fee = BigDecimal.ZERO;
        log.info("\u534f\u8bae\u5355\u5e94\u4ed8\u63a8\u9001collect\uff1a{}", (Object)JSONObject.toJSONString(collect));
        log.info("\u534f\u8bae\u5355\u5e94\u4ed8\u63a8\u9001shipItemList\uff1a{}", (Object)JSONObject.toJSONString((Object)shipItemList));
        for (OrdShipItemPO ordShipItemPO : shipItemList) {
            Long salePrice = collect.get(ordShipItemPO.getOrdItemId()).getSalePrice();
            if (UocConstant.payableType.DH.equals(payableType2)) {
                fee = fee.add(ordShipItemPO.getArriveCount().multiply(new BigDecimal(salePrice)));
            } else if (UocConstant.payableType.YS.equals(payableType2) || UocConstant.payableType.ZB.equals(payableType2)) {
                fee = fee.add(ordShipItemPO.getAcceptanceCount().multiply(new BigDecimal(salePrice)));
            }
            if (ordShipItemPO.getRefuseCount() != null) {
                fee = fee.subtract(ordShipItemPO.getRefuseCount().multiply(new BigDecimal(salePrice)));
            }
            if (ordShipItemPO.getReturnCount() == null) continue;
            fee = fee.subtract(ordShipItemPO.getRefuseCount().multiply(new BigDecimal(salePrice)));
        }
        return fee;
    }

    private List<OrdShipPayAblePO> orderWaranttyPayInfo() {
        List list = this.ordPayConfMapper.getWaranttyUnpushOrder();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList<OrdShipPayAblePO> returnList = new ArrayList<OrdShipPayAblePO>();
        for (OrdPayConfPO confPO : list) {
            Date date = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, -confPO.getWarantty().intValue());
            confPO.setTime(calendar.getTime());
            OrdShipPayAblePO salePO = this.ordPayConfMapper.getWart(confPO);
            OrdShipPayAblePO saleForShipPO = this.ordPayConfMapper.getShipWart(confPO);
            if (salePO != null && salePO.getOrderId() != null) {
                returnList.add(salePO);
            }
            if (saleForShipPO == null || saleForShipPO.getOrderId() == null) continue;
            returnList.add(saleForShipPO);
        }
        return returnList;
    }

    private void saveLog(Long orderId, Long saleId, String in, String out, String code, String errCode) {
        if (StringUtils.isBlank((CharSequence)out)) {
            out = "out";
        }
        if (StringUtils.isBlank((CharSequence)in)) {
            in = "in";
        }
        int max = 3096;
        if (out.length() > max) {
            out = out.substring(0, max - 1);
        }
        if (in.length() > max) {
            in = in.substring(0, max - 1);
        }
        OrdInterLogBO logBO = new OrdInterLogBO();
        logBO.setCallCount(Integer.valueOf(1));
        logBO.setCallState("1");
        logBO.setCallTime(new Date());
        logBO.setCreateLoginId("1");
        logBO.setErrCode(errCode);
        logBO.setErrDetail("1");
        logBO.setFlowFlag(Integer.valueOf(1));
        logBO.setInContent(in);
        logBO.setInterCode(code);
        logBO.setInterSn("1");
        logBO.setOutContent(out);
        logBO.setRetTime(new Date());
        logBO.setOrderId(orderId);
        logBO.setObjId(saleId);
        logBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        PebExtFieldInReqBO reqBO = new PebExtFieldInReqBO();
        reqBO.setLog(logBO);
        try {
            this.pebExtFieldInBusiService.dealSaveLog(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private OrdPayConfPO getPayAbleConfig(Long orderId) {
        OrdPayConfPO ordPayConfPO = new OrdPayConfPO();
        ordPayConfPO.setOrderId(orderId);
        List list = this.ordPayConfMapper.selectByCondition(ordPayConfPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (OrdPayConfPO)list.get(0);
    }

    private OrdSalePO getSaleOrder(Long saleVoucherId) {
        OrdSalePO salePO = this.ordSaleMapper.getModelById(saleVoucherId.longValue());
        return salePO == null ? new OrdSalePO() : salePO;
    }

    private boolean validateParams(PebBusiAddPayAbleReqBO reqBO) {
        if (null == reqBO) {
            log.error("\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u53c2\u6570\u9519\u8bef\uff0c\u5165\u53c2\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSource())) {
            log.error("\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u53c2\u6570\u9519\u8bef\uff0c\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (null == reqBO.getOrderId()) {
            log.error("\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u53c2\u6570\u9519\u8bef\uff0c\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (null == reqBO.getPayType()) {
            log.error("\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u53c2\u6570\u9519\u8bef\uff0c\u4ed8\u6b3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (null == reqBO.getPurchaserId()) {
            log.error("\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u53c2\u6570\u9519\u8bef\uff0c\u4e0b\u5355\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (null == reqBO.getPayableType()) {
            log.error("\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u53c2\u6570\u9519\u8bef\uff0c\u5e94\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        return true;
    }

    private OrdStakeholderPO getStakeholder(Long orderId) {
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(orderId.longValue());
        return stakeholderPO == null ? new OrdStakeholderPO() : stakeholderPO;
    }

    private OrderPO getModelById(Long orderId) {
        OrderPO orderPO = this.orderMapper.getModelById(orderId.longValue());
        return orderPO == null ? new OrderPO() : orderPO;
    }

    private UocProQueryContractSupplierInfoRspBO getContractId(Long orderId, OrdStakeholderPO getStakeholder) {
        OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
        ordExtMapPO.setFieldCode("contractType");
        ordExtMapPO.setOrderId(orderId);
        ordExtMapPO.setObjId(orderId);
        ordExtMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        ordExtMapPO = this.ordExtMapMapper.getModelBy(ordExtMapPO);
        if (ordExtMapPO == null || StringUtils.isEmpty((CharSequence)ordExtMapPO.getFieldValue())) {
            return new UocProQueryContractSupplierInfoRspBO();
        }
        UocProQueryContractSupplierInfoReqBO infoReqBO = new UocProQueryContractSupplierInfoReqBO();
        if (StringUtils.isNotBlank((CharSequence)getStakeholder.getExtField3())) {
            infoReqBO.setContractId(Long.valueOf(getStakeholder.getExtField3()));
        } else {
            infoReqBO.setEnterPurchaserId(Long.valueOf(getStakeholder.getSupNo()));
            infoReqBO.setCategoryType(Integer.valueOf(ordExtMapPO.getFieldValue()));
        }
        UocProQueryContractSupplierInfoRspBO contractRspBO = this.pebIntfQueryContractSupplierService.queryContratSupplierByEnterPurchaserId(infoReqBO);
        return contractRspBO == null ? new UocProQueryContractSupplierInfoRspBO() : contractRspBO;
    }

    private String getBusiMode(Long orderId) {
        OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
        ordExtMapPO.setFieldCode("busiMode");
        ordExtMapPO.setOrderId(orderId);
        ordExtMapPO.setObjId(orderId);
        ordExtMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        ordExtMapPO = this.ordExtMapMapper.getModelBy(ordExtMapPO);
        return ordExtMapPO == null ? null : String.valueOf(ordExtMapPO.getFieldValue());
    }

    private Boolean getOrderCategory(Long orderId) {
        OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
        ordExtMapPO.setFieldCode("orderCategory");
        ordExtMapPO.setOrderId(orderId);
        ordExtMapPO.setObjId(orderId);
        ordExtMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        ordExtMapPO = this.ordExtMapMapper.getModelBy(ordExtMapPO);
        return ordExtMapPO != null && "1".equals(ordExtMapPO.getFieldValue());
    }
}

