/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.order.extend.aop.OrderLogRecord;
import com.tydic.order.extend.bo.saleorder.PebExtSerPriceReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtSerPriceRspBO;
import com.tydic.order.extend.comb.plan.PebReverseCombService;
import com.tydic.order.extend.comb.saleorder.PebExtSerPriceCombService;
import com.tydic.order.pec.bo.sale.UocSyncStatisticsInfoCombReqBO;
import com.tydic.order.pec.busi.es.order.bo.UocReverseReqBO;
import com.tydic.order.pec.comb.sale.UocSyncStatisticsInfoCombService;
import com.tydic.order.third.intf.ability.esb.ecp.PebIntfCancelPurchaseOrderAbilityService;
import com.tydic.order.third.intf.bo.esb.ecp.PebIntfCancelPurchaseOrderAbilityReqBo;
import com.tydic.order.third.intf.bo.esb.ecp.PebIntfCancelPurchaseOrderAbilityRspBo;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.uoc.base.bo.UocProBaseRspBo;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class PebReverseConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(PebReverseConsumer.class);
    @Autowired
    private PebReverseCombService pebReverseCombService;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private PebIntfCancelPurchaseOrderAbilityService pebIntfCancelPurchaseOrderAbilityService;
    @Autowired
    private PebExtSerPriceCombService pebExtSerPriceCombService;
    @Autowired
    private UocSyncStatisticsInfoCombService uocSyncStatisticsInfoCombService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        try {
            UocReverseReqBO reqBO;
            if (log.isDebugEnabled()) {
                log.debug("\u8ba2\u5355\u53d6\u6d88\uff0c\u552e\u540e\uff0c\u5f02\u5e38\u53d8\u66f4");
            }
            if ((reqBO = (UocReverseReqBO)JSON.parseObject((String)proxyMessage.getContent(), UocReverseReqBO.class)).getSerPrice() != null && reqBO.getSerPrice().booleanValue()) {
                this.serPrice(reqBO.getOrderId());
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            log.info("\u8ba2\u5355\u9006\u5411\u6d88\u8d39" + JSON.toJSONString((Object)reqBO));
            UocProBaseRspBo rspBO = this.pebReverseCombService.reverse(reqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                return ProxyConsumerStatus.RECONSUME_LATER;
            }
            if (!reqBO.getObjType().equals(UocCoreConstant.OBJ_TYPE.SALE)) {
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            Object ecp = new OrdExtMapPO();
            ecp.setFieldCode("isSuccess");
            ecp.setOrderId(reqBO.getOrderId());
            ecp.setObjId(reqBO.getOrderId());
            ecp.setObjType(UocCoreConstant.OBJ_TYPE.ORDER);
            List ordExtMapPOS = this.ordExtMapMapper.getList(ecp);
            ecp = !CollectionUtils.isEmpty((Collection)ordExtMapPOS) ? (OrdExtMapPO)ordExtMapPOS.get(0) : null;
            if (UocCoreConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType())) {
                UocSyncStatisticsInfoCombReqBO syncStatisticsInfoCombReqBO = new UocSyncStatisticsInfoCombReqBO();
                syncStatisticsInfoCombReqBO.setOrderId(reqBO.getOrderId());
                syncStatisticsInfoCombReqBO.setSaleVoucherId(reqBO.getObjId());
                syncStatisticsInfoCombReqBO.setIsLess(Boolean.valueOf(true));
                this.uocSyncStatisticsInfoCombService.syncStatisticsInfo(syncStatisticsInfoCombReqBO);
            }
            if (ecp == null) {
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            this.pushEcp(reqBO);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }

    @OrderLogRecord(description="\u65b0\u589e")
    private UocProBaseRspBo serPrice(Long orderId) {
        PebExtSerPriceRspBO rspBO3;
        PebExtSerPriceRspBO rspBO2;
        PebExtSerPriceReqBO reqBO = new PebExtSerPriceReqBO();
        reqBO.setPush(Boolean.valueOf(true));
        reqBO.setOrderId(orderId);
        PebExtSerPriceRspBO rspBO = this.pebExtSerPriceCombService.serPrice(reqBO);
        if (!("0000".equals(rspBO.getRespCode()) || "0000".equals((rspBO2 = this.pebExtSerPriceCombService.serPrice(reqBO)).getRespCode()) || "0000".equals((rspBO3 = this.pebExtSerPriceCombService.serPrice(reqBO)).getRespCode()))) {
            UocProBaseRspBo rspInfoBO = new UocProBaseRspBo();
            rspInfoBO.setRespDesc("\u8d85\u5e02\u8ba2\u5355\u521b\u5efa\u5931\u8d25,\u8c03\u7528\u7ed3\u7b97\u4e2d\u5fc3\u4fdd\u5b58\u6210\u4ea4\u670d\u52a1\u8d39\u5931\u8d25!" + rspBO3.getRespDesc());
            rspInfoBO.setRespCode("8888");
            return rspInfoBO;
        }
        UocProBaseRspBo rspInfoBO = new UocProBaseRspBo();
        rspInfoBO.setRespCode("0000");
        rspInfoBO.setRespDesc("\u8d85\u5e02\u4fdd\u5b58\u6210\u4ea4\u670d\u52a1\u8d39\u6210\u529f");
        return rspInfoBO;
    }

    private void pushEcp(UocReverseReqBO reqBO) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        PebIntfCancelPurchaseOrderAbilityReqBo reqBo = new PebIntfCancelPurchaseOrderAbilityReqBo();
        reqBo.setXTBS("DZSC");
        reqBo.setJKBS("DZSC_DDJK");
        reqBo.setYWBH(ordSalePO.getSaleVoucherNo());
        reqBo.setCZBS("ZZ");
        PebIntfCancelPurchaseOrderAbilityRspBo rspBo = this.pebIntfCancelPurchaseOrderAbilityService.cancelPurchaseOrder(reqBo);
        if (!"0000".equals(rspBo.getRespCode())) {
            // empty if block
        }
    }
}

