/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.atom.impl.es.others;

import com.tydic.order.pec.atom.es.others.CreateSalesOrderCodeAtomService;
import com.tydic.order.pec.atom.es.others.SequenceAtomService;
import com.tydic.order.pec.atom.es.others.bo.GenerateSalesOrderCodeSeqRspBO;
import com.tydic.order.pec.atom.impl.es.others.GenerateSaleOrderCode;
import com.tydic.uoc.base.exception.UocProBusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CreateSalesOrderCodeAtomServiceImpl
implements CreateSalesOrderCodeAtomService {
    private static final Logger log = LoggerFactory.getLogger(CreateSalesOrderCodeAtomServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private SequenceAtomService sequenceAtomService;

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={UocProBusinessException.class})
    public GenerateSalesOrderCodeSeqRspBO createSalesOrderCode() {
        if (this.isDebugEnabled) {
            log.debug("\u9500\u552e\u8ba2\u5355code\u751f\u6210");
        }
        GenerateSalesOrderCodeSeqRspBO generateSalesOrderCodeSeq = new GenerateSalesOrderCodeSeqRspBO();
        try {
            Long seqId = this.sequenceAtomService.getSequenceId("SEQ_SALE_ORDER_CODE_SN");
            String saleOrderCode = GenerateSaleOrderCode.getSaleOrderCode(seqId);
            if (this.isDebugEnabled) {
                log.debug("\u9500\u552e\u8ba2\u5355code\u751f\u6210\u51fa\u53c2\uff1a" + saleOrderCode);
            }
            generateSalesOrderCodeSeq.setSaleOrderCode(saleOrderCode);
            return generateSalesOrderCodeSeq;
        }
        catch (Exception e) {
            log.error("\u9500\u552e\u8ba2\u5355code\u751f\u6210\u51fa\u53c2:" + e);
            throw new UocProBusinessException("8888", "\u9500\u552e\u8ba2\u5355code\u751f\u6210\u51fa\u9519");
        }
    }
}

