/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.el.order;

import com.tydic.order.pec.atom.el.other.UocPebSendMsgAtomService;
import com.tydic.order.pec.atom.el.other.bo.UocPebSendMsgReqBO;
import com.tydic.order.pec.atom.el.other.bo.UocPebSendMsgRspBO;
import com.tydic.order.pec.bo.el.order.UocPebAccessoryBO;
import com.tydic.order.pec.busi.el.order.UocPebEaCancelOrderBusiService;
import com.tydic.order.pec.busi.el.order.bo.UocPebEaCancelOrderReqBO;
import com.tydic.order.pec.busi.el.order.bo.UocPebEaCancelOrderRspBO;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.uoc.atom.order.UocCoreCancelOrderAtomService;
import com.tydic.order.uoc.atom.other.UocCoreCreateAccessoryAtomService;
import com.tydic.order.uoc.bo.order.UocCoreCancelOrderReqBO;
import com.tydic.order.uoc.bo.order.UocCoreCancelOrderRspBO;
import com.tydic.order.uoc.bo.other.UocCoreCreateAccessoryReqBO;
import com.tydic.order.uoc.bo.other.UocCoreCreateAccessoryRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="uocPebEaCancelOrderBusiService")
public class UocPebEaCancelOrderBusiServiceImpl
implements UocPebEaCancelOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPebEaCancelOrderBusiServiceImpl.class);
    @Autowired
    OrdExtMapMapper ordExtMapMapper;
    @Autowired
    OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    OrdSaleMapper ordSaleMapper;
    @Autowired
    UocCoreCreateAccessoryAtomService uocCoreCreateAccessoryAtomService;
    @Autowired
    UocCoreCancelOrderAtomService uocCoreCancelOrderAtomService;
    @Autowired
    UocPebSendMsgAtomService uocPebSendMsgAtomService;

    public UocPebEaCancelOrderRspBO executeCancelOrder(UocPebEaCancelOrderReqBO reqBO) {
        this.validateArg(reqBO);
        UocPebEaCancelOrderRspBO rspBO = new UocPebEaCancelOrderRspBO();
        OrdSalePO ordSalePO = new OrdSalePO();
        try {
            ordSalePO.setSaleVoucherId(reqBO.getSaleVoucherId());
            ordSalePO.setOrderId(reqBO.getOrderId());
            ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
            if (ordSalePO == null) {
                throw new UocProBusinessException("8888", "\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u5931\u8d25");
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u6355\u6349\u5230\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e);
            }
            throw new UocProBusinessException("8888", "\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
        }
        this.createAccessory(reqBO);
        this.cancelOrder(reqBO);
        this.sendMsg(reqBO, ordSalePO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateArg(UocPebEaCancelOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("7777", "\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("7777", "\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSaleVoucherId() == null) {
            throw new UocProBusinessException("7777", "\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027saleVoucherId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getUocPebAccessoryBOList())) {
            for (UocPebAccessoryBO accessoryBO : reqBO.getUocPebAccessoryBOList()) {
                if (accessoryBO.getAccessoryId() == null) {
                    throw new UocProBusinessException("7777", "\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u9644\u4ef6\u5217\u8868\u4e2daccessoryId\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)accessoryBO.getAccessoryName())) {
                    throw new UocProBusinessException("7777", "\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u9644\u4ef6\u5217\u8868\u4e2daccessoryName\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.isBlank((CharSequence)accessoryBO.getAccessoryUrl())) continue;
                throw new UocProBusinessException("7777", "\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u9644\u4ef6\u5217\u8868\u4e2daccessoryUrl\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void createAccessory(UocPebEaCancelOrderReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getUocPebAccessoryBOList())) {
            for (UocPebAccessoryBO accessoryBO : reqBO.getUocPebAccessoryBOList()) {
                UocCoreCreateAccessoryReqBO createAccessoryReqBO = new UocCoreCreateAccessoryReqBO();
                createAccessoryReqBO.setOrderId(reqBO.getOrderId());
                createAccessoryReqBO.setObjectId(reqBO.getSaleVoucherId());
                createAccessoryReqBO.setObjectType(UocConstant.OBJ_TYPE.SALE);
                createAccessoryReqBO.setAccessoryId(accessoryBO.getAccessoryId());
                createAccessoryReqBO.setAccessoryName(accessoryBO.getAccessoryName());
                createAccessoryReqBO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
                createAccessoryReqBO.setAttachmentType(accessoryBO.getAttachmentType());
                UocCoreCreateAccessoryRspBO createAccessoryRspBO = this.uocCoreCreateAccessoryAtomService.createAccessory(createAccessoryReqBO);
                if ("0000".equals(createAccessoryRspBO.getRespCode())) continue;
                if (log.isDebugEnabled()) {
                    log.debug("\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u6838\u5fc3\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u52a1\u5f02\u5e38,\u5f02\u5e38\u63cf\u8ff0\uff1a" + createAccessoryRspBO.getRespDesc());
                }
                throw new UocProBusinessException("8888", "\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u6838\u5fc3\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u52a1\u5f02\u5e38,\u5f02\u5e38\u63cf\u8ff0\uff1a" + createAccessoryRspBO.getRespDesc());
            }
        }
    }

    private void cancelOrder(UocPebEaCancelOrderReqBO reqBO) {
        UocCoreCancelOrderReqBO cancelOrderReqBO = new UocCoreCancelOrderReqBO();
        cancelOrderReqBO.setOrderId(reqBO.getOrderId());
        cancelOrderReqBO.setCancelOperId(reqBO.getUserId() + "");
        cancelOrderReqBO.setCancelReason(reqBO.getCancelReason());
        cancelOrderReqBO.setCancelRemark(reqBO.getCancelDesc());
        UocCoreCancelOrderRspBO cancelOrderRspBO = this.uocCoreCancelOrderAtomService.dealCoreCancelOrder(cancelOrderReqBO);
        if (!"0000".equals(cancelOrderRspBO.getRespCode())) {
            if (log.isDebugEnabled()) {
                log.debug("\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u5f02\u5e38,\u5f02\u5e38\u63cf\u8ff0\uff1a" + cancelOrderRspBO.getRespDesc());
            }
            throw new UocProBusinessException("8888", "\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u6838\u5fc3\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u5f02\u5e38,\u5f02\u5e38\u63cf\u8ff0\uff1a" + cancelOrderRspBO.getRespDesc());
        }
    }

    private void sendMsg(UocPebEaCancelOrderReqBO reqBO, OrdSalePO ordSalePO) {
        OrdStakeholderPO stakeholderPO = new OrdStakeholderPO();
        OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
        try {
            stakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
            if (stakeholderPO == null) {
                if (log.isDebugEnabled()) {
                    log.debug("\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\uff0c\u67e5\u8be2\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25");
                }
                throw new UocProBusinessException("8888", "\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\uff0c\u67e5\u8be2\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25");
            }
            ordExtMapPO.setOrderId(reqBO.getOrderId());
            ordExtMapPO.setFieldCode("saleVoucherName");
            ordExtMapPO = this.ordExtMapMapper.getModelBy(ordExtMapPO);
            if (ordExtMapPO == null) {
                if (log.isDebugEnabled()) {
                    log.debug("\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\uff0c\u67e5\u8be2\u8ba2\u5355\u540d\u79f0\u5931\u8d25");
                }
                throw new UocProBusinessException("8888", "\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\uff0c\u67e5\u8be2\u8ba2\u5355\u540d\u79f0\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UocPebSendMsgReqBO sendMsgReqBO = new UocPebSendMsgReqBO();
        sendMsgReqBO.setOrderId(reqBO.getOrderId());
        ArrayList<String> sendTypes = new ArrayList<String>();
        sendTypes.add("3");
        sendMsgReqBO.setSendTypes(sendTypes);
        sendMsgReqBO.setTemplateId(PecConstant.MSG_TEMPLATE_ID.SEND_ORDER_REFUSE_DISPATCH_YES_JHCGY);
        ArrayList<Long> receivers = new ArrayList<Long>();
        if (stakeholderPO.getPurPlaceOrderId() == null) {
            if (log.isDebugEnabled()) {
                log.debug(reqBO.getOrderId() + "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u91c7\u8d2d\u5355\u4f4d\u4e0b\u5355\u4eba\u7f16\u53f7");
            }
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u91c7\u8d2d\u5355\u4f4d\u4e0b\u5355\u4eba\u7f16\u53f7");
        }
        receivers.add(Long.valueOf(stakeholderPO.getPurPlaceOrderId()));
        sendMsgReqBO.setReceiveList(receivers);
        HashMap<String, String> smsParam = new HashMap<String, String>(8);
        smsParam.put("orderId", ordSalePO.getSaleVoucherNo());
        smsParam.put("orderName", ordExtMapPO.getFieldValue());
        sendMsgReqBO.setTemplateParam(smsParam);
        sendMsgReqBO.setRemindConfigureId(sendMsgReqBO.getTemplateId());
        sendMsgReqBO.setUserId(reqBO.getUserId() + "");
        UocPebSendMsgRspBO sendMsgRspBO = this.uocPebSendMsgAtomService.dealSendMsg(sendMsgReqBO);
        if (!"0000".equals(sendMsgRspBO.getRespCode())) {
            if (log.isDebugEnabled()) {
                log.debug("\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4e13\u533a\u8ba2\u5355\u63d0\u9192\u539f\u5b50\u670d\u52a1\u5f02\u5e38,\u5f02\u5e38\u63cf\u8ff0\uff1a" + sendMsgRspBO.getRespDesc());
            }
            throw new UocProBusinessException("8888", "\u4e13\u533a\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4e13\u533a\u8ba2\u5355\u63d0\u9192\u539f\u5b50\u670d\u52a1\u5f02\u5e38,\u5f02\u5e38\u63cf\u8ff0\uff1a" + sendMsgRspBO.getRespDesc());
        }
    }
}

