/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.el.order;

import com.tydic.order.pec.atom.el.authority.PebOperationPermissionsCheckingAtomService;
import com.tydic.order.pec.atom.el.authority.bo.PebOperationPermissionsCheckingAtomReqBO;
import com.tydic.order.pec.atom.el.authority.bo.PebOperationPermissionsCheckingAtomRspBO;
import com.tydic.order.pec.bo.el.order.UocPebAccessoryBO;
import com.tydic.order.pec.busi.el.order.UocProPurchaseArriveConfirmRejectBusiService;
import com.tydic.order.pec.comb.el.order.bo.UocProPurchaseArriveConfirmRejectCombReqBo;
import com.tydic.order.pec.comb.el.order.bo.UocProPurchaseArriveConfirmRejectCombRspBo;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.uoc.atom.afterservice.UocCoreArriveRegistAtomService;
import com.tydic.order.uoc.atom.order.UocCoreStateCheckAtomService;
import com.tydic.order.uoc.atom.other.UocCoreCreateAccessoryAtomService;
import com.tydic.order.uoc.atom.process.UocRunProcessAtomService;
import com.tydic.order.uoc.bo.afterservice.ArriveInfoBO;
import com.tydic.order.uoc.bo.afterservice.UocCoreArriveRegistReqBO;
import com.tydic.order.uoc.bo.afterservice.UocCoreArriveRegistRspBO;
import com.tydic.order.uoc.bo.order.UocCoreStateCheckAtomReqBO;
import com.tydic.order.uoc.bo.order.UocCoreStateCheckAtomRspBO;
import com.tydic.order.uoc.bo.other.UocCoreCreateAccessoryReqBO;
import com.tydic.order.uoc.bo.other.UocCoreCreateAccessoryRspBO;
import com.tydic.order.uoc.bo.process.UocProcessRunReqBO;
import com.tydic.order.uoc.bo.process.UocProcessRunRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdItemMapper;
import com.tydic.order.uoc.dao.OrdShipItemMapper;
import com.tydic.order.uoc.dao.OrdShipMapper;
import com.tydic.order.uoc.dao.po.OrdItemPO;
import com.tydic.order.uoc.dao.po.OrdShipItemPO;
import com.tydic.order.uoc.dao.po.OrdShipPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocProPurchaseArriveConfirmRejectBusiServiceImpl
implements UocProPurchaseArriveConfirmRejectBusiService {
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private PebOperationPermissionsCheckingAtomService pebOperationPermissionsCheckingAtomService;
    @Autowired
    private UocCoreCreateAccessoryAtomService uocCoreCreateAccessoryAtomService;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private UocCoreArriveRegistAtomService uocCoreArriveRegistAtomService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdItemMapper ordItemMapper;

    public UocProPurchaseArriveConfirmRejectCombRspBo dealConfirmReject(UocProPurchaseArriveConfirmRejectCombReqBo reqBo) {
        UocProPurchaseArriveConfirmRejectCombRspBo rspBo = (UocProPurchaseArriveConfirmRejectCombRspBo)UocProRspBoUtil.success(UocProPurchaseArriveConfirmRejectCombRspBo.class);
        this.doStateCheck(reqBo);
        this.checkAuthority(reqBo);
        this.arriveConfirm(reqBo);
        rspBo.setShipVoucherIds(reqBo.getShipVoucherIds());
        return rspBo;
    }

    private void arriveConfirm(UocProPurchaseArriveConfirmRejectCombReqBo reqBo) {
        Long orderId = reqBo.getOrderId();
        Long saleVourcherId = reqBo.getSaleVourcherId();
        boolean confirm = reqBo.isConfirm();
        for (Long shipVoucherId : reqBo.getShipVoucherIds()) {
            OrdShipPO qryShipPo = new OrdShipPO();
            qryShipPo.setOrderId(orderId);
            qryShipPo.setSaleVoucherId(saleVourcherId);
            qryShipPo.setShipVoucherId(shipVoucherId);
            OrdShipPO shipRspBo = this.ordShipMapper.getModelBy(qryShipPo);
            if (shipRspBo == null) {
                throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u5230\u8be5\u53d1\u8d27\u5355\u4fe1\u606f\uff1a" + shipVoucherId);
            }
            if (!"2204".equals(shipRspBo.getShipStatus())) {
                throw new UocProBusinessException("0100", "\u8be5\u53d1\u8d27\u5355(" + shipRspBo.getShipVoucherCode() + ")\u8fd8\u672a\u5230\u8d27\u767b\u8bb0\u6216\u5df2\u767b\u8bb0\u8fc7\u4e86!");
            }
            ArrayList<ArriveInfoBO> arriveInfoList = new ArrayList<ArriveInfoBO>();
            OrdShipItemPO shipItemPo = new OrdShipItemPO();
            shipItemPo.setShipVoucherId(shipVoucherId);
            shipItemPo.setOrderId(orderId);
            List shipItemPoS = this.ordShipItemMapper.getList(shipItemPo);
            if (CollectionUtils.isEmpty((Collection)shipItemPoS)) {
                throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u5230\u8be5\u53d1\u8d27\u5355\u660e\u7ec6\u4fe1\u606f\uff1a" + shipVoucherId);
            }
            String arriveFlag = "1";
            if (!confirm) {
                for (OrdShipItemPO ordShipItemPo : shipItemPoS) {
                    ArriveInfoBO arriveInfoBO = new ArriveInfoBO();
                    arriveInfoBO.setShipItemId(ordShipItemPo.getShipItemId());
                    arriveInfoBO.setArriveCount(ordShipItemPo.getSendCount().negate());
                    arriveInfoBO.setRejectCount(ordShipItemPo.getSendCount());
                    arriveInfoList.add(arriveInfoBO);
                }
                this.doCallCoreArrivalAtom(reqBo, shipVoucherId, arriveInfoList);
                arriveFlag = "0";
            }
            this.doUpdateShipArriveTime(orderId, shipVoucherId, reqBo);
            this.doCreateAccessory(reqBo, shipVoucherId);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("arriveFlag", arriveFlag);
            this.run(reqBo, UocConstant.OBJ_TYPE.SHIP, shipVoucherId, map);
        }
        if (this.judgeIsAllReceive(orderId)) {
            this.executeUpdateSaleOrdState(orderId, saleVourcherId);
        }
    }

    private boolean judgeIsAllReceive(Long orderId) {
        try {
            OrdItemPO ordItemModel = new OrdItemPO();
            ordItemModel.setOrderId(orderId);
            List ordItemPoList = this.ordItemMapper.getList(ordItemModel);
            if (ordItemPoList == null || ordItemPoList.isEmpty()) {
                throw new UocProBusinessException("8888", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u4e3a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f!");
            }
            BigDecimal totalPurchaseCount = new BigDecimal(0);
            BigDecimal totalArriveCount = new BigDecimal(0);
            for (OrdItemPO ordItemPo : ordItemPoList) {
                totalPurchaseCount = totalPurchaseCount.add(ordItemPo.getPurchaseCount());
                BigDecimal arriveCount = ordItemPo.getArriveCount().add(ordItemPo.getRefuseCount());
                totalArriveCount = totalArriveCount.add(arriveCount);
            }
            return totalArriveCount.equals(totalPurchaseCount);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38!");
        }
    }

    private void executeUpdateSaleOrdState(Long orderId, Long saleVoucherId) {
        OrdShipPO ordShipModel = new OrdShipPO();
        ordShipModel.setOrderId(orderId);
        List ordShipPoList = this.ordShipMapper.getList(ordShipModel);
        for (Object ordShipPo : ordShipPoList) {
            if (!"2204".equals(ordShipPo.getShipStatus())) continue;
            return;
        }
        int isAllReceived = 0;
        for (OrdShipPO ordShipPo : ordShipPoList) {
            if (!"2206".equals(ordShipPo.getShipStatus())) continue;
            ++isAllReceived;
        }
        Integer rejectFlag = null;
        rejectFlag = isAllReceived == 0 ? PecConstant.SHIP_RECEIVED_STATE.ALL_RECEIVED : (isAllReceived == ordShipPoList.size() ? PecConstant.SHIP_RECEIVED_STATE.ALL_REFUSEDR : PecConstant.SHIP_RECEIVED_STATE.PART_RECEIVED);
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(saleVoucherId);
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(orderId);
        processRunReqBO.setOperId("0");
        HashMap<String, Integer> map = new HashMap<String, Integer>(1);
        processRunReqBO.setVariables(map);
        map.put("rejectFlag", rejectFlag);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u901a\u8fc7\u5165\u53c2\uff1a" + processRunReqBO.toString() + "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private void run(UocProPurchaseArriveConfirmRejectCombReqBo reqBO, Integer objType, Long objId, Map<String, Object> map) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(objId);
        processRunReqBO.setObjType(objType);
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setOperId(String.valueOf(reqBO.getMemId()));
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private void doCreateAccessory(UocProPurchaseArriveConfirmRejectCombReqBo reqBO, Long shipVoucherId) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            for (UocPebAccessoryBO accessoryBO : reqBO.getAccessoryList()) {
                UocCoreCreateAccessoryReqBO createAccessoryReqBO = new UocCoreCreateAccessoryReqBO();
                createAccessoryReqBO.setAccessoryId(accessoryBO.getAccessoryId());
                createAccessoryReqBO.setAccessoryName(accessoryBO.getAccessoryName());
                createAccessoryReqBO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
                createAccessoryReqBO.setAttachmentType(accessoryBO.getAttachmentType());
                createAccessoryReqBO.setOrderId(reqBO.getOrderId());
                createAccessoryReqBO.setObjectId(shipVoucherId);
                createAccessoryReqBO.setObjectType(UocCoreConstant.OBJ_TYPE.SHIP);
                createAccessoryReqBO.setRemark(reqBO.getActionCode());
                UocCoreCreateAccessoryRspBO createAccessoryRspBO = this.uocCoreCreateAccessoryAtomService.createAccessory(createAccessoryReqBO);
                if ("0000".equals(createAccessoryRspBO.getRespCode())) continue;
                throw new UocProBusinessException("0100", createAccessoryRspBO.getRespDesc());
            }
        }
    }

    private void doUpdateShipArriveTime(Long orderId, Long shipVoucherId, UocProPurchaseArriveConfirmRejectCombReqBo reqBo) {
        OrdShipPO ordShipModel = new OrdShipPO();
        ordShipModel.setArriveTime(new Date());
        ordShipModel.setShipVoucherId(shipVoucherId);
        ordShipModel.setOrderId(orderId);
        ordShipModel.setReceiverContact(reqBo.getReceiverContact());
        ordShipModel.setReceiverRemark(reqBo.getRemark());
        ordShipModel.setReceiverTime(new Date());
        ordShipModel.setReceiverUser(reqBo.getConsignee());
        int updateArriveTimeResult = this.ordShipMapper.updateById(ordShipModel);
        if (updateArriveTimeResult != 1) {
            throw new UocProBusinessException("0100", "\u66f4\u65b0\u5230\u8d27\u65f6\u95f4\u5931\u8d25!");
        }
    }

    private void doCallCoreArrivalAtom(UocProPurchaseArriveConfirmRejectCombReqBo reqBO, Long shipVoucherId, List<ArriveInfoBO> arriveInfoList) {
        UocCoreArriveRegistReqBO registAtomReqBO = new UocCoreArriveRegistReqBO();
        registAtomReqBO.setOrderId(reqBO.getOrderId());
        registAtomReqBO.setShipVoucherId(shipVoucherId);
        registAtomReqBO.setCreateOperId(reqBO.getUserId() + "");
        registAtomReqBO.setArriveInfoList(arriveInfoList);
        registAtomReqBO.setCheckFlag(1);
        registAtomReqBO.setArriveRemark(reqBO.getRemark());
        UocCoreArriveRegistRspBO arriveRegistRspBO = this.uocCoreArriveRegistAtomService.dealCoreArriveRegist(registAtomReqBO);
        if (!"0000".equals(arriveRegistRspBO.getRespCode())) {
            throw new UocProBusinessException("0100", "\u8c03\u7528\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + arriveRegistRspBO.getRespDesc());
        }
    }

    private void doStateCheck(UocProPurchaseArriveConfirmRejectCombReqBo reqBO) {
        UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
        uocCoreStateCheckAtomReqBO.setOrderId(reqBO.getOrderId());
        uocCoreStateCheckAtomReqBO.setObjId(reqBO.getSaleVourcherId());
        uocCoreStateCheckAtomReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        uocCoreStateCheckAtomReqBO.setActionCode(reqBO.getActionCode());
        UocCoreStateCheckAtomRspBO uocCoreStateCheck = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO);
        if (!"0000".equals(uocCoreStateCheck.getRespCode())) {
            throw new UocProBusinessException("100031", "\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u8c03\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreStateCheck.getRespDesc());
        }
    }

    private void checkAuthority(UocProPurchaseArriveConfirmRejectCombReqBo reqBO) {
        if (!PecConstant.AuthCtrl.NO_CTRL.equals(reqBO.getAuthCtrl())) {
            PebOperationPermissionsCheckingAtomReqBO permissionsCheckingAtomReqBO = new PebOperationPermissionsCheckingAtomReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)permissionsCheckingAtomReqBO);
            PebOperationPermissionsCheckingAtomRspBO permissionsCheckingAtomRspBO = this.pebOperationPermissionsCheckingAtomService.dealPebOperationPermissionsChecking(permissionsCheckingAtomReqBO);
            if (!"0000".equals(permissionsCheckingAtomRspBO.getRespCode())) {
                throw new UocProBusinessException("0100", permissionsCheckingAtomRspBO.getRespDesc());
            }
        }
    }
}

