/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.es.order;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.pec.atom.el.order.bo.QrySaleReqBO;
import com.tydic.order.pec.atom.es.order.UocPebRefundAtomService;
import com.tydic.order.pec.atom.es.order.UocQrySaleOrderAtomService;
import com.tydic.order.pec.atom.es.order.bo.UocPebRefundReqBO;
import com.tydic.order.pec.atom.es.order.bo.UocPebRefundRspBO;
import com.tydic.order.pec.atom.es.unicall.UocPebUniCallIntfAtomService;
import com.tydic.order.pec.atom.es.unicall.bo.UnicallInterfaceDefBO;
import com.tydic.order.pec.atom.es.unicall.bo.UocPebUniCallIntfReqBO;
import com.tydic.order.pec.atom.es.unicall.bo.UocPebUniCallIntfRspBO;
import com.tydic.order.pec.bo.pay.UocPayOrderReFundReqBO;
import com.tydic.order.pec.bo.pay.UocPayOrderReFundRspBO;
import com.tydic.order.pec.busi.es.order.UocPebOrderCancelBusiService;
import com.tydic.order.pec.busi.es.order.bo.UocPebOrderCancelReqBO;
import com.tydic.order.pec.busi.es.order.bo.UocPebOrderCancelRspBO;
import com.tydic.order.pec.busi.es.order.bo.UocReverseReqBO;
import com.tydic.order.pec.busi.pay.UocPayOrderReFundBusiService;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.third.intf.ability.fsc.PebIntfFscDealPayableAbilityService;
import com.tydic.order.third.intf.bo.fsc.PebIntfFscDealPayableReqBO;
import com.tydic.order.third.intf.bo.fsc.PebIntfFscDealPayableRspBO;
import com.tydic.order.uoc.atom.core.UocCoreChgVoucherStateAtomService;
import com.tydic.order.uoc.atom.core.UocCoreQryTacheIntfAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreChgVoucherStateReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreChgVoucherStateRspBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreQryTacheIntfReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreQryTacheIntfRspBO;
import com.tydic.order.uoc.bo.InterfaceDefBO;
import com.tydic.order.uoc.bo.order.OrdSaleRspBO;
import com.tydic.order.uoc.bo.other.VoucherStateBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdPayApplyMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdPayApply;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebOrderCancelBusiService")
public class UocPebOrderCancelBusiServiceImpl
implements UocPebOrderCancelBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPebOrderCancelBusiServiceImpl.class);
    @Autowired
    private UocPebRefundAtomService uocPebRefundAtomService;
    @Autowired
    private UocQrySaleOrderAtomService saleOrderAtomService;
    @Autowired
    private UocPebUniCallIntfAtomService uocPebUniCallIntfAtomService;
    @Autowired
    private UocCoreQryTacheIntfAtomService uocCoreQryTacheIntfAtomService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocCoreChgVoucherStateAtomService uocCoreChgVoucherStateAtomService;
    @Value(value="${UOC_ORDER_CANCEL_TOPIC}")
    private String topic;
    @Value(value="${UOC_ORDER_CANCEL_TAG}")
    private String tag;
    @Resource(name="uocPebOrderCancelMsgProvider")
    private ProxyMessageProducer uocPebOrderCancelMsgProvider;
    @Value(value="${uoc.reverse:false}")
    private Boolean reverse;
    @Autowired
    private UocPayOrderReFundBusiService uocPayOrderReFundBusiService;
    @Autowired
    private PebIntfFscDealPayableAbilityService pebIntfFscDealPayableAbilityService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdPayApplyMapper ordPayApplyMapper;

    public UocPebOrderCancelRspBO dealOrderCancel(UocPebOrderCancelReqBO reqBO) {
        UocPebOrderCancelRspBO rspBO = new UocPebOrderCancelRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.validateArg(reqBO);
        QrySaleReqBO qrySaleReqBO = new QrySaleReqBO();
        qrySaleReqBO.setOrderId(reqBO.getOrderId());
        qrySaleReqBO.setSaleId(reqBO.getSaleVoucherId());
        OrdSaleRspBO saleRspBO = this.saleOrderAtomService.qry(qrySaleReqBO);
        rspBO.setSaleId(saleRspBO.getSaleVoucherId());
        if (reqBO.getNotInterface() == null || !reqBO.getNotInterface().booleanValue()) {
            UocCoreQryTacheIntfReqBO uocCoreQryTacheIntfReqBO = new UocCoreQryTacheIntfReqBO();
            uocCoreQryTacheIntfReqBO.setFlowFlag(UocConstant.FLOW_FLAG.NEGATIVE);
            uocCoreQryTacheIntfReqBO.setTacheCode(String.valueOf(UocConstant.SALE_ORDER_STATUS.CANCEL));
            UocCoreQryTacheIntfRspBO intfRspBO = this.uocCoreQryTacheIntfAtomService.qryTacheIntf(uocCoreQryTacheIntfReqBO);
            if (!"0000".equals(intfRspBO.getRespCode())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(intfRspBO.getRespDesc());
                return rspBO;
            }
            if (CollectionUtils.isNotEmpty(intfRspBO.getInterfaceList())) {
                for (InterfaceDefBO defBO : intfRspBO.getInterfaceList()) {
                    try {
                        UocPebUniCallIntfReqBO callIntfReqBO = new UocPebUniCallIntfReqBO();
                        UnicallInterfaceDefBO interfaceDefBO = new UnicallInterfaceDefBO();
                        BeanUtils.copyProperties((Object)defBO, (Object)interfaceDefBO);
                        callIntfReqBO.setInterfaceDef(interfaceDefBO);
                        callIntfReqBO.setOrderId(reqBO.getOrderId());
                        callIntfReqBO.setObjId(reqBO.getSaleVoucherId());
                        callIntfReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                        UocPebUniCallIntfRspBO uocPebUniCallIntfRspBO = this.uocPebUniCallIntfAtomService.dealUniCallIntf(callIntfReqBO);
                    }
                    catch (Exception callIntfReqBO) {}
                }
            }
        }
        UocPebRefundReqBO refundReqBO = new UocPebRefundReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)refundReqBO);
        refundReqBO.setIsNeedOutBackPay(PecConstant.IS_NEED_OUT_BACKPAY_YES);
        refundReqBO.setSource(PecConstant.ORDER_SOURCE.ELEC_SUPERMARKET);
        refundReqBO.setOrderId(reqBO.getOrderId());
        refundReqBO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        UocPebRefundRspBO refundRspBO = this.uocPebRefundAtomService.dealUocPebRefund(refundReqBO);
        if (!"0000".equals(refundRspBO.getRespCode())) {
            if (log.isDebugEnabled()) {
                log.debug("\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1,\u8c03\u7528\u9000\u6b3e\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u539f\u56e0\u7801\uff1a" + refundRspBO.getFailCode() + "\u5931\u8d25\u539f\u56e0\u63cf\u8ff0\uff1a" + refundRspBO.getFailDesc() + "\u5f02\u5e38\u63cf\u8ff0\uff1a" + refundRspBO.getRespDesc());
            }
            throw new UocProBusinessException("8888", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1,\u8c03\u7528\u9000\u6b3e\u670d\u52a1\u5931\u8d25,\u5f02\u5e38\u63cf\u8ff0\uff1a" + refundRspBO.getRespDesc());
        }
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO = this.orderMapper.getModelBy(orderPO);
        this.updateOrder(reqBO, orderPO);
        this.updateStatus(reqBO, saleRspBO, orderPO);
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
        if (stakeholderPO != null && StringUtils.isNotBlank((CharSequence)stakeholderPO.getExtField4())) {
            OrdPayApply ordPayApply = new OrdPayApply();
            ordPayApply.setOrderId(reqBO.getOrderId());
            List payApplyList = this.ordPayApplyMapper.queryAll(ordPayApply);
            if (CollectionUtils.isNotEmpty((Collection)payApplyList)) {
                UocPayOrderReFundReqBO uocPayOrderReFundReqBO = new UocPayOrderReFundReqBO();
                uocPayOrderReFundReqBO.setOrderId(reqBO.getOrderId());
                uocPayOrderReFundReqBO.setOperType("SUBMIT");
                UocPayOrderReFundRspBO uocPayOrderReFundRspBO = this.uocPayOrderReFundBusiService.dealOrderReFund(uocPayOrderReFundReqBO);
                log.info("\u8c03\u7528\u9000\u6b3e\u670d\u52a1\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocPayOrderReFundRspBO));
                if (!"0000".equals(uocPayOrderReFundRspBO.getRespCode())) {
                    log.debug("\u8c03\u7528\u9000\u6b3e\u670d\u52a1\u5931\u8d25,\u5f02\u5e38\u63cf\u8ff0\uff1a{}", (Object)uocPayOrderReFundRspBO.getRespDesc());
                    throw new UocProBusinessException("8888", "\u8c03\u7528\u9000\u6b3e\u670d\u52a1\u5931\u8d25,\u5f02\u5e38\u63cf\u8ff0\uff1a" + uocPayOrderReFundRspBO.getRespDesc());
                }
            } else {
                PebIntfFscDealPayableReqBO pebIntfFscDealPayableReqBO = new PebIntfFscDealPayableReqBO();
                pebIntfFscDealPayableReqBO.setPayableNos(Collections.singletonList(stakeholderPO.getExtField4()));
                pebIntfFscDealPayableReqBO.setOperType("CANCEL");
                log.info("\u8c03\u7528\u7ed3\u7b97\u53d6\u6d88\u652f\u4ed8\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)pebIntfFscDealPayableReqBO));
                PebIntfFscDealPayableRspBO pebIntfFscDealPayableRspBO = this.pebIntfFscDealPayableAbilityService.dealPayable(pebIntfFscDealPayableReqBO);
                if (!"0000".equals(pebIntfFscDealPayableRspBO.getRespCode())) {
                    log.debug("\u8c03\u7528\u7ed3\u7b97\u53d6\u6d88\u652f\u4ed8\u670d\u52a1\u5931\u8d25,\u5f02\u5e38\u63cf\u8ff0\uff1a{}", (Object)pebIntfFscDealPayableRspBO.getRespDesc());
                    throw new UocProBusinessException("8888", "\u8c03\u7528\u7ed3\u7b97\u53d6\u6d88\u652f\u4ed8\u670d\u52a1,\u5f02\u5e38\u63cf\u8ff0\uff1a" + pebIntfFscDealPayableRspBO.getRespDesc());
                }
                log.info("\u8c03\u7528\u7ed3\u7b97\u53d6\u6d88\u652f\u4ed8\u670d\u52a1\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)pebIntfFscDealPayableRspBO));
            }
        }
        if (this.reverse != null && this.reverse.booleanValue()) {
            UocReverseReqBO reverseReqBO = new UocReverseReqBO();
            reverseReqBO.setOrderId(saleRspBO.getOrderId());
            reverseReqBO.setObjId(saleRspBO.getSaleVoucherId());
            reverseReqBO.setObjType(UocConstant.ORDER_TYPE.SALE_ORDER);
            reverseReqBO.setPrice(saleRspBO.getSaleFee());
            this.uocPebOrderCancelMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)reverseReqBO)));
        }
        return rspBO;
    }

    private void updateOrder(UocPebOrderCancelReqBO reqBO, OrderPO orderPO) {
        orderPO.setCancelDesc(reqBO.getCancelDesc() == null ? "\u8ba2\u5355\u53d6\u6d88" : reqBO.getCancelDesc());
        orderPO.setCancelReason(reqBO.getCancelReason());
        orderPO.setCancelTime(new Date());
        if (reqBO.getCancelOperId() != null) {
            orderPO.setCancelOperId(reqBO.getCancelOperId());
        } else {
            orderPO.setCancelOperId(reqBO.getUserId() == null ? orderPO.getCreateOperId() : String.valueOf(reqBO.getUserId()));
        }
        orderPO.setProcState(reqBO.getFailCode());
        orderPO.setOrderState(UocConstant.CORE_ORDER_STATUS.CANCEL);
        try {
            this.orderMapper.updateById(orderPO);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u53d6\u6d88\u66f4\u6539\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
        }
    }

    private void updateStatus(UocPebOrderCancelReqBO reqBO, OrdSaleRspBO saleRspBO, OrderPO orderPO) {
        UocCoreChgVoucherStateReqBO voucherStateReqBO = new UocCoreChgVoucherStateReqBO();
        voucherStateReqBO.setDealDesc("\u8ba2\u5355\u53d6\u6d88");
        if (reqBO.getCancelOperId() != null) {
            voucherStateReqBO.setOperId(reqBO.getCancelOperId());
        } else {
            voucherStateReqBO.setOperId(orderPO.getCreateOperId());
        }
        voucherStateReqBO.setOrderId(reqBO.getOrderId());
        ArrayList<VoucherStateBO> voucherStateBOS = new ArrayList<VoucherStateBO>();
        VoucherStateBO voucherStateBO = new VoucherStateBO();
        voucherStateBO.setAfterState(UocConstant.SALE_ORDER_STATUS.CANCEL);
        voucherStateBO.setObjId(saleRspBO.getSaleVoucherId());
        voucherStateBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        voucherStateBOS.add(voucherStateBO);
        voucherStateReqBO.setVoucherStateList(voucherStateBOS);
        UocCoreChgVoucherStateRspBO rspBO = this.uocCoreChgVoucherStateAtomService.dealCoreChgVoucherState(voucherStateReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u66f4\u65b0\u72b6\u6001\u5931\u8d25," + rspBO.getRespDesc());
        }
    }

    private void validateArg(UocPebOrderCancelReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("7777", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("7777", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCancelOperId()) && reqBO.getUserId() != null) {
            reqBO.setCancelOperId(reqBO.getUserId().toString());
        }
    }
}

