/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.es.timetask;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.pec.bo.es.consumer.UocPebGeneralConsumerReqBO;
import com.tydic.order.pec.busi.es.timetask.UocPebDealOutPushMsgBusiService;
import com.tydic.order.pec.busi.es.timetask.bo.UocPebDealOutPushMsgReqBO;
import com.tydic.order.pec.busi.es.timetask.bo.UocPebDealOutPushMsgRspBO;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.third.intf.bo.esb.other.ResultBO;
import com.tydic.order.uoc.dao.MsgPoolMapper;
import com.tydic.order.uoc.dao.po.MsgPoolPO;
import com.tydic.order.uoc.utils.OrderPropertiesUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebDealOutPushMsgBusiService")
public class UocPebDealOutPushMsgBusiServiceImpl
implements UocPebDealOutPushMsgBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(UocPebDealOutPushMsgBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOG.isDebugEnabled();
    private MsgPoolMapper msgPoolMapper;
    private static final Integer QRY_EXCEPT_VOTE_MSGS = 1;
    private static final Integer ONLY_QRY_VOTE_MSGS = 2;
    @Value(value="${isOpenDelPushMsg}")
    private boolean isOpenDelPushMsg;
    @Resource(name="dealSplitOrderMsgProvider")
    private ProxyMessageProducer dealSplitOrderMsgProvider;
    @Resource(name="dealSendGoodsMsgProvider")
    private ProxyMessageProducer dealSendGoodsMsgProvider;
    @Resource(name="dealChangeStatusMsgProvider")
    private ProxyMessageProducer dealChangeStatusMsgProvider;
    @Resource(name="dealCancelOrderMsgProvider")
    private ProxyMessageProducer dealCancelOrderMsgProvider;
    @Resource(name="dealChgBackGoodsMsgProvider")
    private ProxyMessageProducer dealChgBackGoodsMsgProvider;
    @Resource(name="dealOutAfterDeliveryMsgProvider")
    private ProxyMessageProducer dealOutAfterDeliveryMsgProvider;
    @Resource(name="dealOutAfsNewOrderIdMsgProvider")
    private ProxyMessageProducer dealOutAfsNewOrderIdMsgProvider;
    @Resource(name="dealOutAfterByOffLineMsgProvider")
    private ProxyMessageProducer dealOutAfterByOffLineMsgProvider;
    @Resource(name="dealCancelOrderOfShippingMsgProvider")
    private ProxyMessageProducer dealCancelOrderOfShippingMsgProvider;

    @Autowired
    public UocPebDealOutPushMsgBusiServiceImpl(MsgPoolMapper msgPoolMapper) {
        this.msgPoolMapper = msgPoolMapper;
    }

    public UocPebDealOutPushMsgRspBO executeOutPushMsgDeal(UocPebDealOutPushMsgReqBO uocPebDealPushMsgBusiReqBO) {
        UocPebDealOutPushMsgRspBO rspBO = new UocPebDealOutPushMsgRspBO();
        List<MsgPoolPO> msgPoolPOS = this.qryMsgPoolList(uocPebDealPushMsgBusiReqBO, QRY_EXCEPT_VOTE_MSGS);
        if (null == msgPoolPOS || msgPoolPOS.isEmpty()) {
            List<MsgPoolPO> msgOfVotePoolPOS;
            if (this.IS_DEBUG_ENABLED) {
                LOG.debug("\u672a\u67e5\u8be2\u5230\u9700\u8981\u8fdb\u884c\u9664\u59a5\u6295\u5916\u7684\u5904\u7406\u7684\u6d88\u606f\u4fe1\u606f\uff01\uff01\uff01\uff01\uff01\uff01");
            }
            if (CollectionUtils.isNotEmpty(msgOfVotePoolPOS = this.qryMsgPoolList(uocPebDealPushMsgBusiReqBO, ONLY_QRY_VOTE_MSGS))) {
                for (MsgPoolPO msgOfVotePoolPO : msgOfVotePoolPOS) {
                    this.sendMQMsg(msgOfVotePoolPO);
                }
                if (this.IS_DEBUG_ENABLED) {
                    LOG.debug("\u5df2\u5904\u7406\u59a5\u6295\u53d1\u8d27\u5355\u6d88\u606f\uff01\uff01\uff01\uff01\uff01\uff01");
                }
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        for (MsgPoolPO msgPoolPO : msgPoolPOS) {
            this.sendMQMsg(msgPoolPO);
        }
        List<MsgPoolPO> msgOfVotePoolPOS = this.qryMsgPoolList(uocPebDealPushMsgBusiReqBO, ONLY_QRY_VOTE_MSGS);
        if (null != msgOfVotePoolPOS && !msgOfVotePoolPOS.isEmpty()) {
            for (MsgPoolPO msgOfVotePoolPO : msgOfVotePoolPOS) {
                this.sendMQMsg(msgOfVotePoolPO);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d88\u606f\u6c60\u79cd\u4fdd\u5b58\u7684\u63a8\u9001\u6d88\u606f\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private List<MsgPoolPO> qryMsgPoolList(UocPebDealOutPushMsgReqBO reqBO, Integer qryType) {
        Long supNo = reqBO.getGoodsSupplierId();
        ArrayList<Integer> runResultList = new ArrayList<Integer>();
        runResultList.add(PecConstant.OUT_MSG_RUN_RESULT.RUN_FAILURE);
        runResultList.add(PecConstant.OUT_MSG_RUN_RESULT.WAIT_RUN);
        Integer failureCount = PecConstant.MAX_FAILURE_COUNT;
        if (qryType.equals(QRY_EXCEPT_VOTE_MSGS)) {
            return this.msgPoolMapper.getListByRunResultAndFailureCount(supNo, runResultList, failureCount);
        }
        ArrayList<Integer> objTypeList = new ArrayList<Integer>();
        objTypeList.add(PecConstant.OUT_MSG_OBJ_TYPE.SHIP_ORDER);
        if (OrderPropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(String.valueOf(supNo)) || OrderPropertiesUtil.getProperty("SUPPLIER_SUNING_ID").equals(String.valueOf(supNo))) {
            objTypeList.add(PecConstant.OUT_MSG_OBJ_TYPE.SALE_ORDER);
        }
        return this.msgPoolMapper.getVoteMsgList(supNo, runResultList, objTypeList, failureCount);
    }

    private void sendMQMsg(MsgPoolPO msgPoolPO) {
        if (msgPoolPO.getOrderType() == null) {
            msgPoolPO.setOrderType(Integer.valueOf(1));
        }
        int type = msgPoolPO.getMsgType();
        UocPebGeneralConsumerReqBO uocPebGeneralConsumerReqBO = new UocPebGeneralConsumerReqBO();
        String extOrderId = null;
        if (StringUtils.isNotBlank((CharSequence)msgPoolPO.getOutOrderId())) {
            extOrderId = msgPoolPO.getOutOrderId();
        } else if (StringUtils.isNotBlank((CharSequence)msgPoolPO.getPOrderId())) {
            extOrderId = msgPoolPO.getPOrderId();
        }
        uocPebGeneralConsumerReqBO.setSupplierId(msgPoolPO.getSupNo());
        uocPebGeneralConsumerReqBO.setExtOrderId(extOrderId);
        uocPebGeneralConsumerReqBO.setPackageId(msgPoolPO.getPackageid());
        uocPebGeneralConsumerReqBO.setServiceId(msgPoolPO.getServiceid());
        uocPebGeneralConsumerReqBO.setMsgId(String.valueOf(msgPoolPO.getId()));
        uocPebGeneralConsumerReqBO.setOrderType(msgPoolPO.getOrderType());
        uocPebGeneralConsumerReqBO.setStatus(msgPoolPO.getMsgState());
        uocPebGeneralConsumerReqBO.setOrderId(msgPoolPO.getOrderId());
        uocPebGeneralConsumerReqBO.setMsgType(msgPoolPO.getMsgType());
        switch (type) {
            case 1: {
                this.dealSplitOrderMsgProvider.send(new ProxyMessage(this.getProperty("DEAL_OUT_SPLIT_ORDER_TOPIC"), this.getProperty("DEAL_OUT_SPLIT_ORDER_TAG"), JSON.toJSONString((Object)uocPebGeneralConsumerReqBO)));
                break;
            }
            case 5: {
                if (OrderPropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(String.valueOf(msgPoolPO.getSupNo())) || OrderPropertiesUtil.getProperty("SUPPLIER_SUNING_ID").equals(String.valueOf(msgPoolPO.getSupNo()))) {
                    this.dealChangeStatusMsgProvider.send(new ProxyMessage(this.getProperty("DEAL_OUT_CHANGE_STATUS_TOPIC"), this.getProperty("DEAL_OUT_CHANGE_STATUS_TAG"), JSON.toJSONString((Object)uocPebGeneralConsumerReqBO)));
                    break;
                }
                Integer orderType = 2;
                if (!orderType.equals(msgPoolPO.getOrderType()) && msgPoolPO.getOrderType() != 1) break;
                this.dealChangeStatusMsgProvider.send(new ProxyMessage(this.getProperty("DEAL_OUT_CHANGE_STATUS_TOPIC"), this.getProperty("DEAL_OUT_CHANGE_STATUS_TAG"), JSON.toJSONString((Object)uocPebGeneralConsumerReqBO)));
                break;
            }
            case 10: {
                this.dealCancelOrderMsgProvider.send(new ProxyMessage(this.getProperty("DEAL_OUT_CANCEL_ORDER_TOPIC"), this.getProperty("DEAL_OUT_CANCEL_ORDER_TAG"), JSON.toJSONString((Object)uocPebGeneralConsumerReqBO)));
                break;
            }
            case 101: {
                this.dealSendGoodsMsgProvider.send(new ProxyMessage(this.getProperty("DEAL_OUT_CREATE_SHIP_ORDER_TOPIC"), this.getProperty("DEAL_OUT_CREATE_SHIP_ORDER_TAG"), JSON.toJSONString((Object)uocPebGeneralConsumerReqBO)));
                break;
            }
            case 102: {
                this.dealChgBackGoodsMsgProvider.send(new ProxyMessage(this.getProperty("DEAL_OUT_CHANGE_BACK_GOODS_STATUS_TOPIC"), this.getProperty("DEAL_OUT_CHANGE_BACK_GOODS_STATUS_TAG"), JSON.toJSONString((Object)uocPebGeneralConsumerReqBO)));
                break;
            }
            case 106: {
                this.dealCancelOrderOfShippingMsgProvider.send(new ProxyMessage(OrderPropertiesUtil.getProperty("DEAL_CANCEL_ORDER_OF_SHIPPING_TOPIC"), OrderPropertiesUtil.getProperty("DEAL_CANCEL_ORDER_OF_SHIPPING_TAG"), JSON.toJSONString((Object)uocPebGeneralConsumerReqBO)));
                break;
            }
            case 107: {
                this.dealOutAfterDeliveryMsgProvider.send(new ProxyMessage(this.getProperty("DEAL_OUT_AFTER_DELIVERY_STATUS_TOPIC"), this.getProperty("DEAL_OUT_AFTER_DELIVERY_STATUS_TAG"), JSON.toJSONString((Object)uocPebGeneralConsumerReqBO)));
                break;
            }
            case 13: {
                this.dealOutAfsNewOrderIdMsgProvider.send(new ProxyMessage(this.getProperty("DEAL_OUT_AFS_NEW_ORDER_ID_TOPIC"), this.getProperty("DEAL_OUT_AFS_NEW_ORDER_ID_TAG"), JSON.toJSONString((Object)uocPebGeneralConsumerReqBO)));
                break;
            }
            case 28: {
                if (StringUtils.isBlank((CharSequence)uocPebGeneralConsumerReqBO.getServiceId())) {
                    try {
                        if (msgPoolPO.getMsgContent() != null) {
                            ResultBO resultBO = (ResultBO)JSON.parseObject((String)msgPoolPO.getMsgContent(), ResultBO.class);
                            uocPebGeneralConsumerReqBO.setServiceId(resultBO.getResult().getAfsServiceId());
                            if (StringUtils.isBlank((CharSequence)uocPebGeneralConsumerReqBO.getServiceId())) {
                                uocPebGeneralConsumerReqBO.setServiceId(resultBO.getResult().getServiceId());
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.dealOutAfterByOffLineMsgProvider.send(new ProxyMessage(this.getProperty("DEAL_OUT_AFTER_BY_OFF_LINE_TOPIC"), this.getProperty("DEAL_OUT_AFTER_BY_OFF_LINE_TAG"), JSON.toJSONString((Object)uocPebGeneralConsumerReqBO)));
                break;
            }
            case 31: {
                this.dealOutAfsNewOrderIdMsgProvider.send(new ProxyMessage(this.getProperty("DEAL_JD_CREATE_SHIP_ORDER_TOPIC"), this.getProperty("DEAL_JD_CREATE_SHIP_ORDER_TAG"), JSON.toJSONString((Object)uocPebGeneralConsumerReqBO)));
                break;
            }
            case 12: {
                this.dealOutAfsNewOrderIdMsgProvider.send(new ProxyMessage(this.getProperty("DEAL_JD_CREATE_SHIP_ORDER_TOPIC"), this.getProperty("DEAL_JD_CREATE_SHIP_ORDER_TAG"), JSON.toJSONString((Object)uocPebGeneralConsumerReqBO)));
                break;
            }
            default: {
                LOG.error("\u7c7b\u578b[" + type + "]\u8fd8\u672a\u914d\u7f6e\u6d88\u8d39\u8005\u7c7b\u578b!!!!!!!!!!!!!!!!!!");
            }
        }
    }

    private String getProperty(String key) {
        return OrderPropertiesUtil.getProperty(key);
    }
}

