/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.order;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.order.pec.bo.order.PebOrderStatusBO;
import com.tydic.order.pec.bo.order.PebQryOrderStatusBO;
import com.tydic.order.pec.bo.order.PebQryOrderStatusReqBO;
import com.tydic.order.pec.bo.order.PebQryOrderStatusRspBO;
import com.tydic.order.pec.busi.order.PebQryOrderStatusBusiService;
import com.tydic.order.pec.dic.SelectDicValByPcodeAndCode;
import com.tydic.order.pec.dic.bo.SelectSingleDictReqBO;
import com.tydic.order.pec.dic.bo.SelectSingleDictRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="pebQryOrderStatusBusiService")
public class PebQryOrderStatusBusiServiceImpl
implements PebQryOrderStatusBusiService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdStakeholderMapper getOrdStakeholderMapper;

    public PebQryOrderStatusRspBO qryOrderStatus(PebQryOrderStatusReqBO reqBO) {
        PebQryOrderStatusRspBO rspBO = new PebQryOrderStatusRspBO();
        List<OrdSalePO> saleInfo = this.getSaleInfo(reqBO);
        this.dealSaleInfo(saleInfo, reqBO, rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<OrdSalePO> getSaleInfo(PebQryOrderStatusReqBO reqBO) {
        ArrayList<Long> orderIdList = new ArrayList<Long>();
        for (PebQryOrderStatusBO qryOrderStatusBO : reqBO.getOrderStatusList()) {
            orderIdList.add(qryOrderStatusBO.getOrderId());
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderIdList(orderIdList);
        List ordSalePOList = this.ordSaleMapper.getList(salePO);
        if (CollectionUtils.isEmpty((Collection)ordSalePOList)) {
            throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u8be5\u9500\u552e\u5355\u4fe1\u606f");
        }
        return ordSalePOList;
    }

    private void dealSaleInfo(List<OrdSalePO> saleInfo, PebQryOrderStatusReqBO reqBO, PebQryOrderStatusRspBO rspBO) {
        Map pebQryOrderStatusBOMap = reqBO.getOrderStatusList().stream().collect(Collectors.toMap(PebQryOrderStatusBO::getOrderId, Function.identity(), (pebQryOrderStatusBO1, pebQryOrderStatusBO2) -> pebQryOrderStatusBO2));
        ArrayList<PebOrderStatusBO> orderInfo = new ArrayList<PebOrderStatusBO>();
        ArrayList<Long> failureOrder = new ArrayList<Long>();
        for (OrdSalePO salePO : saleInfo) {
            OrdStakeholderPO modelById;
            List list;
            OrdExtMapPO extMapPO;
            PebQryOrderStatusBO pebQryOrderStatusBO = (PebQryOrderStatusBO)pebQryOrderStatusBOMap.get(salePO.getOrderId());
            PebOrderStatusBO orderStatusBO = new PebOrderStatusBO();
            SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
            dictReqBO.setCode(salePO.getSaleState() + "");
            dictReqBO.setPcode("RESULT_CODE");
            SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if ("0000".equals(dictRspBO.getRespCode())) {
                String resultCode = dictRspBO.getDicDictionarys().getDescrip();
                if (StringUtils.isEmpty((Object)resultCode)) {
                    resultCode = UocCoreConstant.RESULT_CODE.SUCCESS + "";
                }
                dictReqBO.setCode(resultCode);
                dictReqBO.setPcode("RESULT_DESCRIPTION");
                dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
                if ("0000".equals(dictRspBO.getRespCode())) {
                    orderStatusBO.setResultDescription(dictRspBO.getDicDictionarys().getDescrip());
                }
                orderStatusBO.setResultCode(Integer.valueOf(resultCode));
            }
            if (UocCoreConstant.RESULT_CODE.SUCCESS.equals(orderStatusBO.getResultCode())) {
                extMapPO = new OrdExtMapPO();
                extMapPO.setFieldCode("isSuccess");
                extMapPO.setOrderId(salePO.getOrderId());
                extMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
                list = this.ordExtMapMapper.getList(extMapPO);
                if (!CollectionUtils.isEmpty((Collection)list) && !"1".equals(((OrdExtMapPO)list.get(0)).getFieldValue())) {
                    orderStatusBO.setResultCode(UocCoreConstant.RESULT_CODE.SUCCESS_AND_FAIL);
                    orderStatusBO.setFailMsg(((OrdExtMapPO)list.get(0)).getFieldValue());
                }
            }
            orderStatusBO.setSeller(pebQryOrderStatusBO.getGoodsSupplierName());
            extMapPO = new OrdExtMapPO();
            extMapPO.setFieldCode("busiMode");
            extMapPO.setOrderId(salePO.getOrderId());
            extMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list = this.ordExtMapMapper.getList(extMapPO);
            if (!CollectionUtils.isEmpty((Collection)list) && "0".equals(((OrdExtMapPO)list.get(0)).getFieldValue())) {
                OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(salePO.getOrderId().longValue());
                orderStatusBO.setSeller(stakeholderPO.getProName());
            }
            orderStatusBO.setOrderId(salePO.getOrderId());
            orderStatusBO.setSaleOrderId(salePO.getSaleVoucherId());
            orderStatusBO.setSaleVoucherNo(salePO.getSaleVoucherNo());
            orderStatusBO.setGoodsSupplierId(pebQryOrderStatusBO.getGoodsSupplierId());
            orderStatusBO.setGoodSupplierName(pebQryOrderStatusBO.getGoodsSupplierName());
            orderStatusBO.setOrderSource(salePO.getOrderSource());
            try {
                orderStatusBO.setFee(MoneyUtils.Long2BigDecimal((Long)salePO.getSaleFee()));
            }
            catch (Exception e) {
                throw new UocProBusinessException("0100", "\u91d1\u989d\u8f6c\u6362\u5931\u8d25\uff1a" + salePO.getOrderId());
            }
            if (UocCoreConstant.RESULT_CODE.FAILURE.equals(orderStatusBO.getResultCode())) {
                failureOrder.add(salePO.getOrderId());
            }
            if ((ObjectUtil.isEmpty((Object)orderStatusBO.getGoodsSupplierId()) || ObjectUtil.isEmpty((Object)orderStatusBO.getGoodSupplierName())) && (modelById = this.getOrdStakeholderMapper.getModelById(orderStatusBO.getOrderId().longValue())) != null) {
                orderStatusBO.setGoodsSupplierId(Long.valueOf(Long.parseLong(modelById.getSupNo())));
                orderStatusBO.setGoodSupplierName(modelById.getSupName());
                if (ObjectUtil.isEmpty((Object)orderStatusBO.getSeller())) {
                    orderStatusBO.setSeller(orderStatusBO.getGoodSupplierName());
                }
            }
            orderInfo.add(orderStatusBO);
        }
        if (!CollectionUtils.isEmpty(failureOrder)) {
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderIdList(failureOrder);
            List orderPOList = this.orderMapper.getList(orderPO);
            if (!CollectionUtils.isEmpty((Collection)orderPOList)) {
                block3: for (OrderPO po : orderPOList) {
                    for (PebOrderStatusBO orderStatusBO : orderInfo) {
                        if (!po.getOrderId().equals(orderStatusBO.getOrderId())) continue;
                        if (!StringUtils.isEmpty((Object)po.getCancelDesc())) {
                            orderStatusBO.setFailMsg(po.getCancelDesc());
                            continue block3;
                        }
                        if (!StringUtils.isEmpty((Object)po.getCancelReason())) continue;
                        orderStatusBO.setFailMsg(po.getCancelReason());
                        continue block3;
                    }
                }
            }
        }
        rspBO.setOrderInfo(orderInfo);
    }
}

