/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.order;

import com.tydic.order.pec.atom.el.authority.PebOperationPermissionsCheckingAtomService;
import com.tydic.order.pec.atom.el.authority.bo.PebOperationPermissionsCheckingAtomReqBO;
import com.tydic.order.pec.atom.el.authority.bo.PebOperationPermissionsCheckingAtomRspBO;
import com.tydic.order.pec.atom.el.order.UocOrderRemindAtomService;
import com.tydic.order.pec.atom.el.order.bo.UocOrderRemindAtomServiceReqBO;
import com.tydic.order.pec.atom.el.order.bo.UocOrderRemindAtomServiceRspBO;
import com.tydic.order.pec.bo.other.UocOrderRemindOrderInfoBO;
import com.tydic.order.pec.bo.other.UocOrderRemindServiceReqBO;
import com.tydic.order.pec.bo.other.UocOrderRemindServiceRspBO;
import com.tydic.order.pec.busi.order.UocOrderRemindBusiService;
import com.tydic.order.uoc.atom.order.UocCoreStateCheckAtomService;
import com.tydic.order.uoc.bo.order.UocCoreStateCheckAtomReqBO;
import com.tydic.order.uoc.bo.order.UocCoreStateCheckAtomRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdItemMapper;
import com.tydic.order.uoc.dao.po.OrdItemPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="UocOrderRemindBusiService")
public class UocOrderRemindBusiServiceImpl
implements UocOrderRemindBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocOrderRemindBusiServiceImpl.class);
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private PebOperationPermissionsCheckingAtomService pebOperationPermissionsCheckingAtomService;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocOrderRemindAtomService uocOrderRemindAtomService;

    public UocOrderRemindServiceRspBO dealRemind(UocOrderRemindServiceReqBO reqBO) {
        this.validateOrderStatusAndAuth(reqBO);
        this.validateOrderInfo(reqBO);
        UocOrderRemindServiceRspBO retBo = new UocOrderRemindServiceRspBO();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        UocOrderRemindAtomServiceReqBO atomReqBo = new UocOrderRemindAtomServiceReqBO();
        atomReqBo.setDealType(reqBO.getDealType());
        atomReqBo.setActionCode(reqBO.getActionCode());
        for (UocOrderRemindOrderInfoBO orderInfoBo : reqBO.getNoticeOrderList()) {
            atomReqBo.setOrderId(orderInfoBo.getOrderId());
            UocOrderRemindAtomServiceRspBO atomRetBo = this.uocOrderRemindAtomService.dealRemind(atomReqBo);
            BeanUtils.copyProperties((Object)atomRetBo, (Object)retBo);
        }
        return retBo;
    }

    private void validateOrderInfo(UocOrderRemindServiceReqBO reqBO) {
        if ("ACTPEB011".equals(reqBO.getActionCode())) {
            boolean isDelivered = true;
            OrdItemPO ordItemReqPo = new OrdItemPO();
            for (UocOrderRemindOrderInfoBO orderInfoBo : reqBO.getNoticeOrderList()) {
                ordItemReqPo.setOrderId(orderInfoBo.getOrderId());
                List ordItems = this.ordItemMapper.getList(ordItemReqPo);
                if (CollectionUtils.isEmpty((Collection)ordItems)) continue;
                for (OrdItemPO ordItemPO : ordItems) {
                    if (ordItemPO.getSendCount().equals(ordItemPO.getPurchaseCount())) continue;
                    isDelivered = false;
                    break;
                }
                if (!isDelivered) continue;
                throw new UocProBusinessException("0002", "\u8ba2\u5355id:" + orderInfoBo.getOrderId() + "\u5df2\u5168\u90e8\u53d1\u8d27\u5b8c\u6210");
            }
        }
    }

    private void validateOrderStatusAndAuth(UocOrderRemindServiceReqBO reqBO) {
        UocCoreStateCheckAtomReqBO atomStatusReqBO = new UocCoreStateCheckAtomReqBO();
        atomStatusReqBO.setActionCode(reqBO.getActionCode());
        PebOperationPermissionsCheckingAtomReqBO atomAuthReqBo = new PebOperationPermissionsCheckingAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)atomAuthReqBo);
        for (UocOrderRemindOrderInfoBO orderInfoBo : reqBO.getNoticeOrderList()) {
            PebOperationPermissionsCheckingAtomRspBO atomAuthRetBo;
            UocCoreStateCheckAtomRspBO atomStatusRspBO;
            atomStatusReqBO.setOrderId(orderInfoBo.getOrderId());
            if (null != orderInfoBo.getPurchaseVoucherId()) {
                atomStatusReqBO.setObjId(orderInfoBo.getPurchaseVoucherId());
                atomStatusReqBO.setObjType(UocCoreConstant.OBJ_TYPE.PURCHASE);
            }
            if (null != orderInfoBo.getSaleVoucherId()) {
                atomStatusReqBO.setObjId(orderInfoBo.getSaleVoucherId());
                atomStatusReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            }
            if (log.isDebugEnabled()) {
                log.debug("\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u5165\u53c2\uff1a {}", (Object)atomStatusReqBO);
            }
            if (!"0000".equals((atomStatusRspBO = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(atomStatusReqBO)).getRespCode())) {
                throw new UocProBusinessException("0002", "\u8ba2\u5355id:" + atomStatusReqBO.getOrderId() + "\u72b6\u6001\u6821\u9a8c\u4e0d\u901a\u8fc7");
            }
            if (UocConstant.ORDER_TO_REMIND_AUTH_CTRL.AUTH_CTRL0.equals(reqBO.getAuthCtrl()) || StringUtils.isEmpty((Object)reqBO.getAuthCtrl())) continue;
            BeanUtils.copyProperties((Object)reqBO, (Object)atomAuthReqBo);
            atomAuthReqBo.setOrderId(orderInfoBo.getOrderId());
            if (log.isDebugEnabled()) {
                log.debug("\u64cd\u4f5c\u6743\u9650\u6821\u9a8c\u5165\u53c2\uff1a {}", (Object)atomAuthReqBo);
            }
            if ("0000".equals((atomAuthRetBo = this.pebOperationPermissionsCheckingAtomService.dealPebOperationPermissionsChecking(atomAuthReqBo)).getRespCode())) continue;
            throw new UocProBusinessException("0002", "\u8ba2\u5355id:" + orderInfoBo.getOrderId() + "\u64cd\u4f5c\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7");
        }
    }
}

