/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.comb.other;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.order.pec.bo.afterservice.UocAfterSalesDetailsListQueryBO;
import com.tydic.order.pec.bo.afterservice.UocAfterSalesDetailsQueryReqBO;
import com.tydic.order.pec.bo.afterservice.UocAfterSalesDetailsQueryRspBO;
import com.tydic.order.pec.bo.order.UocMainOrderDetailQueryReqBO;
import com.tydic.order.pec.bo.order.UocMainOrderDetailQueryRspBO;
import com.tydic.order.pec.bo.other.UocOrdIdxSyncReqBO;
import com.tydic.order.pec.bo.other.UocOrdIdxSyncRspBO;
import com.tydic.order.pec.bo.pay.UocPayOrderDetailQueryReqBO;
import com.tydic.order.pec.bo.pay.UocPayOrderDetailQueryRspBO;
import com.tydic.order.pec.bo.pay.UocPayOrderDetailRspBO;
import com.tydic.order.pec.bo.purchase.UocPurchaseSingleDetailsListQueryBO;
import com.tydic.order.pec.bo.purchase.UocPurchaseSingleDetailsQueryReqBO;
import com.tydic.order.pec.bo.purchase.UocPurchaseSingleDetailsQueryRspBO;
import com.tydic.order.pec.bo.sale.UocOrdItemRspBO;
import com.tydic.order.pec.bo.sale.UocSalesSingleDetailsListQueryBO;
import com.tydic.order.pec.bo.sale.UocSalesSingleDetailsQueryReqBO;
import com.tydic.order.pec.bo.sale.UocSalesSingleDetailsQueryRspBO;
import com.tydic.order.pec.busi.afterservice.UocAfterSalesDetailsQueryBusiService;
import com.tydic.order.pec.busi.order.UocMainOrderDetailQueryBusiService;
import com.tydic.order.pec.busi.pay.UocPayOrderDetailQueryBusiService;
import com.tydic.order.pec.busi.purchase.UocPurchaseSingleDetailsQueryBusiService;
import com.tydic.order.pec.busi.sale.UocSalesSingleDetailsQueryBusiService;
import com.tydic.order.pec.comb.other.UocOrdIdxSyncCombService;
import com.tydic.order.pec.es.bo.UocEsQryPurchaseListSingleBO;
import com.tydic.order.pec.es.bo.UocEsSyncAfsListReqBO;
import com.tydic.order.pec.es.bo.UocEsSyncAfsListRspBO;
import com.tydic.order.pec.es.bo.UocEsSyncOrderListReqBO;
import com.tydic.order.pec.es.bo.UocEsSyncOrderListRspBO;
import com.tydic.order.pec.es.bo.UocEsSyncPurchaseListReqBO;
import com.tydic.order.pec.es.bo.UocEsSyncPurchaseListRspBO;
import com.tydic.order.pec.es.service.UocEsSyncAfsListBusiService;
import com.tydic.order.pec.es.service.UocEsSyncOrderListBusiService;
import com.tydic.order.pec.es.service.UocEsSyncPurchaseListBusiService;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdAsItemMapper;
import com.tydic.order.uoc.dao.OrdAsObjMapper;
import com.tydic.order.uoc.dao.po.OrdAsItemPO;
import com.tydic.order.uoc.dao.po.OrdAsObjPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocOrdIdxSyncCombService")
public class UocOrdIdxSyncCombServiceImpl
implements UocOrdIdxSyncCombService {
    private static final Logger log = LoggerFactory.getLogger(UocOrdIdxSyncCombServiceImpl.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private UocMainOrderDetailQueryBusiService uocMainOrderDetailQueryBusiService;
    @Autowired
    private UocSalesSingleDetailsQueryBusiService salesSingleDetailsQueryBusiService;
    @Autowired
    private UocPayOrderDetailQueryBusiService payOrderDetailQueryBusiService;
    @Autowired
    private OrdAsObjMapper ordAsObjMapper;
    @Autowired
    private OrdAsItemMapper ordAsItemMapper;
    @Autowired
    private UocEsSyncOrderListBusiService uocEsSyncOrderListBusiService;
    @Autowired
    private UocAfterSalesDetailsQueryBusiService afterSalesDetailsQueryBusiService;
    @Autowired
    private UocEsSyncAfsListBusiService uocEsSyncAfsListBusiService;
    @Autowired
    private UocPurchaseSingleDetailsQueryBusiService purchaseSingleDetailsQueryBusiService;
    @Autowired
    private UocEsSyncPurchaseListBusiService uocEsSyncPurchaseListBusiService;

    public UocOrdIdxSyncRspBO dealOrdIdxSync(UocOrdIdxSyncReqBO reqBO) {
        UocOrdIdxSyncRspBO rspBO = new UocOrdIdxSyncRspBO();
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("ES\u540c\u6b65\u539f\u5b50\u670d\u52a1\u5165\u53c2:" + JSON.toJSONString((Object)reqBO));
        }
        this.validateParams(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocMainOrderDetailQueryRspBO mainOrderDetail = this.getMainOrderDetail(reqBO);
        UocPayOrderDetailQueryRspBO payOrderDetail = this.getPayOrderDetail(reqBO);
        if (UocCoreConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType())) {
            UocSalesSingleDetailsQueryRspBO salesDetails = this.getSalesDetails(reqBO);
            return this.dealSalesDetailsSync(salesDetails, mainOrderDetail, payOrderDetail);
        }
        if (UocCoreConstant.OBJ_TYPE.AFTER_SERVICE.equals(reqBO.getObjType())) {
            UocAfterSalesDetailsQueryRspBO afterSalesDetails = this.getAfterSalesDetails(reqBO);
            return this.dealAfterServiceDetailsSync(afterSalesDetails, mainOrderDetail, payOrderDetail);
        }
        if (UocCoreConstant.OBJ_TYPE.PURCHASE.equals(reqBO.getObjType())) {
            UocPurchaseSingleDetailsQueryRspBO purchaseSingleDetails = this.getPurchaseSingleDetails(reqBO);
            return this.dealPurchaseSingleDetailsSync(purchaseSingleDetails, mainOrderDetail, payOrderDetail);
        }
        return rspBO;
    }

    private void validateParams(UocOrdIdxSyncReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("0001", "ES\u540c\u6b65\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("0001", "ES\u540c\u6b65\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("0002", "ES\u540c\u6b65\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (null == reqBO.getObjId()) {
            throw new UocProBusinessException("0001", "ES\u540c\u6b65\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5bf9\u8c61ID\u3010objId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getObjId()) {
            throw new UocProBusinessException("0002", "ES\u540c\u6b65\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5bf9\u8c61ID\u3010objId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
    }

    private UocMainOrderDetailQueryRspBO getMainOrderDetail(UocOrdIdxSyncReqBO reqBO) {
        UocMainOrderDetailQueryReqBO mainOrderDetailQueryReqBO = new UocMainOrderDetailQueryReqBO();
        mainOrderDetailQueryReqBO.setOrderId(reqBO.getOrderId());
        UocMainOrderDetailQueryRspBO mainOrderDetailQueryRspBO = this.uocMainOrderDetailQueryBusiService.getMainOrderDetailQueryBusi(mainOrderDetailQueryReqBO);
        if (!"0000".equals(mainOrderDetailQueryRspBO.getRespCode())) {
            throw new UocProBusinessException(mainOrderDetailQueryRspBO.getRespCode(), mainOrderDetailQueryRspBO.getRespDesc());
        }
        return mainOrderDetailQueryRspBO;
    }

    private UocSalesSingleDetailsQueryRspBO getSalesDetails(UocOrdIdxSyncReqBO reqBO) {
        UocSalesSingleDetailsQueryReqBO salesSingleDetailsQueryReqBO = new UocSalesSingleDetailsQueryReqBO();
        salesSingleDetailsQueryReqBO.setOrderId(reqBO.getOrderId());
        salesSingleDetailsQueryReqBO.setSaleVoucherId(reqBO.getObjId());
        UocSalesSingleDetailsQueryRspBO salesSingleDetailsQueryRspBO = this.salesSingleDetailsQueryBusiService.getSalesSingleDetailsQuery(salesSingleDetailsQueryReqBO);
        if (!"0000".equals(salesSingleDetailsQueryRspBO.getRespCode())) {
            throw new UocProBusinessException(salesSingleDetailsQueryRspBO.getRespCode(), salesSingleDetailsQueryRspBO.getRespDesc());
        }
        return salesSingleDetailsQueryRspBO;
    }

    private UocPayOrderDetailQueryRspBO getPayOrderDetail(UocOrdIdxSyncReqBO reqBO) {
        UocPayOrderDetailQueryReqBO payOrderDetailQueryReqBO = new UocPayOrderDetailQueryReqBO();
        payOrderDetailQueryReqBO.setOrderId(reqBO.getOrderId());
        payOrderDetailQueryReqBO.setObjType(reqBO.getObjType());
        payOrderDetailQueryReqBO.setObjId(reqBO.getObjId());
        UocPayOrderDetailQueryRspBO payOrderDetailQueryRspBO = this.payOrderDetailQueryBusiService.getPayOrderDetail(payOrderDetailQueryReqBO);
        if (!"0000".equals(payOrderDetailQueryRspBO.getRespCode())) {
            throw new UocProBusinessException(payOrderDetailQueryRspBO.getRespCode(), payOrderDetailQueryRspBO.getRespDesc());
        }
        return payOrderDetailQueryRspBO;
    }

    private UocAfterSalesDetailsQueryRspBO getMainAfterSalesInfo(Long orderId, Long afterServId) {
        UocAfterSalesDetailsQueryReqBO afterSalesDetailsQueryReqBO = new UocAfterSalesDetailsQueryReqBO();
        afterSalesDetailsQueryReqBO.setOrderId(orderId);
        afterSalesDetailsQueryReqBO.setAfterServId(afterServId);
        afterSalesDetailsQueryReqBO.setQueryLevel(UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY_NOT);
        UocAfterSalesDetailsQueryRspBO afterSalesDetailsQueryRspBO = this.afterSalesDetailsQueryBusiService.getAfterSalesDetailsQuery(afterSalesDetailsQueryReqBO);
        if (!"0000".equals(afterSalesDetailsQueryRspBO.getRespCode())) {
            throw new UocProBusinessException(afterSalesDetailsQueryRspBO.getRespCode(), afterSalesDetailsQueryRspBO.getRespDesc());
        }
        return afterSalesDetailsQueryRspBO;
    }

    private UocOrdIdxSyncRspBO dealSalesDetailsSync(UocSalesSingleDetailsQueryRspBO salesDetails, UocMainOrderDetailQueryRspBO mainOrderDetail, UocPayOrderDetailQueryRspBO payOrderDetail) {
        UocOrdIdxSyncRspBO rspBO = new UocOrdIdxSyncRspBO();
        UocEsSyncOrderListReqBO uocEsSyncOrderListReqBO = this.buildEsSyncOrderListReqBO(salesDetails, mainOrderDetail, payOrderDetail);
        UocEsSyncOrderListRspBO uocEsSyncOrderListRspBO = this.uocEsSyncOrderListBusiService.esSyncOrderList(uocEsSyncOrderListReqBO);
        if (!"0000".equals(uocEsSyncOrderListRspBO.getRespCode())) {
            rspBO.setRespCode("0100");
            rspBO.setRespDesc("\u540c\u6b65\u9500\u552e\u5355\u7d22\u5f15\u5230ES\u5931\u8d25!");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UocEsSyncOrderListReqBO buildEsSyncOrderListReqBO(UocSalesSingleDetailsQueryRspBO salesDetails, UocMainOrderDetailQueryRspBO mainOrderDetail, UocPayOrderDetailQueryRspBO payOrderDetail) {
        UocEsSyncOrderListReqBO esSyncOrderListReqBO = new UocEsSyncOrderListReqBO();
        UocSalesSingleDetailsListQueryBO salesSingleDetailsListQueryBO = new UocSalesSingleDetailsListQueryBO();
        esSyncOrderListReqBO.setObjId(salesDetails.getOrdSaleRspBO().getSaleVoucherId());
        esSyncOrderListReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        esSyncOrderListReqBO.setOrderId(mainOrderDetail.getOrderRspBO().getOrderId());
        esSyncOrderListReqBO.setUpperOrderId(mainOrderDetail.getOrderRspBO().getUpperOrderId());
        esSyncOrderListReqBO.setPurNo(mainOrderDetail.getOrdStakeholderRspBO().getPurNo());
        esSyncOrderListReqBO.setPurName(mainOrderDetail.getOrdStakeholderRspBO().getPurName());
        esSyncOrderListReqBO.setPurAccount(mainOrderDetail.getOrdStakeholderRspBO().getPurAccount());
        esSyncOrderListReqBO.setPurAccountName(mainOrderDetail.getOrdStakeholderRspBO().getPurAccountName());
        esSyncOrderListReqBO.setSaleState(salesDetails.getOrdSaleRspBO().getSaleState());
        esSyncOrderListReqBO.setOrderSource(salesDetails.getOrdSaleRspBO().getOrderSource());
        esSyncOrderListReqBO.setPurchaseType(salesDetails.getOrdSaleRspBO().getPurchaseType() + "");
        esSyncOrderListReqBO.setCreateTime(mainOrderDetail.getOrderRspBO().getCreateTime());
        esSyncOrderListReqBO.setCreateOperId(mainOrderDetail.getOrderRspBO().getCreateOperId());
        esSyncOrderListReqBO.setSupNo(mainOrderDetail.getOrdStakeholderRspBO().getSupNo());
        esSyncOrderListReqBO.setSupName(mainOrderDetail.getOrdStakeholderRspBO().getSupName());
        esSyncOrderListReqBO.setSaleVoucherNo(salesDetails.getOrdSaleRspBO().getSaleVoucherNo());
        esSyncOrderListReqBO.setOutOrderNo(mainOrderDetail.getOrderRspBO().getOrderNo());
        esSyncOrderListReqBO.setOrderDesc(mainOrderDetail.getOrderRspBO().getOrderDesc());
        if (CollectionUtils.isNotEmpty((Collection)payOrderDetail.getPayOrderDetailRspBOList())) {
            UocPayOrderDetailRspBO payOrderDetailRspBO = (UocPayOrderDetailRspBO)payOrderDetail.getPayOrderDetailRspBOList().get(0);
            esSyncOrderListReqBO.setPayVourcherNo(payOrderDetailRspBO.getOrdPayRspBO().getPayVoucherNo());
            esSyncOrderListReqBO.setPayTime(payOrderDetailRspBO.getOrdPayRspBO().getPayTime());
            salesSingleDetailsListQueryBO.setSalePayRspBO(payOrderDetailRspBO.getOrdPayRspBO());
            salesSingleDetailsListQueryBO.setSalePayItemRspBOList(payOrderDetailRspBO.getOrdPayItemRspBOList());
        }
        esSyncOrderListReqBO.setUpdateTime(mainOrderDetail.getOrderRspBO().getUpdateTime());
        esSyncOrderListReqBO.setRefundFlag(UocCoreConstant.REFUND_FLAG.NO);
        esSyncOrderListReqBO.setCreateOperName(mainOrderDetail.getOrdStakeholderRspBO().getPurName());
        esSyncOrderListReqBO.setCreateOperPhone(mainOrderDetail.getOrdStakeholderRspBO().getPurMobile());
        StringBuilder aggregationCondition = null;
        ArrayList<String> skuId = new ArrayList<String>(salesDetails.getOrdItemRspBOList().size());
        ArrayList<String> skuName = new ArrayList<String>(salesDetails.getOrdItemRspBOList().size());
        ArrayList<String> outSkuId = new ArrayList<String>(salesDetails.getOrdItemRspBOList().size());
        OrdAsObjPO asObjPO = new OrdAsObjPO();
        asObjPO.setOrderId(salesDetails.getOrdSaleRspBO().getOrderId());
        asObjPO.setSaleVoucherId(salesDetails.getOrdSaleRspBO().getSaleVoucherId());
        asObjPO.setOrderBy("create_time desc");
        List ordAsObjPOS = this.ordAsObjMapper.getList(asObjPO);
        OrdAsItemPO asItemPO = new OrdAsItemPO();
        asItemPO.setOrderId(salesDetails.getOrdSaleRspBO().getOrderId());
        if (CollectionUtils.isNotEmpty((Collection)ordAsObjPOS)) {
            ArrayList<Long> afterServIdList = new ArrayList<Long>();
            for (OrdAsObjPO ordAsObjPO : ordAsObjPOS) {
                afterServIdList.add(ordAsObjPO.getSaleVoucherId());
            }
            asItemPO.setAfterServIdList(afterServIdList);
            List skuServState = this.ordAsItemMapper.getSkuservState(asItemPO);
            skuServState = skuServState.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OrdAsItemPO>(Comparator.comparing(OrdAsItemPO::getSkuId))), ArrayList::new));
            if (CollectionUtils.isNotEmpty((Collection)salesDetails.getOrdItemRspBOList())) {
                for (UocOrdItemRspBO ordItemRspBO : salesDetails.getOrdItemRspBOList()) {
                    for (int i = 0; i < skuServState.size(); ++i) {
                        if (!((OrdAsItemPO)skuServState.get(i)).getSkuId().equals(ordItemRspBO.getSkuId())) continue;
                        UocAfterSalesDetailsQueryRspBO mainAfterSalesInfo = this.getMainAfterSalesInfo(salesDetails.getOrdSaleRspBO().getOrderId(), ((OrdAsItemPO)skuServState.get(i)).getAfterServId());
                        ordItemRspBO.setSaleItemAfterServiceInfo(mainAfterSalesInfo.getOrdAfterServiceRspBO());
                        esSyncOrderListReqBO.setRefundFlag(UocCoreConstant.REFUND_FLAG.YES);
                        if (1 != i) break;
                        esSyncOrderListReqBO.setServCreateTime(mainAfterSalesInfo.getOrdAfterServiceRspBO().getCreateTime());
                        esSyncOrderListReqBO.setServType(mainAfterSalesInfo.getOrdAfterServiceRspBO().getServType());
                        esSyncOrderListReqBO.setServState(mainAfterSalesInfo.getOrdAfterServiceRspBO().getServState());
                        salesSingleDetailsListQueryBO.setSaleAfterServiceInfo(mainAfterSalesInfo.getOrdAfterServiceRspBO());
                        break;
                    }
                    skuId.add(ordItemRspBO.getSkuId());
                    skuName.add(ordItemRspBO.getSkuName());
                    outSkuId.add(ordItemRspBO.getOrdGoodsRspBO().getSkuExtSkuId());
                }
            }
        }
        assert (aggregationCondition != null);
        esSyncOrderListReqBO.setAggregationCondition(aggregationCondition.toString());
        esSyncOrderListReqBO.setSkuId(skuId);
        esSyncOrderListReqBO.setSkuName(skuName);
        esSyncOrderListReqBO.setOutSkuId(outSkuId);
        salesSingleDetailsListQueryBO.setOrdSaleRspBO(salesDetails.getOrdSaleRspBO());
        salesSingleDetailsListQueryBO.setOrdSaleMtLogRspBO(salesDetails.getOrdSaleMtLogRspBO());
        salesSingleDetailsListQueryBO.setSaleAccessoryList(salesDetails.getSaleAccessoryList());
        salesSingleDetailsListQueryBO.setOrdItemRspBOList(salesDetails.getOrdItemRspBOList());
        salesSingleDetailsListQueryBO.setOrdSaleCouponRspBOList(salesDetails.getOrdSaleCouponRspBOList());
        salesSingleDetailsListQueryBO.setOrderRspBO(mainOrderDetail.getOrderRspBO());
        salesSingleDetailsListQueryBO.setOrdStakeholderRspBO(mainOrderDetail.getOrdStakeholderRspBO());
        salesSingleDetailsListQueryBO.setOrdAgrAgreementRspBO(mainOrderDetail.getOrdAgreementRspBO());
        salesSingleDetailsListQueryBO.setOrdInvoiceRspBO(mainOrderDetail.getOrdInvoiceRspBO());
        salesSingleDetailsListQueryBO.setOrderAccessoryList(mainOrderDetail.getOrderAccessoryList());
        esSyncOrderListReqBO.setObjJson(JSONObject.toJSONString((Object)salesSingleDetailsListQueryBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return esSyncOrderListReqBO;
    }

    private UocAfterSalesDetailsQueryRspBO getAfterSalesDetails(UocOrdIdxSyncReqBO reqBO) {
        UocAfterSalesDetailsQueryReqBO afterSalesDetailsQueryReqBO = new UocAfterSalesDetailsQueryReqBO();
        afterSalesDetailsQueryReqBO.setOrderId(reqBO.getOrderId());
        afterSalesDetailsQueryReqBO.setAfterServId(reqBO.getObjId());
        UocAfterSalesDetailsQueryRspBO afterSalesDetailsQueryRspBO = this.afterSalesDetailsQueryBusiService.getAfterSalesDetailsQuery(afterSalesDetailsQueryReqBO);
        if (!"0000".equals(afterSalesDetailsQueryRspBO.getRespCode())) {
            throw new UocProBusinessException(afterSalesDetailsQueryRspBO.getRespCode(), afterSalesDetailsQueryRspBO.getRespDesc());
        }
        return afterSalesDetailsQueryRspBO;
    }

    private UocOrdIdxSyncRspBO dealAfterServiceDetailsSync(UocAfterSalesDetailsQueryRspBO afterSalesDetails, UocMainOrderDetailQueryRspBO mainOrderDetail, UocPayOrderDetailQueryRspBO payOrderDetail) {
        UocOrdIdxSyncRspBO rspBO = new UocOrdIdxSyncRspBO();
        UocEsSyncAfsListReqBO uocEsSyncAfsListReqBO = this.buildEsSyncAfsListReqBO(afterSalesDetails, mainOrderDetail, payOrderDetail);
        UocEsSyncAfsListRspBO uocEsSyncAfsListRspBO = this.uocEsSyncAfsListBusiService.esSyncAfsList(uocEsSyncAfsListReqBO);
        if (!"0000".equals(uocEsSyncAfsListRspBO.getRespCode())) {
            rspBO.setRespCode("0100");
            rspBO.setRespDesc("\u540c\u6b65\u552e\u540e\u5355\u7d22\u5f15\u5230ES\u5931\u8d25!");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UocEsSyncAfsListReqBO buildEsSyncAfsListReqBO(UocAfterSalesDetailsQueryRspBO afterSalesDetails, UocMainOrderDetailQueryRspBO mainOrderDetail, UocPayOrderDetailQueryRspBO payOrderDetail) {
        UocEsSyncAfsListReqBO uocEsSyncAfsListReqBO = new UocEsSyncAfsListReqBO();
        uocEsSyncAfsListReqBO.setObjId(afterSalesDetails.getOrdAfterServiceRspBO().getAfterServId());
        uocEsSyncAfsListReqBO.setObjType(UocCoreConstant.OBJ_TYPE.AFTER_SERVICE);
        uocEsSyncAfsListReqBO.setOrderId(mainOrderDetail.getOrderRspBO().getOrderId());
        uocEsSyncAfsListReqBO.setUpperOrderId(mainOrderDetail.getOrderRspBO().getUpperOrderId());
        uocEsSyncAfsListReqBO.setAfterServiceNo(afterSalesDetails.getOrdAfterServiceRspBO().getAfterServCode());
        uocEsSyncAfsListReqBO.setAfsServiceId(afterSalesDetails.getOrdAfterServiceRspBO().getAfsServiceId());
        uocEsSyncAfsListReqBO.setPurNo(mainOrderDetail.getOrdStakeholderRspBO().getPurNo());
        uocEsSyncAfsListReqBO.setPurName(mainOrderDetail.getOrdStakeholderRspBO().getPurName());
        uocEsSyncAfsListReqBO.setPurAccount(mainOrderDetail.getOrdStakeholderRspBO().getPurAccount());
        uocEsSyncAfsListReqBO.setPurAccountName(mainOrderDetail.getOrdStakeholderRspBO().getPurAccountName());
        uocEsSyncAfsListReqBO.setServState(afterSalesDetails.getOrdAfterServiceRspBO().getServState());
        uocEsSyncAfsListReqBO.setServType(afterSalesDetails.getOrdAfterServiceRspBO().getServType());
        uocEsSyncAfsListReqBO.setCreateTime(afterSalesDetails.getOrdAfterServiceRspBO().getCreateTime());
        uocEsSyncAfsListReqBO.setCreateOperId(afterSalesDetails.getOrdAfterServiceRspBO().getCreateOperId());
        uocEsSyncAfsListReqBO.setCreateOperName(afterSalesDetails.getOrdAfterServiceRspBO().getSubmitterOperName());
        uocEsSyncAfsListReqBO.setSupNo(mainOrderDetail.getOrdStakeholderRspBO().getSupNo());
        uocEsSyncAfsListReqBO.setSupName(mainOrderDetail.getOrdStakeholderRspBO().getSupName());
        UocAfterSalesDetailsListQueryBO afterSalesDetailsListQueryBO = new UocAfterSalesDetailsListQueryBO();
        afterSalesDetailsListQueryBO.setOrdAfterServiceRspBO(afterSalesDetails.getOrdAfterServiceRspBO());
        afterSalesDetailsListQueryBO.setOrdAsItemRspBOList(afterSalesDetails.getOrdAsItemRspBOList());
        afterSalesDetailsListQueryBO.setAfsAccessoryList(afterSalesDetails.getAfsAccessoryList());
        afterSalesDetailsListQueryBO.setOrderRspBO(mainOrderDetail.getOrderRspBO());
        afterSalesDetailsListQueryBO.setOrdStakeholderRspBO(mainOrderDetail.getOrdStakeholderRspBO());
        afterSalesDetailsListQueryBO.setOrdAgrAgreementRspBO(mainOrderDetail.getOrdAgreementRspBO());
        afterSalesDetailsListQueryBO.setOrdInvoiceRspBO(mainOrderDetail.getOrdInvoiceRspBO());
        afterSalesDetailsListQueryBO.setOrderAccessoryList(mainOrderDetail.getOrderAccessoryList());
        if (CollectionUtils.isNotEmpty((Collection)payOrderDetail.getPayOrderDetailRspBOList())) {
            afterSalesDetailsListQueryBO.setAfsPayRspBO(((UocPayOrderDetailRspBO)payOrderDetail.getPayOrderDetailRspBOList().get(0)).getOrdPayRspBO());
            afterSalesDetailsListQueryBO.setAfsPayItemRspBOList(((UocPayOrderDetailRspBO)payOrderDetail.getPayOrderDetailRspBOList().get(0)).getOrdPayItemRspBOList());
        }
        uocEsSyncAfsListReqBO.setObjJson(JSONObject.toJSONString((Object)afterSalesDetailsListQueryBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return uocEsSyncAfsListReqBO;
    }

    private UocPurchaseSingleDetailsQueryRspBO getPurchaseSingleDetails(UocOrdIdxSyncReqBO reqBO) {
        UocPurchaseSingleDetailsQueryReqBO purchaseSingleDetailsQueryReqBO = new UocPurchaseSingleDetailsQueryReqBO();
        purchaseSingleDetailsQueryReqBO.setOrderId(reqBO.getOrderId());
        purchaseSingleDetailsQueryReqBO.setPurchaseVoucherId(reqBO.getObjId());
        UocPurchaseSingleDetailsQueryRspBO purchaseSingleDetailsQueryRspBO = this.purchaseSingleDetailsQueryBusiService.getPurchaseSingleDetailsQuery(purchaseSingleDetailsQueryReqBO);
        if (!"0000".equals(purchaseSingleDetailsQueryRspBO.getRespCode())) {
            throw new UocProBusinessException(purchaseSingleDetailsQueryRspBO.getRespCode(), purchaseSingleDetailsQueryRspBO.getRespDesc());
        }
        return purchaseSingleDetailsQueryRspBO;
    }

    private UocOrdIdxSyncRspBO dealPurchaseSingleDetailsSync(UocPurchaseSingleDetailsQueryRspBO purchaseSingleDetails, UocMainOrderDetailQueryRspBO mainOrderDetail, UocPayOrderDetailQueryRspBO payOrderDetail) {
        UocOrdIdxSyncRspBO rspBO = new UocOrdIdxSyncRspBO();
        UocEsSyncPurchaseListReqBO esSyncPurchaseListReqBO = new UocEsSyncPurchaseListReqBO();
        esSyncPurchaseListReqBO.setObjId(purchaseSingleDetails.getOrdPurchaseRspBO().getPurchaseVoucherId());
        esSyncPurchaseListReqBO.setObjType(UocCoreConstant.OBJ_TYPE.PURCHASE);
        esSyncPurchaseListReqBO.setOrderId(purchaseSingleDetails.getOrdPurchaseRspBO().getOrderId());
        esSyncPurchaseListReqBO.setPurchaseState(purchaseSingleDetails.getOrdPurchaseRspBO().getPurchaseState());
        esSyncPurchaseListReqBO.setOrderSource(purchaseSingleDetails.getOrdPurchaseRspBO().getOrderSource());
        esSyncPurchaseListReqBO.setProtocolNo(mainOrderDetail.getOrdAgreementRspBO().getAgreementId());
        esSyncPurchaseListReqBO.setCreateTime(mainOrderDetail.getOrderRspBO().getCreateTime());
        UocEsQryPurchaseListSingleBO esQryPurchaseListSingleBO = new UocEsQryPurchaseListSingleBO();
        UocPurchaseSingleDetailsListQueryBO purchaseSingleDetailsListQueryBO = new UocPurchaseSingleDetailsListQueryBO();
        purchaseSingleDetailsListQueryBO.setOrdPurchase(purchaseSingleDetails.getOrdPurchaseRspBO());
        purchaseSingleDetailsListQueryBO.setOrdPurchaseItemDetailsBOList(purchaseSingleDetails.getOrdPurchaseItemRspBOList());
        purchaseSingleDetailsListQueryBO.setPurchaseAccessoryList(purchaseSingleDetails.getPurchaseAccessoryList());
        purchaseSingleDetailsListQueryBO.setOrderRspBO(mainOrderDetail.getOrderRspBO());
        purchaseSingleDetailsListQueryBO.setOrdStakeholderRspBO(mainOrderDetail.getOrdStakeholderRspBO());
        purchaseSingleDetailsListQueryBO.setOrdAgrAgreementRspBO(mainOrderDetail.getOrdAgreementRspBO());
        purchaseSingleDetailsListQueryBO.setOrdInvoiceRspBO(mainOrderDetail.getOrdInvoiceRspBO());
        purchaseSingleDetailsListQueryBO.setOrderAccessoryList(mainOrderDetail.getOrderAccessoryList());
        if (CollectionUtils.isNotEmpty((Collection)payOrderDetail.getPayOrderDetailRspBOList())) {
            purchaseSingleDetailsListQueryBO.setPurchasePayRspBO(((UocPayOrderDetailRspBO)payOrderDetail.getPayOrderDetailRspBOList().get(0)).getOrdPayRspBO());
            purchaseSingleDetailsListQueryBO.setPurchasePayItemRspBOList(((UocPayOrderDetailRspBO)payOrderDetail.getPayOrderDetailRspBOList().get(0)).getOrdPayItemRspBOList());
        }
        esSyncPurchaseListReqBO.setObjJson(JSONObject.toJSONString((Object)purchaseSingleDetailsListQueryBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        UocEsSyncPurchaseListRspBO esSyncPurchaseListRspBO = this.uocEsSyncPurchaseListBusiService.esSyncPurchaseList(esSyncPurchaseListReqBO);
        if (!"0000".equals(esSyncPurchaseListRspBO.getRespCode())) {
            rspBO.setRespCode("0100");
            rspBO.setRespDesc("\u540c\u6b65\u91c7\u8d2d\u5355\u7d22\u5f15\u5230ES\u5931\u8d25!");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

