/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.comb.pay;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.pec.bo.pay.UocPebUpdatePayStatusReqBO;
import com.tydic.order.pec.bo.pay.UocPebUpdatePayStatusRspBO;
import com.tydic.order.pec.busi.pay.UocPebUpdatePayStatusBusiService;
import com.tydic.order.pec.comb.es.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.pec.comb.pay.UocPebUpdatePayStatusCombService;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdPayMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdPayPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrderPO;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocPebUpdatePayStatusCombServiceImpl
implements UocPebUpdatePayStatusCombService {
    private final UocPebUpdatePayStatusBusiService uocPebUpdatePayStatusBusiService;
    private final OrdPayMapper ordPayMapper;
    private final OrderMapper orderMapper;
    private final OrdSaleMapper ordSaleMapper;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    @Autowired
    public UocPebUpdatePayStatusCombServiceImpl(UocPebUpdatePayStatusBusiService uocPebUpdatePayStatusBusiService, OrdPayMapper ordPayMapper, OrderMapper orderMapper, OrdSaleMapper ordSaleMapper) {
        this.uocPebUpdatePayStatusBusiService = uocPebUpdatePayStatusBusiService;
        this.ordPayMapper = ordPayMapper;
        this.orderMapper = orderMapper;
        this.ordSaleMapper = ordSaleMapper;
    }

    public UocPebUpdatePayStatusRspBO updatePayStatus(UocPebUpdatePayStatusReqBO reqBO) {
        UocPebUpdatePayStatusRspBO rspBO = new UocPebUpdatePayStatusRspBO();
        rspBO.setRespCode("0000");
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(Long.valueOf(reqBO.getOrderId()));
        orderPO = this.orderMapper.getModelBy(orderPO);
        if (null == orderPO) {
            rspBO.setRespCode("10000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u8ba2\u5355[" + reqBO.getOrderId() + "]\u7684\u4fe1\u606f");
            return rspBO;
        }
        int interType = 0;
        OrdPayPO ordPayPO = new OrdPayPO();
        if (null != orderPO.getUpperOrderId() && 0L != orderPO.getUpperOrderId()) {
            ordPayPO.setOrderId(orderPO.getUpperOrderId());
        } else {
            ordPayPO.setOrderId(orderPO.getOrderId());
        }
        ordPayPO.setInterType(Integer.valueOf(interType));
        ordPayPO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        ordPayPO = this.ordPayMapper.getModelBy(ordPayPO);
        if (null == ordPayPO) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u8ba2\u5355[" + reqBO.getOrderId() + "]\u7684\u652f\u4ed8\u5355\u4fe1\u606f");
            return rspBO;
        }
        if (PecConstant.PAY_STAT_SUCCESS.equals(ordPayPO.getPayState())) {
            if (null != orderPO.getUpperOrderId() && 0L != orderPO.getUpperOrderId()) {
                OrdSalePO ordSalePO = new OrdSalePO();
                ordSalePO.setOrderId(Long.valueOf(reqBO.getOrderId()));
                ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
                if (null == ordSalePO) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u8ba2\u5355[" + reqBO.getOrderId() + "]\u7684\u9500\u552e\u5355\u4fe1\u606f");
                    return rspBO;
                }
                this.syncSaleOrder(Long.valueOf(reqBO.getOrderId()), ordSalePO.getSaleVoucherId());
            }
            rspBO.setRespDesc("\u5f53\u524d\u8ba2\u5355\u652f\u4ed8\u5355\u72b6\u6001\u5df2\u4fee\u6539");
            return rspBO;
        }
        reqBO.setPayVoucherId(ordPayPO.getPayVoucherId());
        reqBO.setOrderType(orderPO.getOrderType());
        rspBO = this.uocPebUpdatePayStatusBusiService.updatePayStatus(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.syncSaleOrder(ordPayPO.getOrderId(), ordPayPO.getObjId());
        }
        return rspBO;
    }

    private void syncSaleOrder(Long orderId, Long saleVoucherId) {
        UocPebOrdIdxSyncReqBO syncReqBO = new UocPebOrdIdxSyncReqBO();
        syncReqBO.setObjId(saleVoucherId);
        syncReqBO.setOrderId(orderId);
        syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)syncReqBO)));
    }
}

