/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.order.extend.ability.order.UocProInspectionConfigQryAbilityService;
import com.tydic.order.extend.ability.order.bo.UocProInspectionConfigQryAbilityCommodityBo;
import com.tydic.order.extend.ability.order.bo.UocProInspectionConfigQryAbilityReqBo;
import com.tydic.order.extend.ability.order.bo.UocProInspectionConfigQryAbilityRspBo;
import com.tydic.order.uoc.constant.UocProDicValueConstants;
import com.tydic.order.uoc.dao.SysDicDictionaryMapper;
import com.tydic.order.uoc.dao.UocConfInspectionMapper;
import com.tydic.order.uoc.dao.po.DicDictionary;
import com.tydic.order.uoc.dao.po.UocConfInspectionPo;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=UocProInspectionConfigQryAbilityService.class)
public class UocProInspectionConfigQryAbilityServiceImpl
implements UocProInspectionConfigQryAbilityService {
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;
    @Autowired
    private UocConfInspectionMapper uocConfInspectionMapper;

    public UocProInspectionConfigQryAbilityRspBo qryConfig(UocProInspectionConfigQryAbilityReqBo reqBo) {
        this.validateArgs(reqBo);
        UocProInspectionConfigQryAbilityRspBo rspBo = (UocProInspectionConfigQryAbilityRspBo)UocProRspBoUtil.success(UocProInspectionConfigQryAbilityRspBo.class);
        UocConfInspectionPo qryPo = new UocConfInspectionPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryPo);
        List uocConfInspectionPos = this.uocConfInspectionMapper.qryList(qryPo);
        if (ObjectUtil.isEmpty((Object)uocConfInspectionPos)) {
            return (UocProInspectionConfigQryAbilityRspBo)UocProRspBoUtil.failed((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e", UocProInspectionConfigQryAbilityRspBo.class);
        }
        Map<String, String> busiTypeDic = this.sysDicDictionaryMapper.selectByPCode("INSPECTION_BUSI_TYPE").stream().collect(Collectors.toMap(DicDictionary::getCode, DicDictionary::getTitle));
        Map<String, String> inspectTypeDic = this.sysDicDictionaryMapper.selectByPCode("INSPECTION_TYPE").stream().collect(Collectors.toMap(DicDictionary::getCode, DicDictionary::getTitle));
        if (UocProDicValueConstants.INSPECTION_TYPE_ALL.equals(reqBo.getInspectionType())) {
            rspBo.setAllExcessPercent(((UocConfInspectionPo)uocConfInspectionPos.get(0)).getExcessPercent());
        } else {
            for (UocConfInspectionPo tmpPo : uocConfInspectionPos) {
                UocProInspectionConfigQryAbilityCommodityBo tmpBo = new UocProInspectionConfigQryAbilityCommodityBo();
                BeanUtils.copyProperties((Object)tmpPo, (Object)tmpBo);
                rspBo.getCommodityDatas().add(tmpBo);
            }
        }
        rspBo.setBusiTypeName(busiTypeDic.get(reqBo.getBusiType().toString()));
        rspBo.setInspectionTypeName(inspectTypeDic.get(reqBo.getInspectionType().toString()));
        rspBo.setInspectionType(reqBo.getInspectionType());
        rspBo.setBusiType(reqBo.getBusiType());
        return rspBo;
    }

    private void validateArgs(UocProInspectionConfigQryAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getBusiType())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61[busiType]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getInspectionType())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61[inspectionType]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UocProDicValueConstants.INSPECTION_TYPE_ALL.equals(reqBo.getInspectionType()) && !UocProDicValueConstants.INSPECTION_TYPE_COMMODITY.equals(reqBo.getInspectionType())) {
            throw new UocProBusinessException("8888", "\u65e0\u6548\u7684inspectionType\uff08" + reqBo.getInspectionType() + "\uff09");
        }
    }
}

