/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.pec.bo.other.UocOrdIdxSyncReqBO;
import com.tydic.order.uoc.ability.UocProOrderDeleteAbilityService;
import com.tydic.order.uoc.ability.bo.UocProOrderDeleteAbilityReqBo;
import com.tydic.order.uoc.ability.bo.UocProOrderDeleteAbilityRspBo;
import com.tydic.order.uoc.atom.order.UocCoreStateCheckAtomService;
import com.tydic.order.uoc.bo.order.UocCoreStateCheckAtomReqBO;
import com.tydic.order.uoc.bo.order.UocCoreStateCheckAtomRspBO;
import com.tydic.order.uoc.busi.UocProOrderDeleteBusiService;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=UocProOrderDeleteAbilityService.class)
public class UocProOrderDeleteAbilityServiceImpl
implements UocProOrderDeleteAbilityService {
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private UocProOrderDeleteBusiService uocProOrderDeleteBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;

    public UocProOrderDeleteAbilityRspBo deleteOrder(UocProOrderDeleteAbilityReqBo reqBo) {
        UocProOrderDeleteAbilityRspBo rspBo;
        this.validateArgs(reqBo);
        this.stateCheck(reqBo);
        if (null == reqBo.getUserId() || 0L == reqBo.getUserId()) {
            reqBo.setUserId(reqBo.getUserIdIn());
        }
        if (!"0000".equals((rspBo = this.uocProOrderDeleteBusiService.deleteOrder(reqBo)).getRespCode())) {
            throw new UocProBusinessException(rspBo.getRespCode(), rspBo.getRespDesc());
        }
        this.syncSale(reqBo);
        return rspBo;
    }

    private void validateArgs(UocProOrderDeleteAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId() || 0L == reqBo.getOrderId()) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61[orderId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleVoucherId() || 0L == reqBo.getSaleVoucherId()) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61[saleVoucherId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void stateCheck(UocProOrderDeleteAbilityReqBo reqBo) {
        UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
        uocCoreStateCheckAtomReqBO.setActionCode("ORDER_DELETE");
        uocCoreStateCheckAtomReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocCoreStateCheckAtomReqBO.setObjId(reqBo.getSaleVoucherId());
        uocCoreStateCheckAtomReqBO.setOrderId(reqBo.getOrderId());
        UocCoreStateCheckAtomRspBO uocCoreStateCheck = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO);
        if (!"0000".equals(uocCoreStateCheck.getRespCode())) {
            throw new UocProBusinessException("0100", "\u8be5\u8ba2\u5355\u4e0d\u5141\u8bb8\u8fdb\u884c\u5220\u9664\u64cd\u4f5c");
        }
        reqBo.setSaleState(Integer.valueOf(uocCoreStateCheck.getObjState()));
    }

    private void syncSale(UocProOrderDeleteAbilityReqBo reqBo) {
        UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdSaleIdxSyncReqBO.setObjId(reqBo.getSaleVoucherId());
        uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdSaleIdxSyncReqBO.setOrderId(reqBo.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
    }
}

