/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.order.uoc.ability.UocProOrderQuotaAllocationDealAbilityService;
import com.tydic.order.uoc.ability.bo.UocProOrderQuotaAllocationDealReqBo;
import com.tydic.order.uoc.ability.bo.UocProOrderQuotaAllocationDealRspBo;
import com.tydic.order.uoc.busi.UocProOrderQuotaAllocationDealBusiService;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=UocProOrderQuotaAllocationDealAbilityService.class)
public class UocProOrderQuotaAllocationDealAbilityServiceImpl
implements UocProOrderQuotaAllocationDealAbilityService {
    @Autowired
    private UocProOrderQuotaAllocationDealBusiService uocProOrderQuotaAllocationDealBusiService;

    public UocProOrderQuotaAllocationDealRspBo dealOrderQuotaAllocation(UocProOrderQuotaAllocationDealReqBo reqBo) {
        this.validateArgs(reqBo);
        UocProOrderQuotaAllocationDealRspBo rspBo = this.uocProOrderQuotaAllocationDealBusiService.dealOrderQuotaAllocation(reqBo);
        if (!"0000".equals(rspBo.getRespCode())) {
            return (UocProOrderQuotaAllocationDealRspBo)UocProRspBoUtil.failed((String)rspBo.getRespDesc(), UocProOrderQuotaAllocationDealRspBo.class);
        }
        return rspBo;
    }

    private void validateArgs(UocProOrderQuotaAllocationDealReqBo reqBo) {
        if (null == reqBo) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSupNo() || 0L == reqBo.getSupNo()) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[supNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOperateType()) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[operateType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (1 == reqBo.getOperateType()) {
            if (!StringUtils.hasText((String)reqBo.getSupplierName())) {
                throw new UocProBusinessException("8888", "\u5165\u53c2[supplierName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)reqBo.getBusinessTypeCode())) {
                throw new UocProBusinessException("8888", "\u5165\u53c2[businessTypeCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.isPositiveIntegerValue(reqBo.getOrderQuota());
        } else if (2 == reqBo.getOperateType()) {
            this.isPositiveIntegerValue(reqBo.getOrderQuota());
        } else if (3 != reqBo.getOperateType()) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[operateType]\u4e0d\u5408\u6cd5");
        }
    }

    private void isPositiveIntegerValue(BigDecimal bigDecimal) {
        if (null != bigDecimal) {
            if (BigDecimal.ZERO.compareTo(bigDecimal) >= 0) {
                throw new UocProBusinessException("8888", "\u5165\u53c2[orderQuota]\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
            }
            if (bigDecimal.stripTrailingZeros().scale() > 0) {
                throw new UocProBusinessException("8888", "\u5165\u53c2[orderQuota]\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
            }
        } else {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderQuota]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

