/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.atom.impl.core;

import com.tydic.order.uoc.atom.core.UocCoreCreatePayOrderAtomService;
import com.tydic.order.uoc.atom.core.UocCoreExtFieldInAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreCreatePayOrderReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreCreatePayOrderRspBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreExtFieldInReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreExtFieldInRspBO;
import com.tydic.order.uoc.atom.impl.core.UocCoreExtFieldInAtomServiceImpl;
import com.tydic.order.uoc.atom.process.UocStartProcessAtomService;
import com.tydic.order.uoc.bo.order.UocOrderPayItemBO;
import com.tydic.order.uoc.bo.process.UocProcessStartReqBO;
import com.tydic.order.uoc.bo.process.UocProcessStartRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdPayItemMapper;
import com.tydic.order.uoc.dao.OrdPayMapper;
import com.tydic.order.uoc.dao.po.OrdPayItemPO;
import com.tydic.order.uoc.dao.po.OrdPayPO;
import com.tydic.order.uoc.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreCreatePayOrderAtomService")
public class UocCoreCreatePayOrderAtomServiceImpl
implements UocCoreCreatePayOrderAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UocCoreCreatePayOrderAtomServiceImpl.class);
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrdPayItemMapper ordPayItemMapper;
    @Autowired
    private UocCoreExtFieldInAtomService uocCoreExtFieldInAtomService;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private UocStartProcessAtomService uocStartProcessAtomService;

    @Override
    public UocCoreCreatePayOrderRspBO dealCoreCreatePayOrder(UocCoreCreatePayOrderReqBO reqBO) {
        boolean hasExtField;
        this.validParam(reqBO);
        UocCoreCreatePayOrderRspBO rspBO = new UocCoreCreatePayOrderRspBO();
        OrdPayPO ordPayPO = new OrdPayPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)ordPayPO);
        if (ordPayPO.getPayState() == null) {
            ordPayPO.setPayState(UocConstant.PAY_ORDER_STATUS.CREATE);
        }
        try {
            long payVoucherId = this.sequence.nextId();
            ordPayPO.setPayVoucherId(Long.valueOf(payVoucherId));
            if (StringUtils.isNotBlank((CharSequence)reqBO.getProcDefKey())) {
                UocProcessStartRspBO uocProcessStartRspBO = this.startProcess(reqBO.getOrderId(), payVoucherId, reqBO.getProcDefKey());
                ordPayPO.setPayState(Integer.valueOf(Integer.parseInt(uocProcessStartRspBO.getStepId())));
            }
            this.ordPayMapper.insert(ordPayPO);
            if (reqBO.getUocOrderPayItemList() != null && reqBO.getUocOrderPayItemList().size() > 0) {
                ArrayList<OrdPayItemPO> payItemList = new ArrayList<OrdPayItemPO>(reqBO.getUocOrderPayItemList().size());
                for (UocOrderPayItemBO itemBO : reqBO.getUocOrderPayItemList()) {
                    OrdPayItemPO ordPayItemPO = new OrdPayItemPO();
                    BeanUtils.copyProperties((Object)itemBO, (Object)ordPayItemPO);
                    ordPayItemPO.setPayVoucherId(ordPayPO.getPayVoucherId());
                    ordPayItemPO.setOrderId(reqBO.getOrderId());
                    ordPayItemPO.setPayItemId(Long.valueOf(this.sequence.nextId()));
                    if (itemBO.getPurchaseCount() == null) {
                        ordPayItemPO.setPurchaseCount(new BigDecimal(0));
                    }
                    if (itemBO.getPayCount() == null) {
                        ordPayItemPO.setPayCount(new BigDecimal(0));
                    }
                    if (itemBO.getReduceFee() == null) {
                        ordPayItemPO.setReduceFee(Long.valueOf(0L));
                    }
                    if (itemBO.getPayFee() == null) {
                        ordPayItemPO.setPayFee(Long.valueOf(0L));
                    }
                    payItemList.add(ordPayItemPO);
                }
                this.ordPayItemMapper.insertBatch(payItemList);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u652f\u4ed8\u5355\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u521b\u5efa\u652f\u4ed8\u5355\u5f02\u5e38");
            return rspBO;
        }
        boolean bl = hasExtField = reqBO.getCruFieldList() != null && reqBO.getCruFieldList().size() > 0 || reqBO.getExtFieldList() != null && reqBO.getExtFieldList().size() > 0;
        if (hasExtField) {
            UocCoreExtFieldInReqBO extFieldInAtomReqBO = new UocCoreExtFieldInReqBO();
            extFieldInAtomReqBO.setOrderId(reqBO.getOrderId());
            extFieldInAtomReqBO.setCruFieldList(reqBO.getCruFieldList());
            extFieldInAtomReqBO.setExtFieldList(reqBO.getExtFieldList());
            extFieldInAtomReqBO.setObjId(ordPayPO.getPayVoucherId());
            extFieldInAtomReqBO.setObjType(UocConstant.OBJ_TYPE.PAY);
            UocCoreExtFieldInRspBO extFieldInAtomRspBO = this.uocCoreExtFieldInAtomService.dealCoreExtFieldIn(extFieldInAtomReqBO);
            if (!"0000".equals(extFieldInAtomRspBO.getRespCode())) {
                rspBO.setRespCode(extFieldInAtomRspBO.getRespCode());
                rspBO.setRespDesc(extFieldInAtomRspBO.getRespDesc());
                return rspBO;
            }
        }
        rspBO.setPayVoucherID(ordPayPO.getPayVoucherId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u521b\u5efa\u652f\u4ed8\u5355\u6210\u529f");
        return rspBO;
    }

    private void validParam(UocCoreCreatePayOrderReqBO reqBO) {
        if (reqBO == null || reqBO.getOrderId() == null) {
            throw new UocProBusinessException("7777", "\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPayType() == null) {
            reqBO.setPayType(2);
        } else {
            if (reqBO.getFeeType() == null) {
                throw new UocProBusinessException("7777", "\u8d27\u6b3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getObjType() == null) {
                throw new UocProBusinessException("7777", "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!UocConstant.OBJ_TYPE.ORDER.equals(reqBO.getObjType())) {
                if (reqBO.getObjId() == null) {
                    throw new UocProBusinessException("7777", "\u5355\u636eId\u4e0d\u80fd\u4e3a\u7a7a");
                }
            } else if (reqBO.getUocOrderPayItemList() != null && reqBO.getUocOrderPayItemList().size() > 0) {
                for (UocOrderPayItemBO itemBO : reqBO.getUocOrderPayItemList()) {
                    if (itemBO.getOrdItemId() == null) {
                        throw new UocProBusinessException("7777", "\u9500\u552e\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (itemBO.getTotalFee() != null) continue;
                    throw new UocProBusinessException("7777", "\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                }
            } else if (reqBO.getCruFieldList() != null && reqBO.getCruFieldList().size() > 0) {
                UocCoreExtFieldInAtomServiceImpl.validList(reqBO.getCruFieldList());
            } else if (reqBO.getExtFieldList() != null && reqBO.getExtFieldList().size() > 0) {
                UocCoreExtFieldInAtomServiceImpl.validList(reqBO.getExtFieldList());
            }
        }
    }

    private UocProcessStartRspBO startProcess(Long orderId, Long objId, String procDefKey) {
        UocProcessStartReqBO processStartReqBO = new UocProcessStartReqBO();
        processStartReqBO.setProcDefId("UOC");
        processStartReqBO.setProcDefKey(procDefKey);
        processStartReqBO.setSysCode("UOC");
        processStartReqBO.setObjId(objId);
        processStartReqBO.setObjType(UocConstant.OBJ_TYPE.PAY);
        processStartReqBO.setOrderId(orderId);
        UocProcessStartRspBO uocProcessStartRspBO = this.uocStartProcessAtomService.start(processStartReqBO);
        if (!"0000".equals(uocProcessStartRspBO.getRespCode())) {
            throw new UocProBusinessException(uocProcessStartRspBO.getRespCode(), uocProcessStartRspBO.getRespDesc());
        }
        return uocProcessStartRspBO;
    }
}

