/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.atom.impl.other;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.order.uoc.atom.impl.other.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.order.uoc.atom.impl.other.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.plugin.encoded.service.EncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.EncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.EncodedSerialGetServiceRspBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UocProGetVoucherNoAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocProGetVoucherNoAtomService.class);
    @Autowired
    private EncodedSerialGetService encodedSerialGetService;
    @Value(value="${voucher.generate.switch:true}")
    private boolean voucherGenerateSwitch;

    public UocProGetVoucherNoAtomRspBo getVoucherNo(UocProGetVoucherNoAtomReqBo reqBo) {
        UocProGetVoucherNoAtomRspBo rspBo = (UocProGetVoucherNoAtomRspBo)UocProRspBoUtil.success(UocProGetVoucherNoAtomRspBo.class);
        if (!this.voucherGenerateSwitch) {
            rspBo.setVoucherGenerated(false);
            rspBo.setRespDesc("\u8be5\u7f16\u53f7\u53ea\u80fd\u4f7f\u7528\u914d\u7f6e\u4e2d\u5fc3\u751f\u6210\u7f16\u53f7");
            return rspBo;
        }
        this.validateArgs(reqBo);
        EncodedSerialGetServiceReqBO getBo = new EncodedSerialGetServiceReqBO();
        getBo.setCenter("UOC");
        getBo.setEncodedRuleCode(reqBo.getVoucherNoKey() + "_" + reqBo.getOrderSource());
        getBo.setOrgType("-1");
        log.info("\u83b7\u53d6\u7f16\u53f7\u5165\u53c2\uff1a" + JSON.toJSONString((Object)getBo));
        try {
            EncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(getBo);
            log.info("\u83b7\u53d6\u7f16\u53f7\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)encodedSerial));
            if (ObjectUtil.isEmpty((Object)encodedSerial.getSerialNoList())) {
                return (UocProGetVoucherNoAtomRspBo)UocProRspBoUtil.failed((String)"\u83b7\u53d6\u7f16\u53f7\u8fd4\u56delist\u4e3a\u7a7a", UocProGetVoucherNoAtomRspBo.class);
            }
            rspBo.setVoucherNo((String)encodedSerial.getSerialNoList().get(0));
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff1a" + e.getMessage());
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        return rspBo;
    }

    private void validateArgs(UocProGetVoucherNoAtomReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u7f16\u53f7\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getVoucherNoKey())) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u7f16\u53f7\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[voucherNoKey]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderSource())) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u7f16\u53f7\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderSource]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

