/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.atom.impl.ship;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.order.uoc.atom.impl.inspection.UocProInspectionConfigAtomService;
import com.tydic.order.uoc.atom.impl.inspection.bo.UocProQryCommodityTypeReqBo;
import com.tydic.order.uoc.atom.impl.inspection.bo.UocProQrySkuInspectionConfigRspBo;
import com.tydic.order.uoc.atom.ship.UocCoreShipDetailsQueryAtomService;
import com.tydic.order.uoc.bo.afterservice.AfterServBO;
import com.tydic.order.uoc.bo.common.OrdAccessoryPO;
import com.tydic.order.uoc.bo.order.OrdGoodsGiftRspBO;
import com.tydic.order.uoc.bo.other.OrdAccessoryRspBO;
import com.tydic.order.uoc.bo.ship.OrdShipItemRspBO;
import com.tydic.order.uoc.bo.ship.OrdShipRspBO;
import com.tydic.order.uoc.bo.ship.UocCoreShipDetailsQueryReqBO;
import com.tydic.order.uoc.bo.ship.UocCoreShipDetailsQueryRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdAccessoryMapper;
import com.tydic.order.uoc.dao.OrdAfterServiceMapper;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdGoodsGiftMapper;
import com.tydic.order.uoc.dao.OrdGoodsMapper;
import com.tydic.order.uoc.dao.OrdItemMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdShipItemMapper;
import com.tydic.order.uoc.dao.OrdShipMapper;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdGoodsGiftPO;
import com.tydic.order.uoc.dao.po.OrdGoodsPO;
import com.tydic.order.uoc.dao.po.OrdItemPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdShipItemPO;
import com.tydic.order.uoc.dao.po.OrdShipPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreShipDetailsQueryAtomService")
public class UocCoreShipDetailsQueryAtomServiceImpl
implements UocCoreShipDetailsQueryAtomService {
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdGoodsGiftMapper ordGoodsGiftMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocProInspectionConfigAtomService uocProInspectionConfigAtomService;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;

    @Override
    public UocCoreShipDetailsQueryRspBO getShipDetailsQuery(UocCoreShipDetailsQueryReqBO reqBO) {
        UocCoreShipDetailsQueryRspBO rspBO = new UocCoreShipDetailsQueryRspBO();
        this.validateParams(reqBO);
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY_NOT.equals(reqBO.getQueryLevel())) {
            OrdShipRspBO ordShipRspBO = this.buildOrdShipRspBO(reqBO);
            rspBO.setOrdShipRspBO(ordShipRspBO);
        }
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
            rspBO.setShipAccessoryRspList(this.buildAdjustAccessoryList(reqBO));
        }
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM_NOT.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
            List<OrdShipItemRspBO> ordShipItemRspBOList = this.buildOrdShipItemRspBOList(reqBO);
            if (CollectionUtils.isEmpty(ordShipItemRspBOList)) {
                if (UocCoreConstant.QUERY_LEVEL.QUERY_ITEM_NOT.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
                    rspBO.setRespCode("0200");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u53d1\u8d27\u660e\u7ec6Item\u4fe1\u606f:" + reqBO.getOrderId());
                    return rspBO;
                }
            } else {
                rspBO.setOrdShipItemRspBOList(ordShipItemRspBOList);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParams(UocCoreShipDetailsQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("0001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("0001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("0002", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (null == reqBO.getShipVoucherId()) {
            throw new UocProBusinessException("0001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u53d1\u8d27\u5355ID\u3010shipVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getShipVoucherId()) {
            throw new UocProBusinessException("0002", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u53d1\u8d27\u5355ID\u3010shipVoucherId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
    }

    private OrdShipRspBO buildOrdShipRspBO(UocCoreShipDetailsQueryReqBO reqBO) {
        OrdShipRspBO ordShipRspBO = new OrdShipRspBO();
        OrdShipPO shipPO = new OrdShipPO();
        shipPO.setOrderId(reqBO.getOrderId());
        shipPO.setShipVoucherId(reqBO.getShipVoucherId());
        OrdShipPO ordShipPO = this.ordShipMapper.getModelBy(shipPO);
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        OrdSalePO ordSale = this.ordSaleMapper.getModelBy(ordSalePO);
        if (ordSale != null) {
            if (StringUtils.isNotBlank((CharSequence)ordSale.getChnlType())) {
                ordShipRspBO.setDeliveryWay(ordSale.getChnlType());
            } else {
                ordShipRspBO.setDeliveryWay("1");
            }
        }
        if (null == ordShipPO) {
            return ordShipRspBO;
        }
        BeanUtils.copyProperties((Object)ordShipPO, (Object)ordShipRspBO);
        ordShipRspBO.setShipExtraMap(this.buildShipExtraInfoMap(reqBO));
        AfterServBO afterServBO = new AfterServBO();
        afterServBO.setShipVoucherId(ordShipPO.getShipVoucherId());
        afterServBO.setOrderId(ordShipPO.getOrderId());
        ArrayList<Integer> notStatus = new ArrayList<Integer>(2);
        notStatus.add(UocConstant.AFS_ORDER_STATUS.SUCCESS);
        notStatus.add(UocConstant.ZONE_AFS_STATUS.COMPLETE);
        afterServBO.setNotStatus(notStatus);
        int notEndCount = this.ordAfterServiceMapper.getNotEndCount(afterServBO);
        if (0 < notEndCount) {
            ordShipRspBO.setIsUndoneAfter(Integer.valueOf(0));
        } else {
            ordShipRspBO.setIsUndoneAfter(Integer.valueOf(1));
        }
        return ordShipRspBO;
    }

    private Map<String, Object> buildShipExtraInfoMap(UocCoreShipDetailsQueryReqBO reqBO) {
        HashMap<String, Object> orderExtraMap = new HashMap<String, Object>(16);
        OrdExtMapPO ordExtMapCondition = new OrdExtMapPO();
        ordExtMapCondition.setOrderId(reqBO.getOrderId());
        ordExtMapCondition.setObjId(reqBO.getShipVoucherId());
        ordExtMapCondition.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
        List ordExtMapList = this.ordExtMapMapper.getList(ordExtMapCondition);
        if (!CollectionUtils.isNotEmpty((Collection)ordExtMapList)) {
            for (OrdExtMapPO ordExtMap : ordExtMapList) {
                orderExtraMap.put(ordExtMap.getFieldCode(), ordExtMap.getFieldValue());
            }
        }
        return orderExtraMap;
    }

    private List<OrdAccessoryRspBO> buildAdjustAccessoryList(UocCoreShipDetailsQueryReqBO reqBO) {
        OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
        ordAccessoryPO.setOrderId(reqBO.getOrderId());
        ordAccessoryPO.setObjectId(reqBO.getShipVoucherId());
        ordAccessoryPO.setObjectType(UocCoreConstant.OBJ_TYPE.SHIP);
        List ordAccessoryPOList = this.ordAccessoryMapper.getList(ordAccessoryPO);
        ArrayList<OrdAccessoryRspBO> ordAccessoryRspBOList = new ArrayList<OrdAccessoryRspBO>();
        if (CollectionUtils.isNotEmpty((Collection)ordAccessoryPOList)) {
            for (OrdAccessoryPO accessoryPO : ordAccessoryPOList) {
                OrdAccessoryRspBO ordAccessoryRspBO = new OrdAccessoryRspBO();
                BeanUtils.copyProperties((Object)accessoryPO, (Object)ordAccessoryRspBO);
                ordAccessoryRspBOList.add(ordAccessoryRspBO);
            }
        }
        return ordAccessoryRspBOList;
    }

    private List<OrdShipItemRspBO> buildOrdShipItemRspBOList(UocCoreShipDetailsQueryReqBO reqBO) {
        List ordShipItemPOList;
        ArrayList<OrdShipItemRspBO> ordShipItemRspBOList = new ArrayList<OrdShipItemRspBO>();
        OrdShipItemPO shipItemPO = new OrdShipItemPO();
        shipItemPO.setOrderId(reqBO.getOrderId());
        shipItemPO.setShipVoucherId(reqBO.getShipVoucherId());
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getShipItemIdList())) {
            shipItemPO.setShipItemIdList(reqBO.getShipItemIdList());
        }
        if (CollectionUtils.isEmpty((Collection)(ordShipItemPOList = this.ordShipItemMapper.getList(shipItemPO)))) {
            return ordShipItemRspBOList;
        }
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        OrdSalePO ordSale = this.ordSaleMapper.getModelBy(ordSalePO);
        List<Long> ordItemList = ordShipItemPOList.stream().map(OrdShipItemPO::getOrdItemId).collect(Collectors.toList());
        UocProQryCommodityTypeReqBo qryCommdity = new UocProQryCommodityTypeReqBo();
        qryCommdity.setOrderId(reqBO.getOrderId());
        qryCommdity.setOrdItems(ordItemList);
        qryCommdity.setBusiType(Integer.parseInt(ordSale.getOrderSource()));
        UocProQrySkuInspectionConfigRspBo uocProQrySkuInspectionConfigRspBo = this.uocProInspectionConfigAtomService.qrySkuInspections(qryCommdity);
        if (!"0000".equals(uocProQrySkuInspectionConfigRspBo.getRespCode())) {
            throw new UocProBusinessException("0100", "\u67e5\u8be2\u5546\u54c1\u7c7b\u578b\u5931\u8d25\uff1a" + uocProQrySkuInspectionConfigRspBo.getRespDesc());
        }
        Map<Long, Integer> commodityTypes = uocProQrySkuInspectionConfigRspBo.getCommodityTypes();
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(reqBO.getOrderId());
        List ordItemPOS = this.ordItemMapper.getList(itemPO);
        Map ordItemPOMap = ordItemPOS.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, Function.identity(), (ordItemPO, ordItemPO1) -> ordItemPO));
        OrdGoodsPO goodsPO = new OrdGoodsPO();
        goodsPO.setOrderId(reqBO.getOrderId());
        List ordGoodsPOS = this.ordGoodsMapper.getList(goodsPO);
        Map<Long, String> ordItemSkuMap = ordGoodsPOS.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, OrdGoodsPO::getSkuId));
        Map ordGoodsPOMap = ordGoodsPOS.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, Function.identity(), (ordGoodsPO, ordGoodsPO1) -> ordGoodsPO));
        for (OrdShipItemPO ordShipItemPO : ordShipItemPOList) {
            OrdShipItemRspBO ordShipItemRspBO = new OrdShipItemRspBO();
            BeanUtils.copyProperties((Object)ordShipItemPO, (Object)ordShipItemRspBO);
            OrdItemPO ordItemPO2 = (OrdItemPO)ordItemPOMap.get(ordShipItemPO.getOrdItemId());
            ordShipItemRspBO.setSkuId(Long.valueOf(ordItemPO2.getSkuId()));
            ordShipItemRspBO.setSkuName(ordItemPO2.getSkuName());
            ordShipItemRspBO.setPurchaseCount(ordItemPO2.getPurchaseCount());
            ordShipItemRspBO.setSalePrice(ordItemPO2.getSalePrice());
            ordShipItemRspBO.setPurchasePrice(ordItemPO2.getPurchasePrice());
            ordShipItemRspBO.setArrivalTime(DateUtils.strToDate((String)ordItemPO2.getArrivalTime()));
            OrdGoodsPO ordGoodsPO2 = (OrdGoodsPO)ordGoodsPOMap.get(ordShipItemPO.getOrdItemId());
            BeanUtils.copyProperties((Object)ordGoodsPO2, (Object)ordShipItemRspBO);
            ordShipItemRspBO.setPicUlr(ordGoodsPO2.getSkuMainPicUrl());
            ordShipItemRspBO.setSkuMaterialId(ordGoodsPO2.getSkuMaterialId());
            ordShipItemRspBO.setSkuMaterialName(ordGoodsPO2.getSkuMaterialName());
            ordShipItemRspBO.setSkuMaterialTypeId(ordGoodsPO2.getSkuMaterialTypeId());
            ordShipItemRspBO.setSkuMaterialTypeName(ordGoodsPO2.getSkuMaterialTypeName());
            ordShipItemRspBO.setSpuId(ordGoodsPO2.getSpuId());
            ordShipItemRspBO.setSupplierShopId(ordGoodsPO2.getSupplierShopId());
            ordShipItemRspBO.setSkuExtSkuId(ordGoodsPO2.getSkuExtSkuId());
            ordShipItemRspBO.setManufacturer(ordGoodsPO2.getManufacturer());
            ordShipItemRspBO.setTechnicalParameters(ordGoodsPO2.getTechnicalParameters());
            ordShipItemRspBO.setDomestic(ordGoodsPO2.getDomestic());
            ordShipItemRspBO.setStorageAge(ordGoodsPO2.getStorageAge());
            ordShipItemRspBO.setSelfMentionAddress(ordGoodsPO2.getSelfMentionAddress());
            ordShipItemRspBO.setSelfMentionTime(ordShipItemRspBO.getSelfMentionTime());
            ordShipItemRspBO.setSkuBrandName(ordGoodsPO2.getSkuBrandName());
            ordShipItemRspBO.setSpec(ordGoodsPO2.getSpec());
            ordShipItemRspBO.setModel(ordGoodsPO2.getModel());
            ordShipItemRspBO.setTexture(ordGoodsPO2.getTexture());
            OrdGoodsGiftPO goodsGiftPO = new OrdGoodsGiftPO();
            goodsGiftPO.setOrderId(ordShipItemPO.getOrderId());
            goodsGiftPO.setOrdItemId(ordShipItemPO.getOrdItemId());
            List ordGoodsGiftPOS = this.ordGoodsGiftMapper.getList(goodsGiftPO);
            List<Object> ordGoodsGiftRspBOList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)ordGoodsGiftPOS)) {
                ordGoodsGiftRspBOList = ordGoodsGiftPOS.stream().map(ordGoodsGiftPO -> {
                    OrdGoodsGiftRspBO ordGoodsGiftRspBO = new OrdGoodsGiftRspBO();
                    BeanUtils.copyProperties((Object)ordGoodsGiftPO, (Object)ordGoodsGiftRspBO);
                    return ordGoodsGiftRspBO;
                }).collect(Collectors.toList());
            }
            ordShipItemRspBO.setOrdGoodsGiftRspBOList(ordGoodsGiftRspBOList);
            ordShipItemRspBO.setTax(ordItemPO2.getTax());
            try {
                ordShipItemRspBO.setSalePriceMoney(MoneyUtils.Long2BigDecimal((Long)ordItemPO2.getSalePrice()));
                ordShipItemRspBO.setPurchasePriceMoney(MoneyUtils.Long2BigDecimal((Long)ordItemPO2.getPurchasePrice()));
            }
            catch (Exception e) {
                throw new UocProBusinessException("0100", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            }
            ordShipItemRspBO.setExceedInspection(commodityTypes.get(ordShipItemPO.getOrdItemId()));
            ordShipItemRspBOList.add(ordShipItemRspBO);
        }
        return ordShipItemRspBOList;
    }
}

