/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.uoc.busi.impl;

import com.tydic.order.uoc.atom.core.UocCoreQryTaskInstAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreQryTaskInstReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreQryTaskInstRspBO;
import com.tydic.order.uoc.bo.TaskInstBO;
import com.tydic.order.uoc.bo.task.UocCoreToErrorTaskReqBO;
import com.tydic.order.uoc.bo.task.UocCoreToErrorTaskRspBO;
import com.tydic.order.uoc.busi.UocCoreToErrorTaskBusiService;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdTaskCandidateMapper;
import com.tydic.order.uoc.dao.OrdTaskMapper;
import com.tydic.order.uoc.dao.OrdTaskRecordMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdTaskCandidatePO;
import com.tydic.order.uoc.dao.po.OrdTaskPO;
import com.tydic.order.uoc.dao.po.OrdTaskRecordPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.order.uoc.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreToErrorTaskBusiService")
public class UocCoreToErrorTaskBusiServiceImpl
implements UocCoreToErrorTaskBusiService {
    private static final Logger logger = LoggerFactory.getLogger(UocCoreToErrorTaskBusiServiceImpl.class);
    @Autowired
    private UocCoreQryTaskInstAtomService qryTaskInstAtomService;
    @Autowired
    private OrdTaskMapper ordTaskMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdTaskCandidateMapper ordTaskCandidateMapper;
    @Autowired
    private OrdTaskRecordMapper ordTaskRecordMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;

    public UocCoreToErrorTaskRspBO dealCoreToErrorTask(UocCoreToErrorTaskReqBO reqBO) {
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("7777", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long orderId = reqBO.getOrderId();
        UocCoreToErrorTaskRspBO rspBO = new UocCoreToErrorTaskRspBO();
        UocCoreQryTaskInstReqBO qryTaskInstAtomReqBO = new UocCoreQryTaskInstReqBO();
        qryTaskInstAtomReqBO.setOrderId(orderId);
        qryTaskInstAtomReqBO.setTacheCode(reqBO.getTacheCode());
        qryTaskInstAtomReqBO.setTaskId(reqBO.getTaskId());
        qryTaskInstAtomReqBO.setCurState(reqBO.getOrderState());
        UocCoreQryTaskInstRspBO qryTaskInstAtomRspBO = this.qryTaskInstAtomService.qryTaskInst(qryTaskInstAtomReqBO);
        if ("0000".equals(qryTaskInstAtomRspBO.getRespCode())) {
            TaskInstBO taskInstBO = qryTaskInstAtomRspBO.getTaskInstBO();
            OrdTaskPO ordTaskPO = new OrdTaskPO();
            ordTaskPO.setOrderId(orderId);
            ordTaskPO.setTaskId(taskInstBO.getTaskId());
            ordTaskPO.setTaskProperty(UocConstant.TASK_PROPERTY.ERROR_TASK);
            try {
                this.ordTaskMapper.updateById(ordTaskPO);
                OrdTaskRecordPO ordTaskRecordPO = new OrdTaskRecordPO();
                ordTaskRecordPO.setOrderId(orderId);
                ordTaskRecordPO.setTaskId(taskInstBO.getTaskId());
                ordTaskRecordPO.setDealDesc(reqBO.getDealDesc());
                ordTaskRecordPO.setDealOperId(reqBO.getDealOper());
                ordTaskRecordPO.setDealCode("ERROR");
                ordTaskRecordPO.setId(Long.valueOf(this.sequence.nextId()));
                this.ordTaskRecordMapper.insert(ordTaskRecordPO);
                OrderPO orderPO = this.orderMapper.getModelById(orderId.longValue());
                OrdTaskCandidatePO candidatePO = new OrdTaskCandidatePO();
                candidatePO.setOrderId(orderId);
                candidatePO.setOperId(orderPO.getCreateOperId());
                candidatePO.setTaskId(qryTaskInstAtomRspBO.getTaskInstBO().getTaskId());
                candidatePO.setId(Long.valueOf(this.sequence.nextId()));
                this.ordTaskCandidateMapper.insert(candidatePO);
            }
            catch (Exception e) {
                logger.error("\u4fee\u6539\u4efb\u52a1\u5c5e\u6027\u5f02\u5e38", (Throwable)e);
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u4fee\u6539\u4efb\u52a1\u5c5e\u6027\u5f02\u5e38");
                return rspBO;
            }
        } else {
            rspBO.setRespCode(qryTaskInstAtomRspBO.getRespCode());
            rspBO.setRespDesc(qryTaskInstAtomRspBO.getRespDesc());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4fee\u6539\u4efb\u52a1\u5c5e\u6027\u6210\u529f");
        return rspBO;
    }
}

