/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.aop;

import com.alibaba.dubbo.rpc.RpcContext;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taobao.eagleeye.EagleEye;
import com.tydic.uoc.base.bo.UocProBaseRspBo;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.springframework.core.Ordered;

public abstract class BaseAopAdvisor
implements Ordered {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String SEPARATOR = "|";
    private static final String EXCLUDE_METHODS = "subscribe";
    private static final String CLASS_METHOD_SEPARATOR = ".";
    private static final String START_IDENTIFICATION = "START";
    private static final String ERROR_IDENTIFICATION = "ERROR";
    private static final String END_IDENTIFICATION = "END";
    private static final String TRACE_ID = "traceId";
    private static final String RESP_CODE_SUCCESS = "0000";
    private static final String RESP_DESC_SUCCESS = "\u6210\u529f";
    private static final String RESP_CODE_ERROR = "8888";
    private static final String RESP_DESC_ERROR = "\u5931\u8d25";
    private static final String DEFINE_BASE_CLASS_FIELD_CODE = "respCode";
    private static final String DEFINE_BASE_CLASS_FIELD_DESC = "respDesc";

    public int getOrder() {
        return 100;
    }

    abstract Object throwAopTreat(ProceedingJoinPoint var1) throws Throwable;

    Object executeAopTreat(ProceedingJoinPoint pjp, Logger logger) throws Throwable {
        Object rspObj;
        String traceId;
        Map hiddenParm = RpcContext.getContext().getAttachments();
        if (hiddenParm.containsKey(TRACE_ID)) {
            traceId = (String)hiddenParm.get(TRACE_ID);
        } else {
            traceId = EagleEye.getTraceId();
            hiddenParm.put(TRACE_ID, traceId);
        }
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> rspClass = method.getReturnType();
        String[] infos = this.printAopStartLog(pjp, traceId, logger);
        try {
            rspObj = pjp.proceed();
            this.putCodeToRsp(rspObj, RESP_CODE_SUCCESS, RESP_DESC_SUCCESS);
        }
        catch (UocProBusinessException e) {
            rspObj = rspClass.newInstance();
            String msgCode = e.getMsgCode();
            String desc = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)msgCode)) {
                msgCode = RESP_CODE_ERROR;
            }
            if (StringUtils.isEmpty((CharSequence)desc)) {
                desc = RESP_DESC_ERROR;
            }
            this.printAopErrorLog(infos, e, logger);
            this.putCodeToRsp(rspObj, msgCode, desc);
        }
        catch (Throwable e) {
            rspObj = rspClass.newInstance();
            this.printAopErrorLog(infos, e, logger);
            this.putCodeToRsp(rspObj, RESP_CODE_ERROR, "\u5931\u8d25:" + e.getMessage());
        }
        this.printAopEndLog(infos, rspObj, logger);
        return rspObj;
    }

    private String[] printAopStartLog(ProceedingJoinPoint pjp, String traceId, Logger logger) {
        Long nowTime = System.currentTimeMillis();
        StringBuilder commonHead = new StringBuilder(traceId + SEPARATOR);
        String className = pjp.getTarget().getClass().getName();
        String methodString = pjp.getSignature().getName();
        if (EXCLUDE_METHODS.equals(methodString)) {
            return null;
        }
        commonHead.append(className);
        commonHead.append(CLASS_METHOD_SEPARATOR);
        commonHead.append(methodString);
        String[] infos = new String[8];
        infos[0] = commonHead.toString();
        infos[1] = START_IDENTIFICATION;
        infos[2] = nowTime.toString();
        infos[3] = "";
        Object[] params = pjp.getArgs();
        if (params != null && params.length > 0) {
            if (params.length == 1) {
                try {
                    infos[4] = MAPPER.writeValueAsString(params[0]);
                }
                catch (JsonProcessingException e) {
                    infos[4] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + params[0]).replace("\r\n", "");
                }
            } else {
                StringBuilder paramsStr = new StringBuilder();
                paramsStr.append("[");
                for (Object obj : params) {
                    String objStr = null;
                    if (obj != null) {
                        try {
                            objStr = MAPPER.writeValueAsString(obj);
                        }
                        catch (JsonProcessingException e) {
                            logger.error("\u5207\u9762\u8f6c\u6362\u5165\u53c2\u8f6c\u6362\u5f02\u5e38");
                        }
                    }
                    paramsStr.append(objStr);
                    paramsStr.append(",");
                }
                paramsStr.setLength(paramsStr.length() - 1);
                paramsStr.append("]");
                infos[4] = paramsStr.toString();
            }
        }
        logger.info(this.getLogInfoByStrings(infos));
        return infos;
    }

    private void printAopErrorLog(String[] infos, Throwable e, Logger logger) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[1] = ERROR_IDENTIFICATION;
        infos[3] = nowTime.toString();
        if (null != this.getThrowableStrRep(e)) {
            infos[5] = this.getThrowableStrRep(e);
        }
        logger.error(this.getLogInfoByStrings(infos));
    }

    private String getThrowableStrRep(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.flush();
        LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));
        StringBuilder sb = new StringBuilder();
        try {
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append("\r\n");
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            sb.append(ex.toString());
        }
        return sb.toString();
    }

    private void putCodeToRsp(Object object, String code, String desc) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.putCodeToRsp(object, code, desc, false);
    }

    private void putCodeToRsp(Object object, String code, String desc, boolean fource) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        if (object instanceof UocProBaseRspBo) {
            Field field = UocProBaseRspBo.class.getDeclaredField(DEFINE_BASE_CLASS_FIELD_CODE);
            field.setAccessible(true);
            if (!fource && field.get(object) == null) {
                field.set(object, code);
                field = UocProBaseRspBo.class.getDeclaredField(DEFINE_BASE_CLASS_FIELD_DESC);
                field.setAccessible(true);
                field.set(object, desc);
            } else if (fource && field.get(object) == null) {
                field.set(object, code);
                field = UocProBaseRspBo.class.getDeclaredField(DEFINE_BASE_CLASS_FIELD_DESC);
                field.setAccessible(true);
                field.set(object, desc);
            }
        }
    }

    private void printAopEndLog(String[] infos, Object object, Logger logger) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[1] = END_IDENTIFICATION;
        infos[3] = nowTime.toString();
        if (object instanceof UocProBaseRspBo) {
            UocProBaseRspBo resp = (UocProBaseRspBo)object;
            infos[4] = resp.getRespCode();
            infos[5] = resp.getRespDesc();
            infos[6] = "\u7528\u65f6\uff1a" + (Long.parseLong(infos[3]) - Long.parseLong(infos[2])) + "ms";
            infos[7] = object.toString();
        }
        logger.info(this.getLogInfoByStrings(infos));
    }

    private String getLogInfoByStrings(String[] infos) {
        StringBuilder stb = new StringBuilder();
        for (String info : infos) {
            if (StringUtils.isBlank((CharSequence)info)) {
                info = "";
            }
            stb.append(info).append(SEPARATOR);
        }
        if (stb.length() > 1) {
            stb.setLength(stb.length() - 1);
        }
        return stb.toString();
    }
}

