/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.ability;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.order.ability.bo.UocProOrderCreateResultQryAbilityReqBo;
import com.tydic.order.ability.bo.UocProOrderCreateResultQryAbilityRspBo;
import com.tydic.order.ability.bo.UocProOrderCreateResultQryOrdersBo;
import com.tydic.order.ability.order.PebQryOrderStatusAbilityService;
import com.tydic.order.ability.pro.UocProOrderCreateResultQryAbilityService;
import com.tydic.order.bo.order.PebOrderStatusBO;
import com.tydic.order.bo.order.PebQryOrderStatusBO;
import com.tydic.order.bo.order.PebQryOrderStatusReqBO;
import com.tydic.order.bo.order.PebQryOrderStatusRspBO;
import com.tydic.order.constant.UocConstant;
import com.tydic.order.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdPayMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.SysDicDictionaryMapper;
import com.tydic.order.uoc.dao.po.OrdPayPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.SysDicDictionaryPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=UocProOrderCreateResultQryAbilityService.class)
public class UocProOrderCreateResultQryAbilityServiceImpl
implements UocProOrderCreateResultQryAbilityService {
    @Autowired
    private PebQryOrderStatusAbilityService pebQryOrderStatusAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;

    public UocProOrderCreateResultQryAbilityRspBo qryOrderResult(UocProOrderCreateResultQryAbilityReqBo reqBo) {
        this.validateArg(reqBo);
        OrdSalePO qryListPo = new OrdSalePO();
        qryListPo.setMergeOrderId(reqBo.getMergeOrderId());
        List list = this.ordSaleMapper.getList(qryListPo);
        Map<Long, OrdSalePO> collect = list.stream().collect(Collectors.toMap(OrdSalePO::getOrderId, po -> po));
        if (ObjectUtil.isEmpty((Object)list)) {
            throw new UocProBusinessException("214002", "\u8be5mergeOrderId(" + reqBo.getMergeOrderId() + ")\u4e0b\u6ca1\u6709\u6570\u636e");
        }
        PebQryOrderStatusReqBO qryReqBo = new PebQryOrderStatusReqBO();
        ArrayList<PebQryOrderStatusBO> orderStatusList = new ArrayList<PebQryOrderStatusBO>();
        qryReqBo.setOrderStatusList(orderStatusList);
        for (OrdSalePO salePo : list) {
            PebQryOrderStatusBO tBo = new PebQryOrderStatusBO();
            tBo.setOrderId(salePo.getOrderId());
            orderStatusList.add(tBo);
        }
        PebQryOrderStatusRspBO qryRspBo = this.pebQryOrderStatusAbilityService.qryOrderStatus(qryReqBo);
        if (!"0000".equals(qryRspBo.getRespCode())) {
            throw new UocProBusinessException("214002", "\u67e5\u8be2\u5931\u8d25\uff1a" + qryRspBo.getRespDesc());
        }
        UocProOrderCreateResultQryAbilityRspBo rspBo = (UocProOrderCreateResultQryAbilityRspBo)UocProRspBoUtil.success(UocProOrderCreateResultQryAbilityRspBo.class);
        Map<String, String> dicMap = this.qryDic();
        List orderInfos = qryRspBo.getOrderInfo();
        for (PebOrderStatusBO orderInfo : orderInfos) {
            UocProOrderCreateResultQryOrdersBo rspTmpBo = new UocProOrderCreateResultQryOrdersBo();
            BeanUtils.copyProperties((Object)orderInfo, (Object)rspTmpBo);
            if ("2".equals(orderInfo.getOrderSource()) && UocCoreConstant.RESULT_CODE.SUCCESS.equals(orderInfo.getResultCode()) && !UocConstant.SALE_ORDER_STATUS.ZONE_AUDIT.equals(orderInfo.getSaleState())) {
                rspBo.getCanPayOrders().add(rspTmpBo);
            } else {
                rspBo.getNeedApprovedOrders().add(rspTmpBo);
            }
            OrdPayPO qryPayPo = new OrdPayPO();
            qryPayPo.setOrderId(orderInfo.getOrderId());
            qryPayPo.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            OrdPayPO modelBy = this.ordPayMapper.getModelBy(qryPayPo);
            if (modelBy != null) {
                rspTmpBo.setPayType(modelBy.getPayType());
                rspTmpBo.setPayTypeName(dicMap.get(rspTmpBo.getPayType().toString()));
            }
            rspTmpBo.setOrderSource(collect.get(orderInfo.getOrderId()).getOrderSource());
            rspTmpBo.setSaleVoucherId(collect.get(orderInfo.getOrderId()).getSaleVoucherId());
        }
        return rspBo;
    }

    private Map<String, String> qryDic() {
        SysDicDictionaryPO qryPo = new SysDicDictionaryPO();
        qryPo.setPCode("FSC_PAY_TYPE");
        List list = this.sysDicDictionaryMapper.getList(qryPo);
        return list.stream().collect(Collectors.toMap(SysDicDictionaryPO::getCode, SysDicDictionaryPO::getDescrip));
    }

    private void validateArg(UocProOrderCreateResultQryAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("214002", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getMergeOrderId())) {
            throw new UocProBusinessException("214002", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[mergeOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

