/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.ability.order;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.ability.order.PebAfterSalesServiceApprovalAbilityService;
import com.tydic.order.bo.order.PebAfterSalesServiceApprovalInfoBo;
import com.tydic.order.bo.order.PebAfterSalesServiceApprovalReqBO;
import com.tydic.order.bo.order.PebAfterSalesServiceApprovalRspBO;
import com.tydic.order.bo.other.UocOrdIdxSyncReqBO;
import com.tydic.order.busi.order.PebAfterSalesServiceApprovalBusiService;
import com.tydic.order.constant.UocConstant;
import com.tydic.order.constant.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=PebAfterSalesServiceApprovalAbilityService.class)
public class PebAfterSalesServiceApprovalAbilityServiceImpl
implements PebAfterSalesServiceApprovalAbilityService {
    @Autowired
    PebAfterSalesServiceApprovalBusiService pebAfterSalesServiceApprovalBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    public PebAfterSalesServiceApprovalRspBO dealPebAfterSalesServiceApproval(PebAfterSalesServiceApprovalReqBO reqBO) {
        this.validateParams(reqBO);
        if (StringUtils.isBlank((CharSequence)reqBO.getActionCode())) {
            reqBO.setActionCode("ACTPEB015");
        }
        PebAfterSalesServiceApprovalRspBO rspBO = (PebAfterSalesServiceApprovalRspBO)UocProRspBoUtil.success(PebAfterSalesServiceApprovalRspBO.class);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAfterSaleInfoBOS())) {
            for (PebAfterSalesServiceApprovalInfoBo afterSalesServiceApprovalInfoBo : reqBO.getAfterSaleInfoBOS()) {
                reqBO.setAfterServId(afterSalesServiceApprovalInfoBo.getAfterServId());
                reqBO.setOrderId(afterSalesServiceApprovalInfoBo.getOrderId());
                if (StringUtils.isBlank((CharSequence)reqBO.getActionCode())) {
                    reqBO.setActionCode("ACTPEB015");
                }
                if ("0000".equals((rspBO = this.pebAfterSalesServiceApprovalBusiService.dealPebAfterSalesServiceApproval(reqBO)).getRespCode())) {
                    this.idxSync(reqBO);
                    this.dealEsOrderList(rspBO);
                    this.dealEsInspectionList(rspBO);
                    continue;
                }
                throw new UocProBusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
            }
        } else {
            rspBO = this.pebAfterSalesServiceApprovalBusiService.dealPebAfterSalesServiceApproval(reqBO);
            if ("0000".equals(rspBO.getRespCode())) {
                this.idxSync(reqBO);
                this.dealEsOrderList(rspBO);
                this.dealEsInspectionList(rspBO);
            }
        }
        return rspBO;
    }

    private void idxSync(PebAfterSalesServiceApprovalReqBO reqBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(reqBO.getAfterServId());
        uocOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.AFTER_SERVICE);
        uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    private void dealEsOrderList(PebAfterSalesServiceApprovalRspBO rspBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setOrderId(rspBO.getOrderId());
        uocOrdIdxSyncReqBO.setObjId(rspBO.getSaleVoucherId());
        uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    private void dealEsInspectionList(PebAfterSalesServiceApprovalRspBO rspBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setOrderId(rspBO.getOrderId());
        if (null != rspBO.getInspectionVoucherId() && 0L != rspBO.getInspectionVoucherId()) {
            uocOrdIdxSyncReqBO.setObjId(rspBO.getInspectionVoucherId());
            uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.INSPECTION);
        } else {
            uocOrdIdxSyncReqBO.setObjId(rspBO.getShipVoucherId());
            uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
        }
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    private void validateParams(PebAfterSalesServiceApprovalReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("0001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279API\u5165\u53c2\u3010bo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAuditResult() == null) {
            throw new UocProBusinessException("0001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u5ba1\u6279\u7ed3\u679c\u3010auditResult\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBO.getAuditResult().equals(UocConstant.ACTION_RESULT.PASS) && !reqBO.getAuditResult().equals(UocConstant.ACTION_RESULT.NO_PASS)) {
            throw new UocProBusinessException("0002", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u5ba1\u6279\u7ed3\u679c\u3010auditResult\u3011\u7c7b\u578b\u9519\u8bef");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getAfterSaleInfoBOS())) {
            if (reqBO.getAfterServId() == null) {
                throw new UocProBusinessException("0001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u552e\u540e\u5355id\u3010afterServId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getOrderId() == null) {
                throw new UocProBusinessException("0001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u8ba2\u5355id\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            for (PebAfterSalesServiceApprovalInfoBo afterSaleInfoBO : reqBO.getAfterSaleInfoBOS()) {
                if (afterSaleInfoBO.getAfterServId() == null) {
                    throw new UocProBusinessException("0001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u552e\u540e\u5355id\u3010afterServId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (afterSaleInfoBO.getOrderId() != null) continue;
                throw new UocProBusinessException("0001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u8ba2\u5355id\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

